/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.coroutines;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.CallableReferenceLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.SuspendFunctionKind;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\t*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\f\u00a8\u0006\r"}, d2={"getSuspendFunctionKind", "Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/SuspendFunctionKind;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "includeSuspendLambda", "", "isReturnIfSuspendedCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nAbstractSuspendFunctionsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSuspendFunctionsLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/coroutines/AbstractSuspendFunctionsLoweringKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,584:1\n1#2:585\n*E\n"})
public final class AbstractSuspendFunctionsLoweringKt {
    @NotNull
    public static final SuspendFunctionKind getSuspendFunctionKind(@NotNull CommonBackendContext context2, @NotNull IrSimpleFunction function2, @NotNull IrBody body2, boolean includeSuspendLambda) {
        SuspendFunctionKind suspendFunctionKind;
        IrCall irCall;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(body2, "body");
        if (AbstractSuspendFunctionsLoweringKt.getSuspendFunctionKind$isSuspendLambda(function2) && includeSuspendLambda) {
            return SuspendFunctionKind.NEEDS_STATE_MACHINE.INSTANCE;
        }
        Ref.IntRef numberOfSuspendCalls = new Ref.IntRef();
        IrVisitorsKt.acceptVoid((IrElement)body2, new IrVisitorVoid(numberOfSuspendCalls){
            final /* synthetic */ Ref.IntRef $numberOfSuspendCalls;
            {
                this.$numberOfSuspendCalls = $numberOfSuspendCalls;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            public void visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrVisitorsKt.acceptChildrenVoid((IrElement)expression2, this);
                if (IrUtilsKt.isSuspend(expression2)) {
                    ++this.$numberOfSuspendCalls.element;
                    int cfr_ignored_0 = this.$numberOfSuspendCalls.element;
                }
            }
        });
        IrStatement lastStatement = CollectionsKt.lastOrNull(((IrBlockBody)body2).getStatements());
        if (lastStatement instanceof IrCall) {
            irCall = Intrinsics.areEqual(((IrCall)lastStatement).getType(), context2.getIrBuiltIns().getUnitType()) && Intrinsics.areEqual(function2.getReturnType(), context2.getIrBuiltIns().getUnitType()) ? (IrCall)lastStatement : null;
        } else if (lastStatement instanceof IrReturn) {
            IrElement value2 = lastStatement;
            while (true) {
                IrElement irElement;
                if (value2 instanceof IrBlock && ((IrBlock)value2).getStatements().size() == 1) {
                    irElement = CollectionsKt.first(((IrBlock)value2).getStatements());
                } else if (value2 instanceof IrReturn) {
                    irElement = ((IrReturn)value2).getValue();
                } else {
                    if (!(value2 instanceof IrTypeOperatorCall) || !AbstractSuspendFunctionsLoweringKt.getSuspendFunctionKind$isImplicitCast((IrTypeOperatorCall)value2)) break;
                    irElement = ((IrTypeOperatorCall)value2).getArgument();
                }
                value2 = irElement;
            }
            IrElement irElement = value2;
            irCall = irElement instanceof IrCall ? (IrCall)irElement : null;
        } else {
            irCall = null;
        }
        IrCall lastCall = irCall;
        boolean suspendCallAtEnd = lastCall != null && IrUtilsKt.isSuspend(lastCall);
        if (numberOfSuspendCalls.element == 0) {
            suspendFunctionKind = SuspendFunctionKind.NO_SUSPEND_CALLS.INSTANCE;
        } else if (numberOfSuspendCalls.element == 1 && suspendCallAtEnd) {
            IrCall irCall2 = lastCall;
            Intrinsics.checkNotNull(irCall2);
            suspendFunctionKind = new SuspendFunctionKind.DELEGATING(irCall2);
        } else {
            suspendFunctionKind = SuspendFunctionKind.NEEDS_STATE_MACHINE.INSTANCE;
        }
        return suspendFunctionKind;
    }

    public static /* synthetic */ SuspendFunctionKind getSuspendFunctionKind$default(CommonBackendContext commonBackendContext, IrSimpleFunction irSimpleFunction, IrBody irBody, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return AbstractSuspendFunctionsLoweringKt.getSuspendFunctionKind(commonBackendContext, irSimpleFunction, irBody, bl);
    }

    public static final boolean isReturnIfSuspendedCall(@NotNull IrCall $this$isReturnIfSuspendedCall, @NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter($this$isReturnIfSuspendedCall, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        return Intrinsics.areEqual($this$isReturnIfSuspendedCall.getSymbol(), context2.getIr().getSymbols().getReturnIfSuspended());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getSuspendFunctionKind$isSuspendLambda(IrSimpleFunction $this$getSuspendFunctionKind_u24isSuspendLambda) {
        if (!Intrinsics.areEqual($this$getSuspendFunctionKind_u24isSuspendLambda.getName().asString(), "invoke")) return false;
        IrClass irClass = IrUtilsKt.getParentClassOrNull($this$getSuspendFunctionKind_u24isSuspendLambda);
        if (irClass == null) return false;
        IrClass it = irClass;
        boolean bl = false;
        if (it.getOrigin() != CallableReferenceLowering.Companion.getLAMBDA_IMPL()) return false;
        return true;
    }

    private static final boolean getSuspendFunctionKind$isImplicitCast(IrTypeOperatorCall $this$getSuspendFunctionKind_u24isImplicitCast) {
        return $this$getSuspendFunctionKind_u24isImplicitCast.getOperator() == IrTypeOperator.IMPLICIT_CAST || $this$getSuspendFunctionKind_u24isImplicitCast.getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT;
    }
}

