/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.target;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.target.Distribution;
import org.jetbrains.kotlin.konan.target.Family;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.SubTargetProvider;
import org.jetbrains.kotlin.konan.target.TargetManager;
import org.jetbrains.kotlin.konan.target.TargetManagerImpl;
import org.jetbrains.kotlin.konan.target.TargetSupportException;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B\u001b\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\rJ\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001cJ\u000e\u0010\"\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u001cJ\u0012\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u001cJ\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0(R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R#\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0018\u0010\u0012R\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\r0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0016\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/konan/target/HostManager;", "", "subTargetProvider", "Lorg/jetbrains/kotlin/konan/target/SubTargetProvider;", "experimental", "", "(Lorg/jetbrains/kotlin/konan/target/SubTargetProvider;Z)V", "distribution", "Lorg/jetbrains/kotlin/konan/target/Distribution;", "(Lorg/jetbrains/kotlin/konan/target/Distribution;Z)V", "()V", "appleTargets", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "commonTargets", "enabled", "", "getEnabled", "()Ljava/util/List;", "enabledByHost", "", "getEnabledByHost", "()Ljava/util/Map;", "targetValues", "getTargetValues", "targetValues$delegate", "Lkotlin/Lazy;", "targets", "", "getTargets", "isEnabled", "target", "known", "name", "targetByName", "targetManager", "Lorg/jetbrains/kotlin/konan/target/TargetManager;", "userRequest", "toKonanTargets", "names", "", "Companion", "kotlin-native-utils"})
@SourceDebugExtension(value={"SMAP\nHostManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostManager.kt\norg/jetbrains/kotlin/konan/target/HostManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,225:1\n1208#2,2:226\n1236#2,4:228\n1563#2:232\n1634#2,3:233\n*S KotlinDebug\n*F\n+ 1 HostManager.kt\norg/jetbrains/kotlin/konan/target/HostManager\n*L\n31#1:226,2\n31#1:228,4\n34#1:232\n34#1:233,3\n*E\n"})
public class HostManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy targetValues$delegate;
    @NotNull
    private final Map<String, KonanTarget> targets;
    @NotNull
    private final Set<KonanTarget> commonTargets;
    @NotNull
    private final Set<KonanTarget> appleTargets;
    @NotNull
    private final Map<KonanTarget, Set<KonanTarget>> enabledByHost;
    @NotNull
    private static final Map<Pair<String, String>, KonanTarget> hostMapping;
    @NotNull
    private static final List<String> defaultJvmArgs;
    @NotNull
    private static final List<String> regularJvmArgs;
    @NotNull
    private static final Map<String, String> targetAliasResolutions;
    @NotNull
    private static final Lazy<Map<String, List<String>>> targetAliases$delegate;

    /*
     * WARNING - void declaration
     */
    public HostManager() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        this.targetValues$delegate = LazyKt.lazy(targetValues.2.INSTANCE);
        Serializable[] serializableArray = (KonanTarget[])this.getTargetValues();
        HostManager hostManager = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        void var4_5 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KonanTarget konanTarget = (KonanTarget)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getVisibleName(), element$iv$iv);
        }
        hostManager.targets = destination$iv$iv;
        serializableArray = new KonanTarget[]{KonanTarget.LINUX_X64.INSTANCE, KonanTarget.LINUX_ARM32_HFP.INSTANCE, KonanTarget.LINUX_ARM64.INSTANCE, KonanTarget.MINGW_X64.INSTANCE, KonanTarget.ANDROID_X86.INSTANCE, KonanTarget.ANDROID_X64.INSTANCE, KonanTarget.ANDROID_ARM32.INSTANCE, KonanTarget.ANDROID_ARM64.INSTANCE};
        this.commonTargets = SetsKt.setOf(serializableArray);
        serializableArray = new KonanTarget[]{KonanTarget.MACOS_X64.INSTANCE, KonanTarget.MACOS_ARM64.INSTANCE, KonanTarget.IOS_ARM64.INSTANCE, KonanTarget.IOS_X64.INSTANCE, KonanTarget.IOS_SIMULATOR_ARM64.INSTANCE, KonanTarget.WATCHOS_ARM32.INSTANCE, KonanTarget.WATCHOS_ARM64.INSTANCE, KonanTarget.WATCHOS_X64.INSTANCE, KonanTarget.WATCHOS_SIMULATOR_ARM64.INSTANCE, KonanTarget.WATCHOS_DEVICE_ARM64.INSTANCE, KonanTarget.TVOS_ARM64.INSTANCE, KonanTarget.TVOS_X64.INSTANCE, KonanTarget.TVOS_SIMULATOR_ARM64.INSTANCE};
        this.appleTargets = SetsKt.setOf(serializableArray);
        serializableArray = new Pair[]{TuplesKt.to(KonanTarget.LINUX_X64.INSTANCE, this.commonTargets), TuplesKt.to(KonanTarget.MINGW_X64.INSTANCE, this.commonTargets), TuplesKt.to(KonanTarget.MACOS_X64.INSTANCE, SetsKt.plus(this.commonTargets, (Iterable)this.appleTargets)), TuplesKt.to(KonanTarget.MACOS_ARM64.INSTANCE, SetsKt.plus(this.commonTargets, (Iterable)this.appleTargets))};
        this.enabledByHost = MapsKt.mapOf(serializableArray);
    }

    @NotNull
    public final TargetManager targetManager(@Nullable String userRequest) {
        return new TargetManagerImpl(userRequest, this);
    }

    public static /* synthetic */ TargetManager targetManager$default(HostManager hostManager, String string2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: targetManager");
        }
        if ((n2 & 1) != 0) {
            string2 = null;
        }
        return hostManager.targetManager(string2);
    }

    @Deprecated(message="Kept for binary compatibility of Gradle plugins", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ HostManager(SubTargetProvider subTargetProvider, boolean experimental) {
        Intrinsics.checkNotNullParameter(subTargetProvider, "subTargetProvider");
        this();
    }

    public /* synthetic */ HostManager(SubTargetProvider subTargetProvider, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            subTargetProvider = SubTargetProvider.NoSubTargets.INSTANCE;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(subTargetProvider, bl);
    }

    @Deprecated(message="Kept for binary compatibility of Gradle plugins", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ HostManager(Distribution distribution, boolean experimental) {
        Intrinsics.checkNotNullParameter(distribution, "distribution");
        this();
    }

    public /* synthetic */ HostManager(Distribution distribution, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(distribution, bl);
    }

    @NotNull
    public final List<KonanTarget> getTargetValues() {
        Lazy lazy = this.targetValues$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final Map<String, KonanTarget> getTargets() {
        return this.targets;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KonanTarget> toKonanTargets(@NotNull Iterable<String> names) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(names, "names");
        Iterable<String> $this$map$iv = names;
        boolean $i$f$map = false;
        Iterable<String> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Intrinsics.areEqual(it, "host") ? Companion.getHost() : MapsKt.getValue(this.targets, this.known(Companion.resolveAlias((String)it))));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String known(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        if (this.targets.get(name2) == null) {
            throw new TargetSupportException("Unknown target: " + name2 + ". Use -list_targets to see the list of available targets", null, 2, null);
        }
        return name2;
    }

    @NotNull
    public final KonanTarget targetByName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        if (Intrinsics.areEqual(name2, "host")) {
            return Companion.getHost();
        }
        KonanTarget konanTarget = this.targets.get(Companion.resolveAlias(name2));
        if (konanTarget == null) {
            throw new TargetSupportException("Unknown target name: " + name2, null, 2, null);
        }
        return konanTarget;
    }

    @NotNull
    public final Map<KonanTarget, Set<KonanTarget>> getEnabledByHost() {
        return this.enabledByHost;
    }

    @NotNull
    public final List<KonanTarget> getEnabled() {
        Collection<KonanTarget> collection = this.enabledByHost.get(Companion.getHost());
        if (collection == null || (collection = CollectionsKt.toList((Iterable)collection)) == null) {
            throw new TargetSupportException("Unknown host platform: " + Companion.getHost(), null, 2, null);
        }
        return collection;
    }

    public final boolean isEnabled(@NotNull KonanTarget target) {
        Intrinsics.checkNotNullParameter(target, "target");
        return this.getEnabled().contains(target);
    }

    @JvmStatic
    @NotNull
    public static final String simpleOsName() {
        return Companion.simpleOsName();
    }

    @JvmStatic
    @NotNull
    public static final String platformName() {
        return Companion.platformName();
    }

    @NotNull
    public static final KonanTarget getHost() {
        return Companion.getHost();
    }

    public static final boolean getHostIsMac() {
        return Companion.getHostIsMac();
    }

    public static final boolean getHostIsLinux() {
        return Companion.getHostIsLinux();
    }

    public static final boolean getHostIsMingw() {
        return Companion.getHostIsMingw();
    }

    @NotNull
    public static final String getHostName() {
        return Companion.getHostName();
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to(new Pair<String, String>("osx", "x86_64"), KonanTarget.MACOS_X64.INSTANCE), TuplesKt.to(new Pair<String, String>("osx", "aarch64"), KonanTarget.MACOS_ARM64.INSTANCE), TuplesKt.to(new Pair<String, String>("linux", "x86_64"), KonanTarget.LINUX_X64.INSTANCE), TuplesKt.to(new Pair<String, String>("windows", "x86_64"), KonanTarget.MINGW_X64.INSTANCE)};
        hostMapping = MapsKt.mapOf(objectArray);
        objectArray = new String[]{"-XX:TieredStopAtLevel=1", "-ea", "-Dfile.encoding=UTF-8"};
        defaultJvmArgs = CollectionsKt.listOf(objectArray);
        regularJvmArgs = CollectionsKt.plus((Collection)defaultJvmArgs, "-Xmx3G");
        objectArray = new Pair[]{TuplesKt.to("linux", "linux_x64"), TuplesKt.to("macbook", "macos_x64"), TuplesKt.to("macos", "macos_x64"), TuplesKt.to("imac", "macos_x64"), TuplesKt.to("raspberrypi", "linux_arm32_hfp"), TuplesKt.to("iphone32", "ios_arm32"), TuplesKt.to("iphone", "ios_arm64"), TuplesKt.to("ipad", "ios_arm64"), TuplesKt.to("ios", "ios_arm64"), TuplesKt.to("iphone_sim", "ios_x64"), TuplesKt.to("mingw", "mingw_x64")};
        targetAliasResolutions = MapsKt.mapOf(objectArray);
        targetAliases$delegate = LazyKt.lazy(Companion.targetAliases.2.INSTANCE);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u001f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u00052\b\u0010-\u001a\u0004\u0018\u00010\u0005H\u0002J\u0006\u0010.\u001a\u00020\u0005J\b\u0010/\u001a\u0004\u0018\u00010\u0005J\u0006\u00100\u001a\u00020\u0005J\b\u00101\u001a\u00020\u0005H\u0007J\b\u00102\u001a\u00020\u0005H\u0007J\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u00104\u001a\u00020\u0005J\b\u00105\u001a\u00020\u0005H\u0007J\u000e\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u0005J\b\u00108\u001a\u00020\u0005H\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u000e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\u000e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\u0011R&\u0010\u0018\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001a\u0012\u0004\u0012\u00020\t0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u0002\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\fR\u0011\u0010!\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0007R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/konan/target/HostManager$Companion;", "", "()V", "defaultJvmArgs", "", "", "getDefaultJvmArgs", "()Ljava/util/List;", "host", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getHost$annotations", "getHost", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "hostIsLinux", "", "getHostIsLinux$annotations", "getHostIsLinux", "()Z", "hostIsMac", "getHostIsMac$annotations", "getHostIsMac", "hostIsMingw", "getHostIsMingw$annotations", "getHostIsMingw", "hostMapping", "", "Lkotlin/Pair;", "hostName", "getHostName$annotations", "getHostName", "()Ljava/lang/String;", "hostOrNull", "getHostOrNull", "jniHostPlatformIncludeDir", "getJniHostPlatformIncludeDir", "regularJvmArgs", "getRegularJvmArgs", "targetAliasResolutions", "targetAliases", "getTargetAliases", "()Ljava/util/Map;", "targetAliases$delegate", "Lkotlin/Lazy;", "determineHost", "os", "arch", "hostArch", "hostArchOrNull", "hostOs", "host_arch", "host_os", "listAliases", "target", "platformName", "resolveAlias", "request", "simpleOsName", "kotlin-native-utils"})
    @SourceDebugExtension(value={"SMAP\nHostManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostManager.kt\norg/jetbrains/kotlin/konan/target/HostManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,225:1\n295#2,2:226\n*S KotlinDebug\n*F\n+ 1 HostManager.kt\norg/jetbrains/kotlin/konan/target/HostManager$Companion\n*L\n173#1:226,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use `hostOs` instead", replaceWith=@ReplaceWith(expression="HostManager.hostOs()", imports={}))
        @NotNull
        public final String host_os() {
            return this.hostOs();
        }

        @NotNull
        public final String hostOs() {
            String string2;
            String javaOsName = System.getProperty("os.name");
            if (Intrinsics.areEqual(javaOsName, "Mac OS X")) {
                string2 = "osx";
            } else if (Intrinsics.areEqual(javaOsName, "Linux")) {
                string2 = "linux";
            } else {
                Intrinsics.checkNotNullExpressionValue(javaOsName, "javaOsName");
                if (StringsKt.startsWith$default(javaOsName, "Windows", false, 2, null)) {
                    string2 = "windows";
                } else {
                    throw new TargetSupportException("Unknown operating system: " + javaOsName, null, 2, null);
                }
            }
            return string2;
        }

        @JvmStatic
        @NotNull
        public final String simpleOsName() {
            String hostOs = this.hostOs();
            return Intrinsics.areEqual(hostOs, "osx") ? "macos" : hostOs;
        }

        @JvmStatic
        @NotNull
        public final String platformName() {
            String hostOs = this.hostOs();
            String arch = this.hostArch();
            return Intrinsics.areEqual(hostOs, "osx") ? "macos-" + arch : hostOs + '-' + arch;
        }

        @NotNull
        public final String getJniHostPlatformIncludeDir() {
            String string2;
            KonanTarget konanTarget = this.getHost();
            if (Intrinsics.areEqual(konanTarget, KonanTarget.MACOS_X64.INSTANCE) ? true : Intrinsics.areEqual(konanTarget, KonanTarget.MACOS_ARM64.INSTANCE)) {
                string2 = "darwin";
            } else if (Intrinsics.areEqual(konanTarget, KonanTarget.LINUX_X64.INSTANCE)) {
                string2 = "linux";
            } else if (Intrinsics.areEqual(konanTarget, KonanTarget.MINGW_X64.INSTANCE)) {
                string2 = "win32";
            } else {
                throw new TargetSupportException("Unknown host: " + this.getHost() + '.', null, 2, null);
            }
            return string2;
        }

        @Deprecated(message="Use `hostArch` instead", replaceWith=@ReplaceWith(expression="HostManager.hostArch()", imports={}))
        @NotNull
        public final String host_arch() {
            return this.hostArch();
        }

        @NotNull
        public final String hostArch() {
            String string2 = this.hostArchOrNull();
            if (string2 == null) {
                throw new TargetSupportException("Unknown hardware platform: " + System.getProperty("os.arch"), null, 2, null);
            }
            return string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final String hostArchOrNull() {
            String string2 = System.getProperty("os.arch");
            if (string2 == null) return null;
            int n2 = -1;
            switch (string2.hashCode()) {
                case -1221096139: {
                    if (string2.equals("aarch64")) {
                        n2 = 1;
                    }
                    break;
                }
                case -806050265: {
                    if (string2.equals("x86_64")) {
                        n2 = 2;
                    }
                    break;
                }
                case 93084186: {
                    if (string2.equals("arm64")) {
                        n2 = 3;
                    }
                    break;
                }
                case 92926582: {
                    if (string2.equals("amd64")) {
                        n2 = 4;
                    }
                    break;
                }
            }
            switch (n2) {
                case 2: {
                    return "x86_64";
                }
                case 4: {
                    return "x86_64";
                }
                case 3: {
                    return "aarch64";
                }
                case 1: {
                    return "aarch64";
                }
                default: {
                    return null;
                }
            }
        }

        @NotNull
        public final KonanTarget getHost() {
            return this.determineHost(this.hostOs(), this.hostArchOrNull());
        }

        @JvmStatic
        public static /* synthetic */ void getHost$annotations() {
        }

        @Nullable
        public final KonanTarget getHostOrNull() {
            KonanTarget konanTarget;
            try {
                konanTarget = this.getHost();
            }
            catch (TargetSupportException _) {
                konanTarget = null;
            }
            return konanTarget;
        }

        private final KonanTarget determineHost(String os, String arch) {
            Object v0;
            Object object;
            block3: {
                object = (KonanTarget)hostMapping.get(TuplesKt.to(os, arch));
                if (object != null) {
                    KonanTarget it = object;
                    boolean bl = false;
                    return it;
                }
                Iterable $this$firstOrNull$iv = hostMapping.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    Pair host = (Pair)entry.getKey();
                    if (!Intrinsics.areEqual(host.getFirst(), os)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            object = v0;
            if (object != null) {
                Object it = object;
                boolean bl = false;
                return (KonanTarget)it.getValue();
            }
            throw new TargetSupportException("Unknown host target: " + os + ' ' + arch, null, 2, null);
        }

        @NotNull
        public final List<String> getDefaultJvmArgs() {
            return defaultJvmArgs;
        }

        @NotNull
        public final List<String> getRegularJvmArgs() {
            return regularJvmArgs;
        }

        public final boolean getHostIsMac() {
            KonanTarget konanTarget = this.getHostOrNull();
            return (konanTarget != null ? konanTarget.getFamily() : null) == Family.OSX;
        }

        @JvmStatic
        public static /* synthetic */ void getHostIsMac$annotations() {
        }

        public final boolean getHostIsLinux() {
            KonanTarget konanTarget = this.getHostOrNull();
            return (konanTarget != null ? konanTarget.getFamily() : null) == Family.LINUX;
        }

        @JvmStatic
        public static /* synthetic */ void getHostIsLinux$annotations() {
        }

        public final boolean getHostIsMingw() {
            KonanTarget konanTarget = this.getHostOrNull();
            return (konanTarget != null ? konanTarget.getFamily() : null) == Family.MINGW;
        }

        @JvmStatic
        public static /* synthetic */ void getHostIsMingw$annotations() {
        }

        @NotNull
        public final String getHostName() {
            return this.getHost().getName();
        }

        @JvmStatic
        public static /* synthetic */ void getHostName$annotations() {
        }

        private final Map<String, List<String>> getTargetAliases() {
            Lazy lazy = targetAliases$delegate;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final String resolveAlias(@NotNull String request) {
            Intrinsics.checkNotNullParameter(request, "request");
            String string2 = (String)targetAliasResolutions.get(request);
            if (string2 == null) {
                string2 = request;
            }
            return string2;
        }

        @NotNull
        public final List<String> listAliases(@NotNull String target) {
            Intrinsics.checkNotNullParameter(target, "target");
            List<String> list = this.getTargetAliases().get(target);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

