/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import java.util.Collections;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.utils.Printer;

public final class ScopeUtils {
    private ScopeUtils() {
    }

    public static LexicalScope makeScopeForPropertyHeader(@NotNull LexicalScope parent2, @NotNull PropertyDescriptor propertyDescriptor) {
        if (parent2 == null) {
            ScopeUtils.$$$reportNull$$$0(0);
        }
        if (propertyDescriptor == null) {
            ScopeUtils.$$$reportNull$$$0(1);
        }
        return new LexicalScopeImpl(parent2, propertyDescriptor, false, null, Collections.emptyList(), LexicalScopeKind.PROPERTY_HEADER, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, handler2 -> {
            for (TypeParameterDescriptor typeParameterDescriptor : propertyDescriptor.getTypeParameters()) {
                handler2.addClassifierDescriptor(typeParameterDescriptor);
            }
            return Unit.INSTANCE;
        });
    }

    @NotNull
    public static LexicalScope makeScopeForPropertyInitializer(@NotNull LexicalScope propertyHeader, @NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyHeader == null) {
            ScopeUtils.$$$reportNull$$$0(2);
        }
        if (propertyDescriptor == null) {
            ScopeUtils.$$$reportNull$$$0(3);
        }
        return new LexicalScopeImpl(propertyHeader, propertyDescriptor, false, null, Collections.emptyList(), LexicalScopeKind.PROPERTY_INITIALIZER_OR_DELEGATE);
    }

    @NotNull
    public static LexicalScope makeScopeForDelegateConventionFunctions(@NotNull LexicalScope parent2, @NotNull VariableDescriptorWithAccessors variableDescriptor) {
        if (parent2 == null) {
            ScopeUtils.$$$reportNull$$$0(4);
        }
        if (variableDescriptor == null) {
            ScopeUtils.$$$reportNull$$$0(5);
        }
        return new LexicalScopeImpl(parent2, variableDescriptor, true, variableDescriptor.getExtensionReceiverParameter(), Collections.emptyList(), LexicalScopeKind.PROPERTY_DELEGATE_METHOD);
    }

    @NotNull
    public static String printStructure(@Nullable MemberScope scope2) {
        StringBuilder out = new StringBuilder();
        Printer p2 = new Printer(out);
        if (scope2 == null) {
            p2.println("null");
        } else {
            scope2.printScopeStructure(p2);
        }
        String string2 = out.toString();
        if (string2 == null) {
            ScopeUtils.$$$reportNull$$$0(6);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyHeader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/scopes/ScopeUtils";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/scopes/ScopeUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "printStructure";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "makeScopeForPropertyHeader";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "makeScopeForPropertyInitializer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makeScopeForDelegateConventionFunctions";
                break;
            }
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

