/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.byteCodeViewer;

import com.intellij.byteCodeViewer.ByteCodeViewerManager;
import com.intellij.byteCodeViewer.ClassSearcher;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0007\u001a\u00020\b*\u00020\bH\u0002J\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/byteCodeViewer/ByteCodeViewerManager;", "", "<init>", "()V", "CLASS_SEARCHER_EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/byteCodeViewer/ClassSearcher;", "containingClassFileClass", "Lcom/intellij/psi/PsiClass;", "findClassFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "aClass", "findClassFile$intellij_java_byteCodeViewer", "loadClassFileBytes", "", "getJVMClassName", "", "getContainingClass", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.java.byteCodeViewer"})
@SourceDebugExtension(value={"SMAP\nByteCodeViewerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteCodeViewerManager.kt\ncom/intellij/byteCodeViewer/ByteCodeViewerManager\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,94:1\n80#2:95\n*S KotlinDebug\n*F\n+ 1 ByteCodeViewerManager.kt\ncom/intellij/byteCodeViewer/ByteCodeViewerManager\n*L\n24#1:95\n*E\n"})
public final class ByteCodeViewerManager {
    @NotNull
    public static final ByteCodeViewerManager INSTANCE = new ByteCodeViewerManager();
    @NotNull
    private static final ExtensionPointName<ClassSearcher> CLASS_SEARCHER_EP = new ExtensionPointName("ByteCodeViewer.classSearcher");

    private ByteCodeViewerManager() {
    }

    /*
     * WARNING - void declaration
     */
    private final PsiClass containingClassFileClass(PsiClass $this$containingClassFileClass) {
        void $this$parentsOfType$iv;
        PsiElement psiElement = (PsiElement)$this$containingClassFileClass;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        return (PsiClass)SequencesKt.first((Sequence)SequencesKt.filterNot((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, PsiClass.class, (boolean)withSelf$iv), (Function1)containingClassFileClass.1.INSTANCE));
    }

    @Nullable
    public final VirtualFile findClassFile$intellij_java_byteCodeViewer(@NotNull PsiClass aClass) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        PsiClass fileClass = this.containingClassFileClass(aClass);
        VirtualFile virtualFile = fileClass.getOriginalElement().getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)aClass.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        String string = this.getJVMClassName(aClass);
        if (string == null) {
            return null;
        }
        String jvmClassName = string;
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)JavaClassFileType.INSTANCE)) {
            CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)fileIndex.getModuleForFile(file));
            if (compilerModuleExtension == null) {
                return null;
            }
            CompilerModuleExtension moduleExtension = compilerModuleExtension;
            VirtualFile virtualFile2 = fileIndex.isInTestSourceContent(file) ? moduleExtension.getCompilerOutputPathForTests() : moduleExtension.getCompilerOutputPath();
            if (virtualFile2 == null) {
                return null;
            }
            VirtualFile classRoot = virtualFile2;
            return VirtualFileUtil.resolveFromRootOrRelative((VirtualFile)classRoot, (String)(StringsKt.replace$default((String)jvmClassName, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class"));
        }
        return file.getParent().findChild(StringUtil.getShortName((String)jvmClassName) + ".class");
    }

    @JvmStatic
    @Nullable
    public static final byte[] loadClassFileBytes(@NotNull PsiClass aClass) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        VirtualFile virtualFile = INSTANCE.findClassFile$intellij_java_byteCodeViewer(aClass);
        return (byte[])(virtualFile != null ? virtualFile.contentsToByteArray(false) : null);
    }

    private final String getJVMClassName(PsiClass aClass) {
        if (!(aClass instanceof PsiAnonymousClass)) {
            return ClassUtil.getJVMClassName((PsiClass)aClass);
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)aClass), PsiClass.class);
        if (containingClass != null) {
            return this.getJVMClassName(containingClass) + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)aClass));
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final PsiClass getContainingClass(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        for (ClassSearcher searcher : CLASS_SEARCHER_EP.getExtensionList()) {
            PsiClass aClass;
            PsiClass psiClass = aClass = searcher.findClass(psiElement);
            if (psiClass == null) continue;
            return psiClass;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        while (containingClass instanceof PsiTypeParameter) {
            containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)containingClass), PsiClass.class);
        }
        PsiClass psiClass = containingClass;
        if (psiClass != null) {
            return psiClass;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (!(containingFile instanceof PsiClassOwner)) {
            return null;
        }
        TextRange textRange = psiElement.getTextRange();
        PsiClass result = null;
        PsiClass[] psiClassArray = ((PsiClassOwner)containingFile).getClasses();
        Queue queue = new ArrayDeque(CollectionsKt.listOf((Object[])Arrays.copyOf(psiClassArray, psiClassArray.length)));
        while (!queue.isEmpty()) {
            PsiElement navigationElement;
            PsiClass c = (PsiClass)queue.remove();
            PsiElement psiElement2 = navigationElement = c.getNavigationElement();
            Object classRange = psiElement2 != null ? psiElement2.getTextRange() : null;
            if (classRange == null || !classRange.contains(textRange)) continue;
            result = c;
            queue.clear();
            Collection collection = queue;
            PsiClass[] psiClassArray2 = c.getInnerClasses();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassArray2, (String)"getInnerClasses(...)");
            CollectionsKt.addAll((Collection)collection, (Object[])psiClassArray2);
        }
        return result;
    }
}

