/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

public final class ImportOnDemandIntention
extends GrPsiUpdateIntention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        if (element == null) {
            ImportOnDemandIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ImportOnDemandIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            ImportOnDemandIntention.$$$reportNull$$$0(2);
        }
        if (!(element instanceof GrReferenceElement)) {
            return;
        }
        GrReferenceElement ref2 = (GrReferenceElement)element;
        PsiElement resolved = ref2.resolve();
        if (!(resolved instanceof PsiClass)) {
            return;
        }
        PsiClass psiClass = (PsiClass)resolved;
        String qname = psiClass.getQualifiedName();
        GrImportStatement importStatement = GroovyPsiElementFactory.getInstance(context.project()).createImportStatementFromText(qname, true, true, null);
        PsiFile containingFile = element.getContainingFile();
        if (!(containingFile instanceof GroovyFile)) {
            return;
        }
        ((GroovyFile)containingFile).addImport(importStatement);
        for (PsiReference reference : ReferencesSearch.search((PsiElement)resolved, (SearchScope)new LocalSearchScope((PsiElement)containingFile)).asIterable()) {
            PsiElement refElement = reference.getElement();
            PsiElement parent = refElement.getParent();
            if (!(parent instanceof GrQualifiedReference)) continue;
            GrReferenceAdjuster.shortenReference((GrQualifiedReference)parent);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element instanceof GrReferenceElement)) {
                    return false;
                }
                GrReferenceElement ref2 = (GrReferenceElement)element;
                PsiElement parent = ref2.getParent();
                if (!(parent instanceof GrReferenceElement)) {
                    return false;
                }
                PsiElement resolved = ref2.resolve();
                if (resolved == null) {
                    return false;
                }
                return resolved instanceof PsiClass;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/style/ImportOnDemandIntention$1", "satisfiedBy"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "updater";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/style/ImportOnDemandIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

