/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.psi.PsiManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.BitSet;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;

class TypeDfaState {
    static final TypeDfaState EMPTY_STATE = new TypeDfaState((Int2ObjectMap<DFAType>)new Int2ObjectOpenHashMap(), new BitSet());
    private final Int2ObjectMap<DFAType> myVarTypes;
    private final BitSet myProhibitedCachingVars;

    private TypeDfaState(Int2ObjectMap<DFAType> varTypes, BitSet prohibitedCachingVars) {
        this.myVarTypes = varTypes;
        this.myProhibitedCachingVars = prohibitedCachingVars;
    }

    @Contract(pure=true)
    @NotNull
    public static TypeDfaState merge(@NotNull TypeDfaState left, @NotNull TypeDfaState right, PsiManager manager) {
        if (left == null) {
            TypeDfaState.$$$reportNull$$$0(0);
        }
        if (right == null) {
            TypeDfaState.$$$reportNull$$$0(1);
        }
        if (left == right) {
            TypeDfaState typeDfaState = left;
            if (typeDfaState == null) {
                TypeDfaState.$$$reportNull$$$0(2);
            }
            return typeDfaState;
        }
        Int2ObjectMap<DFAType> dominantMap = TypeDfaState.guessDominantMap(left.myVarTypes, right.myVarTypes);
        if (TypeDfaState.dominates(left, right, dominantMap)) {
            TypeDfaState typeDfaState = left;
            if (typeDfaState == null) {
                TypeDfaState.$$$reportNull$$$0(3);
            }
            return typeDfaState;
        }
        if (TypeDfaState.dominates(right, left, dominantMap)) {
            TypeDfaState typeDfaState = right;
            if (typeDfaState == null) {
                TypeDfaState.$$$reportNull$$$0(4);
            }
            return typeDfaState;
        }
        BitSet resultSet = TypeDfaState.mergeProhibitedVariables(left.myProhibitedCachingVars, right.myProhibitedCachingVars);
        Int2ObjectMap<DFAType> resultMap = dominantMap != null ? dominantMap : TypeDfaState.mergeTypeMaps(left.myVarTypes, right.myVarTypes, manager, resultSet);
        return new TypeDfaState(resultMap, resultSet);
    }

    @Contract(pure=true)
    @NotNull
    public TypeDfaState withNewType(int variableIndex, @NotNull DFAType type) {
        Int2ObjectOpenHashMap newTypes;
        BitSet newSet;
        if (type == null) {
            TypeDfaState.$$$reportNull$$$0(5);
        }
        if (variableIndex == 0 || !this.myProhibitedCachingVars.get(variableIndex)) {
            newSet = this.myProhibitedCachingVars;
        } else {
            newSet = (BitSet)this.myProhibitedCachingVars.clone();
            newSet.set(variableIndex, false);
        }
        if (this.myVarTypes.get(variableIndex) == type) {
            newTypes = this.myVarTypes;
        } else {
            newTypes = new Int2ObjectOpenHashMap(this.myVarTypes);
            newTypes.put(variableIndex, (Object)type);
        }
        if (newSet == this.myProhibitedCachingVars && newTypes == this.myVarTypes) {
            TypeDfaState typeDfaState = this;
            if (typeDfaState == null) {
                TypeDfaState.$$$reportNull$$$0(6);
            }
            return typeDfaState;
        }
        return new TypeDfaState((Int2ObjectMap<DFAType>)newTypes, newSet);
    }

    @Contract(pure=true)
    @NotNull
    public TypeDfaState withRemovedBinding(int variableIndex) {
        if (variableIndex == 0 || this.myProhibitedCachingVars.get(variableIndex)) {
            TypeDfaState typeDfaState = this;
            if (typeDfaState == null) {
                TypeDfaState.$$$reportNull$$$0(7);
            }
            return typeDfaState;
        }
        BitSet newProhibitedVars = (BitSet)this.myProhibitedCachingVars.clone();
        newProhibitedVars.set(variableIndex, true);
        return new TypeDfaState(this.myVarTypes, newProhibitedVars);
    }

    boolean contentsEqual(TypeDfaState another) {
        return this.myVarTypes.equals(another.myVarTypes) && this.myProhibitedCachingVars.equals(another.myProhibitedCachingVars);
    }

    @Nullable
    DFAType getVariableType(int descriptor) {
        return descriptor != 0 && !this.myProhibitedCachingVars.get(descriptor) ? (DFAType)this.myVarTypes.get(descriptor) : null;
    }

    Int2ObjectMap<DFAType> getRawVarTypes() {
        return this.myVarTypes;
    }

    @Contract(pure=true)
    @NotNull
    DFAType getNotNullDFAType(int descriptor) {
        DFAType result2 = this.getVariableType(descriptor);
        DFAType dFAType = result2 == null ? DFAType.NULL_DFA_TYPE : result2;
        if (dFAType == null) {
            TypeDfaState.$$$reportNull$$$0(8);
        }
        return dFAType;
    }

    @NonNls
    public String toString() {
        String evicted = this.myProhibitedCachingVars.isEmpty() ? "" : ", (caching prohibited: " + this.myProhibitedCachingVars + ")";
        return this.myVarTypes.toString() + evicted;
    }

    boolean isProhibited(int index) {
        return index == 0 || this.myProhibitedCachingVars.get(index);
    }

    private static BitSet mergeProhibitedVariables(BitSet leftSet, BitSet rightSet) {
        if (leftSet.equals(rightSet)) {
            return leftSet;
        }
        BitSet prohibited = (BitSet)leftSet.clone();
        prohibited.or(rightSet);
        return prohibited;
    }

    @NotNull
    private static Int2ObjectMap<DFAType> mergeTypeMaps(Int2ObjectMap<DFAType> leftMap, Int2ObjectMap<DFAType> rightMap, PsiManager manager, BitSet prohibited) {
        Int2ObjectOpenHashMap newFMap = new Int2ObjectOpenHashMap();
        Stream.concat(rightMap.int2ObjectEntrySet().stream(), leftMap.int2ObjectEntrySet().stream()).forEach(arg_0 -> TypeDfaState.lambda$mergeTypeMaps$0(prohibited, leftMap, rightMap, (Int2ObjectMap)newFMap, manager, arg_0));
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = newFMap;
        if (int2ObjectOpenHashMap == null) {
            TypeDfaState.$$$reportNull$$$0(9);
        }
        return int2ObjectOpenHashMap;
    }

    @Nullable
    private static Int2ObjectMap<DFAType> guessDominantMap(Int2ObjectMap<DFAType> left, Int2ObjectMap<DFAType> right) {
        if (left.size() == right.size() && TypeDfaState.dominatesAll(left, right)) {
            return left;
        }
        if (left.size() > right.size() && TypeDfaState.dominatesAll(left, right)) {
            return left;
        }
        if (left.size() < right.size() && TypeDfaState.dominatesAll(right, left)) {
            return right;
        }
        return null;
    }

    private static boolean dominatesAll(Int2ObjectMap<DFAType> dominator, Int2ObjectMap<DFAType> dominated) {
        for (Int2ObjectMap.Entry dominatedEntry : dominated.int2ObjectEntrySet()) {
            DFAType dominatingType = (DFAType)dominator.get(dominatedEntry.getIntKey());
            if (dominatingType != null && DFAType.dominates(dominatingType, (DFAType)dominatedEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean dominates(TypeDfaState dominator, TypeDfaState dominated, Int2ObjectMap<DFAType> dominantMap) {
        boolean dominateByTypes;
        boolean bl = dominateByTypes = dominated.myVarTypes.isEmpty() || dominantMap == dominator.myVarTypes;
        if (!dominateByTypes) {
            return false;
        }
        return dominator.myProhibitedCachingVars.equals(dominated.myProhibitedCachingVars);
    }

    private static /* synthetic */ void lambda$mergeTypeMaps$0(BitSet prohibited, Int2ObjectMap leftMap, Int2ObjectMap rightMap, Int2ObjectMap newFMap, PsiManager manager, Int2ObjectMap.Entry entry) {
        int descriptorId = entry.getIntKey();
        if (descriptorId == 0 || prohibited.get(descriptorId) || !leftMap.containsKey(descriptorId) || !rightMap.containsKey(descriptorId)) {
            return;
        }
        DFAType candidate = (DFAType)entry.getValue();
        DFAType existing = (DFAType)newFMap.get(descriptorId);
        if (existing == null) {
            newFMap.put(descriptorId, (Object)candidate);
        } else if (candidate != existing) {
            newFMap.put(descriptorId, (Object)DFAType.merge(candidate, existing, manager));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeDfaState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeDfaState";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withNewType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withRemovedBinding";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullDFAType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeTypeMaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withNewType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

