/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrVariableDeclarationStub;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

public class GrVariableDeclarationImpl
extends GrStubElementBase<GrVariableDeclarationStub>
implements GrVariableDeclaration,
StubBasedPsiElement<GrVariableDeclarationStub>,
PsiListLikeElement {
    private static final Logger LOG = Logger.getInstance(GrVariableDeclarationImpl.class);

    public GrVariableDeclarationImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrVariableDeclarationImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public GrVariableDeclarationImpl(@NotNull GrVariableDeclarationStub stub) {
        if (stub == null) {
            GrVariableDeclarationImpl.$$$reportNull$$$0(1);
        }
        super(stub, GroovyStubElementTypes.VARIABLE_DECLARATION);
    }

    @Override
    public <T extends GrStatement> T replaceWithStatement(T statement) {
        return GroovyPsiElementImpl.replaceWithStatement(this, statement);
    }

    @Override
    public void removeStatement() throws IncorrectOperationException {
        GroovyPsiElementImpl.removeStatement(this);
    }

    @Override
    @NotNull
    public GrModifierList getModifierList() {
        GrModifierList grModifierList = (GrModifierList)this.getRequiredStubOrPsiChild(GroovyStubElementTypes.MODIFIER_LIST);
        if (grModifierList == null) {
            GrVariableDeclarationImpl.$$$reportNull$$$0(2);
        }
        return grModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            GrVariableDeclarationImpl.$$$reportNull$$$0(3);
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    public void setType(@Nullable PsiType type) {
        GrTypeElement newTypeElement;
        GrTypeElement typeElement = this.getTypeElementGroovy();
        if (type == null) {
            if (typeElement == null) {
                return;
            }
            if (this.getModifierList().getModifiers().length == 0) {
                this.getModifierList().setModifierProperty("def", true);
            }
            typeElement.delete();
            return;
        }
        type = TypesUtil.unboxPrimitiveTypeWrapper(type);
        try {
            newTypeElement = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(type);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        if (typeElement == null) {
            this.getModifierList().setModifierProperty("def", false);
            GrVariable[] variables = this.getVariables();
            if (variables.length == 0) {
                return;
            }
            newTypeElement = (GrTypeElement)this.addBefore(newTypeElement, variables[0]);
        } else {
            newTypeElement = (GrTypeElement)typeElement.replace(newTypeElement);
        }
        JavaCodeStyleManager.getInstance((Project)this.getProject()).shortenClassReferences((PsiElement)newTypeElement);
    }

    @Override
    public boolean isTuple() {
        return this.findChildByType(GroovyTokenTypes.mLPAREN) != null;
    }

    @Override
    @Nullable
    public GrExpression getTupleInitializer() {
        return GroovyPsiElementImpl.findExpressionChild(this);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement psi;
        if (child == null) {
            GrVariableDeclarationImpl.$$$reportNull$$$0(4);
        }
        if ((psi = child.getPsi()) == this.getTupleInitializer()) {
            this.deleteChildInternal(this.findNotNullChildByType(GroovyTokenTypes.mASSIGN).getNode());
        }
        super.deleteChildInternal(child);
    }

    @Override
    public GrTypeElement getTypeElementGroovyForVariable(GrVariable var) {
        if (this.isTuple()) {
            PsiElement psiElement = PsiUtil.skipWhitespacesAndComments(var.getPrevSibling(), false);
            if (psiElement instanceof GrTypeElement) {
                return (GrTypeElement)psiElement;
            }
            return null;
        }
        return this.getTypeElementGroovy();
    }

    @Override
    @Nullable
    public GrTypeElement getTypeElementGroovy() {
        GrVariableDeclarationStub stub = (GrVariableDeclarationStub)this.getStub();
        if (stub != null) {
            return stub.getTypeElement();
        }
        if (this.isTuple()) {
            return null;
        }
        return (GrTypeElement)this.findChildByClass(GrTypeElement.class);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrVariableDeclarationImpl.$$$reportNull$$$0(5);
        }
        visitor2.visitVariableDeclaration(this);
    }

    public String toString() {
        return "Variable definitions";
    }

    @Override
    public GrMember[] getMembers() {
        return (GrMember[])this.findChildrenByClass(GrMember.class);
    }

    @Override
    public GrVariable @NotNull [] getVariables() {
        GrVariable[] grVariableArray = (GrVariable[])this.getStubOrPsiChildren(TokenSets.VARIABLES, GrVariable.ARRAY_FACTORY);
        if (grVariableArray == null) {
            GrVariableDeclarationImpl.$$$reportNull$$$0(6);
        }
        return grVariableArray;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            GrVariableDeclarationImpl.$$$reportNull$$$0(7);
        }
        if (state == null) {
            GrVariableDeclarationImpl.$$$reportNull$$$0(8);
        }
        if (place == null) {
            GrVariableDeclarationImpl.$$$reportNull$$$0(9);
        }
        if (!ResolveUtilKt.shouldProcessLocals(processor)) {
            return true;
        }
        if (lastParent != null && !(this.getParent() instanceof GrTypeDefinitionBody) && lastParent == this.getTupleInitializer()) {
            return true;
        }
        for (GrVariable variable : this.getVariables()) {
            if (lastParent == variable || lastParent instanceof GrMethod && !(variable instanceof GrField)) break;
            if (ResolveUtil.processElement(processor, (PsiNamedElement)variable, state)) continue;
            return false;
        }
        return true;
    }

    public PsiReference getReference() {
        if (this.getTypeElementGroovy() != null) {
            return null;
        }
        TextRange range = this.getRangeForReference();
        if (range == null) {
            return null;
        }
        return new GrTypeReference(range);
    }

    private TextRange getRangeForReference() {
        PsiElement modifier = this.findSuitableModifier();
        if (modifier == null) {
            return null;
        }
        return modifier.getTextRange().shiftRight(-this.getTextRange().getStartOffset());
    }

    private PsiElement findSuitableModifier() {
        GrModifierList list = this.getModifierList();
        PsiElement defModifier = list.getModifier("def");
        if (defModifier != null) {
            return defModifier;
        }
        PsiElement finalModifier = list.getModifier("final");
        if (finalModifier != null) {
            return finalModifier;
        }
        for (PsiElement element : list.getModifiers()) {
            if (element instanceof GrAnnotation) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public List<? extends PsiElement> getComponents() {
        List<GrVariable> list = Arrays.asList(this.getVariables());
        if (list == null) {
            GrVariableDeclarationImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableDeclarationImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableDeclarationImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 10 -> new IllegalStateException(string);
        };
    }

    private class GrTypeReference
    extends PsiReferenceBase<GrVariableDeclaration> {
        GrTypeReference(TextRange range) {
            super((PsiElement)GrVariableDeclarationImpl.this, range, true);
        }

        @Nullable
        public PsiElement resolve() {
            GrVariable[] variables = GrVariableDeclarationImpl.this.getVariables();
            if (variables.length == 0) {
                return null;
            }
            GrVariable resolved = variables[0];
            PsiType typeGroovy = resolved.getTypeGroovy();
            if (typeGroovy instanceof PsiClassType) {
                return ((PsiClassType)typeGroovy).resolve();
            }
            return resolved;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                GrTypeReference.$$$reportNull$$$0(0);
            }
            return this.getElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrVariableDeclarationImpl$GrTypeReference", "bindToElement"));
        }
    }
}

