/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiTreeUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GrCodeReferenceResolverKt;
import org.jetbrains.plugins.groovy.lang.resolve.OwnerKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.SpreadKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.CodeFieldProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.LocalVariableProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ReferenceExpressionClassProcessor;
import org.jetbrains.plugins.groovy.transformations.inline.GroovyInlineASTTransformationPerformer;
import org.jetbrains.plugins.groovy.transformations.inline.GroovyInlineTransformationUtilKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b*\u00020\fH\u0002\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\t*\u00020\fH\u0002\u001a\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\fH\u0000\u001a\u001a\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000b*\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u001c\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u000b*\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u0015*\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u001e\u0010\u001f\u001a\u0004\u0018\u00010\u0015*\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\fH\u0002\u001a\u0018\u0010!\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020\tH\u0002\u00a8\u0006#"}, d2={"processImplicitSpread", "", "type", "Lcom/intellij/psi/PsiType;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "resolvePackageOrClass", "Lorg/jetbrains/plugins/groovy/lang/resolve/ElementResolveResult;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "doResolvePackageOrClass", "resolveClassFqn", "Lcom/intellij/psi/PsiClass;", "facade", "Lcom/intellij/psi/JavaPsiFacade;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "doResolveStatic", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "resolveToLocalVariable", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariable;", "name", "", "resolveToField", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrField;", "checkCurrentClass", "field", "resolveUnqualifiedType", "resolveQualifiedType", "qualifier", "resolveInInlineTransformation", "psiElement", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGrReferenceResolveRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrReferenceResolveRunner.kt\norg/jetbrains/plugins/groovy/lang/resolve/GrReferenceResolveRunnerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1#2:235\n*E\n"})
public final class GrReferenceResolveRunnerKt {
    private static final boolean processImplicitSpread(PsiType type, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Collection") || type instanceof PsiArrayType && !ResolveUtilKt.checkName(processor, "length", state)) {
            return SpreadKt.processSpread(type, processor, state, place, true);
        }
        return true;
    }

    private static final ElementResolveResult<PsiElement> resolvePackageOrClass(GrReferenceExpression $this$resolvePackageOrClass) {
        ElementResolveResult<PsiElement> elementResolveResult;
        PsiElement psiElement = GrReferenceResolveRunnerKt.doResolvePackageOrClass($this$resolvePackageOrClass);
        if (psiElement != null) {
            PsiElement p0 = psiElement;
            boolean bl = false;
            elementResolveResult = new ElementResolveResult<PsiElement>(p0);
        } else {
            elementResolveResult = null;
        }
        return elementResolveResult;
    }

    private static final PsiElement doResolvePackageOrClass(GrReferenceExpression $this$doResolvePackageOrClass) {
        String string = $this$doResolvePackageOrClass.getQualifiedReferenceName();
        if (string == null) {
            return null;
        }
        String qname = string;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)$this$doResolvePackageOrClass.getProject());
        GlobalSearchScope globalSearchScope = $this$doResolvePackageOrClass.getResolveScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getResolveScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        if ($this$doResolvePackageOrClass.isQualified()) {
            Intrinsics.checkNotNull((Object)facade);
            PsiClass clazz = GrReferenceResolveRunnerKt.resolveClassFqn($this$doResolvePackageOrClass, facade, scope);
            if (clazz != null) {
                PsiClass it = clazz;
                boolean bl = false;
                return (PsiElement)it;
            }
        }
        for (PsiElement parent : com.intellij.psi.util.PsiTreeUtilKt.parents((PsiElement)$this$doResolvePackageOrClass, (boolean)false)) {
            PsiElement psiElement;
            if (!(parent instanceof GrReferenceExpression)) {
                return null;
            }
            GrReferenceExpression grReferenceExpression = (GrReferenceExpression)parent;
            Intrinsics.checkNotNull((Object)facade);
            PsiClass clazz = GrReferenceResolveRunnerKt.resolveClassFqn(grReferenceExpression, facade, scope);
            if (clazz == null) continue;
            PsiPackage psiPackage = facade.findPackage(qname);
            if (psiPackage != null) {
                psiElement = (PsiElement)psiPackage;
            } else {
                PsiManager psiManager = $this$doResolvePackageOrClass.getManager();
                psiElement = (PsiElement)new PsiPackageImpl(qname, psiManager){

                    public boolean isValid() {
                        return !this.getManager().isDisposed();
                    }
                };
            }
            return psiElement;
        }
        return null;
    }

    private static final PsiClass resolveClassFqn(GrReferenceExpression $this$resolveClassFqn, JavaPsiFacade facade, GlobalSearchScope scope) {
        if ($this$resolveClassFqn.getParent() instanceof GrMethodCall) {
            return null;
        }
        String string = $this$resolveClassFqn.getReferenceName();
        if (string == null) {
            return null;
        }
        String name = string;
        if (((CharSequence)name).length() == 0 || !Character.isUpperCase(StringsKt.first((CharSequence)name))) {
            return null;
        }
        String string2 = $this$resolveClassFqn.getQualifiedReferenceName();
        if (string2 == null) {
            return null;
        }
        String qname = string2;
        return facade.findClass(qname, scope);
    }

    @Nullable
    public static final GroovyResolveResult doResolveStatic(@NotNull GrReferenceExpression $this$doResolveStatic) {
        Intrinsics.checkNotNullParameter((Object)$this$doResolveStatic, (String)"<this>");
        String string = $this$doResolveStatic.getReferenceName();
        if (string == null) {
            return null;
        }
        String name = string;
        ElementResolveResult<PsiElement> fqnResult = GrReferenceResolveRunnerKt.resolvePackageOrClass($this$doResolveStatic);
        if (fqnResult != null) {
            return fqnResult;
        }
        GrExpression qualifier = (GrExpression)$this$doResolveStatic.getQualifier();
        if (qualifier == null) {
            ElementResolveResult<GrVariable> localVariable = GrReferenceResolveRunnerKt.resolveToLocalVariable($this$doResolveStatic, name);
            if (localVariable != null) {
                return localVariable;
            }
            ElementResolveResult<PsiElement> macroResult = GrReferenceResolveRunnerKt.resolveInInlineTransformation($this$doResolveStatic);
            if (macroResult != null) {
                return macroResult;
            }
        }
        if (!($this$doResolveStatic.getParent() instanceof GrMethodCall)) {
            ElementResolveResult<GrField> field2;
            if ((qualifier == null || PsiUtilKt.isThisExpression(qualifier)) && (field2 = GrReferenceResolveRunnerKt.resolveToField($this$doResolveStatic, name)) != null && GrReferenceResolveRunnerKt.checkCurrentClass(field2.getElement(), $this$doResolveStatic)) {
                return field2;
            }
            if (qualifier == null) {
                return GrReferenceResolveRunnerKt.resolveUnqualifiedType($this$doResolveStatic, name);
            }
            if (qualifier instanceof GrReferenceExpression) {
                return GrReferenceResolveRunnerKt.resolveQualifiedType($this$doResolveStatic, name, (GrReferenceExpression)qualifier);
            }
        }
        return null;
    }

    @Nullable
    public static final ElementResolveResult<GrVariable> resolveToLocalVariable(@NotNull PsiElement $this$resolveToLocalVariable, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveToLocalVariable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (ElementResolveResult)PsiTreeUtilKt.treeWalkUpAndGet($this$resolveToLocalVariable, new LocalVariableProcessor(name));
    }

    private static final ElementResolveResult<GrField> resolveToField(PsiElement $this$resolveToField, String name) {
        return (ElementResolveResult)PsiTreeUtilKt.treeWalkUpAndGet($this$resolveToField, new CodeFieldProcessor(name, $this$resolveToField));
    }

    private static final boolean checkCurrentClass(GrField field2, PsiElement place) {
        PsiClass psiClass = field2.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        PsiClass containingClass = psiClass;
        return Intrinsics.areEqual((Object)containingClass, (Object)OwnerKt.getOwner(place));
    }

    private static final GroovyResolveResult resolveUnqualifiedType(PsiElement $this$resolveUnqualifiedType, String name) {
        ReferenceExpressionClassProcessor processor = new ReferenceExpressionClassProcessor(name, $this$resolveUnqualifiedType);
        PsiScopeProcessor psiScopeProcessor = processor;
        ResolveState resolveState = ResolveState.initial();
        Intrinsics.checkNotNullExpressionValue((Object)resolveState, (String)"initial(...)");
        GrCodeReferenceResolverKt.processUnqualified($this$resolveUnqualifiedType, psiScopeProcessor, resolveState);
        return processor.getResult();
    }

    private static final GroovyResolveResult resolveQualifiedType(PsiElement $this$resolveQualifiedType, String name, GrReferenceExpression qualifier) {
        PsiElement psiElement = qualifier.getStaticReference().resolve();
        PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
        if (psiClass == null) {
            return null;
        }
        PsiClass classQualifier = psiClass;
        ReferenceExpressionClassProcessor processor = new ReferenceExpressionClassProcessor(name, $this$resolveQualifiedType);
        classQualifier.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, $this$resolveQualifiedType);
        return processor.getResult();
    }

    private static final ElementResolveResult<PsiElement> resolveInInlineTransformation(PsiElement psiElement) {
        GroovyInlineASTTransformationPerformer groovyInlineASTTransformationPerformer = GroovyInlineTransformationUtilKt.getHierarchicalInlineTransformationPerformer(psiElement);
        if (groovyInlineASTTransformationPerformer == null) {
            return null;
        }
        GroovyInlineASTTransformationPerformer handler = groovyInlineASTTransformationPerformer;
        return handler.computeStaticReference(psiElement);
    }

    public static final /* synthetic */ boolean access$processImplicitSpread(PsiType type, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        return GrReferenceResolveRunnerKt.processImplicitSpread(type, processor, state, place);
    }
}

