/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.candidate;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.FirNamedReferenceWithCandidate;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzerContext;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\fH\u0000\u00a8\u0006\r"}, d2={"processConstraintStorageFromExpression", "", "statement", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "processor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "", "addSubsystemFromExpression", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzerContext;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "resolve"})
public final class CandidateFactoryKt {
    /*
     * WARNING - void declaration
     */
    public static final boolean processConstraintStorageFromExpression(@NotNull FirStatement statement, @NotNull Function1<? super ConstraintStorage, Unit> processor) {
        boolean bl;
        Intrinsics.checkNotNullParameter(statement, "statement");
        Intrinsics.checkNotNullParameter(processor, "processor");
        FirStatement firStatement = statement;
        if (firStatement instanceof FirQualifiedAccessExpression || firStatement instanceof FirWhenExpression || firStatement instanceof FirTryExpression || firStatement instanceof FirCheckNotNullCall || firStatement instanceof FirElvisExpression) {
            Candidate candidate2 = CandidateFactoryKt.candidate((FirResolvable)((Object)statement));
            if (candidate2 == null) {
                return false;
            }
            Candidate candidate3 = candidate2;
            processor.invoke(candidate3.getSystem().asReadOnlyStorage());
            bl = true;
        } else if (firStatement instanceof FirSafeCallExpression) {
            bl = CandidateFactoryKt.processConstraintStorageFromExpression(((FirSafeCallExpression)statement).getSelector(), processor);
        } else if (firStatement instanceof FirWrappedArgumentExpression) {
            bl = CandidateFactoryKt.processConstraintStorageFromExpression(((FirWrappedArgumentExpression)statement).getExpression(), processor);
        } else if (firStatement instanceof FirBlock) {
            void var3_4;
            boolean wasAny = false;
            FirExpression firExpression = UtilsKt.getLastExpression((FirBlock)statement);
            if (firExpression != null) {
                FirExpression it = firExpression;
                boolean bl2 = false;
                if (CandidateFactoryKt.processConstraintStorageFromExpression(it, processor)) {
                    wasAny = true;
                }
            }
            bl = var3_4;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean addSubsystemFromExpression(@NotNull PostponedArgumentsAnalyzerContext $this$addSubsystemFromExpression, @NotNull FirStatement statement) {
        Intrinsics.checkNotNullParameter($this$addSubsystemFromExpression, "<this>");
        Intrinsics.checkNotNullParameter(statement, "statement");
        return CandidateFactoryKt.processConstraintStorageFromExpression(statement, arg_0 -> CandidateFactoryKt.addSubsystemFromExpression$lambda$1($this$addSubsystemFromExpression, arg_0));
    }

    @Nullable
    public static final Candidate candidate(@NotNull FirResolvable $this$candidate) {
        Intrinsics.checkNotNullParameter($this$candidate, "<this>");
        FirReference callee = $this$candidate.getCalleeReference();
        if (callee instanceof FirNamedReferenceWithCandidate) {
            return ((FirNamedReferenceWithCandidate)callee).getCandidate();
        }
        return null;
    }

    private static final Unit addSubsystemFromExpression$lambda$1(PostponedArgumentsAnalyzerContext $this_addSubsystemFromExpression, ConstraintStorage it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!it.getUsesOuterCs()) {
            $this_addSubsystemFromExpression.addOtherSystem(it);
        }
        return Unit.INSTANCE;
    }
}

