/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import java.util.Objects;
import java.util.function.Predicate;

interface ListModule {

    public static interface SplitAt {
        public static <T> Tuple2<List<T>, List<T>> splitByPredicateReversed(List<T> source, Predicate<? super T> predicate2) {
            Objects.requireNonNull(predicate2, "predicate is null");
            LinearSeq init2 = List.Nil.instance();
            LinearSeq<T> tail = source;
            while (!tail.isEmpty() && !predicate2.test(tail.head())) {
                init2 = init2.prepend(tail.head());
                tail = tail.tail();
            }
            return Tuple.of(init2, tail);
        }
    }

    public static interface Combinations {
        public static <T> List<List<T>> apply(List<T> elements, int k) {
            if (k == 0) {
                return List.of(List.empty());
            }
            return elements.zipWithIndex().flatMap(t -> Combinations.apply(elements.drop((Integer)t._2 + 1), k - 1).map(c -> c.prepend(t._1)));
        }
    }
}

