/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.base.fe10.analysis;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.base.fe10.analysis.ResolutionAnchorCacheService;
import org.jetbrains.kotlin.idea.base.analysis.LibraryDependenciesCacheImpl;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryDependenciesCache;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.util.LibraryDependenciesUtilKt;
import org.jetbrains.kotlin.idea.caches.project.ModuleInfosFromIdeaModelKt;
import org.jetbrains.kotlin.idea.caches.resolve.util.ResolutionAnchorCacheState;
import org.jetbrains.kotlin.idea.caches.trackers.ModuleModificationTracker;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\u00020\u0001:\u0002./B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0'2\u0006\u0010*\u001a\u00020\u001dH\u0016J\u0014\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020,0\rH\u0002J\b\u0010-\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0014\u001a\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0010R&\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0!0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0010R(\u0010#\u001a\u0016\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0!\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0010R&\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0'0&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0010\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/base/fe10/analysis/ResolutionAnchorCacheServiceImpl;", "Lorg/jetbrains/kotlin/base/fe10/analysis/ResolutionAnchorCacheService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "state", "Lorg/jetbrains/kotlin/idea/caches/resolve/util/ResolutionAnchorCacheState;", "getState", "()Lorg/jetbrains/kotlin/idea/caches/resolve/util/ResolutionAnchorCacheState;", "moduleNameToAnchorName", "", "", "getModuleNameToAnchorName", "()Ljava/util/Map;", "setAnchors", "", "mapping", "anchorMappingCachedValue", "Lcom/intellij/psi/util/CachedValue;", "Lorg/jetbrains/kotlin/base/fe10/analysis/ResolutionAnchorCacheServiceImpl$AnchorMapping;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "anchorMapping", "getAnchorMapping", "()Lorg/jetbrains/kotlin/base/fe10/analysis/ResolutionAnchorCacheServiceImpl$AnchorMapping;", "resolutionAnchorsForLibraries", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "getResolutionAnchorsForLibraries", "librariesForResolutionAnchors", "", "getLibrariesForResolutionAnchors", "librariesForResolutionAnchorsIfComputed", "getLibrariesForResolutionAnchorsIfComputed", "resolutionAnchorDependenciesCache", "", "", "getResolutionAnchorDependenciesCache", "getDependencyResolutionAnchors", "libraryInfo", "associateModulesByNames", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "createResolutionAnchorMapping", "AnchorMapping", "Companion", "kotlin.base.fe10.analysis"})
@SourceDebugExtension(value={"SMAP\nResolutionAnchorCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionAnchorCacheService.kt\norg/jetbrains/kotlin/base/fe10/analysis/ResolutionAnchorCacheServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,188:1\n1619#2:189\n1863#2:190\n1864#2:192\n1620#2:193\n1202#2,2:194\n1230#2,4:196\n1863#2:200\n1864#2:210\n1#3:191\n123#4:201\n123#4:202\n381#5,7:203\n15#6:211\n*S KotlinDebug\n*F\n+ 1 ResolutionAnchorCacheService.kt\norg/jetbrains/kotlin/base/fe10/analysis/ResolutionAnchorCacheServiceImpl\n*L\n126#1:189\n126#1:190\n126#1:192\n126#1:193\n144#1:194,2\n144#1:196,4\n166#1:200\n166#1:210\n126#1:191\n167#1:201\n172#1:202\n178#1:203,7\n185#1:211\n*E\n"})
public final class ResolutionAnchorCacheServiceImpl
implements ResolutionAnchorCacheService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CachedValue<AnchorMapping> anchorMappingCachedValue;
    @NotNull
    private static final Logger logger;

    public ResolutionAnchorCacheServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        CachedValue cachedValue2 = CachedValuesManager.getManager((Project)this.project).createCachedValue((UserDataHolder)this.project, () -> ResolutionAnchorCacheServiceImpl.anchorMappingCachedValue$lambda$0(this), false);
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue2, (String)"createCachedValue(...)");
        this.anchorMappingCachedValue = cachedValue2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final ResolutionAnchorCacheState getState() {
        return ResolutionAnchorCacheState.Companion.getInstance(this.project);
    }

    @NotNull
    public final Map<String, String> getModuleNameToAnchorName() {
        return this.getState().myState.getModuleNameToAnchorName();
    }

    @TestOnly
    public final void setAnchors(@NotNull Map<String, String> mapping) {
        Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
        this.getState().setAnchors(mapping);
    }

    private final AnchorMapping getAnchorMapping() {
        Object object = this.anchorMappingCachedValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (AnchorMapping)object;
    }

    @Override
    @NotNull
    public Map<LibraryInfo, ModuleSourceInfo> getResolutionAnchorsForLibraries() {
        return this.getAnchorMapping().getAnchorByLibrary();
    }

    @Override
    @NotNull
    public Map<ModuleSourceInfo, List<LibraryInfo>> getLibrariesForResolutionAnchors() {
        return this.getAnchorMapping().getLibrariesByAnchor();
    }

    @Override
    @Nullable
    public Map<ModuleSourceInfo, List<LibraryInfo>> getLibrariesForResolutionAnchorsIfComputed() {
        Object object = this.anchorMappingCachedValue.getUpToDateOrNull();
        return object != null && (object = (AnchorMapping)object.get()) != null ? ((AnchorMapping)object).getLibrariesByAnchor() : null;
    }

    private final Map<LibraryInfo, Set<ModuleSourceInfo>> getResolutionAnchorDependenciesCache() {
        Object object = CachedValuesManager.getManager((Project)this.project).getCachedValue((UserDataHolder)this.project, () -> ResolutionAnchorCacheServiceImpl._get_resolutionAnchorDependenciesCache_$lambda$1(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Map)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<ModuleSourceInfo> getDependencyResolutionAnchors(@NotNull LibraryInfo libraryInfo) {
        void destination$iv;
        Set<ModuleSourceInfo> $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
        Set<ModuleSourceInfo> set = this.getResolutionAnchorDependenciesCache().get(libraryInfo);
        if (set != null) {
            Set<ModuleSourceInfo> it = set;
            boolean bl = false;
            return it;
        }
        Collection<LibraryInfo> allTransitiveLibraryDependencies = LibraryDependenciesUtilKt.getTransitiveLibraryDependencyInfos(LibraryDependenciesCache.Companion.getInstance(this.project), libraryInfo);
        Iterable it = allTransitiveLibraryDependencies;
        Collection bl = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            ModuleSourceInfo it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            LibraryInfo it2 = (LibraryInfo)element$iv;
            boolean bl3 = false;
            if (this.getResolutionAnchorsForLibraries().get(it2) == null) continue;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        Set dependencyResolutionAnchors = (Set)destination$iv;
        $this$mapNotNullTo$iv = this.getResolutionAnchorDependenciesCache().putIfAbsent(libraryInfo, dependencyResolutionAnchors);
        if ($this$mapNotNullTo$iv != null) {
            Set<ModuleSourceInfo> it3 = $this$mapNotNullTo$iv;
            boolean bl5 = false;
            return it3;
        }
        TargetPlatform platform = libraryInfo.getPlatform();
        for (LibraryInfo transitiveLibraryDependency : allTransitiveLibraryDependencies) {
            if (!Intrinsics.areEqual((Object)transitiveLibraryDependency.getPlatform(), (Object)platform) || LibraryDependenciesCacheImpl.Companion.isSpecialKotlinCoreLibrary(transitiveLibraryDependency, this.project)) continue;
            this.getResolutionAnchorDependenciesCache().putIfAbsent(transitiveLibraryDependency, dependencyResolutionAnchors);
        }
        return dependencyResolutionAnchors;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ModuleInfo> associateModulesByNames() {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = ModuleInfosFromIdeaModelKt.getModuleInfosFromIdeaModel$default(this.project, null, 2, null);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            String string;
            void moduleInfo;
            IdeaModuleInfo ideaModuleInfo = (IdeaModuleInfo)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            void var11_11 = moduleInfo;
            if (var11_11 instanceof LibraryInfo) {
                string = ((LibraryInfo)moduleInfo).getLibrary().getName();
                if (string == null) {
                    string = "";
                }
            } else if (var11_11 instanceof ModuleSourceInfo) {
                String string2 = ((ModuleSourceInfo)moduleInfo).getModule().getName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            } else {
                String string3 = moduleInfo.getName().asString();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
            }
            map2.put(string, element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final AnchorMapping createResolutionAnchorMapping() {
        Map<String, String> moduleNameToAnchorName = this.getModuleNameToAnchorName();
        if (moduleNameToAnchorName.isEmpty()) {
            return new AnchorMapping(MapsKt.emptyMap(), MapsKt.emptyMap());
        }
        Map<String, ModuleInfo> modulesByNames = this.associateModulesByNames();
        Map anchorByLibrary = new LinkedHashMap();
        Map librariesByAnchor = new LinkedHashMap();
        Iterable $this$forEach$iv = moduleNameToAnchorName.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            ModuleInfo moduleInfo;
            ModuleInfo library;
            block15: {
                String anchorName;
                block14: {
                    ModuleInfo moduleInfo2;
                    block13: {
                        String libraryName;
                        block12: {
                            Map.Entry entry = (Map.Entry)element$iv;
                            boolean bl = false;
                            libraryName = (String)entry.getKey();
                            anchorName = (String)entry.getValue();
                            moduleInfo2 = modulesByNames.get(libraryName);
                            if (moduleInfo2 == null) break block12;
                            ModuleInfo $this$safeAs$iv = moduleInfo2;
                            boolean $i$f$safeAs = false;
                            ModuleInfo moduleInfo3 = $this$safeAs$iv;
                            if (!(moduleInfo3 instanceof LibraryInfo)) {
                                moduleInfo3 = null;
                            }
                            if ((moduleInfo2 = (LibraryInfo)moduleInfo3) != null) break block13;
                        }
                        ResolutionAnchorCacheServiceImpl $this$createResolutionAnchorMapping_u24lambda_u249_u24lambda_u246 = this;
                        boolean bl = false;
                        logger.warn("Resolution anchor mapping key doesn't point to a known library: " + libraryName + ". Skipping this anchor");
                        continue;
                    }
                    library = moduleInfo2;
                    moduleInfo = modulesByNames.get(anchorName);
                    if (moduleInfo == null) break block14;
                    ModuleInfo $this$safeAs$iv = moduleInfo;
                    boolean $i$f$safeAs = false;
                    ModuleInfo moduleInfo4 = $this$safeAs$iv;
                    if (!(moduleInfo4 instanceof ModuleSourceInfo)) {
                        moduleInfo4 = null;
                    }
                    if ((moduleInfo = (ModuleSourceInfo)moduleInfo4) != null) break block15;
                }
                ResolutionAnchorCacheServiceImpl $this$createResolutionAnchorMapping_u24lambda_u249_u24lambda_u247 = this;
                boolean bl = false;
                logger.warn("Resolution anchor mapping value doesn't point to a source module: " + anchorName + ". Skipping this anchor");
                continue;
            }
            ModuleInfo anchor = moduleInfo;
            anchorByLibrary.put(library, anchor);
            Map $this$getOrPut$iv = librariesByAnchor;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(anchor);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(anchor, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(library);
        }
        return new AnchorMapping(anchorByLibrary, librariesByAnchor);
    }

    private static final CachedValueProvider.Result anchorMappingCachedValue$lambda$0(ResolutionAnchorCacheServiceImpl this$0) {
        Object[] objectArray = new Object[]{ModuleModificationTracker.Companion.getInstance(this$0.project), JavaLibraryModificationTracker.getInstance((Project)this$0.project)};
        return CachedValueProvider.Result.create((Object)this$0.createResolutionAnchorMapping(), (Object[])objectArray);
    }

    private static final CachedValueProvider.Result _get_resolutionAnchorDependenciesCache_$lambda$1(ResolutionAnchorCacheServiceImpl this$0) {
        Object[] objectArray = new Object[]{ModuleModificationTracker.Companion.getInstance(this$0.project), JavaLibraryModificationTracker.getInstance((Project)this$0.project)};
        return CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentWeakMap(), (Object[])objectArray);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ResolutionAnchorCacheServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ResolutionAnchorCacheServiceImpl.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/base/fe10/analysis/ResolutionAnchorCacheServiceImpl$AnchorMapping;", "", "anchorByLibrary", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "librariesByAnchor", "", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "getAnchorByLibrary", "()Ljava/util/Map;", "getLibrariesByAnchor", "kotlin.base.fe10.analysis"})
    private static final class AnchorMapping {
        @NotNull
        private final Map<LibraryInfo, ModuleSourceInfo> anchorByLibrary;
        @NotNull
        private final Map<ModuleSourceInfo, List<LibraryInfo>> librariesByAnchor;

        public AnchorMapping(@NotNull Map<LibraryInfo, ? extends ModuleSourceInfo> anchorByLibrary, @NotNull Map<ModuleSourceInfo, ? extends List<? extends LibraryInfo>> librariesByAnchor) {
            Intrinsics.checkNotNullParameter(anchorByLibrary, (String)"anchorByLibrary");
            Intrinsics.checkNotNullParameter(librariesByAnchor, (String)"librariesByAnchor");
            this.anchorByLibrary = anchorByLibrary;
            this.librariesByAnchor = librariesByAnchor;
        }

        @NotNull
        public final Map<LibraryInfo, ModuleSourceInfo> getAnchorByLibrary() {
            return this.anchorByLibrary;
        }

        @NotNull
        public final Map<ModuleSourceInfo, List<LibraryInfo>> getLibrariesByAnchor() {
            return this.librariesByAnchor;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/base/fe10/analysis/ResolutionAnchorCacheServiceImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.base.fe10.analysis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

