/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.Executor;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.GutterContentProvider;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Color;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.api.ScriptEvaluationConfiguration;
import kotlin.script.experimental.api.ScriptEvaluationKt;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.KotlinIdeaReplBundle;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.console.CommandExecutor;
import org.jetbrains.kotlin.console.CommandHistory;
import org.jetbrains.kotlin.console.ConsoleCompilerHelper;
import org.jetbrains.kotlin.console.ConsoleScriptDefinitionSource;
import org.jetbrains.kotlin.console.HistoryKeyListener;
import org.jetbrains.kotlin.console.KotlinConsoleKeeper;
import org.jetbrains.kotlin.console.ReplColors;
import org.jetbrains.kotlin.console.ReplOutputHandler;
import org.jetbrains.kotlin.console.actions.BuildAndRestartConsoleAction;
import org.jetbrains.kotlin.console.actions.KtExecuteCommandAction;
import org.jetbrains.kotlin.console.gutter.ConsoleGutterContentProvider;
import org.jetbrains.kotlin.console.gutter.ConsoleIndicatorRenderer;
import org.jetbrains.kotlin.console.gutter.IconWithTooltip;
import org.jetbrains.kotlin.console.gutter.ReplIcons;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleProductionSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleTestSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.base.util.DumbModeUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinCodeBlockModificationListenerKt;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.repl.ReplState;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0001\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010H\u001a\u00020IH\u0014J\b\u0010J\u001a\u00020\u0002H\u0014J\u0010\u0010K\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020\u0002H\u0002J\u0010\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020IH\u0014J\b\u0010P\u001a\u00020QH\u0014J&\u0010R\u001a\b\u0012\u0004\u0012\u00020T0S2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u000202H\u0014J\u0010\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020QH\u0014J\u0010\u0010]\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010^\u001a\u00020\u001d2\u0006\u0010_\u001a\u00020`H\u0002J\u0010\u0010a\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020\u0002H\u0002J\u0016\u0010b\u001a\u00020*2\u0006\u0010_\u001a\u00020`2\u0006\u0010c\u001a\u00020(J\b\u0010d\u001a\u00020\u001dH\u0007J\u000e\u0010e\u001a\u00020\u001d2\u0006\u0010f\u001a\u00020\u000eJ\u0010\u0010k\u001a\u00020\u001d2\u0006\u0010l\u001a\u00020hH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R$\u0010#\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0015\"\u0004\b$\u0010%R+\u0010+\u001a\u00020*2\u0006\u0010)\u001a\u00020*8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b0\u00101\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R+\u00103\u001a\u0002022\u0006\u0010)\u001a\u0002028B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b8\u00101\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0011\u00109\u001a\u00020:\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R+\u0010>\u001a\u00020=2\u0006\u0010)\u001a\u00020=8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bC\u00101\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u0011\u0010D\u001a\u00020E\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0011\u0010g\u001a\u00020h8F\u00a2\u0006\u0006\u001a\u0004\bi\u0010j\u00a8\u0006m"}, d2={"Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "Lcom/intellij/execution/runners/AbstractConsoleRunnerWithHistory;", "Lcom/intellij/execution/console/LanguageConsoleView;", "module", "Lcom/intellij/openapi/module/Module;", "environmentRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "cmdLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "previousCompilationFailed", "", "myProject", "Lcom/intellij/openapi/project/Project;", "title", "", "path", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/execution/target/TargetEnvironmentRequest;Lcom/intellij/execution/target/TargetedCommandLine;ZLcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getPreviousCompilationFailed$kotlin_repl", "()Z", "replState", "Lorg/jetbrains/kotlin/resolve/repl/ReplState;", "consoleTerminated", "Ljava/util/concurrent/CountDownLatch;", "environment", "Lcom/intellij/execution/target/TargetEnvironment;", "finishConsole", "", "commandHistory", "Lorg/jetbrains/kotlin/console/CommandHistory;", "getCommandHistory", "()Lorg/jetbrains/kotlin/console/CommandHistory;", "value", "isReadLineMode", "setReadLineMode", "(Z)V", "changeConsoleEditorIndicator", "newIconWithTooltip", "Lorg/jetbrains/kotlin/console/gutter/IconWithTooltip;", "<set-?>", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "consoleEditorHighlighter", "getConsoleEditorHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "setConsoleEditorHighlighter", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "consoleEditorHighlighter$delegate", "Lkotlin/properties/ReadWriteProperty;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "disposableDescriptor", "getDisposableDescriptor", "()Lcom/intellij/execution/ui/RunContentDescriptor;", "setDisposableDescriptor", "(Lcom/intellij/execution/ui/RunContentDescriptor;)V", "disposableDescriptor$delegate", "executor", "Lorg/jetbrains/kotlin/console/CommandExecutor;", "getExecutor", "()Lorg/jetbrains/kotlin/console/CommandExecutor;", "Lorg/jetbrains/kotlin/console/ConsoleCompilerHelper;", "compilerHelper", "getCompilerHelper", "()Lorg/jetbrains/kotlin/console/ConsoleCompilerHelper;", "setCompilerHelper", "(Lorg/jetbrains/kotlin/console/ConsoleCompilerHelper;)V", "compilerHelper$delegate", "consoleScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromConfigurations;", "getConsoleScriptDefinition", "()Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition$FromConfigurations;", "createProcess", "Ljava/lang/Process;", "createConsoleView", "enableCompletion", "consoleView", "createProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "process", "createExecuteActionHandler", "Lcom/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler;", "fillToolBarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "toolbarActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "defaultExecutor", "Lcom/intellij/execution/Executor;", "contentDescriptor", "createConsoleExecAction", "Lcom/intellij/execution/console/ConsoleExecuteAction;", "consoleExecuteActionHandler", "constructConsoleTitle", "setupPlaceholder", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "setupGutters", "addGutterIndicator", "iconWithTooltip", "dispose", "successfulLine", "text", "consoleFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getConsoleFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "configureFileDependencies", "psiFile", "kotlin.repl"})
@SourceDebugExtension(value={"SMAP\nKotlinConsoleRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinConsoleRunner.kt\norg/jetbrains/kotlin/console/KotlinConsoleRunner\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,348:1\n73#2:349\n1#3:350\n*S KotlinDebug\n*F\n+ 1 KotlinConsoleRunner.kt\norg/jetbrains/kotlin/console/KotlinConsoleRunner\n*L\n99#1:349\n*E\n"})
public final class KotlinConsoleRunner
extends AbstractConsoleRunnerWithHistory<LanguageConsoleView> {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Module module;
    @NotNull
    private final TargetEnvironmentRequest environmentRequest;
    @NotNull
    private final TargetedCommandLine cmdLine;
    private final boolean previousCompilationFailed;
    @NotNull
    private final ReplState replState;
    @NotNull
    private final CountDownLatch consoleTerminated;
    private TargetEnvironment environment;
    @NotNull
    private final CommandHistory commandHistory;
    private boolean isReadLineMode;
    @NotNull
    private final ReadWriteProperty consoleEditorHighlighter$delegate;
    @NotNull
    private final ReadWriteProperty disposableDescriptor$delegate;
    @NotNull
    private final CommandExecutor executor;
    @NotNull
    private final ReadWriteProperty compilerHelper$delegate;
    @NotNull
    private final ScriptDefinition.FromConfigurations consoleScriptDefinition;

    public KotlinConsoleRunner(@NotNull Module module, @NotNull TargetEnvironmentRequest environmentRequest, @NotNull TargetedCommandLine cmdLine, boolean previousCompilationFailed, @NotNull Project myProject, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, @Nullable String path2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)environmentRequest, (String)"environmentRequest");
        Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super(myProject, title, path2);
        this.module = module;
        this.environmentRequest = environmentRequest;
        this.cmdLine = cmdLine;
        this.previousCompilationFailed = previousCompilationFailed;
        this.replState = new ReplState();
        this.consoleTerminated = new CountDownLatch(1);
        this.commandHistory = new CommandHistory();
        this.consoleEditorHighlighter$delegate = Delegates.INSTANCE.notNull();
        this.disposableDescriptor$delegate = Delegates.INSTANCE.notNull();
        this.executor = new CommandExecutor(this);
        this.compilerHelper$delegate = Delegates.INSTANCE.notNull();
        ScriptingHostConfiguration scriptingHostConfiguration = JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration();
        ScriptCompilationConfiguration scriptCompilationConfiguration = new ScriptCompilationConfiguration((Function1<? super ScriptCompilationConfiguration.Builder, Unit>)((Function1)KotlinConsoleRunner::consoleScriptDefinition$lambda$1));
        ScriptEvaluationConfiguration scriptEvaluationConfiguration = new ScriptEvaluationConfiguration((Function1<? super ScriptEvaluationConfiguration.Builder, Unit>)((Function1)KotlinConsoleRunner::consoleScriptDefinition$lambda$2));
        this.consoleScriptDefinition = new ScriptDefinition.FromConfigurations(this, scriptingHostConfiguration, scriptCompilationConfiguration, scriptEvaluationConfiguration){
            final /* synthetic */ KotlinConsoleRunner this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, null, 8, null);
            }

            public boolean isScript(SourceCode script) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)script, (String)"script");
                String string = script.getName();
                if (string != null) {
                    String string2 = this.this$0.getConsoleView().getVirtualFile().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    bl = StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null);
                } else {
                    bl = false;
                }
                return bl;
            }
        };
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    public final boolean getPreviousCompilationFailed$kotlin_repl() {
        return this.previousCompilationFailed;
    }

    protected void finishConsole() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KotlinConsoleKeeper.Companion.getInstance(project).removeConsole(this.getConsoleView().getVirtualFile());
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ConsoleScriptDefinitionSource consoleScriptDefinitionSource = ConsoleScriptDefinitionSource.Companion.getInstance(project2);
        Intrinsics.checkNotNull((Object)consoleScriptDefinitionSource);
        ConsoleScriptDefinitionSource consoleContributor = consoleScriptDefinitionSource;
        consoleContributor.unregisterDefinition(this.consoleScriptDefinition);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        ScriptDefinitionsManager.Companion.getInstance(project3).reloadDefinitionsBy(consoleContributor);
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.consoleTerminated.countDown();
            return;
        }
        super.finishConsole();
    }

    @NotNull
    public final CommandHistory getCommandHistory() {
        return this.commandHistory;
    }

    public final boolean isReadLineMode() {
        return this.isReadLineMode;
    }

    public final void setReadLineMode(boolean value) {
        if (value) {
            this.changeConsoleEditorIndicator(ReplIcons.INSTANCE.getEDITOR_READLINE_INDICATOR());
        } else {
            this.changeConsoleEditorIndicator(ReplIcons.INSTANCE.getEDITOR_INDICATOR());
        }
        this.isReadLineMode = value;
    }

    private final void changeConsoleEditorIndicator(IconWithTooltip newIconWithTooltip) {
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> KotlinConsoleRunner.changeConsoleEditorIndicator$lambda$0(this, newIconWithTooltip));
    }

    private final RangeHighlighter getConsoleEditorHighlighter() {
        return (RangeHighlighter)this.consoleEditorHighlighter$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setConsoleEditorHighlighter(RangeHighlighter rangeHighlighter) {
        this.consoleEditorHighlighter$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)rangeHighlighter);
    }

    private final RunContentDescriptor getDisposableDescriptor() {
        return (RunContentDescriptor)this.disposableDescriptor$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setDisposableDescriptor(RunContentDescriptor runContentDescriptor) {
        this.disposableDescriptor$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)runContentDescriptor);
    }

    @NotNull
    public final CommandExecutor getExecutor() {
        return this.executor;
    }

    @NotNull
    public final ConsoleCompilerHelper getCompilerHelper() {
        return (ConsoleCompilerHelper)this.compilerHelper$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public final void setCompilerHelper(@NotNull ConsoleCompilerHelper consoleCompilerHelper) {
        Intrinsics.checkNotNullParameter((Object)consoleCompilerHelper, (String)"<set-?>");
        this.compilerHelper$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)consoleCompilerHelper);
    }

    @NotNull
    public final ScriptDefinition.FromConfigurations getConsoleScriptDefinition() {
        return this.consoleScriptDefinition;
    }

    @NotNull
    protected Process createProcess() {
        ProgressIndicator progressIndicator;
        TargetProgressIndicator targetProgressIndicator = TargetProgressIndicator.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)targetProgressIndicator, (String)"EMPTY");
        this.environment = this.environmentRequest.prepareEnvironment(targetProgressIndicator);
        TargetEnvironment targetEnvironment = this.environment;
        if (targetEnvironment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
            targetEnvironment = null;
        }
        if ((progressIndicator = ProgressManager.getInstance().getProgressIndicator()) == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        return targetEnvironment.createProcess(this.cmdLine, progressIndicator);
    }

    @NotNull
    protected LanguageConsoleView createConsoleView() {
        LanguageConsoleBuilder builder2 = new LanguageConsoleBuilder();
        LanguageConsoleView languageConsoleView = builder2.gutterContentProvider((GutterContentProvider)new ConsoleGutterContentProvider()).build(this.getProject(), (Language)KotlinLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)languageConsoleView, (String)"build(...)");
        LanguageConsoleView consoleView = languageConsoleView;
        consoleView.getVirtualFile().rename((Object)this, consoleView.getVirtualFile().getName() + KotlinParserDefinition.STD_SCRIPT_EXT);
        consoleView.getVirtualFile().putUserData(KotlinCodeBlockModificationListenerKt.getKOTLIN_CONSOLE_KEY(), (Object)true);
        consoleView.setPrompt(null);
        EditorEx consoleEditor = consoleView.getConsoleEditor();
        this.setupPlaceholder(consoleEditor);
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        HistoryKeyListener historyKeyListener = new HistoryKeyListener(project, consoleEditor, this.commandHistory);
        consoleEditor.getContentComponent().addKeyListener(historyKeyListener);
        this.commandHistory.getListeners().add(historyKeyListener);
        KtExecuteCommandAction executeAction = new KtExecuteCommandAction(consoleView.getVirtualFile());
        executeAction.registerCustomShortcutSet(CommonShortcuts.getCtrlEnter(), consoleView.getConsoleEditor().getComponent());
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ConsoleScriptDefinitionSource consoleScriptDefinitionSource = ConsoleScriptDefinitionSource.Companion.getInstance(project2);
        Intrinsics.checkNotNull((Object)consoleScriptDefinitionSource);
        ConsoleScriptDefinitionSource consoleContributor = consoleScriptDefinitionSource;
        consoleContributor.registerDefinition(this.consoleScriptDefinition);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        ScriptDefinitionsManager.Companion.getInstance(project3).reloadDefinitionsBy(consoleContributor);
        this.enableCompletion(consoleView);
        this.setupGutters(consoleView);
        return consoleView;
    }

    private final void enableCompletion(LanguageConsoleView consoleView) {
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(consoleView.getVirtualFile());
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return;
        }
        KtFile consoleKtFile = ktFile2;
        this.configureFileDependencies(consoleKtFile);
    }

    @NotNull
    protected OSProcessHandler createProcessHandler(@NotNull Process process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        TargetEnvironment targetEnvironment = this.environment;
        if (targetEnvironment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
            targetEnvironment = null;
        }
        ReplOutputHandler processHandler = new ReplOutputHandler(this, process2, this.cmdLine.getCommandPresentation(targetEnvironment));
        VirtualFile consoleFile = this.getConsoleView().getVirtualFile();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KotlinConsoleKeeper keeper = KotlinConsoleKeeper.Companion.getInstance(project);
        keeper.putVirtualFileToConsole(consoleFile, this);
        return processHandler;
    }

    @NotNull
    protected ProcessBackedConsoleExecuteActionHandler createExecuteActionHandler() {
        ProcessHandler processHandler = this.getProcessHandler();
        return new ProcessBackedConsoleExecuteActionHandler(this, processHandler){
            final /* synthetic */ KotlinConsoleRunner this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, false);
            }

            public void runExecuteAction(LanguageConsoleView consoleView) {
                Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
                this.this$0.getExecutor().executeCommand();
            }
        };
    }

    @NotNull
    protected List<AnAction> fillToolBarActions(@NotNull DefaultActionGroup toolbarActions, @NotNull Executor defaultExecutor, @NotNull RunContentDescriptor contentDescriptor) {
        Intrinsics.checkNotNullParameter((Object)toolbarActions, (String)"toolbarActions");
        Intrinsics.checkNotNullParameter((Object)defaultExecutor, (String)"defaultExecutor");
        Intrinsics.checkNotNullParameter((Object)contentDescriptor, (String)"contentDescriptor");
        this.setDisposableDescriptor(contentDescriptor);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.setCompilerHelper(new ConsoleCompilerHelper(project, this.module, defaultExecutor, contentDescriptor));
        Object[] objectArray = new AnAction[3];
        objectArray[0] = new BuildAndRestartConsoleAction(this);
        ProcessBackedConsoleExecuteActionHandler processBackedConsoleExecuteActionHandler = this.getConsoleExecuteActionHandler();
        Intrinsics.checkNotNullExpressionValue((Object)processBackedConsoleExecuteActionHandler, (String)"getConsoleExecuteActionHandler(...)");
        objectArray[1] = this.createConsoleExecAction(processBackedConsoleExecuteActionHandler);
        objectArray[2] = this.createCloseAction(defaultExecutor, contentDescriptor);
        ArrayList actionList = CollectionsKt.arrayListOf((Object[])objectArray);
        toolbarActions.addAll((Collection)actionList);
        return actionList;
    }

    @NotNull
    protected ConsoleExecuteAction createConsoleExecAction(@NotNull ProcessBackedConsoleExecuteActionHandler consoleExecuteActionHandler) {
        Intrinsics.checkNotNullParameter((Object)consoleExecuteActionHandler, (String)"consoleExecuteActionHandler");
        return new ConsoleExecuteAction(this.getConsoleView(), (ConsoleExecuteAction.ConsoleExecuteActionHandler)consoleExecuteActionHandler, "KotlinShellExecute", (Condition)consoleExecuteActionHandler);
    }

    @NotNull
    protected String constructConsoleTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Object[] objectArray = new Object[]{title, this.module.getName()};
        return KotlinIdeaReplBundle.message("constructor.title.0.in.module.1", objectArray);
    }

    private final void setupPlaceholder(EditorEx editor) {
        AnAction executeCommandAction = ActionManager.getInstance().getAction("KotlinShellExecute");
        String string = KeymapUtil.getFirstKeyboardShortcutText((AnAction)executeCommandAction);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFirstKeyboardShortcutText(...)");
        String executeCommandActionShortcutText = string;
        Object[] objectArray = new Object[]{executeCommandActionShortcutText};
        editor.setPlaceholder((CharSequence)KotlinIdeaReplBundle.message("command.0.to.execute", objectArray));
        editor.setShowPlaceholderWhenFocused(true);
        TextAttributes placeholderAttrs = new TextAttributes();
        placeholderAttrs.setForegroundColor((Color)ReplColors.INSTANCE.getPLACEHOLDER_COLOR());
        placeholderAttrs.setFontType(2);
        editor.setPlaceholderAttributes(placeholderAttrs);
    }

    private final void setupGutters(LanguageConsoleView consoleView) {
        EditorEx historyEditor = consoleView.getHistoryViewer();
        EditorEx consoleEditor = consoleView.getConsoleEditor();
        KotlinConsoleRunner.setupGutters$configureEditorGutter(this, historyEditor, (Color)ReplColors.INSTANCE.getHISTORY_GUTTER_COLOR(), ReplIcons.INSTANCE.getHISTORY_INDICATOR());
        this.setConsoleEditorHighlighter(KotlinConsoleRunner.setupGutters$configureEditorGutter(this, consoleEditor, (Color)ReplColors.INSTANCE.getEDITOR_GUTTER_COLOR(), ReplIcons.INSTANCE.getEDITOR_INDICATOR()));
        historyEditor.getSettings().setUseSoftWraps(true);
        historyEditor.getSettings().setAdditionalLinesCount(0);
        consoleEditor.getSettings().setCaretRowShown(true);
        consoleEditor.getSettings().setAdditionalLinesCount(2);
    }

    @NotNull
    public final RangeHighlighter addGutterIndicator(@NotNull EditorEx editor, @NotNull IconWithTooltip iconWithTooltip) {
        RangeHighlighter indicatorHighlighter;
        RangeHighlighter rangeHighlighter;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)iconWithTooltip, (String)"iconWithTooltip");
        ConsoleIndicatorRenderer indicator = new ConsoleIndicatorRenderer(iconWithTooltip);
        MarkupModelEx markupModelEx = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx editorMarkup = markupModelEx;
        RangeHighlighter rangeHighlighter2 = editorMarkup.addRangeHighlighter(0, editor.getDocument().getTextLength(), 6000, null, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"addRangeHighlighter(...)");
        RangeHighlighter $this$addGutterIndicator_u24lambda_u243 = rangeHighlighter = (indicatorHighlighter = rangeHighlighter2);
        boolean bl = false;
        $this$addGutterIndicator_u24lambda_u243.setGutterIconRenderer((GutterIconRenderer)indicator);
        return rangeHighlighter;
    }

    @TestOnly
    public final void dispose() {
        this.getProcessHandler().destroyProcess();
        this.consoleTerminated.await(1L, TimeUnit.SECONDS);
        Disposer.dispose((Disposable)((Disposable)this.getDisposableDescriptor()));
    }

    public final void successfulLine(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DumbModeUtils.runReadActionInSmartMode(project, () -> KotlinConsoleRunner.successfulLine$lambda$6(this, text));
    }

    @NotNull
    public final KtFile getConsoleFile() {
        VirtualFile consoleFile = this.getConsoleView().getVirtualFile();
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(consoleFile);
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        return (KtFile)psiFile;
    }

    private final void configureFileDependencies(KtFile psiFile) {
        ModuleInfo moduleInfo;
        PsiFile psiFile2 = (PsiFile)psiFile;
        ModuleTestSourceInfo moduleTestSourceInfo = KotlinProjectStructureUtils.getTestSourceInfo(this.module);
        if (moduleTestSourceInfo != null) {
            moduleInfo = moduleTestSourceInfo;
        } else {
            ModuleProductionSourceInfo moduleProductionSourceInfo = KotlinProjectStructureUtils.getProductionSourceInfo(this.module);
            if (moduleProductionSourceInfo != null) {
                moduleInfo = moduleProductionSourceInfo;
            } else {
                Project project = psiFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                moduleInfo = new NotUnderContentRootModuleInfo(project, psiFile);
            }
        }
        KotlinProjectStructureUtils.setForcedModuleInfo(psiFile2, moduleInfo);
    }

    private static final void changeConsoleEditorIndicator$lambda$0(KotlinConsoleRunner this$0, IconWithTooltip $newIconWithTooltip) {
        this$0.getConsoleEditorHighlighter().setGutterIconRenderer((GutterIconRenderer)new ConsoleIndicatorRenderer($newIconWithTooltip));
    }

    private static final Unit consoleScriptDefinition$lambda$1(ScriptCompilationConfiguration.Builder $this$ScriptCompilationConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$ScriptCompilationConfiguration, (String)"$this$ScriptCompilationConfiguration");
        $this$ScriptCompilationConfiguration.invoke(ScriptCompilationKt.getDisplayName($this$ScriptCompilationConfiguration), KotlinIdeaReplBundle.message("name.kotlin.repl", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit consoleScriptDefinition$lambda$2(ScriptEvaluationConfiguration.Builder $this$ScriptEvaluationConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$ScriptEvaluationConfiguration, (String)"$this$ScriptEvaluationConfiguration");
        $this$ScriptEvaluationConfiguration.invoke(ScriptEvaluationKt.getHostConfiguration($this$ScriptEvaluationConfiguration), JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration());
        return Unit.INSTANCE;
    }

    private static final RangeHighlighter setupGutters$configureEditorGutter(KotlinConsoleRunner this$0, EditorEx editor, Color color, IconWithTooltip iconWithTooltip) {
        editor.getSettings().setLineMarkerAreaShown(true);
        editor.getSettings().setFoldingOutlineShown(true);
        editor.getGutterComponentEx().setPaintBackground(true);
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        EditorColorsScheme editorColorScheme = editorColorsScheme;
        editorColorScheme.setColor(EditorColors.GUTTER_BACKGROUND, color);
        editor.setColorsScheme(editorColorScheme);
        return this$0.addGutterIndicator(editor, iconWithTooltip);
    }

    private static final Unit successfulLine$lambda$6$lambda$5(KtFile $psiFile) {
        ScriptConfigurationManager.Companion.updateScriptDependenciesSynchronously((PsiFile)$psiFile);
        return Unit.INSTANCE;
    }

    private static final Unit successfulLine$lambda$6(KotlinConsoleRunner this$0, String $text) {
        LightVirtualFile lightVirtualFile;
        int lineNumber = this$0.replState.getSuccessfulLinesCount() + 1;
        LightVirtualFile $this$successfulLine_u24lambda_u246_u24lambda_u244 = lightVirtualFile = new LightVirtualFile(this$0.getConsoleView().getVirtualFile().getName() + lineNumber + KotlinParserDefinition.STD_SCRIPT_EXT, (Language)KotlinLanguage.INSTANCE, (CharSequence)$text);
        boolean bl = false;
        $this$successfulLine_u24lambda_u246_u24lambda_u244.setCharset(StandardCharsets.UTF_8);
        $this$successfulLine_u24lambda_u246_u24lambda_u244.setWritable(false);
        LightVirtualFile virtualFile = lightVirtualFile;
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)this$0.getProject());
        Intrinsics.checkNotNull((Object)psiFileFactory, (String)"null cannot be cast to non-null type com.intellij.psi.impl.PsiFileFactoryImpl");
        KtFile ktFile2 = (KtFile)((PsiFileFactoryImpl)psiFileFactory).trySetupPsiForFile(virtualFile, (Language)KotlinLanguage.INSTANCE, true, false);
        if (ktFile2 == null) {
            throw new IllegalStateException(("Failed to setup PSI for file:\n" + $text).toString());
        }
        KtFile psiFile = ktFile2;
        ActionsKt.runInEdt$default(null, () -> KotlinConsoleRunner.successfulLine$lambda$6$lambda$5(psiFile), (int)1, null);
        this$0.replState.submitLine(psiFile);
        this$0.configureFileDependencies(psiFile);
        KtScript ktScript = psiFile.getScript();
        Intrinsics.checkNotNull((Object)ktScript);
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)ktScript, null, 1, null);
        ScriptDescriptor scriptDescriptor = declarationDescriptor instanceof ScriptDescriptor ? (ScriptDescriptor)declarationDescriptor : null;
        if (scriptDescriptor == null) {
            throw new IllegalStateException(("Failed to analyze line:\n" + $text).toString());
        }
        ScriptDescriptor scriptDescriptor2 = scriptDescriptor;
        ForceResolveUtil.forceResolveAllContents((Object)scriptDescriptor2);
        this$0.replState.lineSuccess(psiFile, scriptDescriptor2);
        this$0.replState.submitLine(this$0.getConsoleFile());
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(KotlinConsoleRunner.class, "consoleEditorHighlighter", "getConsoleEditorHighlighter()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(KotlinConsoleRunner.class, "disposableDescriptor", "getDisposableDescriptor()Lcom/intellij/execution/ui/RunContentDescriptor;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(KotlinConsoleRunner.class, "compilerHelper", "getCompilerHelper()Lorg/jetbrains/kotlin/console/ConsoleCompilerHelper;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

