/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeUnderscoreUsageWithoutBackticks;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnderscoreChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "diagnosticsCheckNeeded", "", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnderscoreChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnderscoreChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnderscoreChecker\n+ 2 FirReferenceUtils.kt\norg/jetbrains/kotlin/fir/references/FirReferenceUtilsKt\n*L\n1#1,52:1\n24#2,8:53\n*S KotlinDebug\n*F\n+ 1 FirUnderscoreChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnderscoreChecker\n*L\n47#1:53,8\n*E\n"})
public final class FirUnderscoreChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirUnderscoreChecker INSTANCE = new FirUnderscoreChecker();

    private FirUnderscoreChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirStatement expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirStatement firStatement = expression;
        if (firStatement instanceof FirResolvable) {
            if (this.diagnosticsCheckNeeded((FirResolvable)((Object)expression))) {
                FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(((FirResolvable)((Object)expression)).getCalleeReference().getSource(), context, reporter, true);
            }
        } else if (firStatement instanceof FirResolvedQualifier) {
            for (ConeDiagnostic reservedUnderscoreDiagnostic : ((FirResolvedQualifier)expression).getNonFatalDiagnostics()) {
                if (!(reservedUnderscoreDiagnostic instanceof ConeUnderscoreUsageWithoutBackticks)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((ConeUnderscoreUsageWithoutBackticks)reservedUnderscoreDiagnostic).getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getUNDERSCORE_USAGE_WITHOUT_BACKTICKS(), (DiagnosticContext)context, null, (int)8, null);
            }
        } else if (firStatement instanceof FirSmartCastExpression) {
            this.check(((FirSmartCastExpression)expression).getOriginalExpression(), context, reporter);
        }
    }

    private final boolean diagnosticsCheckNeeded(FirResolvable expression) {
        boolean bl;
        if (expression.getCalleeReference() instanceof FirErrorNamedReference) {
            return false;
        }
        FirResolvable firResolvable = expression;
        if (firResolvable instanceof FirImplicitInvokeCall) {
            String string = ((FirImplicitInvokeCall)expression).getCalleeReference().getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            bl = FirUnderscoreHelpersKt.isUnderscore(string);
        } else if (firResolvable instanceof FirCall) {
            Object object;
            FirReference $this$toResolvedSymbol_u24default$iv = expression.getCalleeReference();
            boolean discardErrorReference$iv = false;
            boolean $i$f$toResolvedSymbol = false;
            FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$toResolvedSymbol_u24default$iv);
            FirBasedSymbol<Object> firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
            if (!(firBasedSymbol instanceof FirFunctionSymbol)) {
                firBasedSymbol = null;
            }
            bl = (object = (FirFunctionSymbol)((FirBasedSymbol)((FirFunctionSymbol)firBasedSymbol))) != null && (object = ((FirFunctionSymbol)object).getCallableId()) != null && (object = object.getCallableName()) != null && (object = object.asString()) != null ? FirUnderscoreHelpersKt.isUnderscore((CharSequence)object) : false;
        } else {
            bl = true;
        }
        return bl;
    }
}

