/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirExpressionSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0018\u0010\u000b\u001a\u00020\u0007*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u0018\u001a\u00020\u0007*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u0018\u0010\u001b\u001a\u00020\u0007*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirAnnotatedBinaryExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExpressionSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lcom/intellij/psi/PsiElement;", "<init>", "()V", "isApplicable", "", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "hasAnnotatedLhs", "getHasAnnotatedLhs", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "checkPsi", "", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "psi", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkLightTree", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "isStatementContainer", "Lcom/intellij/lang/LighterASTNode;", "(Lcom/intellij/lang/LighterASTNode;)Z", "isContainerNodeForControlStructureBody", "checkers"})
public final class FirAnnotatedBinaryExpressionChecker
extends FirExpressionSyntaxChecker<FirStatement, PsiElement> {
    @NotNull
    public static final FirAnnotatedBinaryExpressionChecker INSTANCE = new FirAnnotatedBinaryExpressionChecker();

    private FirAnnotatedBinaryExpressionChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirStatement element, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source.getKind() instanceof KtRealSourceElementKind && Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.BINARY_EXPRESSION) && this.getHasAnnotatedLhs(source);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getHasAnnotatedLhs(KtSourceElement $this$hasAnnotatedLhs) {
        PsiElement psiElement = KtSourceElementKt.getPsi((AbstractKtSourceElement)((AbstractKtSourceElement)$this$hasAnnotatedLhs));
        KtBinaryExpression ktBinaryExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
        if ((ktBinaryExpression != null ? ktBinaryExpression.getLeft() : null) instanceof KtAnnotatedExpression) return true;
        LighterASTNode lighterASTNode = (LighterASTNode)ArraysKt.firstOrNull((Object[])LightTreePositioningStrategiesKt.getChildrenArray((FlyweightCapableTreeStructure)$this$hasAnnotatedLhs.getTreeStructure(), (LighterASTNode)$this$hasAnnotatedLhs.getLighterASTNode()));
        if (!Intrinsics.areEqual((Object)(lighterASTNode != null ? lighterASTNode.getTokenType() : null), (Object)KtNodeTypes.ANNOTATED_EXPRESSION)) return false;
        return true;
    }

    @Override
    public void checkPsi(@NotNull FirStatement element, @NotNull KtPsiSourceElement source, @NotNull PsiElement psi, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        PsiElement current = source.getPsi();
        PsiElement parent2 = current.getParent();
        while (parent2 instanceof KtBinaryExpression) {
            if (!Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getLeft(), (Object)current)) {
                return;
            }
            current = parent2;
            parent2 = ((KtBinaryExpression)parent2).getParent();
        }
        if (KtPsiUtil.isStatementContainer((PsiElement)parent2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getANNOTATIONS_ON_BLOCK_LEVEL_EXPRESSION_ON_THE_SAME_LINE(), (DiagnosticContext)context, null, (int)8, null);
        }
    }

    @Override
    public void checkLightTree(@NotNull FirStatement element, @NotNull KtLightSourceElement source, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        LighterASTNode current = source.getLighterASTNode();
        LighterASTNode parent2 = (LighterASTNode)source.getTreeStructure().getParent((Object)current);
        while (true) {
            LighterASTNode lighterASTNode = parent2;
            if (!Intrinsics.areEqual((Object)(lighterASTNode != null ? lighterASTNode.getTokenType() : null), (Object)KtNodeTypes.BINARY_EXPRESSION)) break;
            if (!Intrinsics.areEqual((Object)ArraysKt.firstOrNull((Object[])LightTreePositioningStrategiesKt.getChildrenArray((FlyweightCapableTreeStructure)source.getTreeStructure(), (LighterASTNode)parent2)), (Object)current)) {
                return;
            }
            current = parent2;
            parent2 = (LighterASTNode)source.getTreeStructure().getParent((Object)parent2);
        }
        LighterASTNode lighterASTNode = parent2;
        boolean bl = lighterASTNode != null ? this.isStatementContainer(lighterASTNode) : false;
        if (bl) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getANNOTATIONS_ON_BLOCK_LEVEL_EXPRESSION_ON_THE_SAME_LINE(), (DiagnosticContext)context, null, (int)8, null);
        }
    }

    private final boolean isStatementContainer(LighterASTNode $this$isStatementContainer) {
        return Intrinsics.areEqual((Object)$this$isStatementContainer.getTokenType(), (Object)KtNodeTypes.BLOCK) || Intrinsics.areEqual((Object)$this$isStatementContainer.getTokenType(), (Object)KtNodeTypes.WHEN_ENTRY) || this.isContainerNodeForControlStructureBody($this$isStatementContainer);
    }

    private final boolean isContainerNodeForControlStructureBody(LighterASTNode $this$isContainerNodeForControlStructureBody) {
        return Intrinsics.areEqual((Object)$this$isContainerNodeForControlStructureBody.getTokenType(), (Object)KtNodeTypes.BODY) || Intrinsics.areEqual((Object)$this$isContainerNodeForControlStructureBody.getTokenType(), (Object)KtNodeTypes.ELSE) || Intrinsics.areEqual((Object)$this$isContainerNodeForControlStructureBody.getTokenType(), (Object)KtNodeTypes.THEN);
    }
}

