/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.backend.Fir2IrScopeCache;
import org.jetbrains.kotlin.fir.backend.LeakedDeclarationCaches;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ1\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\u0004\b\u0000\u0010\u001f2\u0019\u0010 \u001a\u0015\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u0001H\u001f0!\u00a2\u0006\u0002\b\"H\u0082\b\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u000fJ\u0016\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u0013J\u0016\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u0017J\u0016\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\f\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage;", "", "<init>", "()V", "cacheStack", "", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrScopeCache;", "enterCallable", "", "lastCache", "getLastCache$annotations", "getLastCache", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrScopeCache;", "leaveCallable", "getParameter", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getVariable", "Lorg/jetbrains/kotlin/ir/symbols/IrVariableSymbol;", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "getLocalFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "localFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getDelegatedProperty", "Lorg/jetbrains/kotlin/ir/symbols/IrLocalDelegatedPropertySymbol;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "last", "T", "getter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "putParameter", "firParameter", "irParameterSymbol", "putVariable", "firVariable", "irVariableSymbol", "putLocalFunction", "firFunction", "irFunctionSymbol", "putDelegatedProperty", "firProperty", "irPropertySymbol", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrLocalCallableStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrLocalCallableStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n52#1,2:75\n55#1:78\n52#1,2:79\n55#1:82\n52#1,2:83\n55#1:86\n1#2:77\n1#2:81\n1#2:85\n1#2:87\n*S KotlinDebug\n*F\n+ 1 Fir2IrLocalCallableStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage\n*L\n40#1:75,2\n40#1:78\n44#1:79,2\n44#1:82\n48#1:83,2\n48#1:86\n40#1:77\n44#1:81\n48#1:85\n*E\n"})
public final class Fir2IrLocalCallableStorage {
    @NotNull
    private final List<Fir2IrScopeCache> cacheStack = new ArrayList();

    public final void enterCallable() {
        ((Collection)this.cacheStack).add(new Fir2IrScopeCache());
    }

    @NotNull
    public final Fir2IrScopeCache getLastCache() {
        return (Fir2IrScopeCache)CollectionsKt.last(this.cacheStack);
    }

    @LeakedDeclarationCaches
    public static /* synthetic */ void getLastCache$annotations() {
    }

    public final void leaveCallable() {
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).clear();
        this.cacheStack.remove(this.cacheStack.size() - 1);
    }

    @Nullable
    public final IrValueParameterSymbol getParameter(@NotNull FirValueParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        for (Fir2IrScopeCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            IrValueParameterSymbol local = cache2.getParameter(parameter);
            if (local == null) continue;
            return local;
        }
        return null;
    }

    @Nullable
    public final IrVariableSymbol getVariable(@NotNull FirVariable variable) {
        IrVariableSymbol irVariableSymbol;
        block1: {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator iterator = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getVariable_u24lambda_u240 = cache$iv = (Fir2IrScopeCache)iterator.next();
                boolean bl = false;
                IrVariableSymbol irVariableSymbol2 = $this$getVariable_u24lambda_u240.getVariable(variable);
                if (irVariableSymbol2 == null) continue;
                IrVariableSymbol it$iv = irVariableSymbol2;
                boolean bl2 = false;
                irVariableSymbol = it$iv;
                break block1;
            }
            irVariableSymbol = null;
        }
        return irVariableSymbol;
    }

    @Nullable
    public final IrSimpleFunctionSymbol getLocalFunctionSymbol(@NotNull FirFunction localFunction) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        block1: {
            Intrinsics.checkNotNullParameter((Object)localFunction, (String)"localFunction");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator iterator = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getLocalFunctionSymbol_u24lambda_u241 = cache$iv = (Fir2IrScopeCache)iterator.next();
                boolean bl = false;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = $this$getLocalFunctionSymbol_u24lambda_u241.getLocalFunction(localFunction);
                if (irSimpleFunctionSymbol2 == null) continue;
                IrSimpleFunctionSymbol it$iv = irSimpleFunctionSymbol2;
                boolean bl2 = false;
                irSimpleFunctionSymbol = it$iv;
                break block1;
            }
            irSimpleFunctionSymbol = null;
        }
        return irSimpleFunctionSymbol;
    }

    @Nullable
    public final IrLocalDelegatedPropertySymbol getDelegatedProperty(@NotNull FirProperty property) {
        IrLocalDelegatedPropertySymbol irLocalDelegatedPropertySymbol;
        block1: {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator iterator = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getDelegatedProperty_u24lambda_u242 = cache$iv = (Fir2IrScopeCache)iterator.next();
                boolean bl = false;
                IrLocalDelegatedPropertySymbol irLocalDelegatedPropertySymbol2 = $this$getDelegatedProperty_u24lambda_u242.getDelegatedProperty(property);
                if (irLocalDelegatedPropertySymbol2 == null) continue;
                IrLocalDelegatedPropertySymbol it$iv = irLocalDelegatedPropertySymbol2;
                boolean bl2 = false;
                irLocalDelegatedPropertySymbol = it$iv;
                break block1;
            }
            irLocalDelegatedPropertySymbol = null;
        }
        return irLocalDelegatedPropertySymbol;
    }

    private final <T> T last(Function1<? super Fir2IrScopeCache, ? extends T> getter) {
        boolean $i$f$last = false;
        for (Fir2IrScopeCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            Object object = getter.invoke((Object)cache2);
            if (object == null) continue;
            Object it = object;
            boolean bl = false;
            return (T)it;
        }
        return null;
    }

    public final void putParameter(@NotNull FirValueParameter firParameter, @NotNull IrValueParameterSymbol irParameterSymbol) {
        Intrinsics.checkNotNullParameter((Object)firParameter, (String)"firParameter");
        Intrinsics.checkNotNullParameter((Object)irParameterSymbol, (String)"irParameterSymbol");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putParameter(firParameter, irParameterSymbol);
    }

    public final void putVariable(@NotNull FirVariable firVariable, @NotNull IrVariableSymbol irVariableSymbol) {
        Intrinsics.checkNotNullParameter((Object)firVariable, (String)"firVariable");
        Intrinsics.checkNotNullParameter((Object)irVariableSymbol, (String)"irVariableSymbol");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putVariable(firVariable, irVariableSymbol);
    }

    public final void putLocalFunction(@NotNull FirFunction firFunction, @NotNull IrSimpleFunctionSymbol irFunctionSymbol) {
        Intrinsics.checkNotNullParameter((Object)firFunction, (String)"firFunction");
        Intrinsics.checkNotNullParameter((Object)irFunctionSymbol, (String)"irFunctionSymbol");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putLocalFunction(firFunction, irFunctionSymbol);
    }

    public final void putDelegatedProperty(@NotNull FirProperty firProperty, @NotNull IrLocalDelegatedPropertySymbol irPropertySymbol) {
        Intrinsics.checkNotNullParameter((Object)firProperty, (String)"firProperty");
        Intrinsics.checkNotNullParameter((Object)irPropertySymbol, (String)"irPropertySymbol");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putDelegatedProperty(firProperty, irPropertySymbol);
    }
}

