/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.constant.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.constant.AnnotationValue;
import org.jetbrains.kotlin.constant.ArrayValue;
import org.jetbrains.kotlin.constant.BooleanValue;
import org.jetbrains.kotlin.constant.ByteValue;
import org.jetbrains.kotlin.constant.CharValue;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.DoubleValue;
import org.jetbrains.kotlin.constant.EnumValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.constant.FloatValue;
import org.jetbrains.kotlin.constant.IntValue;
import org.jetbrains.kotlin.constant.KClassValue;
import org.jetbrains.kotlin.constant.LongValue;
import org.jetbrains.kotlin.constant.NullValue;
import org.jetbrains.kotlin.constant.ShortValue;
import org.jetbrains.kotlin.constant.StringValue;
import org.jetbrains.kotlin.constant.UByteValue;
import org.jetbrains.kotlin.constant.UIntValue;
import org.jetbrains.kotlin.constant.ULongValue;
import org.jetbrains.kotlin.constant.UShortValue;
import org.jetbrains.kotlin.fir.serialization.FirAnnotationArgumentVisitorData;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020!2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020#2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020%2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020'2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020)2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020+2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010,\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020-2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitor;", "Lorg/jetbrains/kotlin/constant/AnnotationArgumentVisitor;", "", "Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;", "<init>", "()V", "visitAnnotationValue", "value", "Lorg/jetbrains/kotlin/constant/AnnotationValue;", "data", "visitArrayValue", "Lorg/jetbrains/kotlin/constant/ArrayValue;", "visitBooleanValue", "Lorg/jetbrains/kotlin/constant/BooleanValue;", "visitByteValue", "Lorg/jetbrains/kotlin/constant/ByteValue;", "visitCharValue", "Lorg/jetbrains/kotlin/constant/CharValue;", "visitDoubleValue", "Lorg/jetbrains/kotlin/constant/DoubleValue;", "visitEnumValue", "Lorg/jetbrains/kotlin/constant/EnumValue;", "visitErrorValue", "Lorg/jetbrains/kotlin/constant/ErrorValue;", "visitFloatValue", "Lorg/jetbrains/kotlin/constant/FloatValue;", "visitIntValue", "Lorg/jetbrains/kotlin/constant/IntValue;", "visitKClassValue", "Lorg/jetbrains/kotlin/constant/KClassValue;", "visitLongValue", "Lorg/jetbrains/kotlin/constant/LongValue;", "visitNullValue", "Lorg/jetbrains/kotlin/constant/NullValue;", "visitShortValue", "Lorg/jetbrains/kotlin/constant/ShortValue;", "visitStringValue", "Lorg/jetbrains/kotlin/constant/StringValue;", "visitUByteValue", "Lorg/jetbrains/kotlin/constant/UByteValue;", "visitUShortValue", "Lorg/jetbrains/kotlin/constant/UShortValue;", "visitUIntValue", "Lorg/jetbrains/kotlin/constant/UIntValue;", "visitULongValue", "Lorg/jetbrains/kotlin/constant/ULongValue;", "fir-serialization"})
public final class FirAnnotationArgumentVisitor
extends AnnotationArgumentVisitor<Unit, FirAnnotationArgumentVisitorData> {
    @NotNull
    public static final FirAnnotationArgumentVisitor INSTANCE = new FirAnnotationArgumentVisitor();

    private FirAnnotationArgumentVisitor() {
    }

    public void visitAnnotationValue(@NotNull AnnotationValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION);
        data.getBuilder().setAnnotation(data.getSerializer().serializeAnnotation(value));
    }

    public void visitArrayValue(@NotNull ArrayValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.ARRAY);
        for (ConstantValue element : (List)value.getValue()) {
            data.getBuilder().addArrayElement(data.getSerializer().valueProto$fir_serialization(element).build());
        }
    }

    public void visitBooleanValue(@NotNull BooleanValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN);
        data.getBuilder().setIntValue((Boolean)value.getValue() != false ? 1L : 0L);
    }

    public void visitByteValue(@NotNull ByteValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
        data.getBuilder().setIntValue((long)((Number)value.getValue()).byteValue());
    }

    public void visitCharValue(@NotNull CharValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.CHAR);
        data.getBuilder().setIntValue((long)((Character)value.getValue()).charValue());
    }

    public void visitDoubleValue(@NotNull DoubleValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.DOUBLE);
        data.getBuilder().setDoubleValue(((Number)value.getValue()).doubleValue());
    }

    public void visitEnumValue(@NotNull EnumValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.ENUM);
        data.getBuilder().setClassId(data.getStringTable().getQualifiedClassNameIndex(value.getEnumClassId()));
        ProtoBuf.Annotation.Argument.Value.Builder builder2 = data.getBuilder();
        FirElementAwareStringTable firElementAwareStringTable = data.getStringTable();
        String string = value.getEnumEntryName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        builder2.setEnumValueId(firElementAwareStringTable.getStringIndex(string));
    }

    public void visitErrorValue(@NotNull ErrorValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        throw new UnsupportedOperationException("Error value: " + value);
    }

    public void visitFloatValue(@NotNull FloatValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.FLOAT);
        data.getBuilder().setFloatValue(((Number)value.getValue()).floatValue());
    }

    public void visitIntValue(@NotNull IntValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
        data.getBuilder().setIntValue((long)((Number)value.getValue()).intValue());
    }

    public void visitKClassValue(@NotNull KClassValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.CLASS);
        KClassValue.Value classValue = (KClassValue.Value)value.getValue();
        if (classValue instanceof KClassValue.Value.NormalClass) {
            data.getBuilder().setClassId(data.getStringTable().getQualifiedClassNameIndex(((KClassValue.Value.NormalClass)classValue).getClassId()));
            if (((KClassValue.Value.NormalClass)classValue).getArrayDimensions() > 0) {
                data.getBuilder().setArrayDimensionCount(((KClassValue.Value.NormalClass)classValue).getArrayDimensions());
            }
        } else if (classValue instanceof KClassValue.Value.LocalClass) {
            ClassId classId = data.getSerializer().getLocalClassIdOracle$fir_serialization().getLocalClassId((KClassValue.Value.LocalClass)classValue);
            if (classId == null) {
                throw new IllegalStateException("Cannot serialize KClass value for local class".toString());
            }
            ClassId classId2 = classId;
            data.getBuilder().setClassId(data.getStringTable().getQualifiedClassNameIndex(classId2));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public void visitLongValue(@NotNull LongValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
        data.getBuilder().setIntValue(((Number)value.getValue()).longValue());
    }

    public void visitNullValue(@NotNull NullValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        throw new UnsupportedOperationException("Null should not appear in annotation arguments");
    }

    public void visitShortValue(@NotNull ShortValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
        data.getBuilder().setIntValue((long)((Number)value.getValue()).shortValue());
    }

    public void visitStringValue(@NotNull StringValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.STRING);
        data.getBuilder().setStringValue(data.getStringTable().getStringIndex((String)value.getValue()));
    }

    public void visitUByteValue(@NotNull UByteValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
        data.getBuilder().setIntValue((long)((Number)value.getValue()).byteValue());
        data.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(Boolean.valueOf(true)));
    }

    public void visitUShortValue(@NotNull UShortValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
        data.getBuilder().setIntValue((long)((Number)value.getValue()).shortValue());
        data.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(Boolean.valueOf(true)));
    }

    public void visitUIntValue(@NotNull UIntValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
        data.getBuilder().setIntValue((long)((Number)value.getValue()).intValue());
        data.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(Boolean.valueOf(true)));
    }

    public void visitULongValue(@NotNull ULongValue value, @NotNull FirAnnotationArgumentVisitorData data) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
        data.getBuilder().setIntValue(((Number)value.getValue()).longValue());
        data.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(Boolean.valueOf(true)));
    }
}

