/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.codeInsight.tooling;

import com.intellij.java.analysis.OuterModelsModificationTrackerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testIntegration.TestFramework;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.tooling.IdePlatformKindTooling;
import org.jetbrains.kotlin.idea.highlighter.KotlinTestRunLineMarkerContributor;
import org.jetbrains.kotlin.idea.projectModel.KotlinPlatform;
import org.jetbrains.kotlin.idea.testIntegration.framework.KotlinPsiBasedTestFramework;
import org.jetbrains.kotlin.idea.util.RunConfigurationUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0018H\u0016J\u0018\u0010 \u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u001a\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/base/codeInsight/tooling/AbstractJvmIdePlatformKindTooling;", "Lorg/jetbrains/kotlin/idea/base/codeInsight/tooling/IdePlatformKindTooling;", "<init>", "()V", "kind", "Lorg/jetbrains/kotlin/platform/impl/JvmIdePlatformKind;", "getKind", "()Lorg/jetbrains/kotlin/platform/impl/JvmIdePlatformKind;", "mavenLibraryIds", "", "", "getMavenLibraryIds", "()Ljava/util/List;", "gradlePluginId", "getGradlePluginId", "()Ljava/lang/String;", "gradlePlatformIds", "Lorg/jetbrains/kotlin/idea/projectModel/KotlinPlatform;", "getGradlePlatformIds", "libraryKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getLibraryKind", "()Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "acceptsAsEntryPoint", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getTestIcon", "Ljavax/swing/Icon;", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "allowSlowOperations", "calculateUrls", "Companion", "kotlin.base.code-insight"})
@SourceDebugExtension(value={"SMAP\nAbstractJvmIdePlatformKindTooling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractJvmIdePlatformKindTooling.kt\norg/jetbrains/kotlin/idea/base/codeInsight/tooling/AbstractJvmIdePlatformKindTooling\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n230#2,2:100\n*S KotlinDebug\n*F\n+ 1 AbstractJvmIdePlatformKindTooling.kt\norg/jetbrains/kotlin/idea/base/codeInsight/tooling/AbstractJvmIdePlatformKindTooling\n*L\n51#1:100,2\n*E\n"})
public abstract class AbstractJvmIdePlatformKindTooling
extends IdePlatformKindTooling {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final JvmIdePlatformKind kind = JvmIdePlatformKind.INSTANCE;
    @NotNull
    private final List<String> mavenLibraryIds;
    @NotNull
    private static final String URL_TEST_PREFIX = "java:test://";
    @NotNull
    private static final String URL_SUITE_PREFIX = "java:suite://";
    @NotNull
    private static final Key<CachedValue<String>> TEST_FRAMEWORK_NAME_KEY;

    public AbstractJvmIdePlatformKindTooling() {
        Object[] objectArray = new String[]{"kotlin-stdlib", "kotlin-stdlib-jre7", "kotlin-stdlib-jdk7", "kotlin-stdlib-jre8", "kotlin-stdlib-jdk8"};
        this.mavenLibraryIds = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public JvmIdePlatformKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public List<String> getMavenLibraryIds() {
        return this.mavenLibraryIds;
    }

    @Override
    @NotNull
    public String getGradlePluginId() {
        return "kotlin-platform-jvm";
    }

    @Override
    @NotNull
    public List<KotlinPlatform> getGradlePlatformIds() {
        Object[] objectArray = new KotlinPlatform[]{KotlinPlatform.JVM, KotlinPlatform.ANDROID};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @Nullable
    public PersistentLibraryKind<?> getLibraryKind() {
        return null;
    }

    @Override
    public boolean acceptsAsEntryPoint(@NotNull KtFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return true;
    }

    @Override
    @Nullable
    public Icon getTestIcon(@NotNull KtNamedDeclaration declaration, boolean allowSlowOperations) {
        Icon icon2;
        CachedValue testFramework2;
        CachedValue cachedValue2;
        block12: {
            block11: {
                TestFramework testFramework3;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                CachedValue calculatedTestFrameworkValue = (CachedValue)declaration.getUserData(TEST_FRAMEWORK_NAME_KEY);
                if (calculatedTestFrameworkValue != null && allowSlowOperations) {
                    return null;
                }
                cachedValue2 = calculatedTestFrameworkValue;
                if (cachedValue2 == null) break block11;
                CachedValue cachedValue3 = cachedValue2;
                boolean bl = false;
                Object object = cachedValue3.getUpToDateOrNull();
                if (object == null || (object = (String)object.get()) == null) {
                    testFramework3 = null;
                } else {
                    Object element$iv2;
                    block10: {
                        Object name2 = object;
                        Iterable $this$first$iv = TestFramework.EXTENSION_NAME.getExtensionList();
                        boolean $i$f$first = false;
                        for (Object element$iv2 : $this$first$iv) {
                            TestFramework it = (TestFramework)element$iv2;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)name2, (Object)it.getName())) continue;
                            break block10;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    testFramework3 = (TestFramework)element$iv2;
                }
                cachedValue2 = testFramework3;
                if (testFramework3 != null) break block12;
            }
            cachedValue2 = KotlinPsiBasedTestFramework.Companion.findTestFramework(declaration, !allowSlowOperations);
        }
        if ((testFramework2 = cachedValue2) != null) {
            List<String> urls;
            declaration.putUserData(TEST_FRAMEWORK_NAME_KEY, (Object)CachedValuesManager.getManager((Project)declaration.getProject()).createCachedValue(() -> AbstractJvmIdePlatformKindTooling.getTestIcon$lambda$2((TestFramework)testFramework2, declaration)));
            List<String> list2 = urls = this.calculateUrls(declaration);
            icon2 = list2 != null ? KotlinTestRunLineMarkerContributor.Companion.getTestStateIcon(list2, declaration) : null;
        } else {
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)declaration), TEST_FRAMEWORK_NAME_KEY);
            icon2 = allowSlowOperations ? this.getTestIconProvider().getGenericTestIcon(declaration, CollectionsKt.emptyList()) : null;
        }
        return icon2;
    }

    private final List<String> calculateUrls(KtNamedDeclaration declaration) {
        List list2;
        String string;
        KtNamedDeclaration ktNamedDeclaration = declaration;
        if (ktNamedDeclaration instanceof KtClassOrObject) {
            FqName fqName2 = ((KtClassOrObject)declaration).getFqName();
            string = fqName2 != null ? fqName2.asString() : null;
        } else {
            KtClassOrObject ktClassOrObject;
            string = ktNamedDeclaration instanceof KtNamedFunction ? ((ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration))) != null && (ktClassOrObject = ktClassOrObject.getFqName()) != null ? ktClassOrObject.asString() : null) : null;
        }
        if (string == null) {
            return null;
        }
        String qualifiedName = string;
        KtNamedDeclaration ktNamedDeclaration2 = declaration;
        if (ktNamedDeclaration2 instanceof KtClassOrObject) {
            list2 = CollectionsKt.listOf((Object)(URL_SUITE_PREFIX + qualifiedName));
        } else if (ktNamedDeclaration2 instanceof KtNamedFunction) {
            Object[] objectArray = new String[]{URL_TEST_PREFIX + qualifiedName + "/" + ((KtNamedFunction)declaration).getName(), URL_TEST_PREFIX + qualifiedName + "." + ((KtNamedFunction)declaration).getName()};
            List urlList = CollectionsKt.listOf((Object[])objectArray);
            list2 = RunConfigurationUtils.INSTANCE.isGradleRunConfiguration((PsiElement)declaration) ? CollectionsKt.plus((Collection)urlList, (Object)(URL_SUITE_PREFIX + qualifiedName + "/" + ((KtNamedFunction)declaration).getName())) : urlList;
        } else {
            list2 = null;
        }
        return list2;
    }

    private static final CachedValueProvider.Result getTestIcon$lambda$2(TestFramework $testFramework, KtNamedDeclaration $declaration) {
        Object[] objectArray = new Object[]{OuterModelsModificationTrackerManager.getInstance((Project)$declaration.getProject()).getTracker()};
        return CachedValueProvider.Result.create((Object)$testFramework.getName(), (Object[])objectArray);
    }

    static {
        Key key = Key.create((String)"TestFramework:name");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TEST_FRAMEWORK_NAME_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/base/codeInsight/tooling/AbstractJvmIdePlatformKindTooling$Companion;", "", "<init>", "()V", "URL_TEST_PREFIX", "", "URL_SUITE_PREFIX", "TEST_FRAMEWORK_NAME_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "getTEST_FRAMEWORK_NAME_KEY", "()Lcom/intellij/openapi/util/Key;", "kotlin.base.code-insight"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<CachedValue<String>> getTEST_FRAMEWORK_NAME_KEY() {
            return TEST_FRAMEWORK_NAME_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

