/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.indices.names;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.io.DataExternalizer;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.konan.FileWithMetadata;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetaFileType;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.indices.names.InternalUtilsKt;
import org.jetbrains.kotlin.idea.base.indices.names.ListOfNamesDataExternalizer;
import org.jetbrains.kotlin.idea.vfilefinder.FqNameKeyDescriptor;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinPartialPackageNamesIndex;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\n\u001a\u00020\u000bH$J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\r\u001a\u00020\u000eH$J\"\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H$J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0014\u001a\u00020\u0015H$J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0014\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J \u0010!\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u00120\"H\u0016J\"\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/base/indices/names/NameByPackageShortNameIndex;", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/name/Name;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getDeclarationNamesByKtFile", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getDeclarationNamesByMetadata", "kotlinJvmBinaryClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "getPackageAndNamesFromBuiltIns", "", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "getDeclarationNamesByKnm", "kotlinNativeMetadata", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Compatible;", "dependsOnFileContent", "", "getVersion", "", "getKeyDescriptor", "Lorg/jetbrains/kotlin/idea/vfilefinder/FqNameKeyDescriptor;", "getValueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "traceKeyHashToVirtualFileMapping", "getInputFilter", "Lcom/intellij/util/indexing/DefaultFileTypeSpecificInputFilter;", "getIndexer", "Lcom/intellij/util/indexing/DataIndexer;", "getPackageAndNamesFromMetadata", "getPackageAndNamesFromKnm", "kotlin.base.indices"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNameByPackageShortNameIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameByPackageShortNameIndex.kt\norg/jetbrains/kotlin/idea/base/indices/names/NameByPackageShortNameIndex\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,100:1\n15#2:101\n*S KotlinDebug\n*F\n+ 1 NameByPackageShortNameIndex.kt\norg/jetbrains/kotlin/idea/base/indices/names/NameByPackageShortNameIndex\n*L\n39#1:101\n*E\n"})
public abstract class NameByPackageShortNameIndex
extends FileBasedIndexExtension<FqName, List<? extends Name>> {
    @NotNull
    private final Logger LOG;

    public NameByPackageShortNameIndex() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KotlinPartialPackageNamesIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
    }

    @NotNull
    protected abstract List<Name> getDeclarationNamesByKtFile(@NotNull KtFile var1);

    @NotNull
    protected abstract List<Name> getDeclarationNamesByMetadata(@NotNull KotlinJvmBinaryClass var1);

    @NotNull
    protected abstract Map<FqName, List<Name>> getPackageAndNamesFromBuiltIns(@NotNull FileContent var1);

    @NotNull
    protected abstract List<Name> getDeclarationNamesByKnm(@NotNull FileWithMetadata.Compatible var1);

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    public FqNameKeyDescriptor getKeyDescriptor() {
        return FqNameKeyDescriptor.INSTANCE;
    }

    @NotNull
    public DataExternalizer<List<Name>> getValueExternalizer() {
        return ListOfNamesDataExternalizer.INSTANCE;
    }

    public boolean traceKeyHashToVirtualFileMapping() {
        return true;
    }

    @NotNull
    public DefaultFileTypeSpecificInputFilter getInputFilter() {
        FileType[] fileTypeArray = new FileType[]{KotlinFileType.INSTANCE, JavaClassFileType.INSTANCE, KotlinBuiltInFileType.INSTANCE, KlibMetaFileType.INSTANCE};
        return new DefaultFileTypeSpecificInputFilter(fileTypeArray);
    }

    @NotNull
    public DataIndexer<FqName, List<Name>, FileContent> getIndexer() {
        return arg_0 -> NameByPackageShortNameIndex.getIndexer$lambda$0(this, arg_0);
    }

    private final Map<FqName, List<Name>> getPackageAndNamesFromMetadata(FileContent fileContent) {
        KotlinJvmBinaryClass kotlinJvmBinaryClass = InternalUtilsKt.toKotlinJvmBinaryClass(fileContent);
        if (kotlinJvmBinaryClass == null) {
            return MapsKt.emptyMap();
        }
        KotlinJvmBinaryClass binaryClass = kotlinJvmBinaryClass;
        if (binaryClass.getClassHeader().getKind() == KotlinClassHeader.Kind.SYNTHETIC_CLASS) {
            return MapsKt.emptyMap();
        }
        if (binaryClass.getClassId().isLocal()) {
            return MapsKt.emptyMap();
        }
        FqName packageName = InternalUtilsKt.getPackageName(binaryClass);
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)packageName, (Object)CollectionsKt.distinct((Iterable)this.getDeclarationNamesByMetadata(binaryClass))));
    }

    private final Map<FqName, List<Name>> getPackageAndNamesFromKnm(FileContent fileContent) {
        FileWithMetadata.Compatible compatible = InternalUtilsKt.toCompatibleFileWithMetadata(fileContent);
        if (compatible == null) {
            return MapsKt.emptyMap();
        }
        FileWithMetadata.Compatible fileWithMetadata = compatible;
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)fileWithMetadata.getPackageFqName(), this.getDeclarationNamesByKnm(fileWithMetadata)));
    }

    private static final Map getIndexer$lambda$0(NameByPackageShortNameIndex this$0, FileContent fileContent) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        try {
            Map map2;
            object = fileContent.getFileType();
            if (Intrinsics.areEqual((Object)object, (Object)JavaClassFileType.INSTANCE)) {
                map2 = this$0.getPackageAndNamesFromMetadata(fileContent);
            } else if (Intrinsics.areEqual((Object)object, (Object)KotlinBuiltInFileType.INSTANCE)) {
                map2 = this$0.getPackageAndNamesFromBuiltIns(fileContent);
            } else if (Intrinsics.areEqual((Object)object, (Object)KotlinFileType.INSTANCE)) {
                PsiFile psiFile = fileContent.getPsiFile();
                KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
                if (ktFile2 == null) {
                    return MapsKt.emptyMap();
                }
                KtFile ktFile3 = ktFile2;
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)ktFile3.getPackageFqName(), (Object)CollectionsKt.distinct((Iterable)this$0.getDeclarationNamesByKtFile(ktFile3))));
            } else {
                map2 = Intrinsics.areEqual((Object)object, (Object)KlibMetaFileType.INSTANCE) ? this$0.getPackageAndNamesFromKnm(fileContent) : MapsKt.emptyMap();
            }
            object = map2;
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            this$0.LOG.warn("Error `(" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")` while indexing file " + fileContent.getFileName() + " using " + this$0.getName() + " index. Probably the file is broken.");
            object = MapsKt.emptyMap();
        }
        return object;
    }
}

