/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.injection;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.ValueArgumentName;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0003\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0012H\u0002\u001a\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u000f*\u00020\u000fH\u0002\u001a \u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002\"\u0016\u0010\u0000\u001a\u00020\u00018\u0000X\u0081D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001c"}, d2={"KOTLIN_SUPPORT_ID", "", "getKOTLIN_SUPPORT_ID", "()Ljava/lang/String;", "extractStringArgumentByName", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "name", "extractLanguageFromInjectAnnotation", "extractStringValue", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "canInjectWithAnnotation", "", "host", "Lcom/intellij/psi/PsiElement;", "findElementToInjectWithAnnotation", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "Lorg/jetbrains/kotlin/psi/KtElement;", "findElementToInjectWithComment", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkIsValidPlaceForInjectionWithLineComment", "statement", "firstNonCommentChild", "prevWalker", "", "element", "scope", "kotlin.base.injection"})
@SourceDebugExtension(value={"SMAP\nKotlinLanguageInjectionSupportBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLanguageInjectionSupportBase.kt\norg/jetbrains/kotlin/idea/base/injection/KotlinLanguageInjectionSupportBaseKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,266:1\n295#2,2:267\n295#2,2:270\n1#3:269\n1251#4,2:272\n*S KotlinDebug\n*F\n+ 1 KotlinLanguageInjectionSupportBase.kt\norg/jetbrains/kotlin/idea/base/injection/KotlinLanguageInjectionSupportBaseKt\n*L\n167#1:267,2\n217#1:270,2\n233#1:272,2\n*E\n"})
public final class KotlinLanguageInjectionSupportBaseKt {
    @NonNls
    @NotNull
    private static final String KOTLIN_SUPPORT_ID = "kotlin";

    @NotNull
    public static final String getKOTLIN_SUPPORT_ID() {
        return KOTLIN_SUPPORT_ID;
    }

    private static final String extractStringArgumentByName(KtAnnotationEntry annotationEntry2, String name2) {
        Object v2;
        block2: {
            List list2 = annotationEntry2.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ValueArgument it = (ValueArgument)element$iv;
                boolean bl = false;
                ValueArgumentName valueArgumentName = it.getArgumentName();
                if (!Intrinsics.areEqual((Object)(valueArgumentName != null && (valueArgumentName = valueArgumentName.getAsName()) != null ? valueArgumentName.asString() : null), (Object)name2)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        ValueArgument valueArgument = v2;
        if (valueArgument == null) {
            return null;
        }
        ValueArgument namedArgument = valueArgument;
        return KotlinLanguageInjectionSupportBaseKt.extractStringValue(namedArgument);
    }

    private static final String extractLanguageFromInjectAnnotation(KtAnnotationEntry annotationEntry2) {
        List list2 = annotationEntry2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        ValueArgument valueArgument = (ValueArgument)CollectionsKt.firstOrNull((List)list2);
        if (valueArgument == null) {
            return null;
        }
        ValueArgument firstArgument2 = valueArgument;
        return KotlinLanguageInjectionSupportBaseKt.extractStringValue(firstArgument2);
    }

    private static final String extractStringValue(ValueArgument valueArgument) {
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        KtStringTemplateExpression ktStringTemplateExpression = ktExpression instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)ktExpression : null;
        if (ktStringTemplateExpression == null) {
            return null;
        }
        KtStringTemplateExpression firstStringArgument = ktStringTemplateExpression;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = firstStringArgument.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        KtStringTemplateEntry ktStringTemplateEntry = (KtStringTemplateEntry)ArraysKt.singleOrNull((Object[])ktStringTemplateEntryArray);
        if (ktStringTemplateEntry == null) {
            return null;
        }
        KtStringTemplateEntry firstStringEntry = ktStringTemplateEntry;
        return firstStringEntry.getText();
    }

    private static final boolean canInjectWithAnnotation(PsiElement host) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host);
        if (module == null) {
            return false;
        }
        Module module2 = module;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module2.getProject());
        return javaPsiFacade.findClass("org.intellij.lang.annotations.Language", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2)) != null;
    }

    private static final KtModifierListOwner findElementToInjectWithAnnotation(KtElement host) {
        Class[] classArray;
        block6: {
            block5: {
                Class[] classArray2;
                Class[] classArray3 = new Class[]{KtBlockExpression.class, KtParameterList.class, KtTypeParameterList.class};
                KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)host), KtModifierListOwner.class, (boolean)false, (Class[])classArray3);
                if (ktModifierListOwner != null) {
                    KtModifierListOwner it = ktModifierListOwner;
                    boolean bl = false;
                    return it;
                }
                classArray = new Class[]{KtBlockExpression.class, KtParameterList.class, KtTypeParameterList.class};
                classArray3 = (Class[])PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)host), KtBinaryExpression.class, (boolean)false, (Class[])classArray);
                if (classArray3 == null) break block5;
                Class[] it = classArray2 = classArray3;
                boolean bl = false;
                Object object = classArray = KtTokens.ALL_ASSIGNMENTS.contains(it.getOperationToken()) ? classArray2 : null;
                if (classArray != null) break block6;
            }
            return null;
        }
        Class[] binaryExpression = classArray;
        KtExpression ktExpression = binaryExpression.getLeft();
        if (ktExpression == null) {
            return null;
        }
        KtExpression left = ktExpression;
        KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)left));
        classArray = ktReference != null ? ktReference.resolve() : null;
        return classArray instanceof KtModifierListOwner ? (KtModifierListOwner)classArray : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final KtExpression findElementToInjectWithComment(KtElement host) {
        Object element$iv;
        Object v2;
        boolean bl;
        Class[] classArray = new Class[]{KtDeclaration.class};
        KtBlockExpression ktBlockExpression = (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)host), KtBlockExpression.class, (boolean)true, (Class[])classArray);
        if (ktBlockExpression == null) {
            return null;
        }
        KtBlockExpression parentBlockExpression = ktBlockExpression;
        List list2 = parentBlockExpression.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
        Iterable $this$firstOrNull$iv = list2;
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v2 = null;
                return v2;
            }
            element$iv = iterator.next();
            KtExpression statement = (KtExpression)element$iv;
            boolean bl2 = false;
            if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)statement), (PsiElement)((PsiElement)host), (boolean)false)) {
                Intrinsics.checkNotNull((Object)statement);
                if (KotlinLanguageInjectionSupportBaseKt.checkIsValidPlaceForInjectionWithLineComment(statement, host)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v2 = element$iv;
        return v2;
    }

    private static final boolean checkIsValidPlaceForInjectionWithLineComment(KtExpression statement, KtElement host) {
        int statementStartOffset = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)statement));
        int hostStart = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)host));
        if (hostStart < statementStartOffset || hostStart - statementStartOffset > 120) {
            return false;
        }
        if (hostStart - statementStartOffset > 2) {
            boolean bl;
            block4: {
                Sequence $this$any$iv = SequencesKt.takeWhile((Sequence)SequencesKt.asSequence(KotlinLanguageInjectionSupportBaseKt.prevWalker((PsiElement)host, (PsiElement)statement)), KotlinLanguageInjectionSupportBaseKt::checkIsValidPlaceForInjectionWithLineComment$lambda$4);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof PsiLanguageInjectionHost && ((PsiLanguageInjectionHost)it).isValidHost() && !StringUtil.isEmptyOrSpaces((String)((PsiLanguageInjectionHost)it).getText()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
        }
        return true;
    }

    private static final PsiElement firstNonCommentChild(PsiElement $this$firstNonCommentChild) {
        PsiElement psiElement = $this$firstNonCommentChild.getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
        return (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)PsiUtilsKt.siblings$default((PsiElement)psiElement, (boolean)false, (boolean)false, (int)3, null), KotlinLanguageInjectionSupportBaseKt::firstNonCommentChild$lambda$6));
    }

    private static final Iterator<PsiElement> prevWalker(PsiElement element, PsiElement scope) {
        return new Iterator<PsiElement>(element, scope){
            private PsiElement e;
            final /* synthetic */ PsiElement $scope;
            {
                this.$scope = $scope;
                this.e = $element;
            }

            public boolean hasNext() {
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public PsiElement next() {
                void var3_3;
                PsiElement parent2;
                PsiElement current = this.e;
                if (current == null || current == this.$scope) {
                    return null;
                }
                PsiElement prev = current.getPrevSibling();
                this.e = prev != null ? PsiTreeUtil.getDeepestLast((PsiElement)prev) : ((parent2 = current.getParent()) == this.$scope || parent2 instanceof PsiFile ? null : var3_3);
                return this.e;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    private static final boolean checkIsValidPlaceForInjectionWithLineComment$lambda$4(PsiElement it) {
        return it != null;
    }

    private static final boolean firstNonCommentChild$lambda$6(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PsiComment || it instanceof PsiWhiteSpace;
    }

    public static final /* synthetic */ String access$extractLanguageFromInjectAnnotation(KtAnnotationEntry annotationEntry2) {
        return KotlinLanguageInjectionSupportBaseKt.extractLanguageFromInjectAnnotation(annotationEntry2);
    }

    public static final /* synthetic */ String access$extractStringArgumentByName(KtAnnotationEntry annotationEntry2, String name2) {
        return KotlinLanguageInjectionSupportBaseKt.extractStringArgumentByName(annotationEntry2, name2);
    }

    public static final /* synthetic */ KtModifierListOwner access$findElementToInjectWithAnnotation(KtElement host) {
        return KotlinLanguageInjectionSupportBaseKt.findElementToInjectWithAnnotation(host);
    }

    public static final /* synthetic */ boolean access$canInjectWithAnnotation(PsiElement host) {
        return KotlinLanguageInjectionSupportBaseKt.canInjectWithAnnotation(host);
    }

    public static final /* synthetic */ PsiElement access$firstNonCommentChild(PsiElement $receiver) {
        return KotlinLanguageInjectionSupportBaseKt.firstNonCommentChild($receiver);
    }

    public static final /* synthetic */ KtExpression access$findElementToInjectWithComment(KtElement host) {
        return KotlinLanguageInjectionSupportBaseKt.findElementToInjectWithComment(host);
    }
}

