/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.TrackableModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinStdlibCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryDependenciesCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoListener;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;
import org.jetbrains.kotlin.idea.base.util.caching.FineGrainedEntityCache;
import org.jetbrains.kotlin.idea.base.util.caching.SynchronizedFineGrainedEntityCache;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinStdlibIndex;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0007\u001e\u001f !\"#$B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0014\u0010\u001c\u001a\u00020\u000e*\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "stdlibCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdLibCache;", "stdlibDependencyCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependencyCache;", "moduleStdlibDependencyCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache;", "libraryScopeContainsIndexedFilesForName", "", "libraryInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "name", "Lorg/jetbrains/kotlin/name/FqName;", "isFatJar", "isKotlinJavaRuntime", "isStdlib", "isStdlibDependency", "findStdlibInModuleDependencies", "module", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "dispose", "", "isStdlibWithFile", "fileName", "Companion", "StdlibDependency", "LibraryScope", "BaseStdLibCache", "StdLibCache", "StdlibDependencyCache", "ModuleStdlibDependencyCache", "kotlin.base.project-structure"})
public final class KotlinStdlibCacheImpl
implements KotlinStdlibCache,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final StdLibCache stdlibCache;
    @NotNull
    private final StdlibDependencyCache stdlibDependencyCache;
    @NotNull
    private final ModuleStdlibDependencyCache moduleStdlibDependencyCache;
    @NotNull
    private static final String KOTLIN_JAVA_RUNTIME_NAME = "KotlinJavaRuntime";
    @NotNull
    private static final LibraryInfo noStdlibDependency = StdlibDependency.constructor-impl(null);

    public KotlinStdlibCacheImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.stdlibCache = new StdLibCache();
        this.stdlibDependencyCache = new StdlibDependencyCache();
        this.moduleStdlibDependencyCache = new ModuleStdlibDependencyCache();
        Disposer.register((Disposable)this, (Disposable)this.stdlibCache);
        Disposer.register((Disposable)this, (Disposable)this.stdlibDependencyCache);
        Disposer.register((Disposable)this, (Disposable)this.moduleStdlibDependencyCache);
    }

    private final boolean libraryScopeContainsIndexedFilesForName(LibraryInfo libraryInfo, FqName name2) {
        VirtualFile[] virtualFileArray = libraryInfo.getLibrary().getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        LibraryScope libraryScope = new LibraryScope(this.project, ArraysKt.toSet((Object[])virtualFileArray));
        Object object = DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> KotlinStdlibCacheImpl.libraryScopeContainsIndexedFilesForName$lambda$0(name2, libraryScope));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ignoreDumbMode(...)");
        return (Boolean)object;
    }

    private final boolean isFatJar(LibraryInfo libraryInfo) {
        return libraryInfo.getLibraryRoots().size() > 1;
    }

    private final boolean isKotlinJavaRuntime(LibraryInfo libraryInfo) {
        return Intrinsics.areEqual((Object)libraryInfo.getLibrary().getName(), (Object)KOTLIN_JAVA_RUNTIME_NAME);
    }

    @Override
    public boolean isStdlib(@NotNull LibraryInfo libraryInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
        return (Boolean)this.stdlibCache.get(libraryInfo);
    }

    @Override
    public boolean isStdlibDependency(@NotNull LibraryInfo libraryInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
        return (Boolean)this.stdlibDependencyCache.get(libraryInfo);
    }

    @Override
    @Nullable
    public LibraryInfo findStdlibInModuleDependencies(@NotNull IdeaModuleInfo module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ProgressManager.checkCanceled();
        LibraryInfo stdlibDependency = this.moduleStdlibDependencyCache.get-ZbUFyrI(module);
        return stdlibDependency;
    }

    public void dispose() {
    }

    private final boolean isStdlibWithFile(LibraryInfo $this$isStdlibWithFile, FqName fileName) {
        if (this.isFatJar($this$isStdlibWithFile) && !this.isKotlinJavaRuntime($this$isStdlibWithFile)) {
            return false;
        }
        return this.libraryScopeContainsIndexedFilesForName($this$isStdlibWithFile, fileName);
    }

    private static final Boolean libraryScopeContainsIndexedFilesForName$lambda$0(FqName $name, LibraryScope $libraryScope) {
        return FileBasedIndex.getInstance().getContainingFilesIterator(KotlinStdlibIndex.Companion.getNAME(), (Object)$name, (GlobalSearchScope)$libraryScope).hasNext();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u0011\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0016\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$BaseStdLibCache;", "Lorg/jetbrains/kotlin/idea/base/util/caching/SynchronizedFineGrainedEntityCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "subscribe", "", "checkKeyValidity", "key", "libraryInfosRemoved", "libraryInfos", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdLibCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependencyCache;", "kotlin.base.project-structure"})
    private static abstract class BaseStdLibCache
    extends SynchronizedFineGrainedEntityCache<LibraryInfo, Boolean>
    implements LibraryInfoListener {
        private BaseStdLibCache(Project project) {
            super(project, false, true);
        }

        @Override
        protected void subscribe() {
            MessageBusConnection busConnection = this.getProject().getMessageBus().connect((Disposable)this);
            busConnection.subscribe(LibraryInfoListener.Companion.getTOPIC(), (Object)this);
        }

        @Override
        protected void checkKeyValidity(@NotNull LibraryInfo key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            key.checkValidity();
        }

        @Override
        public void libraryInfosRemoved(@NotNull Collection<? extends LibraryInfo> libraryInfos) {
            Intrinsics.checkNotNullParameter(libraryInfos, (String)"libraryInfos");
            FineGrainedEntityCache.invalidateKeys$default(this, libraryInfos, null, 2, null);
        }

        public /* synthetic */ BaseStdLibCache(Project project, DefaultConstructorMarker $constructor_marker) {
            this(project);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$Companion;", "", "<init>", "()V", "KOTLIN_JAVA_RUNTIME_NAME", "", "noStdlibDependency", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependency;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "kotlin.base.project-structure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$LibraryScope;", "Lcom/intellij/psi/search/DelegatingGlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "directories", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "fileSystems", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "contains", "", "file", "toString", "", "kotlin.base.project-structure"})
    @SourceDebugExtension(value={"SMAP\nKotlinStdlibCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStdlibCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$LibraryScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n1628#2,3:298\n*S KotlinDebug\n*F\n+ 1 KotlinStdlibCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$LibraryScope\n*L\n85#1:298,3\n*E\n"})
    private static final class LibraryScope
    extends DelegatingGlobalSearchScope {
        @NotNull
        private final Set<VirtualFile> directories;
        @NotNull
        private final Set<VirtualFileSystem> fileSystems;

        /*
         * WARNING - void declaration
         */
        public LibraryScope(@NotNull Project project, @NotNull Set<? extends VirtualFile> directories) {
            void destination$iv;
            void $this$mapTo$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(directories, (String)"directories");
            super(GlobalSearchScope.allScope((Project)project));
            this.directories = directories;
            Iterable iterable = this.directories;
            Collection collection = new HashSet();
            LibraryScope libraryScope = this;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void p0;
                VirtualFile virtualFile = (VirtualFile)item$iv;
                void var11_11 = destination$iv;
                boolean bl = false;
                var11_11.add(p0.getFileSystem());
            }
            libraryScope.fileSystems = (Set)destination$iv;
        }

        public boolean contains(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.fileSystems.contains(file.getFileSystem()) && VfsUtilCore.isUnder((VirtualFile)file, this.directories);
        }

        @NotNull
        public String toString() {
            return "All files under: " + this.directories;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0016\u0010\u0004\u001a\n0\u0005R\u00060\u0000R\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n0\bR\u00060\u0000R\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache;", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl;)V", "libraryCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$LibraryCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl;", "moduleCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$ModuleCache;", "get", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependency;", "key", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "get-ZbUFyrI", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;)Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "dispose", "", "AbstractCache", "LibraryCache", "ModuleCache", "kotlin.base.project-structure"})
    private final class ModuleStdlibDependencyCache
    implements Disposable {
        @NotNull
        private final LibraryCache libraryCache = new LibraryCache();
        @NotNull
        private final ModuleCache moduleCache = new ModuleCache();

        public ModuleStdlibDependencyCache() {
            Disposer.register((Disposable)this, (Disposable)this.libraryCache);
            Disposer.register((Disposable)this, (Disposable)this.moduleCache);
        }

        @NotNull
        public final LibraryInfo get-ZbUFyrI(@NotNull IdeaModuleInfo key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            IdeaModuleInfo ideaModuleInfo = key;
            return ideaModuleInfo instanceof LibraryInfo ? ((StdlibDependency)this.libraryCache.get(key)).unbox-impl() : (ideaModuleInfo instanceof SdkInfo || ideaModuleInfo instanceof NotUnderContentRootModuleInfo ? noStdlibDependency : ((StdlibDependency)this.moduleCache.get(key)).unbox-impl());
        }

        public void dispose() {
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00a2\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u00032\u00020\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0013\u0010\f\u001a\u0004\u0018\u00010\r*\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u0004*\u0004\u0018\u00010\rH\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$AbstractCache;", "Key", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/idea/base/util/caching/SynchronizedFineGrainedEntityCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependency;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoListener;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache;)V", "subscribe", "", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "findStdLib", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;)Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "toStdlibDependency", "toStdlibDependency-ZbUFyrI", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "checkValueValidity", "value", "checkValueValidity-d6v7aPo", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)V", "kotlin.base.project-structure"})
        @SourceDebugExtension(value={"SMAP\nKotlinStdlibCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStdlibCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$AbstractCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,297:1\n1#2:298\n123#3:299\n*S KotlinDebug\n*F\n+ 1 KotlinStdlibCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$AbstractCache\n*L\n183#1:299\n*E\n"})
        private abstract class AbstractCache<Key extends IdeaModuleInfo>
        extends SynchronizedFineGrainedEntityCache<Key, StdlibDependency>
        implements LibraryInfoListener {
            public AbstractCache() {
                super(KotlinStdlibCacheImpl.this.project, false, true);
            }

            @Override
            protected void subscribe() {
                MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
                connection.subscribe(LibraryInfoListener.Companion.getTOPIC(), (Object)this);
                this.subscribe(connection);
            }

            protected void subscribe(@NotNull MessageBusConnection connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            }

            @Nullable
            protected final LibraryInfo findStdLib(@NotNull Key $this$findStdLib) {
                LibraryInfo libraryInfo;
                block7: {
                    List<IdeaModuleInfo> list2;
                    Intrinsics.checkNotNullParameter($this$findStdLib, (String)"<this>");
                    if ($this$findStdLib instanceof LibraryInfo) {
                        if (KotlinStdlibCacheImpl.this.isStdlib((LibraryInfo)$this$findStdLib)) {
                            return (LibraryInfo)$this$findStdLib;
                        }
                        list2 = LibraryDependenciesCache.Companion.getInstance(((LibraryInfo)$this$findStdLib).getProject()).getLibraryDependencies((LibraryInfo)$this$findStdLib).getLibraries();
                    } else {
                        list2 = $this$findStdLib.dependencies();
                    }
                    List<IdeaModuleInfo> dependencies = list2;
                    Iterable iterable = dependencies;
                    KotlinStdlibCacheImpl kotlinStdlibCacheImpl = KotlinStdlibCacheImpl.this;
                    for (IdeaModuleInfo it : iterable) {
                        LibraryInfo libraryInfo2;
                        LibraryInfo libraryInfo3;
                        boolean bl = false;
                        IdeaModuleInfo $this$safeAs$iv = it;
                        boolean $i$f$safeAs = false;
                        IdeaModuleInfo ideaModuleInfo = $this$safeAs$iv;
                        if (!(ideaModuleInfo instanceof LibraryInfo)) {
                            ideaModuleInfo = null;
                        }
                        if ((LibraryInfo)ideaModuleInfo != null) {
                            LibraryInfo libraryInfo4;
                            LibraryInfo p0 = libraryInfo4;
                            boolean bl2 = false;
                            libraryInfo3 = kotlinStdlibCacheImpl.isStdlib(p0) ? libraryInfo4 : null;
                        } else {
                            libraryInfo3 = null;
                        }
                        if ((libraryInfo2 = libraryInfo3) == null) continue;
                        libraryInfo = libraryInfo2;
                        break block7;
                    }
                    libraryInfo = null;
                }
                return libraryInfo;
            }

            @NotNull
            protected final LibraryInfo toStdlibDependency-ZbUFyrI(@Nullable LibraryInfo $this$toStdlibDependency_u2dZbUFyrI) {
                if ($this$toStdlibDependency_u2dZbUFyrI != null) {
                    return StdlibDependency.constructor-impl($this$toStdlibDependency_u2dZbUFyrI);
                }
                Boolean flag = (Boolean)ActionsKt.runReadAction(() -> AbstractCache.toStdlibDependency_ZbUFyrI$lambda$1(this));
                Boolean bl = flag;
                if (bl == null) {
                    throw new ProcessCanceledException();
                }
                if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                    throw IndexNotReadyException.create();
                }
                return noStdlibDependency;
            }

            protected void checkValueValidity-d6v7aPo(@NotNull LibraryInfo value) {
                block0: {
                    LibraryInfo libraryInfo = value;
                    if (libraryInfo == null) break block0;
                    libraryInfo.checkValidity();
                }
            }

            private static final Boolean toStdlibDependency_ZbUFyrI$lambda$1(AbstractCache this$0) {
                return this$0.getProject().isDisposed() ? null : (DumbService.Companion.isDumb(this$0.getProject()) ? Boolean.valueOf(true) : Boolean.valueOf(false));
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\b\u0082\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u00020\u0001R\u00060\u0003R\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0016\u0010\u0011\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$LibraryCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$AbstractCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache;)V", "calculate", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependency;", "key", "calculate-ZbUFyrI", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "putExtraValues", "", "map", "", "checkKeyValidity", "libraryInfosRemoved", "libraryInfos", "", "kotlin.base.project-structure"})
        private final class LibraryCache
        extends AbstractCache<LibraryInfo> {
            @NotNull
            public LibraryInfo calculate-ZbUFyrI(@NotNull LibraryInfo key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return this.toStdlibDependency-ZbUFyrI(this.findStdLib((IdeaModuleInfo)key));
            }

            public final void putExtraValues(@NotNull Map<LibraryInfo, StdlibDependency> map2) {
                Intrinsics.checkNotNullParameter(map2, (String)"map");
                this.putAll(map2);
            }

            @Override
            protected void checkKeyValidity(@NotNull LibraryInfo key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                key.checkValidity();
            }

            @Override
            public void libraryInfosRemoved(@NotNull Collection<? extends LibraryInfo> libraryInfos) {
                Intrinsics.checkNotNullParameter(libraryInfos, (String)"libraryInfos");
                FineGrainedEntityCache.invalidateEntries$default(this, (arg_0, arg_1) -> LibraryCache.libraryInfosRemoved$lambda$0(libraryInfos, arg_0, arg_1), null, 2, null);
            }

            private static final boolean libraryInfosRemoved$lambda$0(Collection $libraryInfos, LibraryInfo k, StdlibDependency v) {
                Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                return $libraryInfos.contains(k) || CollectionsKt.contains((Iterable)$libraryInfos, (Object)v.unbox-impl());
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u00020\u0001R\u00060\u0003R\u00020\u00042\u00020\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0017\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0016\u0010\u0016\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$ModuleCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$AbstractCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelChangeListener;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache;)V", "subscribe", "", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "calculate", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependency;", "key", "calculate-ZbUFyrI", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;)Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "postProcessNewValue", "value", "postProcessNewValue-6iLzBBY", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)V", "checkKeyValidity", "libraryInfosRemoved", "libraryInfos", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "changed", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "kotlin.base.project-structure"})
        @SourceDebugExtension(value={"SMAP\nKotlinStdlibCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStdlibCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$ModuleCache\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 WorkspaceEntityChangeListener.kt\norg/jetbrains/kotlin/idea/base/util/caching/WorkspaceEntityChangeListenerKt\n*L\n1#1,297:1\n123#2:298\n123#2:299\n1#3:300\n1863#4,2:301\n111#5:303\n*S KotlinDebug\n*F\n+ 1 KotlinStdlibCache.kt\norg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$ModuleStdlibDependencyCache$ModuleCache\n*L\n233#1:298\n248#1:299\n264#1:301,2\n282#1:303\n*E\n"})
        private final class ModuleCache
        extends AbstractCache<IdeaModuleInfo>
        implements WorkspaceModelChangeListener {
            @Override
            protected void subscribe(@NotNull MessageBusConnection connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                connection.subscribe(WorkspaceModelTopics.CHANGED, (Object)this);
            }

            @NotNull
            public LibraryInfo calculate-ZbUFyrI(@NotNull IdeaModuleInfo key) {
                TrackableModuleInfo trackableModuleInfo;
                block14: {
                    block13: {
                        LibraryInfo libraryInfo;
                        block12: {
                            ModuleSourceInfo moduleSourceInfo;
                            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                            IdeaModuleInfo $this$safeAs$iv = key;
                            boolean $i$f$safeAs = false;
                            IdeaModuleInfo ideaModuleInfo = $this$safeAs$iv;
                            if (!(ideaModuleInfo instanceof ModuleSourceInfo)) {
                                ideaModuleInfo = null;
                            }
                            if ((trackableModuleInfo = (moduleSourceInfo = (ModuleSourceInfo)ideaModuleInfo)) == null || (trackableModuleInfo = trackableModuleInfo.getModule()) == null || (trackableModuleInfo = trackableModuleInfo.getModuleWithLibrariesScope()) == null) break block13;
                            TrackableModuleInfo trackableModuleInfo2 = trackableModuleInfo;
                            KotlinStdlibCacheImpl kotlinStdlibCacheImpl = KotlinStdlibCacheImpl.this;
                            TrackableModuleInfo scope = trackableModuleInfo2;
                            boolean bl = false;
                            Collection stdlibManifests = (Collection)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> ModuleCache.calculate_ZbUFyrI$lambda$1$lambda$0((GlobalSearchScope)scope));
                            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.getProject());
                            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
                            ProjectFileIndex projectFileIndex2 = projectFileIndex;
                            LibraryInfoCache libraryInfoCache = LibraryInfoCache.Companion.getInstance(this.getProject());
                            for (VirtualFile manifest : stdlibManifests) {
                                List orderEntries;
                                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex2.getOrderEntriesForFile(manifest), (String)"getOrderEntriesForFile(...)");
                                Iterator iterator = orderEntries.iterator();
                                while (iterator.hasNext()) {
                                    Object v6;
                                    block11: {
                                        LibraryEx library;
                                        OrderEntry entry;
                                        OrderEntry $this$safeAs$iv2 = entry = (OrderEntry)iterator.next();
                                        boolean $i$f$safeAs2 = false;
                                        OrderEntry orderEntry = $this$safeAs$iv2;
                                        if (!(orderEntry instanceof LibraryOrderEntry)) {
                                            orderEntry = null;
                                        }
                                        LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                                        Library $this$safeAs$iv3 = libraryOrderEntry != null ? libraryOrderEntry.getLibrary() : null;
                                        boolean $i$f$safeAs3 = false;
                                        Library library2 = $this$safeAs$iv3;
                                        if (!(library2 instanceof LibraryEx)) {
                                            library2 = null;
                                        }
                                        if ((LibraryEx)library2 == null) continue;
                                        List<LibraryInfo> libraryInfos = libraryInfoCache.get((Library)library);
                                        Iterable iterable = libraryInfos;
                                        for (Object t : iterable) {
                                            LibraryInfo p0 = (LibraryInfo)t;
                                            boolean bl2 = false;
                                            if (!kotlinStdlibCacheImpl.isStdlib(p0)) continue;
                                            v6 = t;
                                            break block11;
                                        }
                                        v6 = null;
                                    }
                                    if ((libraryInfo = (LibraryInfo)v6) == null) {
                                        continue;
                                    }
                                    break block12;
                                }
                            }
                            libraryInfo = null;
                        }
                        trackableModuleInfo = libraryInfo;
                        if (libraryInfo != null) break block14;
                    }
                    trackableModuleInfo = this.findStdLib(key);
                }
                TrackableModuleInfo stdLib = trackableModuleInfo;
                return this.toStdlibDependency-ZbUFyrI((LibraryInfo)stdLib);
            }

            public void postProcessNewValue-6iLzBBY(@NotNull IdeaModuleInfo key, @NotNull LibraryInfo value) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                if (!(key instanceof ModuleSourceInfo)) {
                    return;
                }
                HashMap result2 = new HashMap();
                Iterable $this$forEach$iv = ((ModuleSourceInfo)key).dependencies();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IdeaModuleInfo it = (IdeaModuleInfo)element$iv;
                    boolean bl = false;
                    if (!(it instanceof LibraryInfo)) continue;
                    StdlibDependency stdlibDependency = StdlibDependency.box-impl(value);
                    ((Map)result2).put(it, stdlibDependency);
                }
                ModuleStdlibDependencyCache.this.libraryCache.putExtraValues(result2);
            }

            @Override
            protected void checkKeyValidity(@NotNull IdeaModuleInfo key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                key.checkValidity();
            }

            @Override
            public void libraryInfosRemoved(@NotNull Collection<? extends LibraryInfo> libraryInfos) {
                Intrinsics.checkNotNullParameter(libraryInfos, (String)"libraryInfos");
                this.invalidateEntries((arg_0, arg_1) -> ModuleCache.libraryInfosRemoved$lambda$3(libraryInfos, arg_0, arg_1), ModuleCache::libraryInfosRemoved$lambda$4);
            }

            public void changed(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VersionedStorageChange $this$getChanges$iv = event;
                boolean $i$f$getChanges = false;
                Collection collection = $this$getChanges$iv.getChanges(ModuleEntity.class);
                if (collection.isEmpty()) {
                    boolean bl = false;
                    return;
                }
                this.invalidate(true);
            }

            private static final Collection calculate_ZbUFyrI$lambda$1$lambda$0(GlobalSearchScope $scope) {
                return FileBasedIndex.getInstance().getContainingFiles(KotlinStdlibIndex.Companion.getNAME(), (Object)KotlinStdlibIndex.Companion.getKOTLIN_STDLIB_NAME(), $scope);
            }

            private static final boolean libraryInfosRemoved$lambda$3(Collection $libraryInfos, IdeaModuleInfo ideaModuleInfo, StdlibDependency v) {
                Intrinsics.checkNotNullParameter((Object)ideaModuleInfo, (String)"<unused var>");
                return CollectionsKt.contains((Iterable)$libraryInfos, (Object)v.unbox-impl());
            }

            private static final boolean libraryInfosRemoved$lambda$4(IdeaModuleInfo ideaModuleInfo, StdlibDependency v) {
                Intrinsics.checkNotNullParameter((Object)ideaModuleInfo, (String)"<unused var>");
                return v.unbox-impl() != null;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdLibCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$BaseStdLibCache;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl;)V", "calculate", "", "key", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)Ljava/lang/Boolean;", "kotlin.base.project-structure"})
    private final class StdLibCache
    extends BaseStdLibCache {
        public StdLibCache() {
            super(KotlinStdlibCacheImpl.this.project, null);
        }

        @Override
        @NotNull
        public Boolean calculate(@NotNull LibraryInfo key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return KotlinStdlibCacheImpl.this.isStdlibWithFile(key, KotlinStdlibIndex.Companion.getKOTLIN_STDLIB_NAME());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0083@\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0088\u0001\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependency;", "", "libraryInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "constructor-impl", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "getLibraryInfo", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "equals", "", "other", "equals-impl", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)I", "toString", "", "toString-impl", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)Ljava/lang/String;", "kotlin.base.project-structure"})
    private static final class StdlibDependency {
        @Nullable
        private final LibraryInfo libraryInfo;

        @Nullable
        public final LibraryInfo getLibraryInfo() {
            return this.libraryInfo;
        }

        public static String toString-impl(LibraryInfo arg0) {
            return "StdlibDependency(libraryInfo=" + arg0 + ")";
        }

        public String toString() {
            return StdlibDependency.toString-impl(this.libraryInfo);
        }

        public static int hashCode-impl(LibraryInfo arg0) {
            LibraryInfo libraryInfo = arg0;
            return libraryInfo == null ? 0 : libraryInfo.hashCode();
        }

        public int hashCode() {
            return StdlibDependency.hashCode-impl(this.libraryInfo);
        }

        public static boolean equals-impl(LibraryInfo arg0, Object other) {
            if (!(other instanceof StdlibDependency)) {
                return false;
            }
            return Intrinsics.areEqual((Object)arg0, (Object)((StdlibDependency)other).unbox-impl());
        }

        public boolean equals(Object other) {
            return StdlibDependency.equals-impl(this.libraryInfo, other);
        }

        private /* synthetic */ StdlibDependency(LibraryInfo libraryInfo) {
            this.libraryInfo = libraryInfo;
        }

        @NotNull
        public static LibraryInfo constructor-impl(@Nullable LibraryInfo libraryInfo) {
            return libraryInfo;
        }

        public static final /* synthetic */ StdlibDependency box-impl(LibraryInfo v) {
            return new StdlibDependency(v);
        }

        public final /* synthetic */ LibraryInfo unbox-impl() {
            return this.libraryInfo;
        }

        public static final boolean equals-impl0(LibraryInfo p1, LibraryInfo p2) {
            return Intrinsics.areEqual((Object)p1, (Object)p2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$StdlibDependencyCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl$BaseStdLibCache;", "<init>", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/KotlinStdlibCacheImpl;)V", "calculate", "", "key", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;)Ljava/lang/Boolean;", "kotlin.base.project-structure"})
    private final class StdlibDependencyCache
    extends BaseStdLibCache {
        public StdlibDependencyCache() {
            super(KotlinStdlibCacheImpl.this.project, null);
        }

        @Override
        @NotNull
        public Boolean calculate(@NotNull LibraryInfo key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return KotlinStdlibCacheImpl.this.isStdlibWithFile(key, KotlinStdlibIndex.Companion.getSTANDARD_LIBRARY_DEPENDENCY_NAME());
        }
    }
}

