/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\f\u0010\u0014\u001a\u00020\u0013*\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u0014\u0010\t\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveEmptyClassBodyInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "<init>", "()V", "inspectionText", "", "element", "defaultFixText", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "addSemicolonIfNeeded", "Lcom/intellij/psi/PsiElement;", "addSemicolon", "isApplicable", "", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nRemoveEmptyClassBodyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveEmptyClassBodyInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveEmptyClassBodyInspection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,86:1\n2353#2,5:87\n183#3,2:92\n183#3,2:94\n213#4:96\n213#4:97\n*S KotlinDebug\n*F\n+ 1 RemoveEmptyClassBodyInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveEmptyClassBodyInspection\n*L\n49#1:87,5\n55#1:92,2\n56#1:94,2\n76#1:96\n80#1:97\n*E\n"})
public final class RemoveEmptyClassBodyInspection
extends AbstractApplicabilityBasedInspection<KtClassBody>
implements CleanupLocalInspectionTool {
    public RemoveEmptyClassBodyInspection() {
        super(KtClassBody.class);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtClassBody element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinBundle.message((String)"redundant.empty.class.body", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"remove.redundant.empty.class.body", (Object[])new Object[0]);
    }

    @Override
    public void applyTo(@NotNull KtClassBody element, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiElement parent2 = element.getParent();
        element.delete();
        Intrinsics.checkNotNull((Object)parent2);
        this.addSemicolonIfNeeded(parent2, editor);
    }

    /*
     * WARNING - void declaration
     */
    private final void addSemicolonIfNeeded(PsiElement element, Editor editor) {
        block22: {
            PsiElement psiElement = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)element, (boolean)false, (int)1, null);
            if (psiElement == null) {
                return;
            }
            PsiElement next = psiElement;
            if (Intrinsics.areEqual((Object)next.getNode().getElementType(), (Object)KtTokens.SEMICOLON)) {
                return;
            }
            PsiElement psiElement2 = element;
            if (psiElement2 instanceof KtObjectDeclaration) {
                if (!((KtObjectDeclaration)element).isCompanion() || ((KtObjectDeclaration)element).getNameIdentifier() != null) {
                    return;
                }
                PsiElement psiElement3 = next.getFirstChild();
                if (psiElement3 == null || (psiElement3 = psiElement3.getNode()) == null) {
                    return;
                }
                PsiElement firstChildNode = psiElement3;
                if (KtTokens.KEYWORDS.contains(firstChildNode.getElementType())) {
                    return;
                }
            } else if (psiElement2 instanceof KtEnumEntry) {
                Object v3;
                PsiElement psiElement4;
                boolean isLastChild;
                block19: {
                    void $this$lastOrNull$iv;
                    Object[] objectArray = ((KtEnumEntry)element).getParent().getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getChildren(...)");
                    Object[] children = objectArray;
                    isLastChild = Intrinsics.areEqual((Object)element, (Object)ArraysKt.lastOrNull((Object[])children));
                    Object[] objectArray2 = children;
                    psiElement4 = element;
                    boolean $i$f$lastOrNull = false;
                    int n = ((void)$this$lastOrNull$iv).length + -1;
                    if (0 <= n) {
                        do {
                            void element$iv;
                            int index$iv = n--;
                            void it = element$iv = $this$lastOrNull$iv[index$iv];
                            boolean bl = false;
                            if (!(it instanceof KtEnumEntry)) continue;
                            v3 = element$iv;
                            break block19;
                        } while (0 <= n);
                    }
                    v3 = null;
                }
                boolean isLastEnumEntry = Intrinsics.areEqual((Object)psiElement4, v3);
                if (isLastChild || !isLastEnumEntry) {
                    return;
                }
            } else if (psiElement2 instanceof KtClass) {
                Object v6;
                block21: {
                    Object v4;
                    PsiElement it;
                    boolean $i$f$firstOrNull;
                    Sequence $this$firstOrNull$iv;
                    block20: {
                        if (!((KtClass)element).isLocal()) {
                            return;
                        }
                        $this$firstOrNull$iv = PsiTreeUtilKt.getNextLeafs((PsiElement)element);
                        $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (PsiElement)element$iv;
                            boolean bl = false;
                            if (!(!(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment))) continue;
                            v4 = element$iv;
                            break block20;
                        }
                        v4 = null;
                    }
                    PsiElement psiElement5 = v4;
                    if (!Intrinsics.areEqual((Object)(psiElement5 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement5) : null), (Object)KtTokens.LPAR)) {
                        return;
                    }
                    $this$firstOrNull$iv = PsiTreeUtilKt.getPrevLeafs((PsiElement)next);
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!(!(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment))) continue;
                        v6 = element$iv;
                        break block21;
                    }
                    v6 = null;
                }
                PsiElement psiElement6 = v6;
                if (Intrinsics.areEqual((Object)(psiElement6 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement6) : null), (Object)KtTokens.RPAR)) {
                    return;
                }
            } else {
                return;
            }
            PsiElement semicolon = this.addSemicolon(element);
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block22;
            editor2.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)semicolon));
        }
    }

    private final PsiElement addSemicolon(PsiElement $this$addSemicolon) {
        PsiElement psiElement;
        Project project = $this$addSemicolon.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiElement semicolon = new KtPsiFactory(project, false, 2, null).createSemicolon();
        if ($this$addSemicolon instanceof KtEnumEntry) {
            PsiElement psiElement2 = ((KtEnumEntry)$this$addSemicolon).add(semicolon);
            Intrinsics.checkNotNull((Object)psiElement2);
            psiElement = psiElement2;
        } else {
            PsiElement psiElement3 = $this$addSemicolon.getParent().addAfter(semicolon, $this$addSemicolon);
            Intrinsics.checkNotNull((Object)psiElement3);
            psiElement = psiElement3;
        }
        return psiElement;
    }

    @Override
    public boolean isApplicable(@NotNull KtClassBody element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
        boolean $i$f$getStrictParentOfType = false;
        KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtObjectDeclaration.class, (boolean)true);
        if (ktObjectDeclaration != null) {
            KtObjectDeclaration it = ktObjectDeclaration;
            boolean bl = false;
            if (it.isObjectLiteral()) {
                return false;
            }
        }
        $this$getStrictParentOfType$iv = (PsiElement)element;
        $i$f$getStrictParentOfType = false;
        KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
        if (ktClass != null) {
            KtClass it = ktClass;
            boolean bl = false;
            if (!it.isTopLevel() && PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)((PsiElement)it), (boolean)false, (int)1, null) instanceof KtSecondaryConstructor) {
                return false;
            }
        }
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.isBlank((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"{", (String)"", (boolean)false, (int)4, null), (String)"}", (String)"", (boolean)false, (int)4, null));
    }
}

