/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveRedundantGetterFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "canBeCompletelyDeleted", "", "<init>", "(Z)V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.code-insight.inspections.shared"})
final class RemoveRedundantGetterFix
extends PsiUpdateModCommandQuickFix {
    private final boolean canBeCompletelyDeleted;

    public RemoveRedundantGetterFix(boolean canBeCompletelyDeleted) {
        this.canBeCompletelyDeleted = canBeCompletelyDeleted;
    }

    @NotNull
    public String getFamilyName() {
        String key = this.canBeCompletelyDeleted ? "remove.redundant.getter.fix.text" : "remove.redundant.getter.body.fix.text";
        return KotlinBundle.message((String)key, (Object[])new Object[0]);
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        KtPropertyAccessor ktPropertyAccessor = element instanceof KtPropertyAccessor ? (KtPropertyAccessor)element : null;
        if (ktPropertyAccessor == null) {
            return;
        }
        KtPropertyAccessor accessor = ktPropertyAccessor;
        KotlinPsiUtilsKt.removeRedundantGetter(accessor);
    }
}

