/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.application.options.CodeStyle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/IndentRawStringIntention;", "Lcom/intellij/modcommand/PsiBasedModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "isAvailable", "", "element", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "perform", "Lcom/intellij/modcommand/ModCommand;", "kotlin.code-insight.intentions.shared"})
@SourceDebugExtension(value={"SMAP\nIndentRawStringIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndentRawStringIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/IndentRawStringIntention\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,72:1\n1251#2,2:73\n12567#3,2:75\n13467#3,3:77\n*S KotlinDebug\n*F\n+ 1 IndentRawStringIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/IndentRawStringIntention\n*L\n31#1:73,2\n34#1:75,2\n57#1:77,3\n*E\n"})
public final class IndentRawStringIntention
extends PsiBasedModCommandAction<KtStringTemplateExpression> {
    public IndentRawStringIntention() {
        super(KtStringTemplateExpression.class);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"indent.raw.string", (Object[])new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAvailable(KtStringTemplateExpression element) {
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            return false;
        }
        Sequence $this$any$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)element));
        boolean $i$f$any = false;
        for (Object element$iv : $this$any$iv) {
            boolean bl;
            PsiElement it = (PsiElement)element$iv;
            boolean bl2 = false;
            if (it instanceof KtAnnotationEntry) return false;
            KtProperty ktProperty = it instanceof KtProperty ? (KtProperty)it : null;
            if (ktProperty != null) {
                if (ktProperty.hasModifier(KtTokens.CONST_KEYWORD)) {
                    return false;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) {
                return false;
            }
            boolean bl3 = false;
            if (!bl3) continue;
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        if (KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)element)) != null) {
            return false;
        }
        KtStringTemplateEntry[] entries = element.getEntries();
        if (entries.length <= 1) return false;
        Intrinsics.checkNotNull((Object)entries);
        KtStringTemplateEntry[] $this$any$iv2 = entries;
        boolean $i$f$any2 = false;
        int n = 0;
        int n2 = $this$any$iv2.length;
        while (n < n2) {
            KtStringTemplateEntry element$iv;
            KtStringTemplateEntry it = element$iv = $this$any$iv2[n];
            boolean bl4 = false;
            String string2 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            if (StringsKt.startsWith$default((String)string2, (String)" ", (boolean)false, (int)2, null)) return false;
            String string3 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            if (StringsKt.startsWith$default((String)string3, (String)"\t", (boolean)false, (int)2, null)) {
                return false;
            }
            boolean bl5 = false;
            if (bl5) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull KtStringTemplateExpression element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.isAvailable(element) ? super.getPresentation(context, (PsiElement)element) : null;
    }

    @NotNull
    protected ModCommand perform(@NotNull ActionContext context, @NotNull KtStringTemplateExpression element) {
        ModCommand modCommand;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.isAvailable(element)) {
            ModCommand modCommand2 = ModCommand.psiUpdate((PsiElement)((PsiElement)element), IndentRawStringIntention::perform$lambda$4);
            Intrinsics.checkNotNull((Object)modCommand2);
            modCommand = modCommand2;
        } else {
            ModCommand modCommand3 = ModCommand.nop();
            Intrinsics.checkNotNull((Object)modCommand3);
            modCommand = modCommand3;
        }
        return modCommand;
    }

    /*
     * WARNING - void declaration
     */
    private static final void perform$lambda$4(KtStringTemplateExpression e, ModPsiUpdater updater2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        KtFile ktFile2 = e.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile file = ktFile2;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((PsiFile)((PsiFile)file));
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptions(...)");
        CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        PsiFile psiFile = (PsiFile)file;
        PsiElement psiElement = e.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
        String string = codeStyleManager.getLineIndent(psiFile, PsiUtilsKt.getStartOffset((PsiElement)psiElement));
        if (string == null) {
            string = "";
        }
        String parentIndent = string;
        String indent = indentOptions2.USE_TAB_CHARACTER ? parentIndent + "\t" : parentIndent + StringsKt.repeat((CharSequence)" ", (int)indentOptions2.INDENT_SIZE);
        StringBuilder $this$perform_u24lambda_u244_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int maxIndex = e.getEntries().length - 1;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = e.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        Object[] $this$forEachIndexed$iv = ktStringTemplateEntryArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entry;
            int n = index$iv++;
            KtStringTemplateEntry ktStringTemplateEntry = (KtStringTemplateEntry)item$iv;
            int index2 = n;
            boolean bl2 = false;
            if (index2 == 0) {
                $this$perform_u24lambda_u244_u24lambda_u243.append("\n" + indent);
            }
            $this$perform_u24lambda_u244_u24lambda_u243.append(entry.getText());
            if (Intrinsics.areEqual((Object)entry.getText(), (Object)"\n")) {
                $this$perform_u24lambda_u244_u24lambda_u243.append(indent);
            }
            if (index2 != maxIndex) continue;
            $this$perform_u24lambda_u244_u24lambda_u243.append("\n" + indent);
        }
        String newString = stringBuilder.toString();
        KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
        KtExpression expression = psiFactory.createExpression("\"\"\"" + newString + "\"\"\".trimIndent()");
        e.replace((PsiElement)expression);
    }
}

