/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.renderer.types.impl.KaTypeRendererForSource;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.codeinsight.utils.BranchedUnfoldingUtils;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0014J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\r\u0010\u0012\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0003*\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0002H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/UnfoldPropertyToWhenIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/UnfoldPropertyToWhenIntention$Context;", "<init>", "()V", "invoke", "", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "property", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "splitPropertyDeclaration", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "propertyTypeAsString", "", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "isApplicableByPsi", "", "element", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "Context", "kotlin.code-insight.intentions.shared"})
@SourceDebugExtension(value={"SMAP\nUnfoldPropertyToWhenIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnfoldPropertyToWhenIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/UnfoldPropertyToWhenIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 5 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,78:1\n1#2:79\n2632#3,3:80\n30#4,2:83\n35#5,13:85\n*S KotlinDebug\n*F\n+ 1 UnfoldPropertyToWhenIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/UnfoldPropertyToWhenIntention\n*L\n63#1:80,3\n72#1:83,2\n72#1:85,13\n*E\n"})
public final class UnfoldPropertyToWhenIntention
extends KotlinApplicableModCommandAction<KtProperty, Context> {
    public UnfoldPropertyToWhenIntention() {
        super(Reflection.getOrCreateKotlinClass(KtProperty.class));
    }

    @Override
    protected void invoke(@NotNull ActionContext actionContext, @NotNull KtProperty property, @NotNull Context elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        KtBinaryExpression ktBinaryExpression = this.splitPropertyDeclaration(property, elementContext.getPropertyExplicitType());
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression assignment2 = ktBinaryExpression;
        BranchedUnfoldingUtils.INSTANCE.unfoldAssignmentToWhen(assignment2, (Function1<? super Integer, Unit>)((Function1)arg_0 -> UnfoldPropertyToWhenIntention.invoke$lambda$0(updater2, arg_0)));
    }

    private final KtBinaryExpression splitPropertyDeclaration(KtProperty property, String propertyTypeAsString) {
        KtBinaryExpression assignment2;
        block2: {
            PsiElement parent2 = property.getParent();
            KtExpression ktExpression = property.getInitializer();
            if (ktExpression == null) {
                return null;
            }
            KtExpression initializer2 = ktExpression;
            Project project = property.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNull((Object)property.getNameAsName());
            objectArray[1] = initializer2;
            KtExpression expression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0 = $1", (Object[])objectArray, (boolean)false, (int)4, null);
            PsiElement psiElement = parent2.addAfter((PsiElement)expression, (PsiElement)property);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            assignment2 = (KtBinaryExpression)psiElement;
            parent2.addAfter(psiFactory.createNewLine(), (PsiElement)property);
            property.setInitializer(null);
            if (propertyTypeAsString == null) break block2;
            KtTypeReference typeReference = psiFactory.createType(propertyTypeAsString);
            KtTypeReference ktTypeReference = property.setTypeReference(typeReference);
            if (ktTypeReference != null) {
                KtTypeReference it = ktTypeReference;
                boolean bl = false;
                ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)it);
            }
        }
        return assignment2;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"replace.property.initializer.with.when.expression", (Object[])new Object[0]);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtProperty element) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (!element.isLocal()) {
                return false;
            }
            KtExpression ktExpression = element.getInitializer();
            KtWhenExpression ktWhenExpression = ktExpression instanceof KtWhenExpression ? (KtWhenExpression)ktExpression : null;
            if (ktWhenExpression == null) {
                return false;
            }
            KtWhenExpression initializer2 = ktWhenExpression;
            if (!KtPsiUtil.checkWhenExpressionHasSingleElse((KtWhenExpression)initializer2)) {
                return false;
            }
            List list2 = initializer2.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntries(...)");
            Iterable $this$none$iv = list2;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KtWhenEntry it = (KtWhenEntry)element$iv;
                    boolean bl2 = false;
                    if (!(it.getExpression() == null)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtProperty element) {
        String string;
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getInitializer();
        if (ktExpression == null) {
            return null;
        }
        KtExpression initializer2 = ktExpression;
        if (element.getTypeReference() != null) {
            return new Context(null);
        }
        boolean $i$f$analyze = false;
        Project project = ((KtElement)initializer2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)initializer2);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)initializer2);
        try {
            String string2;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                String string3;
                boolean bl = false;
                KaSession $this$prepareContext_u24lambda_u243 = analysisSession$iv$iv;
                boolean bl2 = false;
                KaType kaType = $this$prepareContext_u24lambda_u243.getExpressionType(initializer2);
                if (kaType == null) {
                    string3 = null;
                } else {
                    KaType initializerType = kaType;
                    string3 = $this$prepareContext_u24lambda_u243.render(initializerType, KaTypeRendererForSource.INSTANCE.getWITH_QUALIFIED_NAMES(), Variance.INVARIANT);
                }
                string2 = string3;
            }
            string = string2;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)initializer2);
        }
        String propertyExplicitType = string;
        return new Context(propertyExplicitType);
    }

    private static final Unit invoke$lambda$0(ModPsiUpdater $updater, int it) {
        $updater.moveCaretTo(it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/UnfoldPropertyToWhenIntention$Context;", "", "propertyExplicitType", "", "<init>", "(Ljava/lang/String;)V", "getPropertyExplicitType", "()Ljava/lang/String;", "kotlin.code-insight.intentions.shared"})
    public static final class Context {
        @Nullable
        private final String propertyExplicitType;

        public Context(@Nullable String propertyExplicitType) {
            this.propertyExplicitType = propertyExplicitType;
        }

        @Nullable
        public final String getPropertyExplicitType() {
            return this.propertyExplicitType;
        }
    }
}

