/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.slicer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.slicer.AbstractKotlinSliceUsage;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0003#$%B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0004J\u0016\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0000J\u001e\u0010\u0014\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00152\u0006\u0010\u0011\u001a\u00020\u0012J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u001b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode;", "", "behaviourStack", "", "Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode$Behaviour;", "inlineCallStack", "Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode$InlineFunctionCall;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getBehaviourStack", "()Ljava/util/List;", "getInlineCallStack", "withBehaviour", "behaviour", "withInlineFunctionCall", "callElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "dropBehaviour", "popInlineFunctionCall", "Lkotlin/Pair;", "currentBehaviour", "getCurrentBehaviour", "()Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode$Behaviour;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Behaviour", "InlineFunctionCall", "Companion", "kotlin.code-insight.impl-base"})
public final class KotlinSliceAnalysisMode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Behaviour> behaviourStack;
    @NotNull
    private final List<InlineFunctionCall> inlineCallStack;
    @NotNull
    private static final KotlinSliceAnalysisMode Default = new KotlinSliceAnalysisMode(CollectionsKt.emptyList(), CollectionsKt.emptyList());

    public KotlinSliceAnalysisMode(@NotNull List<? extends Behaviour> behaviourStack, @NotNull List<InlineFunctionCall> inlineCallStack) {
        Intrinsics.checkNotNullParameter(behaviourStack, (String)"behaviourStack");
        Intrinsics.checkNotNullParameter(inlineCallStack, (String)"inlineCallStack");
        this.behaviourStack = behaviourStack;
        this.inlineCallStack = inlineCallStack;
    }

    @NotNull
    public final List<Behaviour> getBehaviourStack() {
        return this.behaviourStack;
    }

    @NotNull
    public final List<InlineFunctionCall> getInlineCallStack() {
        return this.inlineCallStack;
    }

    @NotNull
    public final KotlinSliceAnalysisMode withBehaviour(@NotNull Behaviour behaviour) {
        Intrinsics.checkNotNullParameter((Object)behaviour, (String)"behaviour");
        return KotlinSliceAnalysisMode.copy$default(this, CollectionsKt.plus((Collection)this.behaviourStack, (Object)behaviour), null, 2, null);
    }

    @NotNull
    public final KotlinSliceAnalysisMode withInlineFunctionCall(@NotNull KtElement callElement, @NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)callElement, (String)"callElement");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return KotlinSliceAnalysisMode.copy$default(this, null, CollectionsKt.plus((Collection)this.inlineCallStack, (Object)new InlineFunctionCall(callElement, function)), 1, null);
    }

    @NotNull
    public final KotlinSliceAnalysisMode dropBehaviour() {
        if (!(!((Collection)this.behaviourStack).isEmpty())) {
            throw new IllegalStateException("Check failed.");
        }
        return KotlinSliceAnalysisMode.copy$default(this, CollectionsKt.dropLast(this.behaviourStack, (int)1), null, 2, null);
    }

    @NotNull
    public final Pair<KotlinSliceAnalysisMode, KtElement> popInlineFunctionCall(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        InlineFunctionCall last = (InlineFunctionCall)CollectionsKt.lastOrNull(this.inlineCallStack);
        InlineFunctionCall inlineFunctionCall = last;
        if (!Intrinsics.areEqual((Object)(inlineFunctionCall != null && (inlineFunctionCall = inlineFunctionCall.getFunction()) != null ? inlineFunctionCall.getNavigationElement() : null), (Object)function)) {
            return TuplesKt.to(null, null);
        }
        KotlinSliceAnalysisMode newMode = KotlinSliceAnalysisMode.copy$default(this, null, CollectionsKt.dropLast(this.inlineCallStack, (int)1), 1, null);
        return TuplesKt.to((Object)newMode, (Object)last.getCallElement());
    }

    @Nullable
    public final Behaviour getCurrentBehaviour() {
        return (Behaviour)CollectionsKt.lastOrNull(this.behaviourStack);
    }

    @NotNull
    public final List<Behaviour> component1() {
        return this.behaviourStack;
    }

    @NotNull
    public final List<InlineFunctionCall> component2() {
        return this.inlineCallStack;
    }

    @NotNull
    public final KotlinSliceAnalysisMode copy(@NotNull List<? extends Behaviour> behaviourStack, @NotNull List<InlineFunctionCall> inlineCallStack) {
        Intrinsics.checkNotNullParameter(behaviourStack, (String)"behaviourStack");
        Intrinsics.checkNotNullParameter(inlineCallStack, (String)"inlineCallStack");
        return new KotlinSliceAnalysisMode(behaviourStack, inlineCallStack);
    }

    public static /* synthetic */ KotlinSliceAnalysisMode copy$default(KotlinSliceAnalysisMode kotlinSliceAnalysisMode, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = kotlinSliceAnalysisMode.behaviourStack;
        }
        if ((n & 2) != 0) {
            list3 = kotlinSliceAnalysisMode.inlineCallStack;
        }
        return kotlinSliceAnalysisMode.copy(list2, list3);
    }

    @NotNull
    public String toString() {
        return "KotlinSliceAnalysisMode(behaviourStack=" + this.behaviourStack + ", inlineCallStack=" + this.inlineCallStack + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.behaviourStack).hashCode();
        result2 = result2 * 31 + ((Object)this.inlineCallStack).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KotlinSliceAnalysisMode)) {
            return false;
        }
        KotlinSliceAnalysisMode kotlinSliceAnalysisMode = (KotlinSliceAnalysisMode)other;
        if (!Intrinsics.areEqual(this.behaviourStack, kotlinSliceAnalysisMode.behaviourStack)) {
            return false;
        }
        return Intrinsics.areEqual(this.inlineCallStack, kotlinSliceAnalysisMode.inlineCallStack);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\tH&J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00a6\u0002J\b\u0010\u0014\u001a\u00020\u0015H&R\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode$Behaviour;", "", "processUsages", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "parent", "Lorg/jetbrains/kotlin/idea/codeInsight/slicer/AbstractKotlinSliceUsage;", "uniqueProcessor", "Lcom/intellij/util/Processor;", "Lcom/intellij/slicer/SliceUsage;", "slicePresentationPrefix", "", "getSlicePresentationPrefix", "()Ljava/lang/String;", "testPresentationPrefix", "getTestPresentationPrefix", "equals", "", "other", "hashCode", "", "kotlin.code-insight.impl-base"})
    public static interface Behaviour {
        public void processUsages(@NotNull KtElement var1, @NotNull AbstractKotlinSliceUsage var2, @NotNull Processor<? super SliceUsage> var3);

        @NotNull
        public String getSlicePresentationPrefix();

        @NotNull
        public String getTestPresentationPrefix();

        public boolean equals(@Nullable Object var1);

        public int hashCode();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode$Companion;", "", "<init>", "()V", "Default", "Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode;", "getDefault", "()Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode;", "kotlin.code-insight.impl-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinSliceAnalysisMode getDefault() {
            return Default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode$InlineFunctionCall;", "", "callElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtNamedFunction;)V", "callElementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "functionPointer", "getCallElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "getFunction", "()Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "equals", "", "other", "hashCode", "", "kotlin.code-insight.impl-base"})
    public static final class InlineFunctionCall {
        @NotNull
        private final SmartPsiElementPointer<KtElement> callElementPointer;
        @NotNull
        private final SmartPsiElementPointer<KtNamedFunction> functionPointer;

        public InlineFunctionCall(@NotNull KtElement callElement, @NotNull KtNamedFunction function) {
            Intrinsics.checkNotNullParameter((Object)callElement, (String)"callElement");
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            this.callElementPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)callElement));
            this.functionPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)function));
        }

        @Nullable
        public final KtElement getCallElement() {
            return (KtElement)this.callElementPointer.getElement();
        }

        @Nullable
        public final KtNamedFunction getFunction() {
            return (KtNamedFunction)this.functionPointer.getElement();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof InlineFunctionCall && Intrinsics.areEqual((Object)((InlineFunctionCall)other).getCallElement(), (Object)this.getCallElement()) && Intrinsics.areEqual((Object)((InlineFunctionCall)other).getFunction(), (Object)this.getFunction());
        }

        public int hashCode() {
            return 0;
        }
    }
}

