/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.utils;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaErrorCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.signatures.KaVariableSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.NamedArgumentUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\u00052\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\fJ5\u0010\r\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e\u0012\u0004\u0012\u00020\t\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007R\u00020\u000f\u00a2\u0006\u0002\u0010\u0013J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u0007R\u00020\u000f\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u00072\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsight/utils/NamedArgumentUtils;", "", "<init>", "()V", "addArgumentName", "", "element", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "argumentName", "Lorg/jetbrains/kotlin/name/Name;", "addArgumentNames", "argumentNames", "", "associateArgumentNamesStartingAt", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "call", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "startArgument", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallElement;Lorg/jetbrains/kotlin/psi/KtValueArgument;)Ljava/util/Map;", "getStableNameFor", "argument", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtValueArgument;)Lorg/jetbrains/kotlin/name/Name;", "getNameForNameableArgument", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "kotlin.code-insight.utils"})
@SourceDebugExtension(value={"SMAP\nNamedArgumentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamedArgumentUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/NamedArgumentUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 KaCallInfo.kt\norg/jetbrains/kotlin/analysis/api/resolution/KaCallInfoKt\n*L\n1#1,115:1\n756#2,10:116\n1279#2,2:126\n1293#2,4:128\n1246#2,4:134\n669#2,11:139\n1557#2:150\n1628#2,3:151\n774#2:154\n865#2,2:155\n1782#2,4:157\n477#3:132\n423#3:133\n63#4:138\n*S KotlinDebug\n*F\n+ 1 NamedArgumentUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/NamedArgumentUtils\n*L\n58#1:116,10\n60#1:126,2\n60#1:128,4\n61#1:134,4\n75#1:139,11\n84#1:150\n84#1:151,3\n86#1:154\n86#1:155,2\n103#1:157,4\n61#1:132\n61#1:133\n75#1:138\n*E\n"})
public final class NamedArgumentUtils {
    @NotNull
    public static final NamedArgumentUtils INSTANCE = new NamedArgumentUtils();

    private NamedArgumentUtils() {
    }

    public final void addArgumentName(@NotNull KtValueArgument element, @NotNull Name argumentName2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)argumentName2, (String)"argumentName");
        KtExpression ktExpression = element.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        PsiElement prevSibling = PsiUtilsKt.getPrevSiblingIgnoringWhitespace$default((PsiElement)((PsiElement)element), (boolean)false, (int)1, null);
        if (prevSibling instanceof PsiComment) {
            Regex regex = new Regex("/\\*\\s*" + argumentName2 + "\\s*=\\s*\\*/");
            String string = ((PsiComment)prevSibling).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (regex.matches((CharSequence)string)) {
                ((PsiComment)prevSibling).delete();
            }
        }
        KtValueArgument newArgument = KtPsiFactory.createArgument$default((KtPsiFactory)new KtPsiFactory((KtElement)element, false, 2, null), (KtExpression)argumentExpression, (Name)argumentName2, (element.getSpreadElement() != null ? 1 : 0) != 0, (boolean)false, (int)8, null);
        element.replace((PsiElement)newArgument);
    }

    public final void addArgumentNames(@NotNull Map<KtValueArgument, Name> argumentNames) {
        Intrinsics.checkNotNullParameter(argumentNames, (String)"argumentNames");
        for (Map.Entry<KtValueArgument, Name> entry : argumentNames.entrySet()) {
            KtValueArgument argument2 = entry.getKey();
            Name name2 = entry.getValue();
            this.addArgumentName(argument2, name2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Map<SmartPsiElementPointer<KtValueArgument>, Name> associateArgumentNamesStartingAt(@NotNull KaSession $context_receiver_0, @NotNull KtCallElement call2, @Nullable KtValueArgument startArgument) {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map map2;
        Map $this$associateWith$iv;
        Object object;
        Iterable $this$dropWhile$iv;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        KaLifetimeOwner kaLifetimeOwner = $context_receiver_0.resolveToCall((KtElement)call2);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.singleFunctionCallOrNull(kaLifetimeOwner)) == null) {
            return null;
        }
        KaLifetimeOwner resolvedCall = kaLifetimeOwner;
        if (!((KaFunctionSymbol)KaCallKt.getSymbol((KaCallableMemberCall)resolvedCall)).getHasStableParameterNames()) {
            return null;
        }
        Object object2 = call2.getValueArgumentList();
        if (object2 == null || (object2 = object2.getArguments()) == null) {
            return null;
        }
        Object arguments2 = object2;
        if (startArgument != null) {
            $this$dropWhile$iv = (Iterable)arguments2;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList<Object> list$iv = new ArrayList<Object>();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                KtValueArgument it = (KtValueArgument)item$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)startArgument)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            object = list$iv;
        } else {
            object = arguments2;
        }
        Object argumentsExcludingPrevious = object;
        $this$dropWhile$iv = (Iterable)argumentsExcludingPrevious;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Name name2;
            void it;
            KtValueArgument bl = (KtValueArgument)element$iv$iv;
            Object e = element$iv$iv;
            map2 = result$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (INSTANCE.getNameForNameableArgument((KtValueArgument)it, (KaFunctionCall<?>)resolvedCall) == null) {
                return null;
            }
            map2.put(e, name2);
        }
        $this$associateWith$iv = result$iv;
        boolean $i$f$mapKeys = false;
        result$iv = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            SmartPsiElementPointer smartPsiElementPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)k));
            Map map3 = map2;
            boolean bl3 = false;
            entry = it$iv$iv.getValue();
            map3.put(smartPsiElementPointer, entry);
        }
        return destination$iv$iv;
    }

    @Nullable
    public final Name getStableNameFor(@NotNull KaSession $context_receiver_0, @NotNull KtValueArgument argument2) {
        KaLifetimeOwner resolvedCall;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        KtCallElement ktCallElement = KotlinPsiUtils.getCallElement(argument2);
        if (ktCallElement == null) {
            return null;
        }
        KtCallElement callElement = ktCallElement;
        KaCallInfo resolveToCall = $context_receiver_0.resolveToCall((KtElement)callElement);
        KaLifetimeOwner kaLifetimeOwner = resolveToCall;
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.singleFunctionCallOrNull(kaLifetimeOwner)) == null) {
            KaLifetimeOwner kaLifetimeOwner2;
            KaErrorCallInfo kaErrorCallInfo = resolveToCall instanceof KaErrorCallInfo ? (KaErrorCallInfo)resolveToCall : null;
            if (kaErrorCallInfo != null) {
                Object v3;
                block8: {
                    KaCallInfo $this$singleCallOrNull$iv = kaErrorCallInfo;
                    boolean $i$f$singleCallOrNull = false;
                    Iterable $this$singleOrNull$iv$iv = KaCallInfoKt.getCalls($this$singleCallOrNull$iv);
                    boolean $i$f$singleOrNull = false;
                    Object single$iv$iv = null;
                    boolean found$iv$iv = false;
                    for (Object element$iv$iv : $this$singleOrNull$iv$iv) {
                        KaCall it$iv = (KaCall)element$iv$iv;
                        boolean bl = false;
                        if (!(it$iv instanceof KaFunctionCall)) continue;
                        if (found$iv$iv) {
                            v3 = null;
                            break block8;
                        }
                        single$iv$iv = element$iv$iv;
                        found$iv$iv = true;
                    }
                    v3 = !found$iv$iv ? null : single$iv$iv;
                }
                kaLifetimeOwner2 = (KaFunctionCall)((KaCall)v3);
            } else {
                kaLifetimeOwner2 = kaLifetimeOwner = null;
            }
            if (kaLifetimeOwner2 == null) {
                return null;
            }
        }
        if (!((KaFunctionSymbol)KaCallKt.getSymbol((KaCallableMemberCall)(resolvedCall = kaLifetimeOwner))).getHasStableParameterNames()) {
            return null;
        }
        return this.getNameForNameableArgument(argument2, (KaFunctionCall<?>)resolvedCall);
    }

    /*
     * WARNING - void declaration
     */
    private final Name getNameForNameableArgument(KtValueArgument argument2, KaFunctionCall<?> resolvedCall) {
        Map<KtExpression, KaVariableSignature<KaValueParameterSymbol>> argumentMapping2 = resolvedCall.getArgumentMapping();
        KaVariableSignature<KaValueParameterSymbol> variableSignature = argumentMapping2.get(argument2.getArgumentExpression());
        if (variableSignature == null) {
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = argumentMapping2.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Iterator it;
                KaVariableSignature kaVariableSignature = (KaVariableSignature)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to(it.getSymbol(), (Object)it));
            }
            Map resolvedCallSignatures = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            Iterable $this$filter$iv = ((KaFunctionSymbol)KaCallKt.getSymbol((KaCallableMemberCall)resolvedCall)).getValueParameters();
            boolean $i$f$filter = false;
            Iterable $i$f$mapTo22 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KaValueParameterSymbol it = (KaValueParameterSymbol)element$iv$iv;
                boolean bl = false;
                if (!(!resolvedCallSignatures.containsKey(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            KaValueParameterSymbol kaValueParameterSymbol = (KaValueParameterSymbol)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
            Name name2 = kaValueParameterSymbol != null ? NamedArgumentUtilsKt.access$getNameIfNotSpecial(kaValueParameterSymbol) : null;
            return name2;
        }
        KaValueParameterSymbol valueParameterSymbol = (KaValueParameterSymbol)variableSignature.getSymbol();
        if (valueParameterSymbol.isVararg()) {
            int varargArgumentCount;
            if (LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)argument2).supportsFeature(LanguageFeature.ProhibitAssigningSingleElementsToVarargsInNamedForm) && !argument2.isSpread()) {
                return null;
            }
            Iterable $this$count$iv = argumentMapping2.values();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v1 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    KaVariableSignature it = (KaVariableSignature)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getSymbol(), (Object)valueParameterSymbol) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v1 = varargArgumentCount = count$iv;
            }
            if (varargArgumentCount != 1) {
                return null;
            }
        }
        return NamedArgumentUtilsKt.access$getNameIfNotSpecial(valueParameterSymbol);
    }
}

