/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.utils;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0006\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"JVM_FIELD_CLASS_ID", "", "JVM_STATIC_CLASS_ID", "getJvmAnnotations", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "checkMayBeConstantByFields", "", "replaceReferencesToGetterByReferenceToField", "", "property", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "kotlin.code-insight.utils"})
@SourceDebugExtension(value={"SMAP\nPropertyModifierUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyModifierUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/PropertyModifierUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,63:1\n1863#2:64\n1864#2:66\n217#3:65\n*S KotlinDebug\n*F\n+ 1 PropertyModifierUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/PropertyModifierUtilsKt\n*L\n54#1:64\n54#1:66\n55#1:65\n*E\n"})
public final class PropertyModifierUtilsKt {
    @NotNull
    public static final String JVM_FIELD_CLASS_ID = "kotlin/jvm/JvmField";
    @NotNull
    public static final String JVM_STATIC_CLASS_ID = "kotlin/jvm/JvmStatic";

    @NotNull
    public static final List<KtAnnotationEntry> getJvmAnnotations(@NotNull KtProperty $this$getJvmAnnotations) {
        Intrinsics.checkNotNullParameter((Object)$this$getJvmAnnotations, (String)"<this>");
        Object[] objectArray = new KtAnnotationEntry[]{AnnotationModificationUtilsKt.findAnnotation$default((KtAnnotated)$this$getJvmAnnotations, ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)JVM_FIELD_CLASS_ID, (boolean)false, (int)2, null), null, false, 6, null), AnnotationModificationUtilsKt.findAnnotation$default((KtAnnotated)$this$getJvmAnnotations, ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)JVM_STATIC_CLASS_ID, (boolean)false, (int)2, null), null, false, 6, null)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    public static final boolean checkMayBeConstantByFields(@NotNull KtProperty $this$checkMayBeConstantByFields) {
        Intrinsics.checkNotNullParameter((Object)$this$checkMayBeConstantByFields, (String)"<this>");
        if ($this$checkMayBeConstantByFields.isLocal() || $this$checkMayBeConstantByFields.isVar() || $this$checkMayBeConstantByFields.getGetter() != null || $this$checkMayBeConstantByFields.hasModifier(KtTokens.CONST_KEYWORD) || $this$checkMayBeConstantByFields.hasModifier(KtTokens.OVERRIDE_KEYWORD) || PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)$this$checkMayBeConstantByFields)) || $this$checkMayBeConstantByFields.hasDelegate() || $this$checkMayBeConstantByFields.getReceiverTypeReference() != null) {
            return false;
        }
        KtClassOrObject containingClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$checkMayBeConstantByFields));
        if (!$this$checkMayBeConstantByFields.isTopLevel() && !(containingClassOrObject instanceof KtObjectDeclaration)) {
            return false;
        }
        KtClassOrObject ktClassOrObject = containingClassOrObject;
        return !(ktClassOrObject != null ? KtPsiUtilKt.isObjectLiteral((KtClassOrObject)ktClassOrObject) : false);
    }

    public static final void replaceReferencesToGetterByReferenceToField(@NotNull KtProperty property, @NotNull LanguageFileType fileType) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Project project = property.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        FileType[] fileTypeArray = new FileType[]{fileType};
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)KotlinScopeUtils.allScope(project2), (FileType[])fileTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getScopeRestrictedByFileTypes(...)");
        GlobalSearchScope javaScope = globalSearchScope;
        if (Intrinsics.areEqual((Object)javaScope, (Object)GlobalSearchScope.EMPTY_SCOPE)) {
            return;
        }
        PsiMethod psiMethod = LightClassUtil.INSTANCE.getLightClassPropertyMethods(property).getGetter();
        if (psiMethod == null) {
            return;
        }
        PsiMethod getter = psiMethod;
        PsiField backingField = LightClassUtil.INSTANCE.getLightClassPropertyMethods(property).getBackingField();
        if (backingField != null) {
            Collection collection = ReferencesSearch.search((PsiElement)((PsiElement)getter), (SearchScope)((SearchScope)javaScope)).findAll();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findAll(...)");
            Collection getterUsages = collection;
            if (getterUsages.isEmpty()) {
                return;
            }
            PsiElementFactory factory2 = PsiElementFactory.getInstance((Project)project2);
            PsiClass psiClass = backingField.getContainingClass();
            Intrinsics.checkNotNull((Object)psiClass);
            String fieldFQName = psiClass.getQualifiedName() + "." + backingField.getName();
            ApplicationUtilsKt.runWriteActionIfPhysical((PsiElement)property, () -> PropertyModifierUtilsKt.replaceReferencesToGetterByReferenceToField$lambda$1(getterUsages, factory2, fieldFQName));
        }
    }

    private static final Unit replaceReferencesToGetterByReferenceToField$lambda$1(Collection $getterUsages, PsiElementFactory $factory, String $fieldFQName) {
        Iterable $this$forEach$iv = $getterUsages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiExpression fieldRef;
            PsiElement $this$getNonStrictParentOfType$iv;
            PsiReference it = (PsiReference)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getElement(), (String)"getElement(...)");
            boolean $i$f$getNonStrictParentOfType = false;
            PsiMethodCallExpression call2 = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, PsiMethodCallExpression.class, (boolean)false);
            if (call2 == null || !Intrinsics.areEqual((Object)it.getElement(), (Object)call2.getMethodExpression())) continue;
            Intrinsics.checkNotNullExpressionValue((Object)$factory.createExpressionFromText($fieldFQName, it.getElement()), (String)"createExpressionFromText(...)");
            call2.replace((PsiElement)fieldRef);
        }
        return Unit.INSTANCE;
    }
}

