/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u0007*\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\u0017*\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0014\u0010\u0019\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0012H&\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/ConvertToConcatenatedStringIntentionBase;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "isApplicableTo", "", "element", "startInWriteAction", "getElementToMakeWritable", "Lcom/intellij/psi/PsiFile;", "currentFile", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "safeDeparenthesizeOperands", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isStringLiteral", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "isTripleQuoted", "str", "", "toSeparateString", "quote", "convertExplicitly", "needsParenthesis", "expression", "checkIfExpressionIsStringFromModalView", "isExpressionOfStringType", "kotlin.code-insight.impl-base"})
@SourceDebugExtension(value={"SMAP\nConvertToConcatenatedStringIntentionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertToConcatenatedStringIntentionBase.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/ConvertToConcatenatedStringIntentionBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1#2:133\n12567#3,2:134\n4154#3:136\n4254#3,2:137\n1567#4:139\n1598#4,4:140\n1812#4,4:144\n*S KotlinDebug\n*F\n+ 1 ConvertToConcatenatedStringIntentionBase.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/ConvertToConcatenatedStringIntentionBase\n*L\n23#1:134,2\n34#1:136\n34#1:137,2\n40#1:139\n40#1:140,4\n47#1:144,4\n*E\n"})
public abstract class ConvertToConcatenatedStringIntentionBase
extends SelfTargetingOffsetIndependentIntention<KtStringTemplateExpression>
implements LowPriorityAction {
    public ConvertToConcatenatedStringIntentionBase() {
        super(KtStringTemplateExpression.class, KotlinBundle.lazyMessage((String)"convert.template.to.concatenated.string", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtStringTemplateExpression element) {
        boolean bl;
        block5: {
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (!Intrinsics.areEqual((Object)element.getLastChild().getNode().getElementType(), (Object)KtTokens.CLOSING_QUOTE)) {
                return false;
            }
            PsiElement psiElement = element.getInterpolationPrefix();
            if (psiElement != null) {
                int it = psiElement.getTextLength();
                boolean bl3 = false;
                bl2 = it > 1;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return false;
            }
            KtStringTemplateEntry[] ktStringTemplateEntryArray = element.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
            Object[] $this$any$iv = ktStringTemplateEntryArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                KtStringTemplateEntry it = (KtStringTemplateEntry)element$iv;
                boolean bl4 = false;
                if (!(it instanceof KtStringTemplateEntryWithExpression)) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public PsiFile getElementToMakeWritable(@NotNull PsiFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        return currentFile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtStringTemplateExpression element, @Nullable Editor editor) {
        void $this$foldIndexed$iv;
        void initial$iv;
        KtStringTemplateEntry ktStringTemplateEntry;
        int n;
        List $this$mapIndexedTo$iv$iv;
        boolean bl;
        Object $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getText() == null) {
            boolean $i$a$-checkNotNull-ConvertToConcatenatedStringIntentionBase$applyTo$22 = false;
            String $i$a$-checkNotNull-ConvertToConcatenatedStringIntentionBase$applyTo$22 = "Failed to get template expression's text";
            throw new IllegalStateException($i$a$-checkNotNull-ConvertToConcatenatedStringIntentionBase$applyTo$22.toString());
        }
        boolean tripleQuoted = !KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)element);
        String quote = tripleQuoted ? "\"\"\"" : "\"";
        KtStringTemplateEntry[] ktStringTemplateEntryArray = element.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        Object[] $this$filterNot$iv = ktStringTemplateEntryArray;
        boolean $i$f$filterNot = false;
        Object[] objectArray = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo22 = false;
        for (void element$iv$iv : $this$filterNotTo$iv$iv) {
            KtStringTemplateEntry it = (KtStringTemplateEntry)element$iv$iv;
            boolean bl2 = false;
            if (it instanceof KtStringTemplateEntryWithExpression && ((KtStringTemplateEntryWithExpression)it).getExpression() == null) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entries = (List)destination$iv$iv;
        $this$filterNotTo$iv$iv = CollectionsKt.firstOrNull((List)entries);
        KtStringTemplateEntryWithExpression ktStringTemplateEntryWithExpression = $this$filterNotTo$iv$iv instanceof KtStringTemplateEntryWithExpression ? (KtStringTemplateEntryWithExpression)$this$filterNotTo$iv$iv : null;
        if (ktStringTemplateEntryWithExpression != null && (ktStringTemplateEntryWithExpression = ktStringTemplateEntryWithExpression.getExpression()) != null) {
            KtStringTemplateEntryWithExpression it = ktStringTemplateEntryWithExpression;
            boolean bl3 = false;
            bl = !this.checkIfExpressionIsStringFromModalView((KtExpression)it);
        } else {
            bl = false;
        }
        boolean convertFirstEntryExplicitly = bl;
        Iterable $this$mapIndexed$iv = entries;
        boolean $i$f$mapIndexed22 = false;
        Iterable $i$f$filterNotTo22 = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void entry;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ktStringTemplateEntry = (KtStringTemplateEntry)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv2;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)entry);
            String entryText = this.toSeparateString((KtStringTemplateEntry)entry, quote, index2 == false && convertFirstEntryExplicitly);
            boolean entryIsString = StringsKt.startsWith$default((String)entryText, (String)quote, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)entryText, (String)quote, (boolean)false, (int)2, null) && this.isStringLiteral((KtStringTemplateEntry)entry);
            collection.add(TuplesKt.to((Object)entryText, (Object)entryIsString));
        }
        List entryTexts = (List)destination$iv$iv2;
        Iterable $i$f$mapIndexed22 = entryTexts;
        $this$mapIndexedTo$iv$iv = new ArrayList();
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        void accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void texts;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ktStringTemplateEntry = (Pair)element$iv;
            void index2 = accumulator$iv;
            int index3 = n;
            boolean bl5 = false;
            String currText = (String)ktStringTemplateEntry.component1();
            boolean currIsString = (Boolean)ktStringTemplateEntry.component2();
            Pair pair = (Pair)CollectionsKt.getOrNull((List)entryTexts, (int)(index3 - 1));
            boolean prevIsString = pair != null ? (Boolean)pair.getSecond() : false;
            Pair pair2 = (Pair)CollectionsKt.getOrNull((List)entryTexts, (int)(index3 + 1));
            boolean nextIsString = pair2 != null ? (Boolean)pair2.getSecond() : false;
            String textToBeMerged = currText;
            if (currIsString && nextIsString) {
                textToBeMerged = StringsKt.removeSuffix((String)textToBeMerged, (CharSequence)quote);
            }
            if (currIsString && prevIsString) {
                textToBeMerged = StringsKt.removePrefix((String)textToBeMerged, (CharSequence)quote);
                int n3 = CollectionsKt.getLastIndex((List)texts);
                texts.set(n3, texts.get(n3) + textToBeMerged);
            } else {
                texts.add(textToBeMerged);
            }
            accumulator$iv = texts;
        }
        void targetTexts = accumulator$iv;
        String text = CollectionsKt.joinToString$default((Iterable)((Iterable)targetTexts), (CharSequence)"+", null, null, (int)0, null, null, (int)62, null);
        KtExpression replacement = this.safeDeparenthesizeOperands(new KtPsiFactory((KtElement)element, false, 2, null).createExpression(text));
        ApplicationUtilsKt.runWriteActionIfPhysical((PsiElement)element, () -> ConvertToConcatenatedStringIntentionBase.applyTo$lambda$7(element, replacement));
    }

    private final KtExpression safeDeparenthesizeOperands(KtExpression $this$safeDeparenthesizeOperands) {
        if ($this$safeDeparenthesizeOperands instanceof KtBinaryExpression) {
            KtExpression ktExpression = ((KtBinaryExpression)$this$safeDeparenthesizeOperands).getLeft();
            Intrinsics.checkNotNull((Object)ktExpression);
            KtExpression deparenthesizedLeft = this.safeDeparenthesizeOperands(ktExpression);
            KtExpression ktExpression2 = ((KtBinaryExpression)$this$safeDeparenthesizeOperands).getRight();
            Intrinsics.checkNotNull((Object)ktExpression2);
            KtExpression deparenthesizedRight = this.safeDeparenthesizeOperands(ktExpression2);
            Project project = ((KtBinaryExpression)$this$safeDeparenthesizeOperands).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object[] objectArray = new Object[]{deparenthesizedLeft.getText(), deparenthesizedRight.getText()};
            return CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)"$0+$1", (Object[])objectArray, (boolean)false, (int)4, null);
        }
        if ($this$safeDeparenthesizeOperands instanceof KtParenthesizedExpression && KtPsiUtil.areParenthesesUseless((KtParenthesizedExpression)((KtParenthesizedExpression)$this$safeDeparenthesizeOperands))) {
            KtExpression ktExpression = KtPsiUtil.safeDeparenthesize((KtExpression)$this$safeDeparenthesizeOperands, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"safeDeparenthesize(...)");
            return ktExpression;
        }
        return $this$safeDeparenthesizeOperands;
    }

    private final boolean isStringLiteral(KtStringTemplateEntry $this$isStringLiteral) {
        return $this$isStringLiteral.getExpression() == null || $this$isStringLiteral.getExpression() instanceof KtStringTemplateExpression;
    }

    private final boolean isTripleQuoted(String str) {
        return StringsKt.startsWith$default((String)str, (String)"\"\"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)str, (String)"\"\"\"", (boolean)false, (int)2, null);
    }

    private final String toSeparateString(KtStringTemplateEntry $this$toSeparateString, String quote, boolean convertExplicitly) {
        Object object;
        Object text;
        if (!($this$toSeparateString instanceof KtStringTemplateEntryWithExpression)) {
            String string = $this$toSeparateString.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return this.quote(string, quote);
        }
        KtExpression ktExpression = ((KtStringTemplateEntryWithExpression)$this$toSeparateString).getExpression();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression expression = ktExpression;
        Object object2 = text = this.needsParenthesis(expression) ? "(" + expression.getText() + ")" : expression.getText();
        if (convertExplicitly) {
            object = (String)text + ".toString()";
        } else {
            Intrinsics.checkNotNull((Object)text);
            object = text;
        }
        return object;
    }

    private final boolean needsParenthesis(KtExpression expression) {
        KtExpression ktExpression = expression;
        return ktExpression instanceof KtPostfixExpression ? false : (ktExpression instanceof KtAnnotatedExpression || ktExpression instanceof KtLabeledExpression || ktExpression instanceof KtOperationExpression ? true : (ktExpression instanceof KtIfExpression ? !(((KtIfExpression)expression).getElse() instanceof KtBlockExpression) : false));
    }

    private final String quote(String $this$quote, String quote) {
        return quote + $this$quote + quote;
    }

    private final boolean checkIfExpressionIsStringFromModalView(KtExpression expression) {
        Project project = expression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object object = ActionUtil.underModalProgress((Project)project, (String)KotlinBundle.message((String)"convert.to.concatenated.string.statement.analyzing.entry.type", (Object[])new Object[0]), () -> ConvertToConcatenatedStringIntentionBase.checkIfExpressionIsStringFromModalView$lambda$8(this, expression));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"underModalProgress(...)");
        return (Boolean)object;
    }

    public abstract boolean isExpressionOfStringType(@NotNull KtExpression var1);

    private static final PsiElement applyTo$lambda$7(KtStringTemplateExpression $element, KtExpression $replacement) {
        return $element.replace((PsiElement)$replacement);
    }

    private static final Boolean checkIfExpressionIsStringFromModalView$lambda$8(ConvertToConcatenatedStringIntentionBase this$0, KtExpression $expression) {
        return this$0.isExpressionOfStringType($expression);
    }
}

