/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001bB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J#\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0094\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/quickFix/AddLoopLabelFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "Lcom/intellij/codeInspection/LocalQuickFix;", "loop", "jumpExpression", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtLoopExpression;Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;)V", "jumpExpressionPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "existingLabelName", "", "description", "getText", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "invoke", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.code-insight.impl-base"})
public final class AddLoopLabelFix
extends KotlinQuickFixAction<KtLoopExpression>
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SmartPsiElementPointer<KtExpressionWithLabel> jumpExpressionPointer;
    @Nullable
    private final String existingLabelName;
    @Nls
    @NotNull
    private final String description;

    /*
     * WARNING - void declaration
     */
    public AddLoopLabelFix(@NotNull KtLoopExpression loop, @NotNull KtExpressionWithLabel jumpExpression) {
        String string;
        void $this$description_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)jumpExpression, (String)"jumpExpression");
        super((PsiElement)loop);
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)jumpExpression));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        this.jumpExpressionPointer = smartPsiElementPointer;
        Object object = loop.getParent();
        KtLabeledExpression ktLabeledExpression = object instanceof KtLabeledExpression ? (KtLabeledExpression)object : null;
        this.existingLabelName = ktLabeledExpression != null ? ktLabeledExpression.getLabelName() : null;
        object = this;
        AddLoopLabelFix addLoopLabelFix = this;
        boolean bl = false;
        if ($this$description_u24lambda_u240.existingLabelName != null) {
            String labelName = "@" + $this$description_u24lambda_u240.existingLabelName;
            Object[] objectArray = new Object[]{labelName, jumpExpression.getText()};
            string = KotlinBundle.message((String)"fix.add.loop.label.text", (Object[])objectArray);
        } else {
            string = KotlinBundle.message((String)"fix.add.loop.label.text.generic", (Object[])new Object[0]);
        }
        addLoopLabelFix.description = string;
    }

    @NotNull
    public String getText() {
        return this.description;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        this.applyFix();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.applyFix();
    }

    private final void applyFix() {
        KtExpressionWithLabel jumpExpression;
        KtLoopExpression ktLoopExpression = (KtLoopExpression)this.getElement();
        if (ktLoopExpression == null) {
            return;
        }
        KtLoopExpression element = ktLoopExpression;
        String string = this.existingLabelName;
        if (string == null) {
            string = Companion.getUniqueLabelName(element);
        }
        String labelName = string;
        KtExpressionWithLabel ktExpressionWithLabel = jumpExpression = (KtExpressionWithLabel)this.jumpExpressionPointer.getElement();
        if (ktExpressionWithLabel != null) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ktExpressionWithLabel.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createExpression(jumpExpression.getText() + "@" + labelName));
        }
        if (this.existingLabelName == null) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object[] objectArray = new Object[]{labelName, element};
            element.replace((PsiElement)CreateByPatternKt.createExpressionByPattern((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)"$0@ $1", (Object[])objectArray, (boolean)false));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/quickFix/AddLoopLabelFix$Companion;", "", "<init>", "()V", "getUniqueLabelName", "", "existingNames", "", "loop", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "collectUsedLabels", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "kotlin.code-insight.impl-base"})
    @SourceDebugExtension(value={"SMAP\nAddLoopLabelFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddLoopLabelFix.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/quickFix/AddLoopLabelFix$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,86:1\n1317#2,2:87\n*S KotlinDebug\n*F\n+ 1 AddLoopLabelFix.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/quickFix/AddLoopLabelFix$Companion\n*L\n77#1:87,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getUniqueLabelName(Collection<String> existingNames) {
            int index2 = 0;
            Object result2 = "loop";
            while (existingNames.contains(result2)) {
                result2 = "loop" + ++index2;
            }
            return result2;
        }

        @NotNull
        public final String getUniqueLabelName(@NotNull KtLoopExpression loop) {
            Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
            return this.getUniqueLabelName((Collection<String>)this.collectUsedLabels((KtElement)loop));
        }

        private final Set<String> collectUsedLabels(KtElement element) {
            HashSet<String> usedLabels = new HashSet<String>();
            element.acceptChildren((PsiElementVisitor)new KtTreeVisitorVoid(usedLabels){
                final /* synthetic */ HashSet<String> $usedLabels;
                {
                    this.$usedLabels = $usedLabels;
                }

                public void visitLabeledExpression(KtLabeledExpression expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    super.visitLabeledExpression(expression);
                    String string = expression.getLabelName();
                    Intrinsics.checkNotNull((Object)string);
                    this.$usedLabels.add(string);
                }
            });
            Sequence $this$forEach$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)element));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof KtLabeledExpression)) continue;
                String string = ((KtLabeledExpression)it).getLabelName();
                Intrinsics.checkNotNull((Object)string);
                usedLabels.add(string);
            }
            return usedLabels;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

