/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compilerPlugin.kotlinxSerialization.compiler.diagnostic;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.refactoring.fqName.FqNameUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationErrors;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\u00132\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/compilerPlugin/kotlinxSerialization/compiler/diagnostic/JsonFormatRedundantDiagnostic;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "jsonFqName", "Lorg/jetbrains/kotlin/name/FqName;", "jsonDefaultFqName", "parameterNameFrom", "Lorg/jetbrains/kotlin/name/Name;", "parameterNameBuilderAction", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isJsonFormatCreation", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "isDefaultFormat", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isDefaultFormatArgument", "arg", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "isEmptyFunctionArgument", "kotlin.compiler-plugins.kotlinx-serialization.common"})
@SourceDebugExtension(value={"SMAP\nJsonFormatRedundantDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonFormatRedundantDiagnostic.kt\norg/jetbrains/kotlin/idea/compilerPlugin/kotlinxSerialization/compiler/diagnostic/JsonFormatRedundantDiagnostic\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,95:1\n216#2,2:96\n*S KotlinDebug\n*F\n+ 1 JsonFormatRedundantDiagnostic.kt\norg/jetbrains/kotlin/idea/compilerPlugin/kotlinxSerialization/compiler/diagnostic/JsonFormatRedundantDiagnostic\n*L\n59#1:96,2\n*E\n"})
public final class JsonFormatRedundantDiagnostic
implements CallChecker {
    @NotNull
    private final FqName jsonFqName = new FqName("kotlinx.serialization.json.Json");
    @NotNull
    private final FqName jsonDefaultFqName = new FqName("kotlinx.serialization.json.Json.Default");
    @NotNull
    private final Name parameterNameFrom;
    @NotNull
    private final Name parameterNameBuilderAction;

    public JsonFormatRedundantDiagnostic() {
        Name name2 = Name.identifier((String)"from");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        this.parameterNameFrom = name2;
        Name name3 = Name.identifier((String)"builderAction");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        this.parameterNameBuilderAction = name3;
    }

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        SimpleFunctionDescriptor simpleFunctionDescriptor = callableDescriptor instanceof SimpleFunctionDescriptor ? (SimpleFunctionDescriptor)callableDescriptor : null;
        if (simpleFunctionDescriptor == null) {
            return;
        }
        SimpleFunctionDescriptor functionDescriptor = simpleFunctionDescriptor;
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        if (this.isJsonFormatCreation(functionDescriptor)) {
            if (this.isDefaultFormat(resolvedCall, bindingContext2)) {
                context.getTrace().report((Diagnostic)SerializationErrors.JSON_FORMAT_REDUNDANT_DEFAULT.on((PsiElement)resolvedCall.getCall().getCallElement()));
            }
            return;
        }
        KtExpression ktExpression = CallUtilKt.getReceiverExpression(resolvedCall);
        if (ktExpression == null) {
            return;
        }
        KtExpression receiverExpression = ktExpression;
        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)receiverExpression), (BindingContext)bindingContext2);
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall receiverResolvedCall = resolvedCall2;
        CallableDescriptor callableDescriptor2 = receiverResolvedCall.getResultingDescriptor();
        SimpleFunctionDescriptor simpleFunctionDescriptor2 = callableDescriptor2 instanceof SimpleFunctionDescriptor ? (SimpleFunctionDescriptor)callableDescriptor2 : null;
        if (simpleFunctionDescriptor2 == null) {
            return;
        }
        SimpleFunctionDescriptor receiverFunctionDescriptor = simpleFunctionDescriptor2;
        if (this.isJsonFormatCreation(receiverFunctionDescriptor) && !this.isDefaultFormat(receiverResolvedCall, bindingContext2)) {
            context.getTrace().report((Diagnostic)SerializationErrors.JSON_FORMAT_REDUNDANT.on(receiverExpression.getOriginalElement()));
        }
    }

    private final boolean isJsonFormatCreation(SimpleFunctionDescriptor descriptor2) {
        return Intrinsics.areEqual((Object)ImportsUtils.getImportableFqName((DeclarationDescriptor)descriptor2), (Object)this.jsonFqName);
    }

    private final boolean isDefaultFormat(ResolvedCall<?> resolvedCall, BindingContext context) {
        boolean defaultFrom = false;
        boolean emptyBuilder = false;
        Map map2 = resolvedCall.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getValueArguments(...)");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ValueParameterDescriptor paramDesc = (ValueParameterDescriptor)entry.getKey();
            ResolvedValueArgument arg = (ResolvedValueArgument)entry.getValue();
            Name name2 = paramDesc.getName();
            if (Intrinsics.areEqual((Object)name2, (Object)this.parameterNameFrom)) {
                Intrinsics.checkNotNull((Object)arg);
                defaultFrom = this.isDefaultFormatArgument(arg, context);
                continue;
            }
            if (!Intrinsics.areEqual((Object)name2, (Object)this.parameterNameBuilderAction)) continue;
            Intrinsics.checkNotNull((Object)arg);
            emptyBuilder = this.isEmptyFunctionArgument(arg);
        }
        return defaultFrom && emptyBuilder;
    }

    private final boolean isDefaultFormatArgument(ResolvedValueArgument arg, BindingContext context) {
        if (arg instanceof DefaultValueArgument) {
            return true;
        }
        if (!(arg instanceof ExpressionValueArgument)) {
            return false;
        }
        ValueArgument valueArgument = ((ExpressionValueArgument)arg).getValueArgument();
        if (valueArgument == null || (valueArgument = valueArgument.getArgumentExpression()) == null) {
            return false;
        }
        ValueArgument expression = valueArgument;
        KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)context.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)expression);
        if (kotlinTypeInfo == null || (kotlinTypeInfo = kotlinTypeInfo.getType()) == null || (kotlinTypeInfo = FqNameUtilKt.getFqName((KotlinType)kotlinTypeInfo)) == null) {
            return false;
        }
        KotlinTypeInfo fqName2 = kotlinTypeInfo;
        return Intrinsics.areEqual((Object)fqName2, (Object)this.jsonDefaultFqName);
    }

    private final boolean isEmptyFunctionArgument(ResolvedValueArgument arg) {
        KtBlockExpression blockExpression;
        Object object;
        Object object2;
        if (!(arg instanceof ExpressionValueArgument)) {
            return false;
        }
        ValueArgument valueArgument = ((ExpressionValueArgument)arg).getValueArgument();
        if (valueArgument == null || (valueArgument = valueArgument.getArgumentExpression()) == null) {
            return false;
        }
        ValueArgument argumentExpression = valueArgument;
        if (argumentExpression instanceof KtNamedFunction) {
            object2 = ((KtNamedFunction)argumentExpression).getBodyBlockExpression();
            if (object2 == null) {
                return true;
            }
        } else {
            KtLambdaExpression ktLambdaExpression = KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)argumentExpression, (boolean)false, (int)1, null);
            object2 = ktLambdaExpression != null ? ktLambdaExpression.getBodyExpression() : null;
        }
        return (object = (blockExpression = object2)) != null && (object = object.getStatements()) != null ? object.isEmpty() : false;
    }
}

