/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.position.LeftNeighbour;
import com.intellij.psi.filters.position.PositionElementFilter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.completion.KeywordLookupObject;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.WithTailInsertHandler;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBackingField;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.ModifierCheckerHelpersKt;
import org.jetbrains.kotlin.resolve.TargetAllowedPredicate;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 R2\u00020\u0001:\u0007QRSTUVWB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J2\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000fJ\u001c\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012*\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u0014\u001a\u00020\r*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0013H\u0002JZ\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r0\u000f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J,\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u001d2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001d0)2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J,\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J.\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010*\u001a\u00020\u001d2\b\u0010,\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0002J&\u0010.\u001a\b\u0012\u0004\u0012\u00020/0)2\u0006\u00100\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u001d2\u0006\u00101\u001a\u000202H\u0002J$\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u00104\u001a\u00020\r*\u00020\tH\u0002J\u0010\u00105\u001a\u00020\r2\u0006\u00106\u001a\u00020\tH\u0002J\u0014\u00107\u001a\u00020\r*\u0002082\u0006\u00109\u001a\u00020\u0013H\u0002J \u0010:\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010;\u001a\u00020<H\u0002J \u0010=\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010>\u001a\u00020?2\u0006\u0010;\u001a\u00020<H\u0002J&\u0010@\u001a\u00020\u00072\n\u0010A\u001a\u00060Bj\u0002`C2\u0006\u0010\b\u001a\u00020\t2\b\u0010D\u001a\u0004\u0018\u00010\tH\u0002J\u0018\u0010E\u001a\u00020\u0007*\u00060Bj\u0002`C2\u0006\u0010F\u001a\u00020\tH\u0002J\u0014\u0010G\u001a\u00020H*\u00020\t2\u0006\u0010I\u001a\u00020\tH\u0002J\u0012\u0010J\u001a\b\u0012\u0004\u0012\u00020\t0)*\u00020\tH\u0002J \u0010K\u001a\u00020\r2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020?2\u0006\u0010;\u001a\u00020<H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010$\u001a\u00020\r*\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010&R\u0018\u0010'\u001a\u00020\r*\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010&R\u0018\u0010O\u001a\u00020\r*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010P\u00a8\u0006X"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion;", "", "languageVersionSettingProvider", "Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$LanguageVersionSettingProvider;", "<init>", "(Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$LanguageVersionSettingProvider;)V", "complete", "", "position", "Lcom/intellij/psi/PsiElement;", "prefixMatcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "isJvmModule", "", "consumer", "Lkotlin/Function1;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getNextPossibleKeywords", "", "Lorg/jetbrains/kotlin/lexer/KtKeywordToken;", "avoidSuggestingWith", "keywordToken", "ignorePrefixForKeyword", "completionPosition", "handleCompoundKeyword", "nextKeyword", "parserFilter", "handleTopLevelClassName", "keyword", "", "createLookupElementBuilder", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "getTopLevelClassName", "GENERAL_FILTER", "Lcom/intellij/psi/filters/NotFilter;", "buildFilter", "isExtensionReceiverInCallableDeclaration", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;)Z", "isTypeArgumentOfOuterKtTypeReference", "computeKeywordApplications", "Lkotlin/sequences/Sequence;", "prefixText", "buildFilterWithContext", "contextElement", "buildFilterWithReducedContext", "buildFilesWithKeywordApplication", "Lorg/jetbrains/kotlin/psi/KtFile;", "keywordTokenType", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "buildFilterByText", "isSemicolon", "isErrorElementBefore", "token", "matchesKeyword", "Lcom/intellij/psi/tree/IElementType;", "keywordType", "isModifierSupportedAtLanguageLevel", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isModifierTargetSupportedAtLanguageLevel", "target", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "buildReducedContextBefore", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "scope", "appendReducedText", "element", "getStartOffsetInAncestor", "", "ancestor", "goUpWhileIsLastChild", "isPossibleParentTarget", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "parentTarget", "isExplicitBackingFieldDeclaration", "(Lcom/intellij/psi/PsiElement;)Z", "LanguageVersionSettingProvider", "Companion", "UseSiteAnnotationTargetInsertHandler", "SpaceAfterInsertHandler", "CommentFilter", "ParentFilter", "FileFilter", "kotlin.completion.impl.shared"})
@SourceDebugExtension(value={"SMAP\nKeywordCompletion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeywordCompletion.kt\norg/jetbrains/kotlin/idea/completion/KeywordCompletion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,777:1\n1863#2,2:778\n2632#2,3:780\n1755#2,3:783\n1755#2,3:788\n2632#2,3:807\n1628#2,3:821\n1557#2:824\n1628#2,3:825\n1251#3,2:786\n1251#3,2:795\n1251#3,2:799\n183#3,2:801\n183#3,2:811\n2163#3,2:813\n1251#3,2:815\n16#4,2:791\n16#4,2:793\n16#4,2:797\n66#5,2:803\n1#6:805\n217#7:806\n196#7:810\n11158#8:817\n11493#8,3:818\n*S KotlinDebug\n*F\n+ 1 KeywordCompletion.kt\norg/jetbrains/kotlin/idea/completion/KeywordCompletion\n*L\n137#1:778,2\n202#1:780,3\n233#1:783,3\n271#1:788,3\n590#1:807,3\n70#1:821,3\n127#1:824\n127#1:825,3\n265#1:786,2\n349#1:795,2\n646#1:799,2\n714#1:801,2\n621#1:811,2\n622#1:813,2\n637#1:815,2\n336#1:791,2\n337#1:793,2\n381#1:797,2\n521#1:803,2\n534#1:806\n595#1:810\n60#1:817\n60#1:818,3\n*E\n"})
public final class KeywordCompletion {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final LanguageVersionSettingProvider languageVersionSettingProvider;
    @NotNull
    private final NotFilter GENERAL_FILTER;
    @NotNull
    private static final List<KtKeywordToken> ALL_KEYWORDS;
    @NotNull
    private static final HashSet<String> INCOMPATIBLE_KEYWORDS_AROUND_SEALED;
    @NotNull
    private static final Set<KtKeywordToken> KEYWORDS_ALLOWED_INSIDE_ANNOTATION_ENTRY;
    @NotNull
    private static final Map<KtKeywordToken, Set<KtKeywordToken>> COMPOUND_KEYWORDS_NOT_SUGGEST_TOGETHER;
    @NotNull
    private static final Map<KtKeywordToken, String> KEYWORD_CONSTRUCTS;
    @NotNull
    private static final List<String> NO_SPACE_AFTER;

    public KeywordCompletion(@NotNull LanguageVersionSettingProvider languageVersionSettingProvider) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettingProvider, (String)"languageVersionSettingProvider");
        this.languageVersionSettingProvider = languageVersionSettingProvider;
        ElementFilter[] elementFilterArray = new ElementFilter[]{new CommentFilter(), new ParentFilter((ElementFilter)new ClassFilter(KtLiteralStringTemplateEntry.class)), new ParentFilter((ElementFilter)new ClassFilter(KtConstantExpression.class)), new FileFilter((ElementFilter)new ClassFilter(KtTypeCodeFragment.class)), new LeftNeighbour((ElementFilter)new TextFilter(".")), new LeftNeighbour((ElementFilter)new TextFilter("?."))};
        this.GENERAL_FILTER = new NotFilter((ElementFilter)new OrFilter(elementFilterArray));
    }

    public final void complete(@NotNull PsiElement position, @NotNull PrefixMatcher prefixMatcher, boolean isJvmModule, @NotNull Function1<? super LookupElement, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)prefixMatcher, (String)"prefixMatcher");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (!this.GENERAL_FILTER.isAcceptable((Object)position, position)) {
            return;
        }
        boolean sealedInterfacesEnabled = this.languageVersionSettingProvider.getLanguageVersionSetting(position).supportsFeature(LanguageFeature.SealedInterfaces);
        Function1<KtKeywordToken, Boolean> parserFilter = this.buildFilter(position);
        for (KtKeywordToken keywordToken : ALL_KEYWORDS) {
            Set set = this.getNextPossibleKeywords(keywordToken, position);
            if (set == null) {
                set = SetsKt.setOf(null);
            }
            Set nextKeywords = set;
            Iterable $this$forEach$iv = nextKeywords;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtKeywordToken it = (KtKeywordToken)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)keywordToken, (Object)KtTokens.SEALED_KEYWORD) && Intrinsics.areEqual((Object)it, (Object)KtTokens.INTERFACE_KEYWORD) && !sealedInterfacesEnabled) continue;
                this.handleCompoundKeyword(position, keywordToken, it, isJvmModule, prefixMatcher, parserFilter, consumer);
            }
        }
    }

    private final Set<KtKeywordToken> getNextPossibleKeywords(KtKeywordToken $this$getNextPossibleKeywords, PsiElement position) {
        return Intrinsics.areEqual((Object)$this$getNextPossibleKeywords, (Object)KtTokens.SUSPEND_KEYWORD) && KotlinPsiUtils.isInsideKtTypeReference(position) ? null : KeywordCompletion.Companion.getCompoundKeywords($this$getNextPossibleKeywords, this.languageVersionSettingProvider.getLanguageVersionSetting(position));
    }

    private final boolean avoidSuggestingWith(KtKeywordToken $this$avoidSuggestingWith, KtKeywordToken keywordToken) {
        Set<KtKeywordToken> set = COMPOUND_KEYWORDS_NOT_SUGGEST_TOGETHER.get($this$avoidSuggestingWith);
        if (set == null) {
            return false;
        }
        Set<KtKeywordToken> nextKeywords = set;
        return nextKeywords.contains(keywordToken);
    }

    private final boolean ignorePrefixForKeyword(PsiElement completionPosition, KtKeywordToken keywordToken) {
        KtKeywordToken ktKeywordToken = keywordToken;
        return Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.OVERRIDE_KEYWORD) ? true : (Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.THIS_KEYWORD) || Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.RETURN_KEYWORD) || Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.BREAK_KEYWORD) || Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.CONTINUE_KEYWORD) ? completionPosition instanceof KtExpressionWithLabel && ((KtExpressionWithLabel)completionPosition).getTargetLabel() != null : false);
    }

    private final void handleCompoundKeyword(PsiElement position, KtKeywordToken keywordToken, KtKeywordToken nextKeyword, boolean isJvmModule, PrefixMatcher prefixMatcher, Function1<? super KtKeywordToken, Boolean> parserFilter, Function1<? super LookupElement, Unit> consumer) {
        if (KotlinPsiUtils.isInsideAnnotationEntryArgumentList(position) && !KEYWORDS_ALLOWED_INSIDE_ANNOTATION_ENTRY.contains(keywordToken)) {
            return;
        }
        String string = keywordToken.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        Object keyword = string;
        boolean applicableAsCompound = false;
        if (nextKeyword != null) {
            boolean nextIsNotYetPresent;
            String next = null;
            PsiElement psiElement = PsiUtilsKt.nextLeaf((PsiElement)position, KeywordCompletion::handleCompoundKeyword$lambda$1);
            String string2 = next = psiElement != null ? psiElement.getText() : null;
            String string3 = next = string2 != null ? StringsKt.removePrefix((String)string2, (CharSequence)"$") : null;
            if (Intrinsics.areEqual((Object)keywordToken, (Object)KtTokens.SEALED_KEYWORD)) {
                String prev;
                if (CollectionsKt.contains((Iterable)INCOMPATIBLE_KEYWORDS_AROUND_SEALED, (Object)next)) {
                    return;
                }
                PsiElement psiElement2 = PsiUtilsKt.prevLeaf((PsiElement)position, KeywordCompletion::handleCompoundKeyword$lambda$2);
                String string4 = prev = psiElement2 != null ? psiElement2.getText() : null;
                if (CollectionsKt.contains((Iterable)INCOMPATIBLE_KEYWORDS_AROUND_SEALED, (Object)prev)) {
                    return;
                }
            }
            Set<KtKeywordToken> set = this.getNextPossibleKeywords(keywordToken, position);
            if (set != null) {
                boolean bl;
                block18: {
                    Iterable $this$none$iv = set;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            KtKeywordToken it = (KtKeywordToken)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getValue(), (Object)next)) continue;
                            bl = false;
                            break block18;
                        }
                        bl = true;
                    }
                }
                v8 = bl;
            } else {
                v8 = nextIsNotYetPresent = false;
            }
            if (nextIsNotYetPresent && this.avoidSuggestingWith(keywordToken, nextKeyword)) {
                return;
            }
            if (nextIsNotYetPresent) {
                keyword = (String)keyword + " " + nextKeyword.getValue();
            } else {
                applicableAsCompound = true;
            }
        }
        if (Intrinsics.areEqual((Object)keywordToken, (Object)KtTokens.DYNAMIC_KEYWORD) && isJvmModule) {
            return;
        }
        if (!this.ignorePrefixForKeyword(position, keywordToken) && !prefixMatcher.isStartMatch((String)keyword)) {
            return;
        }
        if (!((Boolean)parserFilter.invoke((Object)keywordToken)).booleanValue()) {
            return;
        }
        String constructText = KEYWORD_CONSTRUCTS.get(keywordToken);
        if (constructText != null && !applicableAsCompound) {
            Project project = position.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            LookupElement element = HandlerUtilsKt.createKeywordConstructLookupElement$default(project, (String)keyword, constructText, false, false, 24, null);
            consumer.invoke((Object)element);
        } else {
            this.handleTopLevelClassName(position, (String)keyword, consumer);
            consumer.invoke((Object)this.createLookupElementBuilder((String)keyword, position));
        }
    }

    private final void handleTopLevelClassName(PsiElement position, String keyword, Function1<? super LookupElement, Unit> consumer) {
        String topLevelClassName = this.getTopLevelClassName(position);
        if (topLevelClassName != null) {
            boolean bl;
            block8: {
                Object[] objectArray = new KtKeywordToken[]{KtTokens.OBJECT_KEYWORD, KtTokens.INTERFACE_KEYWORD};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtKeywordToken it = (KtKeywordToken)element$iv;
                        boolean bl2 = false;
                        String string = it.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                        if (!StringsKt.endsWith$default((String)keyword, (String)string, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KeywordCompletion.handleTopLevelClassName$consumeClassNameWithoutBraces(consumer, this, keyword, topLevelClassName, position);
            }
            String string = KtTokens.CLASS_KEYWORD.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (StringsKt.endsWith$default((String)keyword, (String)string, (boolean)false, (int)2, null)) {
                String string2 = KtTokens.DATA_KEYWORD.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                if (StringsKt.startsWith$default((String)keyword, (String)string2, (boolean)false, (int)2, null)) {
                    Project project = position.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    consumer.invoke((Object)HandlerUtilsKt.createKeywordConstructLookupElement$default(project, keyword, keyword + " " + topLevelClassName + "(caret)", false, false, 24, null));
                } else {
                    KeywordCompletion.handleTopLevelClassName$consumeClassNameWithoutBraces(consumer, this, keyword, topLevelClassName, position);
                }
            }
        }
    }

    private final LookupElementBuilder createLookupElementBuilder(String keyword, PsiElement position) {
        LookupElementBuilder lookupElementBuilder;
        PsiElement psiElement = PsiUtilsKt.prevLeaf$default((PsiElement)position, (boolean)false, (int)1, null);
        boolean isUseSiteAnnotationTarget = Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)KtTokens.AT);
        InsertHandler insertHandler = isUseSiteAnnotationTarget ? (InsertHandler)UseSiteAnnotationTargetInsertHandler.INSTANCE : (NO_SPACE_AFTER.contains(keyword) ? null : (InsertHandler)SpaceAfterInsertHandler.INSTANCE);
        LookupElementBuilder lookupElementBuilder2 = LookupElementBuilder.create((Object)new KeywordLookupObject(), (String)keyword).bold().withInsertHandler(insertHandler);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder2, (String)"withInsertHandler(...)");
        LookupElementBuilder element = lookupElementBuilder2;
        if (isUseSiteAnnotationTarget) {
            LookupElementBuilder lookupElementBuilder3 = element.withPresentableText(keyword + ":");
            Intrinsics.checkNotNull((Object)lookupElementBuilder3);
            lookupElementBuilder = lookupElementBuilder3;
        } else {
            lookupElementBuilder = element;
        }
        return lookupElementBuilder;
    }

    private final String getTopLevelClassName(PsiElement position) {
        String name2;
        block13: {
            block12: {
                boolean bl;
                block11: {
                    boolean bl2;
                    block10: {
                        Sequence $this$any$iv = PsiUtilsKt.getParents((PsiElement)position);
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl3 = false;
                            if (!(it instanceof KtDeclaration)) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = false;
                    }
                    if (bl2) {
                        return null;
                    }
                    Iterator iterator = position.getContainingFile();
                    KtFile ktFile2 = iterator instanceof KtFile ? (KtFile)iterator : null;
                    if (ktFile2 == null) {
                        return null;
                    }
                    KtFile file = ktFile2;
                    String string = FileUtil.getNameWithoutExtension((String)file.getName());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
                    name2 = string;
                    if (!Name.isValidIdentifier((String)name2)) break block12;
                    Name name3 = Name.identifier((String)name2);
                    Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
                    if (!Intrinsics.areEqual((Object)RenderingUtilsKt.render((Name)name3), (Object)name2) || !Character.isUpperCase(name2.charAt(0))) break block12;
                    Iterable $this$any$iv = file.getDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtDeclaration it = (KtDeclaration)element$iv;
                            boolean bl4 = false;
                            if (!(it instanceof KtClassOrObject && Intrinsics.areEqual((Object)((KtClassOrObject)it).getName(), (Object)name2))) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block13;
            }
            return null;
        }
        return name2;
    }

    /*
     * WARNING - void declaration
     */
    private final Function1<KtKeywordToken, Boolean> buildFilter(PsiElement position) {
        Ref.ObjectRef prevParent = new Ref.ObjectRef();
        prevParent.element = position;
        for (PsiElement parent2 = position.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            PsiElement psiElement = parent2;
            if (psiElement instanceof KtBlockExpression) {
                Object v6;
                Object prefixText;
                block35: {
                    void $this$firstIsInstanceOrNull$iv;
                    if (prevParent.element instanceof KtScriptInitializer && ((KtBlockExpression)parent2).getParent() instanceof KtScript) {
                        Object v0;
                        boolean $i$f$firstIsInstanceOrNull;
                        Sequence $this$firstIsInstanceOrNull$iv2;
                        block32: {
                            $this$firstIsInstanceOrNull$iv2 = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)parent2);
                            $i$f$firstIsInstanceOrNull = false;
                            for (Object element$iv : $this$firstIsInstanceOrNull$iv2) {
                                if (!(element$iv instanceof KtScriptInitializer)) continue;
                                v0 = element$iv;
                                break block32;
                            }
                            v0 = null;
                        }
                        if (v0 == prevParent.element) {
                            Object v2;
                            block33: {
                                PsiElement psiElement2 = ((KtBlockExpression)parent2).getParent();
                                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
                                $this$firstIsInstanceOrNull$iv2 = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)psiElement2);
                                $i$f$firstIsInstanceOrNull = false;
                                for (Object element$iv : $this$firstIsInstanceOrNull$iv2) {
                                    if (!(element$iv instanceof KtBlockExpression)) continue;
                                    v2 = element$iv;
                                    break block33;
                                }
                                v2 = null;
                            }
                            if (v2 == parent2) {
                                return this.buildFilterWithReducedContext("", null, position);
                            }
                        }
                    }
                    prefixText = "fun foo() { ";
                    if (prevParent.element instanceof KtExpression) {
                        PsiElement prevLeaf = PsiUtilsKt.prevLeaf((PsiElement)((PsiElement)prevParent.element), KeywordCompletion::buildFilter$lambda$7);
                        if (prevLeaf != null) {
                            boolean bl;
                            Iterator iterator;
                            block34: {
                                Sequence<PsiElement> $this$any$iv = this.goUpWhileIsLastChild(prevLeaf);
                                boolean $i$f$any = false;
                                iterator = $this$any$iv.iterator();
                                while (iterator.hasNext()) {
                                    Object element$iv = iterator.next();
                                    PsiElement it = (PsiElement)element$iv;
                                    boolean bl2 = false;
                                    if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)KtNodeTypes.THEN)) continue;
                                    bl = true;
                                    break block34;
                                }
                                bl = false;
                            }
                            boolean isAfterThen = bl;
                            boolean isAfterTry = false;
                            boolean isAfterCatch = false;
                            if (Intrinsics.areEqual((Object)prevLeaf.getNode().getElementType(), (Object)KtTokens.RBRACE)) {
                                PsiElement psiElement3 = prevLeaf.getParent();
                                KtBlockExpression ktBlockExpression = psiElement3 instanceof KtBlockExpression ? (KtBlockExpression)psiElement3 : null;
                                Object object = iterator = ktBlockExpression != null ? ktBlockExpression.getParent() : null;
                                if (iterator instanceof KtTryExpression) {
                                    isAfterTry = true;
                                } else if (iterator instanceof KtCatchClause) {
                                    isAfterTry = true;
                                    isAfterCatch = true;
                                }
                            }
                            if (isAfterThen) {
                                prefixText = (String)prefixText + (isAfterTry ? "if (a)\n" : "if (a) {}\n");
                            }
                            if (isAfterTry) {
                                prefixText = (String)prefixText + "try {}\n";
                            }
                            if (isAfterCatch) {
                                prefixText = (String)prefixText + "catch (e: E) {}\n";
                            }
                        }
                        return this.buildFilterWithContext((String)prefixText, (PsiElement)prevParent.element, position);
                    }
                    Sequence isAfterThen = PsiUtilsKt.siblings((PsiElement)((PsiElement)prevParent.element), (boolean)false, (boolean)false);
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof KtExpression)) continue;
                        v6 = element$iv;
                        break block35;
                    }
                    v6 = null;
                }
                KtExpression lastExpression = v6;
                if (lastExpression != null) {
                    String contextAfterExpression = SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)lastExpression), (boolean)true, (boolean)false), arg_0 -> KeywordCompletion.buildFilter$lambda$9(prevParent, arg_0)), null, null, null, (int)0, null, KeywordCompletion::buildFilter$lambda$10, (int)31, null);
                    return this.buildFilterWithContext((String)prefixText + "x" + contextAfterExpression, (PsiElement)prevParent.element, position);
                }
            } else if (psiElement instanceof KtDeclarationWithInitializer) {
                KtExpression initializer2 = ((KtDeclarationWithInitializer)parent2).getInitializer();
                if (Intrinsics.areEqual((Object)prevParent.element, (Object)initializer2)) {
                    return this.buildFilterWithContext("val v = ", (PsiElement)initializer2, position);
                }
            } else if (psiElement instanceof KtParameter) {
                KtExpression ktExpression = ((KtParameter)parent2).getDefaultValue();
                if (Intrinsics.areEqual((Object)prevParent.element, (Object)ktExpression)) {
                    return this.buildFilterWithContext("val v = ", (PsiElement)ktExpression, position);
                }
            } else if (psiElement instanceof KtTypeReference) {
                boolean shouldIntroduceTypeReferenceContext;
                boolean bl = this.isExtensionReceiverInCallableDeclaration((KtTypeReference)parent2) ? false : (shouldIntroduceTypeReferenceContext = !(((KtTypeReference)parent2).getParent() instanceof KtConstructorCalleeExpression));
                if (shouldIntroduceTypeReferenceContext) {
                    String prefixText = this.isTypeArgumentOfOuterKtTypeReference((KtTypeReference)parent2) ? "fun foo(x: X<" : "fun foo(x: ";
                    return this.buildFilterWithContext(prefixText, parent2, position);
                }
            } else if (psiElement instanceof KtDeclaration) {
                PsiElement psiElement4 = ((KtDeclaration)parent2).getParent();
                if (psiElement4 instanceof KtClassOrObject) {
                    return parent2 instanceof KtPrimaryConstructor ? this.buildFilterWithReducedContext("class X ", parent2, position) : this.buildFilterWithReducedContext("class X { ", parent2, position);
                }
                if (psiElement4 instanceof KtFile) {
                    return this.buildFilterWithReducedContext("", parent2, position);
                }
            }
            prevParent.element = parent2;
        }
        return this.buildFilterWithReducedContext("", null, position);
    }

    private final boolean isExtensionReceiverInCallableDeclaration(KtTypeReference $this$isExtensionReceiverInCallableDeclaration) {
        PsiElement parent2 = $this$isExtensionReceiverInCallableDeclaration.getParent();
        return parent2 instanceof KtCallableDeclaration && Intrinsics.areEqual((Object)((KtCallableDeclaration)parent2).getReceiverTypeReference(), (Object)$this$isExtensionReceiverInCallableDeclaration);
    }

    private final boolean isTypeArgumentOfOuterKtTypeReference(KtTypeReference $this$isTypeArgumentOfOuterKtTypeReference) {
        KtUserType userType;
        KtTypeArgumentList typeArgumentList;
        KtTypeProjection typeProjection;
        PsiElement psiElement = $this$isTypeArgumentOfOuterKtTypeReference.getParent();
        KtTypeProjection ktTypeProjection = typeProjection = psiElement instanceof KtTypeProjection ? (KtTypeProjection)psiElement : null;
        PsiElement psiElement2 = ktTypeProjection != null ? ktTypeProjection.getParent() : null;
        KtTypeArgumentList ktTypeArgumentList = typeArgumentList = psiElement2 instanceof KtTypeArgumentList ? (KtTypeArgumentList)psiElement2 : null;
        PsiElement psiElement3 = ktTypeArgumentList != null ? ktTypeArgumentList.getParent() : null;
        KtUserType ktUserType = userType = psiElement3 instanceof KtUserType ? (KtUserType)psiElement3 : null;
        return (ktUserType != null ? ktUserType.getParent() : null) instanceof KtTypeReference;
    }

    private final Sequence<String> computeKeywordApplications(String prefixText, KtKeywordToken keyword) {
        Sequence sequence;
        KtKeywordToken ktKeywordToken = keyword;
        if (Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.SUSPEND_KEYWORD)) {
            Object[] objectArray = new String[]{"suspend () -> Unit>", "suspend X"};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else if (Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.CONTEXT_KEYWORD)) {
            Object[] objectArray = new String[]{"context", "context(X) fun"};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else if (StringsKt.endsWith$default((String)prefixText, (String)"@", (boolean)false, (int)2, null)) {
            Object[] objectArray = new String[]{keyword.getValue() + ":X Y.Z"};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else {
            Object[] objectArray = new String[]{keyword.getValue() + " X"};
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        }
        return sequence;
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterWithContext(String prefixText, PsiElement contextElement, PsiElement position) {
        int offset = this.getStartOffsetInAncestor(position, contextElement);
        String string = contextElement.getText();
        Intrinsics.checkNotNull((Object)string);
        String string2 = string.substring(0, offset);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String truncatedContext = string2;
        return this.buildFilterByText(prefixText + truncatedContext, position);
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterWithReducedContext(String prefixText, PsiElement contextElement, PsiElement position) {
        StringBuilder builder2 = new StringBuilder();
        this.buildReducedContextBefore(builder2, position, contextElement);
        return this.buildFilterByText(prefixText + builder2, position);
    }

    private final Sequence<KtFile> buildFilesWithKeywordApplication(KtKeywordToken keywordTokenType, String prefixText, KtPsiFactory psiFactory) {
        return SequencesKt.map(this.computeKeywordApplications(prefixText, keywordTokenType), arg_0 -> KeywordCompletion.buildFilesWithKeywordApplication$lambda$11(psiFactory, prefixText, arg_0));
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterByText(String prefixText, PsiElement position) {
        Project project = position.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        return arg_0 -> KeywordCompletion.buildFilterByText$lambda$17(this, prefixText, psiFactory, position, arg_0);
    }

    private final boolean isSemicolon(PsiElement $this$isSemicolon) {
        return Intrinsics.areEqual((Object)$this$isSemicolon.getNode().getElementType(), (Object)KtTokens.SEMICOLON);
    }

    private final boolean isErrorElementBefore(PsiElement token) {
        for (PsiElement leaf : PsiUtilsKt.getPrevLeafs((PsiElement)token)) {
            boolean bl;
            block3: {
                if (leaf instanceof PsiWhiteSpace || leaf instanceof PsiComment) continue;
                Sequence $this$any$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)leaf);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof PsiErrorElement)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                return true;
            }
            if (leaf.getTextLength() == 0) continue;
            break;
        }
        return false;
    }

    private final boolean matchesKeyword(IElementType $this$matchesKeyword, KtKeywordToken keywordType) {
        IElementType iElementType = $this$matchesKeyword;
        return Intrinsics.areEqual((Object)iElementType, (Object)keywordType) ? true : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IN) ? Intrinsics.areEqual((Object)keywordType, (Object)KtTokens.IN_KEYWORD) : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IS) ? Intrinsics.areEqual((Object)keywordType, (Object)KtTokens.IS_KEYWORD) : false));
    }

    private final boolean isModifierSupportedAtLanguageLevel(PsiElement position, KtKeywordToken keyword, LanguageVersionSettings languageVersionSettings) {
        LanguageFeature languageFeature;
        KtKeywordToken ktKeywordToken = keyword;
        if (Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.TYPE_ALIAS_KEYWORD)) {
            languageFeature = LanguageFeature.TypeAliases;
        } else if (Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.EXPECT_KEYWORD) || Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.ACTUAL_KEYWORD)) {
            languageFeature = LanguageFeature.MultiPlatformProjects;
        } else if (Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.SUSPEND_KEYWORD)) {
            languageFeature = LanguageFeature.Coroutines;
        } else if (Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.FIELD_KEYWORD)) {
            if (!this.isExplicitBackingFieldDeclaration(position)) {
                return true;
            }
            languageFeature = LanguageFeature.ExplicitBackingFields;
        } else if (Intrinsics.areEqual((Object)ktKeywordToken, (Object)KtTokens.CONTEXT_KEYWORD)) {
            languageFeature = LanguageFeature.ContextReceivers;
        } else {
            return true;
        }
        LanguageFeature feature = languageFeature;
        return languageVersionSettings.supportsFeature(feature);
    }

    private final boolean isModifierTargetSupportedAtLanguageLevel(KtKeywordToken keyword, KotlinTarget target, LanguageVersionSettings languageVersionSettings) {
        if (Intrinsics.areEqual((Object)keyword, (Object)KtTokens.LATEINIT_KEYWORD)) {
            LanguageFeature languageFeature;
            switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
                case 3: {
                    languageFeature = LanguageFeature.LateinitTopLevelProperties;
                    break;
                }
                case 4: {
                    languageFeature = LanguageFeature.LateinitLocalVariables;
                    break;
                }
                default: {
                    return true;
                }
            }
            LanguageFeature feature = languageFeature;
            return languageVersionSettings.supportsFeature(feature);
        }
        return true;
    }

    private final void buildReducedContextBefore(StringBuilder builder2, PsiElement position, PsiElement scope) {
        Object v2;
        PsiElement parent2;
        block10: {
            if (Intrinsics.areEqual((Object)position, (Object)scope)) {
                return;
            }
            if (position instanceof KtCodeFragment) {
                PsiElement psiElement = ((KtCodeFragment)position).getContext();
                KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
                if (ktElement == null) {
                    return;
                }
                KtElement ktContext = ktElement;
                this.buildReducedContextBefore(builder2, (PsiElement)ktContext, scope);
                return;
            }
            if (position instanceof PsiFile) {
                return;
            }
            PsiElement psiElement = position.getParent();
            if (psiElement == null) {
                return;
            }
            parent2 = psiElement;
            this.buildReducedContextBefore(builder2, parent2, scope);
            Sequence $this$firstOrNull$iv = PsiUtilsKt.siblings((PsiElement)position, (boolean)false, (boolean)false);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof KtDeclaration)) continue;
                v2 = element$iv;
                break block10;
            }
            v2 = null;
        }
        PsiElement prevDeclaration = v2;
        PsiElement child = parent2.getFirstChild();
        while (!Intrinsics.areEqual((Object)child, (Object)position)) {
            if (child instanceof KtDeclaration) {
                if (Intrinsics.areEqual((Object)child, (Object)prevDeclaration)) {
                    this.appendReducedText(builder2, child);
                }
            } else {
                PsiElement psiElement = child;
                Intrinsics.checkNotNull((Object)psiElement);
                builder2.append(psiElement.getText());
            }
            child = child.getNextSibling();
        }
    }

    private final void appendReducedText(StringBuilder $this$appendReducedText, PsiElement element) {
        PsiElement child = element.getFirstChild();
        if (child == null) {
            String string = element.getText();
            Intrinsics.checkNotNull((Object)string);
            $this$appendReducedText.append(string);
        } else {
            while (child != null) {
                PsiElement psiElement = child;
                if (psiElement instanceof KtBlockExpression || psiElement instanceof KtClassBody) {
                    $this$appendReducedText.append("{}");
                } else {
                    this.appendReducedText($this$appendReducedText, child);
                }
                child = child.getNextSibling();
            }
        }
    }

    private final int getStartOffsetInAncestor(PsiElement $this$getStartOffsetInAncestor, PsiElement ancestor) {
        if (Intrinsics.areEqual((Object)ancestor, (Object)$this$getStartOffsetInAncestor)) {
            return 0;
        }
        PsiElement psiElement = $this$getStartOffsetInAncestor.getParent();
        Intrinsics.checkNotNull((Object)psiElement);
        return this.getStartOffsetInAncestor(psiElement, ancestor) + $this$getStartOffsetInAncestor.getStartOffsetInParent();
    }

    private final Sequence<PsiElement> goUpWhileIsLastChild(PsiElement $this$goUpWhileIsLastChild) {
        return SequencesKt.generateSequence((Object)$this$goUpWhileIsLastChild, KeywordCompletion::goUpWhileIsLastChild$lambda$20);
    }

    private final boolean isPossibleParentTarget(KtModifierKeywordToken modifier, KotlinTarget parentTarget, LanguageVersionSettings languageVersionSettings) {
        TargetAllowedPredicate targetAllowedPredicate;
        Set it;
        Set set = (Set)ModifierCheckerHelpersKt.getDeprecatedParentTargetMap().get(modifier);
        if (set != null) {
            it = set;
            boolean bl = false;
            if (it.contains(parentTarget)) {
                return false;
            }
        }
        if ((targetAllowedPredicate = (TargetAllowedPredicate)ModifierCheckerHelpersKt.getPossibleParentTargetPredicateMap().get(modifier)) != null) {
            it = targetAllowedPredicate;
            boolean bl = false;
            return it.isAllowed(parentTarget, languageVersionSettings);
        }
        return true;
    }

    private final boolean isExplicitBackingFieldDeclaration(PsiElement $this$isExplicitBackingFieldDeclaration) {
        return $this$isExplicitBackingFieldDeclaration.getParent() instanceof KtBackingField;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean handleCompoundKeyword$isSpace(PsiElement $this$handleCompoundKeyword_u24isSpace) {
        if (!($this$handleCompoundKeyword_u24isSpace instanceof PsiWhiteSpace)) return false;
        String string = $this$handleCompoundKeyword_u24isSpace.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.contains$default((CharSequence)string, (char)'\n', (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final boolean handleCompoundKeyword$lambda$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !KeywordCompletion.handleCompoundKeyword$isSpace(it) && !Intrinsics.areEqual((Object)it.getText(), (Object)"$");
    }

    private static final boolean handleCompoundKeyword$lambda$2(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !KeywordCompletion.handleCompoundKeyword$isSpace(it) && !(it instanceof PsiErrorElement);
    }

    private static final void handleTopLevelClassName$consumeClassNameWithoutBraces(Function1<? super LookupElement, Unit> $consumer, KeywordCompletion this$0, String $keyword, String topLevelClassName, PsiElement $position) {
        $consumer.invoke((Object)this$0.createLookupElementBuilder($keyword + " " + topLevelClassName, $position));
    }

    private static final boolean buildFilter$lambda$7(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment) && !(it instanceof PsiErrorElement);
    }

    private static final boolean buildFilter$lambda$9(Ref.ObjectRef $prevParent, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)$prevParent.element);
    }

    private static final CharSequence buildFilter$lambda$10(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final KtFile buildFilesWithKeywordApplication$lambda$11(KtPsiFactory $psiFactory, String $prefixText, String application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        return $psiFactory.createFile($prefixText + application);
    }

    private static final boolean buildFilterByText$isSecondaryConstructorInObjectDeclaration(PsiElement $this$buildFilterByText_u24isSecondaryConstructorInObjectDeclaration) {
        PsiElement $this$parentOfType_u24default$iv = $this$buildFilterByText_u24isSecondaryConstructorInObjectDeclaration;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtSecondaryConstructor ktSecondaryConstructor = (KtSecondaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtSecondaryConstructor.class, (boolean)true);
        if (ktSecondaryConstructor == null) {
            return false;
        }
        KtSecondaryConstructor secondaryConstructor = ktSecondaryConstructor;
        return secondaryConstructor.getContainingClassOrObject() instanceof KtObjectDeclaration;
    }

    private static final boolean buildFilterByText$isKeywordCorrectlyApplied$lambda$13(KeywordCompletion this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PsiWhiteSpace || this$0.isSemicolon(it);
    }

    /*
     * Unable to fully structure code
     */
    private static final boolean buildFilterByText$isKeywordCorrectlyApplied(String $prefixText, PsiElement $position, KeywordCompletion this$0, KtKeywordToken keywordTokenType, KtFile file) {
        block49: {
            block48: {
                block47: {
                    v0 = file.findElementAt($prefixText.length());
                    Intrinsics.checkNotNull((Object)v0);
                    elementAt = v0;
                    v1 = ModuleUtilCore.findModuleForPsiElement((PsiElement)$position);
                    if (v1 == null) break block47;
                    var9_6 = v1;
                    var10_7 = this$0.languageVersionSettingProvider;
                    p0 = var9_6;
                    $i$a$-let-KeywordCompletion$buildFilterByText$isKeywordCorrectlyApplied$languageVersionSettings$1 = false;
                    v2 = var10_7.getLanguageVersionSetting(p0);
                    v1 = v2;
                    if (v2 != null) break block48;
                }
                v1 = (LanguageVersionSettings)LanguageVersionSettingsImpl.DEFAULT;
            }
            languageVersionSettings = v1;
            v3 = elementAt.getNode();
            Intrinsics.checkNotNull((Object)v3);
            v4 = v3.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getElementType(...)");
            if (!this$0.matchesKeyword(v4, keywordTokenType)) {
                return false;
            }
            $this$getNonStrictParentOfType$iv = elementAt;
            $i$f$getNonStrictParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, PsiErrorElement.class, (boolean)false) != null) {
                return false;
            }
            if (this$0.isErrorElementBefore((PsiElement)elementAt)) {
                return false;
            }
            if (!this$0.isModifierSupportedAtLanguageLevel((PsiElement)elementAt, keywordTokenType, (LanguageVersionSettings)languageVersionSettings)) {
                return false;
            }
            if ((Intrinsics.areEqual((Object)keywordTokenType, (Object)KtTokens.VAL_KEYWORD) || Intrinsics.areEqual((Object)keywordTokenType, (Object)KtTokens.VAR_KEYWORD)) && elementAt.getParent() instanceof KtParameter && PsiTreeUtilKt.parentOfTypes$default((PsiElement)elementAt, (KClass[])($this$getNonStrictParentOfType$iv = new KClass[]{Reflection.getOrCreateKotlinClass(KtNamedFunction.class), Reflection.getOrCreateKotlinClass(KtSecondaryConstructor.class)}), (boolean)false, (int)2, null) != null) {
                return false;
            }
            if (Intrinsics.areEqual((Object)keywordTokenType, (Object)KtTokens.CONSTRUCTOR_KEYWORD) && KeywordCompletion.buildFilterByText$isSecondaryConstructorInObjectDeclaration((PsiElement)elementAt)) {
                return false;
            }
            if (!(keywordTokenType instanceof KtModifierKeywordToken)) {
                return true;
            }
            var9_6 = elementAt.getParent();
            v5 = var9_6 instanceof KtModifierList != false ? (KtModifierList)var9_6 : null;
            if (v5 == null || (v5 = v5.getParent()) == null) {
                return true;
            }
            container = v5;
            var9_6 = container;
            if (var9_6 instanceof KtParameter) {
                if (((KtParameter)container).getOwnerFunction() instanceof KtPrimaryConstructor) {
                    var10_7 = new KotlinTarget[]{KotlinTarget.VALUE_PARAMETER, KotlinTarget.MEMBER_PROPERTY};
                    v6 = CollectionsKt.listOf((Object[])var10_7);
                } else {
                    v6 = CollectionsKt.listOf((Object)KotlinTarget.VALUE_PARAMETER);
                }
            } else if (var9_6 instanceof KtTypeParameter) {
                v6 = CollectionsKt.listOf((Object)KotlinTarget.TYPE_PARAMETER);
            } else if (var9_6 instanceof KtEnumEntry) {
                v6 = CollectionsKt.listOf((Object)KotlinTarget.ENUM_ENTRY);
            } else if (var9_6 instanceof KtClassBody) {
                var10_7 = new KotlinTarget[]{KotlinTarget.CLASS_ONLY, KotlinTarget.INTERFACE, KotlinTarget.OBJECT, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.MEMBER_FUNCTION, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.FUNCTION, KotlinTarget.PROPERTY};
                v6 = CollectionsKt.listOf((Object[])var10_7);
            } else if (var9_6 instanceof KtFile) {
                var10_7 = new KotlinTarget[]{KotlinTarget.CLASS_ONLY, KotlinTarget.INTERFACE, KotlinTarget.OBJECT, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.TOP_LEVEL_FUNCTION, KotlinTarget.TOP_LEVEL_PROPERTY, KotlinTarget.FUNCTION, KotlinTarget.PROPERTY};
                v6 = CollectionsKt.listOf((Object[])var10_7);
            } else {
                v6 = CollectionsKt.emptyList();
            }
            possibleTargets = v6;
            v7 = (Set)ModifierCheckerHelpersKt.getPossibleTargetMap().get(keywordTokenType);
            v8 = modifierTargets = v7 != null ? CollectionsKt.intersect((Iterable)v7, (Iterable)possibleTargets) : null;
            if (modifierTargets != null && ((Collection)possibleTargets).isEmpty() == false) {
                block46: {
                    $this$none$iv = modifierTargets;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        v9 = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            it = (KotlinTarget)element$iv;
                            $i$a$-none-KeywordCompletion$buildFilterByText$isKeywordCorrectlyApplied$1 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!this$0.isModifierTargetSupportedAtLanguageLevel(keywordTokenType, it, (LanguageVersionSettings)languageVersionSettings)) continue;
                            v9 = false;
                            break block46;
                        }
                        v9 = true;
                    }
                }
                if (v9) {
                    return false;
                }
            }
            $i$a$-let-KeywordCompletion$buildFilterByText$isKeywordCorrectlyApplied$languageVersionSettings$1 = container;
            strict$iv = true;
            $i$f$getParentOfType = false;
            ownerDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDeclaration.class, (boolean)strict$iv);
            if (ownerDeclaration == null) {
                v10 = KotlinTarget.FILE;
            } else if (ownerDeclaration instanceof KtClass) {
                v10 = ((KtClass)ownerDeclaration).isInterface() ? KotlinTarget.INTERFACE : (((KtClass)ownerDeclaration).isEnum() ? KotlinTarget.ENUM_CLASS : (((KtClass)ownerDeclaration).isAnnotation() ? KotlinTarget.ANNOTATION_CLASS : KotlinTarget.CLASS_ONLY));
            } else if (ownerDeclaration instanceof KtObjectDeclaration) {
                v10 = ((KtObjectDeclaration)ownerDeclaration).isObjectLiteral() ? KotlinTarget.OBJECT_LITERAL : KotlinTarget.OBJECT;
            } else {
                return Intrinsics.areEqual((Object)keywordTokenType, (Object)KtTokens.CONST_KEYWORD) == false;
            }
            parentTarget = v10;
            if (!this$0.isPossibleParentTarget((KtModifierKeywordToken)keywordTokenType, parentTarget, (LanguageVersionSettings)languageVersionSettings)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)keywordTokenType, (Object)KtTokens.CONST_KEYWORD)) break block49;
            switch (WhenMappings.$EnumSwitchMapping$0[parentTarget.ordinal()]) {
                case 1: {
                    v11 = true;
                    break;
                }
                case 2: {
                    v12 = elementAt.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getParent(...)");
                    prevSiblings = PsiUtilsKt.siblings((PsiElement)v12, (boolean)false, (boolean)false);
                    $i$a$-none-KeywordCompletion$buildFilterByText$isKeywordCorrectlyApplied$1 = SequencesKt.takeWhile((Sequence)prevSiblings, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, buildFilterByText$isKeywordCorrectlyApplied$lambda$13(org.jetbrains.kotlin.idea.completion.KeywordCompletion com.intellij.psi.PsiElement ), (Lcom/intellij/psi/PsiElement;)Ljava/lang/Boolean;)((KeywordCompletion)this$0));
                    $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        it = (PsiElement)element$iv;
                        $i$a$-firstOrNull-KeywordCompletion$buildFilterByText$isKeywordCorrectlyApplied$hasLineBreak$2 = false;
                        v13 = it.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"getText(...)");
                        if (!(StringsKt.contains$default((CharSequence)v13, (CharSequence)"\n", (boolean)false, (int)2, null) != false || this$0.isSemicolon(it) != false)) continue;
                        v14 = element$iv;
                        ** GOTO lbl126
                    }
                    v14 = null;
lbl126:
                    // 2 sources

                    v15 = hasLineBreak = v14 != null;
                    if (hasLineBreak) ** GOTO lbl138
                    $this$none$iv = prevSiblings;
                    $i$f$none = false;
                    for (E element$iv : $this$none$iv) {
                        it = (PsiElement)element$iv;
                        $i$a$-none-KeywordCompletion$buildFilterByText$isKeywordCorrectlyApplied$2 = false;
                        if (!(it instanceof PsiWhiteSpace == false && this$0.isSemicolon(it) == false && it instanceof KtImportList == false && it instanceof KtPackageDirective == false)) continue;
                        v16 = false;
                        ** GOTO lbl137
                    }
                    v16 = true;
lbl137:
                    // 2 sources

                    if (!v16) ** GOTO lbl140
lbl138:
                    // 2 sources

                    v11 = true;
                    break;
lbl140:
                    // 1 sources

                    v11 = false;
                    break;
                }
                default: {
                    v11 = false;
                }
            }
            return v11;
        }
        return true;
    }

    private static final boolean buildFilterByText$lambda$17(KeywordCompletion this$0, String $prefixText, KtPsiFactory psiFactory, PsiElement $position, KtKeywordToken keywordTokenType) {
        boolean bl;
        block1: {
            Sequence<KtFile> files;
            Sequence<KtFile> $this$any$iv = files = this$0.buildFilesWithKeywordApplication(keywordTokenType, $prefixText, psiFactory);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                KtFile file = (KtFile)element$iv;
                boolean bl2 = false;
                if (!KeywordCompletion.buildFilterByText$isKeywordCorrectlyApplied($prefixText, $position, this$0, keywordTokenType, file)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final PsiElement goUpWhileIsLastChild$lambda$20(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof PsiFile ? null : (!Intrinsics.areEqual((Object)it, (Object)it.getParent().getLastChild()) ? null : it.getParent());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_7;
        void $this$mapTo$iv$iv;
        Object[] $this$mapTo$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Companion = new Companion(null);
        IElementType[] iElementTypeArray = KtTokens.KEYWORDS.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"getTypes(...)");
        Object[] objectArray = iElementTypeArray;
        IElementType[] iElementTypeArray2 = KtTokens.SOFT_KEYWORDS.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray2, (String)"getTypes(...)");
        Object $this$map$iv = ArraysKt.plus((Object[])objectArray, (Object[])iElementTypeArray2);
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
        boolean bl = false;
        for (KtKeywordToken item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            IElementType iElementType = (IElementType)item$iv$iv2;
            object = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtKeywordToken");
            object.add((KtKeywordToken)it);
        }
        ALL_KEYWORDS = (List)destination$iv$iv;
        $this$map$iv = new KtModifierKeywordToken[]{KtTokens.SEALED_KEYWORD, KtTokens.ANNOTATION_KEYWORD, KtTokens.DATA_KEYWORD, KtTokens.ENUM_KEYWORD, KtTokens.OPEN_KEYWORD, KtTokens.INNER_KEYWORD, KtTokens.ABSTRACT_KEYWORD};
        $this$map$iv = SetsKt.setOf((Object[])$this$map$iv);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo232 = false;
        for (Object e : $this$mapTo$iv) {
            void it;
            KtModifierKeywordToken ktModifierKeywordToken = (KtModifierKeywordToken)e;
            object = destination$iv;
            boolean bl3 = false;
            object.add(it.getValue());
        }
        INCOMPATIBLE_KEYWORDS_AROUND_SEALED = (HashSet)destination$iv;
        $this$mapTo$iv = new KtKeywordToken[]{KtTokens.IF_KEYWORD, KtTokens.ELSE_KEYWORD, KtTokens.TRUE_KEYWORD, KtTokens.FALSE_KEYWORD, KtTokens.WHEN_KEYWORD};
        KEYWORDS_ALLOWED_INSIDE_ANNOTATION_ENTRY = SetsKt.setOf((Object[])$this$mapTo$iv);
        COMPOUND_KEYWORDS_NOT_SUGGEST_TOGETHER = MapsKt.mapOf((Pair)TuplesKt.to((Object)KtTokens.SEALED_KEYWORD, (Object)SetsKt.setOf((Object)KtTokens.FUN_KEYWORD)));
        $this$mapTo$iv = new Pair[]{TuplesKt.to((Object)KtTokens.IF_KEYWORD, (Object)"fun foo() { if (caret)"), TuplesKt.to((Object)KtTokens.WHILE_KEYWORD, (Object)"fun foo() { while(caret)"), TuplesKt.to((Object)KtTokens.FOR_KEYWORD, (Object)"fun foo() { for(caret)"), TuplesKt.to((Object)KtTokens.TRY_KEYWORD, (Object)"fun foo() { try {\ncaret\n}"), TuplesKt.to((Object)KtTokens.CATCH_KEYWORD, (Object)"fun foo() { try {} catch (caret)"), TuplesKt.to((Object)KtTokens.FINALLY_KEYWORD, (Object)"fun foo() { try {\n}\nfinally{\ncaret\n}"), TuplesKt.to((Object)KtTokens.DO_KEYWORD, (Object)"fun foo() { do {\ncaret\n}"), TuplesKt.to((Object)KtTokens.INIT_KEYWORD, (Object)"class C { init {\ncaret\n}"), TuplesKt.to((Object)KtTokens.CONSTRUCTOR_KEYWORD, (Object)"class C { constructor(caret)"), TuplesKt.to((Object)KtTokens.CONTEXT_KEYWORD, (Object)"context(caret)")};
        KEYWORD_CONSTRUCTS = MapsKt.mapOf((Pair[])$this$mapTo$iv);
        $this$mapTo$iv = new KtKeywordToken[]{KtTokens.THIS_KEYWORD, KtTokens.SUPER_KEYWORD, KtTokens.NULL_KEYWORD, KtTokens.TRUE_KEYWORD, KtTokens.FALSE_KEYWORD, KtTokens.BREAK_KEYWORD, KtTokens.CONTINUE_KEYWORD, KtTokens.ELSE_KEYWORD, KtTokens.WHEN_KEYWORD, KtTokens.FILE_KEYWORD, KtTokens.DYNAMIC_KEYWORD, KtTokens.GET_KEYWORD, KtTokens.SET_KEYWORD};
        $this$map$iv = CollectionsKt.listOf((Object[])$this$mapTo$iv);
        $i$f$map = false;
        Object $i$f$mapTo232 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean bl4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtKeywordToken item$iv$iv2;
            item$iv$iv2 = (KtKeywordToken)item$iv$iv;
            object = destination$iv$iv;
            boolean bl5 = false;
            object.add(it.getValue());
        }
        NO_SPACE_AFTER = CollectionsKt.plus((Collection)((List)var3_7), (Object)"companion object");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\n\u001a\u00020\u00052\u0010\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$CommentFilter;", "Lcom/intellij/psi/filters/ElementFilter;", "<init>", "()V", "isAcceptable", "", "element", "", "context", "Lcom/intellij/psi/PsiElement;", "isClassAcceptable", "hintClass", "Ljava/lang/Class;", "kotlin.completion.impl.shared"})
    private static final class CommentFilter
    implements ElementFilter {
        public boolean isAcceptable(@Nullable Object element, @Nullable PsiElement context) {
            return element instanceof PsiElement && KtPsiUtil.isInComment((PsiElement)((PsiElement)element));
        }

        public boolean isClassAcceptable(@NotNull Class<? extends Object> hintClass) {
            Intrinsics.checkNotNullParameter(hintClass, (String)"hintClass");
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u0011\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n0\bj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\r0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0015\u001a\r\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$Companion;", "", "<init>", "()V", "ALL_KEYWORDS", "", "Lorg/jetbrains/kotlin/lexer/KtKeywordToken;", "INCOMPATIBLE_KEYWORDS_AROUND_SEALED", "Ljava/util/HashSet;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lkotlin/collections/HashSet;", "KEYWORDS_ALLOWED_INSIDE_ANNOTATION_ENTRY", "", "getCompoundKeywords", "token", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "COMPOUND_KEYWORDS_NOT_SUGGEST_TOGETHER", "", "KEYWORD_CONSTRUCTS", "NO_SPACE_AFTER", "kotlin.completion.impl.shared"})
    @SourceDebugExtension(value={"SMAP\nKeywordCompletion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeywordCompletion.kt\norg/jetbrains/kotlin/idea/completion/KeywordCompletion$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,777:1\n1#2:778\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<KtKeywordToken> getCompoundKeywords(KtKeywordToken token, LanguageVersionSettings languageVersionSettings) {
            KtKeywordToken ktKeywordToken;
            Pair[] pairArray = new Pair[8];
            pairArray[0] = TuplesKt.to((Object)KtTokens.COMPANION_KEYWORD, (Object)SetsKt.setOf((Object)KtTokens.OBJECT_KEYWORD));
            Object[] objectArray = new KtKeywordToken[2];
            objectArray[0] = KtTokens.CLASS_KEYWORD;
            KtKeywordToken ktKeywordToken2 = ktKeywordToken = KtTokens.OBJECT_KEYWORD;
            int n = 1;
            Object[] objectArray2 = objectArray;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.DATA_KEYWORD;
            int n2 = 1;
            Pair[] pairArray2 = pairArray;
            boolean bl = false;
            boolean bl2 = languageVersionSettings.supportsFeature(LanguageFeature.DataObjects);
            objectArray2[n] = bl2 ? ktKeywordToken : null;
            pairArray2[n2] = TuplesKt.to((Object)ktModifierKeywordToken, (Object)SetsKt.setOfNotNull((Object[])objectArray));
            pairArray[2] = TuplesKt.to((Object)KtTokens.ENUM_KEYWORD, (Object)SetsKt.setOf((Object)KtTokens.CLASS_KEYWORD));
            pairArray[3] = TuplesKt.to((Object)KtTokens.ANNOTATION_KEYWORD, (Object)SetsKt.setOf((Object)KtTokens.CLASS_KEYWORD));
            objectArray = new KtKeywordToken[]{KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD, KtTokens.FUN_KEYWORD};
            pairArray[4] = TuplesKt.to((Object)KtTokens.SEALED_KEYWORD, (Object)SetsKt.setOf((Object[])objectArray));
            pairArray[5] = TuplesKt.to((Object)KtTokens.LATEINIT_KEYWORD, (Object)SetsKt.setOf((Object)KtTokens.VAR_KEYWORD));
            pairArray[6] = TuplesKt.to((Object)KtTokens.CONST_KEYWORD, (Object)SetsKt.setOf((Object)KtTokens.VAL_KEYWORD));
            pairArray[7] = TuplesKt.to((Object)KtTokens.SUSPEND_KEYWORD, (Object)SetsKt.setOf((Object)KtTokens.FUN_KEYWORD));
            return (Set)MapsKt.mapOf((Pair[])pairArray).get(token);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$FileFilter;", "Lcom/intellij/psi/filters/position/PositionElementFilter;", "filter", "Lcom/intellij/psi/filters/ElementFilter;", "<init>", "(Lcom/intellij/psi/filters/ElementFilter;)V", "isAcceptable", "", "element", "", "context", "Lcom/intellij/psi/PsiElement;", "kotlin.completion.impl.shared"})
    private static final class FileFilter
    extends PositionElementFilter {
        public FileFilter(@NotNull ElementFilter filter2) {
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            this.setFilter(filter2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isAcceptable(@Nullable Object element, @Nullable PsiElement context) {
            if (!(element instanceof PsiElement)) return false;
            PsiElement psiElement = (PsiElement)element;
            if (psiElement == null) return false;
            PsiFile psiFile = psiElement.getContainingFile();
            PsiFile file = psiFile;
            if (file == null) return false;
            ElementFilter elementFilter = this.getFilter();
            if (elementFilter == null) return true;
            boolean bl = elementFilter.isAcceptable((Object)file, context);
            if (!bl) return false;
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$LanguageVersionSettingProvider;", "", "getLanguageVersionSetting", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "element", "Lcom/intellij/psi/PsiElement;", "module", "Lcom/intellij/openapi/module/Module;", "kotlin.completion.impl.shared"})
    public static interface LanguageVersionSettingProvider {
        @NotNull
        public LanguageVersionSettings getLanguageVersionSetting(@NotNull PsiElement var1);

        @NotNull
        public LanguageVersionSettings getLanguageVersionSetting(@NotNull Module var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$ParentFilter;", "Lcom/intellij/psi/filters/position/PositionElementFilter;", "filter", "Lcom/intellij/psi/filters/ElementFilter;", "<init>", "(Lcom/intellij/psi/filters/ElementFilter;)V", "isAcceptable", "", "element", "", "context", "Lcom/intellij/psi/PsiElement;", "kotlin.completion.impl.shared"})
    private static final class ParentFilter
    extends PositionElementFilter {
        public ParentFilter(@NotNull ElementFilter filter2) {
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            this.setFilter(filter2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isAcceptable(@Nullable Object element, @Nullable PsiElement context) {
            if (!(element instanceof PsiElement)) return false;
            PsiElement psiElement = (PsiElement)element;
            if (psiElement == null) return false;
            PsiElement psiElement2 = psiElement.getParent();
            PsiElement parent2 = psiElement2;
            if (parent2 == null) return false;
            ElementFilter elementFilter = this.getFilter();
            if (elementFilter == null) return true;
            boolean bl = elementFilter.isAcceptable((Object)parent2, context);
            if (!bl) return false;
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$SpaceAfterInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "kotlin.completion.impl.shared"})
    private static final class SpaceAfterInsertHandler
    implements InsertHandler<LookupElement> {
        @NotNull
        public static final SpaceAfterInsertHandler INSTANCE = new SpaceAfterInsertHandler();

        private SpaceAfterInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            WithTailInsertHandler.Companion.getSPACE().postHandleInsert(context, item);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$UseSiteAnnotationTargetInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "kotlin.completion.impl.shared"})
    private static final class UseSiteAnnotationTargetInsertHandler
    implements InsertHandler<LookupElement> {
        @NotNull
        public static final UseSiteAnnotationTargetInsertHandler INSTANCE = new UseSiteAnnotationTargetInsertHandler();

        private UseSiteAnnotationTargetInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            new WithTailInsertHandler(":", false, false, false, 8, null).postHandleInsert(context, item);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinTarget.values().length];
            try {
                nArray[KotlinTarget.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinTarget.FILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinTarget.TOP_LEVEL_PROPERTY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinTarget.LOCAL_VARIABLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

