/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.KotlinCallableInsertHandler;
import org.jetbrains.kotlin.idea.util.CallType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinPropertyInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinCallableInsertHandler;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "<init>", "(Lorg/jetbrains/kotlin/idea/util/CallType;)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "deleteEmptyParenthesis", "kotlin.completion.impl.k1"})
public final class KotlinPropertyInsertHandler
extends KotlinCallableInsertHandler {
    public KotlinPropertyInsertHandler(@NotNull CallType<?> callType) {
        Intrinsics.checkNotNullParameter(callType, (String)"callType");
        super(callType);
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        boolean surroundedWithBraces = HandlerUtilsKt.surroundWithBracesIfInStringTemplate(context);
        super.handleInsert(context, item);
        if (context.getCompletionChar() == '\t') {
            this.deleteEmptyParenthesis(context);
        }
        if (surroundedWithBraces) {
            HandlerUtilsKt.removeRedundantBracesInStringTemplate(context);
        }
    }

    private final void deleteEmptyParenthesis(InsertionContext context) {
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
        psiDocumentManager.commitDocument(context.getDocument());
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(context.getDocument());
        int offset = context.getTailOffset();
        Document document = context.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence chars = charSequence;
        Integer n = HandlerUtilsKt.indexOfSkippingSpace(chars, '(', offset);
        if (n == null) {
            return;
        }
        int lParenOffset = n;
        Integer n2 = HandlerUtilsKt.indexOfSkippingSpace(chars, ')', lParenOffset + 1);
        if (n2 == null) {
            return;
        }
        int rParenOffset = n2;
        document2.deleteString(offset, rParenOffset + 1);
    }
}

