/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.lookups.factories;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaFunctionType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.completion.lookups.factories.FunctionLookupElementFactoryKt;
import org.jetbrains.kotlin.name.Name;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0002\n\u000bJ\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\f\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/completion/lookups/factories/TrailingFunctionDescriptor;", "", "functionType", "Lorg/jetbrains/kotlin/analysis/api/types/KaFunctionType;", "getFunctionType", "()Lorg/jetbrains/kotlin/analysis/api/types/KaFunctionType;", "suggestParameterNameAt", "Lorg/jetbrains/kotlin/name/Name;", "index", "", "Function", "SamConstructor", "Lorg/jetbrains/kotlin/idea/completion/lookups/factories/TrailingFunctionDescriptor$Function;", "Lorg/jetbrains/kotlin/idea/completion/lookups/factories/TrailingFunctionDescriptor$SamConstructor;", "kotlin.completion.impl.k2"})
public interface TrailingFunctionDescriptor {
    @NotNull
    public KaFunctionType getFunctionType();

    @Nullable
    public Name suggestParameterNameAt(int var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/completion/lookups/factories/TrailingFunctionDescriptor$Function;", "Lorg/jetbrains/kotlin/idea/completion/lookups/factories/TrailingFunctionDescriptor;", "functionType", "Lorg/jetbrains/kotlin/analysis/api/types/KaFunctionType;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/types/KaFunctionType;)V", "getFunctionType", "()Lorg/jetbrains/kotlin/analysis/api/types/KaFunctionType;", "suggestParameterNameAt", "Lorg/jetbrains/kotlin/name/Name;", "index", "", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "kotlin.completion.impl.k2"})
    public static final class Function
    implements TrailingFunctionDescriptor {
        @NotNull
        private final KaFunctionType functionType;

        public Function(@NotNull KaFunctionType functionType) {
            Intrinsics.checkNotNullParameter((Object)functionType, (String)"functionType");
            this.functionType = functionType;
        }

        @Override
        @NotNull
        public KaFunctionType getFunctionType() {
            return this.functionType;
        }

        @Override
        @Nullable
        public Name suggestParameterNameAt(int index2) {
            KaType kaType = (KaType)CollectionsKt.getOrNull(this.getFunctionType().getParameterTypes(), (int)index2);
            return kaType != null ? FunctionLookupElementFactoryKt.access$extractParameterName(kaType) : null;
        }

        @NotNull
        public final KaFunctionType component1() {
            return this.functionType;
        }

        @NotNull
        public final Function copy(@NotNull KaFunctionType functionType) {
            Intrinsics.checkNotNullParameter((Object)functionType, (String)"functionType");
            return new Function(functionType);
        }

        public static /* synthetic */ Function copy$default(Function function, KaFunctionType kaFunctionType, int n, Object object) {
            if ((n & 1) != 0) {
                kaFunctionType = function.functionType;
            }
            return function.copy(kaFunctionType);
        }

        @NotNull
        public String toString() {
            return "Function(functionType=" + this.functionType + ")";
        }

        public int hashCode() {
            return this.functionType.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Function)) {
                return false;
            }
            Function function = (Function)other;
            return Intrinsics.areEqual((Object)this.functionType, (Object)function.functionType);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/completion/lookups/factories/TrailingFunctionDescriptor$SamConstructor;", "Lorg/jetbrains/kotlin/idea/completion/lookups/factories/TrailingFunctionDescriptor;", "functionType", "Lorg/jetbrains/kotlin/analysis/api/types/KaFunctionType;", "samSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/types/KaFunctionType;Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol;)V", "getFunctionType", "()Lorg/jetbrains/kotlin/analysis/api/types/KaFunctionType;", "getSamSymbol", "()Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol;", "suggestParameterNameAt", "Lorg/jetbrains/kotlin/name/Name;", "index", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "kotlin.completion.impl.k2"})
    public static final class SamConstructor
    implements TrailingFunctionDescriptor {
        @NotNull
        private final KaFunctionType functionType;
        @NotNull
        private final KaNamedFunctionSymbol samSymbol;

        public SamConstructor(@NotNull KaFunctionType functionType, @NotNull KaNamedFunctionSymbol samSymbol) {
            Intrinsics.checkNotNullParameter((Object)functionType, (String)"functionType");
            Intrinsics.checkNotNullParameter((Object)samSymbol, (String)"samSymbol");
            this.functionType = functionType;
            this.samSymbol = samSymbol;
        }

        @Override
        @NotNull
        public KaFunctionType getFunctionType() {
            return this.functionType;
        }

        @NotNull
        public final KaNamedFunctionSymbol getSamSymbol() {
            return this.samSymbol;
        }

        @Override
        @Nullable
        public Name suggestParameterNameAt(int index2) {
            KaValueParameterSymbol kaValueParameterSymbol = (KaValueParameterSymbol)CollectionsKt.getOrNull(this.samSymbol.getValueParameters(), (int)index2);
            return kaValueParameterSymbol != null ? kaValueParameterSymbol.getName() : null;
        }

        @NotNull
        public final KaFunctionType component1() {
            return this.functionType;
        }

        @NotNull
        public final KaNamedFunctionSymbol component2() {
            return this.samSymbol;
        }

        @NotNull
        public final SamConstructor copy(@NotNull KaFunctionType functionType, @NotNull KaNamedFunctionSymbol samSymbol) {
            Intrinsics.checkNotNullParameter((Object)functionType, (String)"functionType");
            Intrinsics.checkNotNullParameter((Object)samSymbol, (String)"samSymbol");
            return new SamConstructor(functionType, samSymbol);
        }

        public static /* synthetic */ SamConstructor copy$default(SamConstructor samConstructor, KaFunctionType kaFunctionType, KaNamedFunctionSymbol kaNamedFunctionSymbol, int n, Object object) {
            if ((n & 1) != 0) {
                kaFunctionType = samConstructor.functionType;
            }
            if ((n & 2) != 0) {
                kaNamedFunctionSymbol = samConstructor.samSymbol;
            }
            return samConstructor.copy(kaFunctionType, kaNamedFunctionSymbol);
        }

        @NotNull
        public String toString() {
            return "SamConstructor(functionType=" + this.functionType + ", samSymbol=" + this.samSymbol + ")";
        }

        public int hashCode() {
            int result2 = this.functionType.hashCode();
            result2 = result2 * 31 + this.samSymbol.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SamConstructor)) {
                return false;
            }
            SamConstructor samConstructor = (SamConstructor)other;
            if (!Intrinsics.areEqual((Object)this.functionType, (Object)samConstructor.functionType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.samSymbol, (Object)samConstructor.samSymbol);
        }
    }
}

