/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptDiagnostic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.IdeScriptReportSinkKt;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.configuration.DefaultScriptingSupport;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptConfigurationsProvider;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007j\u0004\u0018\u0001`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/IdeScriptDependenciesProvider;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptConfigurationsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getScriptConfigurationResult", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationResult;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getScriptConfiguration", "kotlin.base.scripting"})
public final class IdeScriptDependenciesProvider
extends ScriptConfigurationsProvider {
    public IdeScriptDependenciesProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @Nullable
    public ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> getScriptConfigurationResult(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ScriptCompilationConfigurationWrapper configuration2 = this.getScriptConfiguration(file);
        List<ScriptDiagnostic> reports = IdeScriptReportSinkKt.getScriptReports(file);
        if (configuration2 == null && !((Collection)reports).isEmpty()) {
            return ErrorHandlingKt.makeFailureResult(reports);
        }
        ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = configuration2;
        return scriptCompilationConfigurationWrapper != null ? ErrorHandlingKt.asSuccess(scriptCompilationConfigurationWrapper, reports) : null;
    }

    @Override
    @Nullable
    public ScriptCompilationConfigurationWrapper getScriptConfiguration(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return DefaultScriptingSupport.Companion.getInstance(this.getProject()).isLoadedFromCache(file) || !ScratchUtil.isScratch((VirtualFile)file.getVirtualFile()) ? ScriptConfigurationManager.Companion.getInstance(this.getProject()).getConfiguration(file) : null;
    }
}

