/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.SdkDependency;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.KotlinScriptEntitySource;
import org.jetbrains.kotlin.idea.core.script.LibraryDependencyFactory;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.k2.ScriptConfigurationWithSdk;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aG\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"KOTLIN_SCRIPTS_MODULE_NAME", "", "getUpdatedStorage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "project", "Lcom/intellij/openapi/project/Project;", "configurationsData", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/idea/core/script/k2/ScriptConfigurationWithSdk;", "entitySourceSupplier", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "Lkotlin/ParameterName;", "name", "virtualFileUrl", "Lorg/jetbrains/kotlin/idea/core/script/KotlinScriptEntitySource;", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nmodule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 module.kt\norg/jetbrains/kotlin/idea/core/script/ModuleKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1#2:96\n1053#3:97\n1557#3:98\n1628#3,3:99\n*S KotlinDebug\n*F\n+ 1 module.kt\norg/jetbrains/kotlin/idea/core/script/ModuleKt\n*L\n55#1:97\n56#1:98\n56#1:99,3\n*E\n"})
public final class ModuleKt {
    @NotNull
    public static final String KOTLIN_SCRIPTS_MODULE_NAME = "kotlin.scripts";

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final MutableEntityStorage getUpdatedStorage(@NotNull Project project, @NotNull Map<VirtualFile, ScriptConfigurationWithSdk> configurationsData, @NotNull Function1<? super VirtualFileUrl, ? extends KotlinScriptEntitySource> entitySourceSupplier) {
        Object object;
        MutableEntityStorage updatedStorage;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(configurationsData, (String)"configurationsData");
                Intrinsics.checkNotNullParameter(entitySourceSupplier, (String)"entitySourceSupplier");
                updatedStorage = MutableEntityStorage.Companion.create();
                object = project.getBasePath();
                if (object == null) break block7;
                String it = object;
                boolean bl = false;
                Path path2 = Path.of(it, new String[0]);
                object = path2;
                if (path2 != null) break block8;
            }
            return updatedStorage;
        }
        Object projectPath = object;
        VirtualFileUrlManager fileUrlManager = WorkspaceModel.Companion.getInstance(project).getVirtualFileUrlManager();
        LibraryDependencyFactory updatedFactory = new LibraryDependencyFactory(fileUrlManager, updatedStorage);
        for (Map.Entry<VirtualFile, ScriptConfigurationWithSdk> entry : configurationsData.entrySet()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ScriptCompilationConfigurationWrapper configuration2;
            SdkDependency sdkDependency;
            String relativeLocation;
            File file;
            VirtualFile scriptFile = entry.getKey();
            ScriptConfigurationWithSdk configurationWithSdk = entry.getValue();
            if (ErrorHandlingKt.valueOrNull(configurationWithSdk.getScriptConfiguration()) == null) continue;
            KotlinScriptEntitySource source = (KotlinScriptEntitySource)entitySourceSupplier.invoke((Object)VirtualFileUrls.toVirtualFileUrl((VirtualFile)scriptFile, (VirtualFileUrlManager)fileUrlManager));
            File basePath = projectPath.toFile();
            if (FileUtil.getRelativePath((File)basePath, (File)(file = Path.of(scriptFile.getPath(), new String[0]).toFile())) == null) continue;
            String definitionName = DefinitionsKt.findScriptDefinition(project, new VirtualFileScriptSource(scriptFile, null, 2, null)).getName();
            String definitionScriptModuleName = "kotlin.scripts." + definitionName;
            String locationName = StringsKt.replace$default((String)relativeLocation, (char)'/', (char)':', (boolean)false, (int)4, null);
            String moduleName = definitionScriptModuleName + "." + locationName;
            if (configurationWithSdk.getSdk() != null) {
                Sdk it;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = it.getSdkType().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                sdkDependency = new SdkDependency(new SdkId(string, string2));
            } else {
                sdkDependency = null;
            }
            SdkDependency sdkDependency2 = sdkDependency;
            Iterable $this$sortedBy$iv = ScriptConfigurationManager.Companion.toVfsRoots((Iterable<? extends File>)configuration2.getDependenciesClassPath());
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    VirtualFile it = (VirtualFile)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (VirtualFile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(updatedFactory.get((VirtualFile)it, source));
            }
            List libraryDependencies = (List)destination$iv$iv;
            List allDependencies = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)sdkDependency2), (Iterable)libraryDependencies);
            updatedStorage.addEntity((WorkspaceEntity.Builder)ModuleEntity.Companion.create$default((ModuleEntity.Companion)ModuleEntity.Companion, (String)moduleName, (List)allDependencies, (EntitySource)source, null, (int)8, null));
        }
        return updatedStorage;
    }
}

