/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.cache;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.host.HostConfigurationKt;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.impl.BridgeDependenciesResolverKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.CachedConfigurationInputs;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshot;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshotFile;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshotForFS;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoader;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoadingContext;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationFileAttributeCache;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoader;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "loadDependencies", "", "isFirstLoad", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "context", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoadingContext;", "load", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationSnapshotForFS;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "areDependenciesValid", "file", "configuration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "save", "", "value", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationSnapshot;", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptConfigurationFileAttributeCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptConfigurationFileAttributeCache.kt\norg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationFileAttributeCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1734#2,3:129\n774#2:132\n865#2,2:133\n*S KotlinDebug\n*F\n+ 1 ScriptConfigurationFileAttributeCache.kt\norg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationFileAttributeCache\n*L\n79#1:129,3\n95#1:132\n95#1:133,2\n*E\n"})
public final class ScriptConfigurationFileAttributeCache
implements ScriptConfigurationLoader {
    @NotNull
    private final Project project;

    public ScriptConfigurationFileAttributeCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public boolean loadDependencies(boolean isFirstLoad, @NotNull KtFile ktFile2, @NotNull ScriptDefinition scriptDefinition, @NotNull ScriptConfigurationLoadingContext context) {
        Intrinsics.checkNotNullParameter((Object)ktFile2, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!isFirstLoad) {
            return false;
        }
        VirtualFile virtualFile = ktFile2.getOriginalFile().getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        ScriptConfigurationSnapshotForFS scriptConfigurationSnapshotForFS = this.load(virtualFile);
        if (scriptConfigurationSnapshotForFS == null) {
            return false;
        }
        ScriptConfigurationSnapshotForFS fromFs = scriptConfigurationSnapshotForFS;
        context.saveNewConfiguration(virtualFile, new ScriptConfigurationSnapshot(fromFs.getInputs(), fromFs.getReports(), new ScriptCompilationConfigurationWrapper.FromCompilationConfiguration(new KtFileScriptSource(ktFile2, null, 2, null), ScriptCompilationKt.with(fromFs.getConfiguration(), (Function1<? super ScriptCompilationConfiguration.Builder, Unit>)((Function1)arg_0 -> ScriptConfigurationFileAttributeCache.loadDependencies$lambda$1(scriptDefinition, arg_0))))));
        CachedConfigurationInputs cachedConfigurationInputs = fromFs.getInputs();
        Project project = ktFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return cachedConfigurationInputs.isUpToDate(project, virtualFile, ktFile2);
    }

    private final ScriptConfigurationSnapshotForFS load(VirtualFile virtualFile) {
        ScriptConfigurationSnapshotForFS scriptConfigurationSnapshotForFS = ScriptConfigurationSnapshotFile.Companion.get(this.project, virtualFile);
        if (scriptConfigurationSnapshotForFS == null) {
            return null;
        }
        ScriptConfigurationSnapshotForFS configurationSnapshot = scriptConfigurationSnapshotForFS;
        ScriptUtilsKt.scriptingDebugLog(virtualFile, (Function0<String>)((Function0)() -> ScriptConfigurationFileAttributeCache.load$lambda$2(configurationSnapshot)));
        ScriptCompilationConfiguration scriptCompilationConfiguration = configurationSnapshot.getConfiguration();
        if (scriptCompilationConfiguration == null) {
            return null;
        }
        ScriptCompilationConfiguration configuration2 = scriptCompilationConfiguration;
        if (!this.areDependenciesValid(virtualFile, configuration2)) {
            this.save(virtualFile, null);
            return null;
        }
        return configurationSnapshot;
    }

    private final boolean areDependenciesValid(VirtualFile file, ScriptCompilationConfiguration configuration2) {
        boolean bl;
        block5: {
            Iterable $this$all$iv = BridgeDependenciesResolverKt.toClassPathOrEmpty(configuration2.get(ScriptCompilationKt.getDependencies(ScriptCompilationConfiguration.Companion)));
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    File it = (File)element$iv;
                    boolean bl3 = false;
                    Path path2 = it.toPath();
                    Intrinsics.checkNotNull((Object)path2);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        bl2 = true;
                    } else {
                        ScriptUtilsKt.scriptingDebugLog(file, (Function0<String>)((Function0)() -> ScriptConfigurationFileAttributeCache.areDependenciesValid$lambda$4$lambda$3(path2)));
                        bl2 = false;
                    }
                    if (bl2) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void save(@NotNull VirtualFile file, @Nullable ScriptConfigurationSnapshot value) {
        ScriptConfigurationSnapshotForFS scriptConfigurationSnapshotForFS;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ScriptConfigurationSnapshotFile.Companion companion = ScriptConfigurationSnapshotFile.Companion;
        Project project = this.project;
        VirtualFile virtualFile = file;
        ScriptConfigurationSnapshot scriptConfigurationSnapshot = value;
        if (scriptConfigurationSnapshot != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void it;
            ScriptConfigurationSnapshot scriptConfigurationSnapshot2 = scriptConfigurationSnapshot;
            VirtualFile virtualFile2 = virtualFile;
            Project project2 = project;
            ScriptConfigurationSnapshotFile.Companion companion2 = companion;
            boolean bl = false;
            Iterable iterable = it.getReports();
            CachedConfigurationInputs cachedConfigurationInputs = it.getInputs();
            boolean $i$f$filter = false;
            void var8_11 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ScriptDiagnostic report = (ScriptDiagnostic)element$iv$iv;
                boolean bl2 = false;
                if (!(report.getException() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = it.getConfiguration();
            ScriptCompilationConfiguration scriptCompilationConfiguration = scriptCompilationConfigurationWrapper != null ? scriptCompilationConfigurationWrapper.getConfiguration() : null;
            List list2 = (List)destination$iv$iv;
            CachedConfigurationInputs cachedConfigurationInputs2 = cachedConfigurationInputs;
            ScriptConfigurationSnapshotForFS scriptConfigurationSnapshotForFS2 = new ScriptConfigurationSnapshotForFS(cachedConfigurationInputs2, list2, scriptCompilationConfiguration);
            companion = companion2;
            project = project2;
            virtualFile = virtualFile2;
            scriptConfigurationSnapshotForFS = scriptConfigurationSnapshotForFS2;
        } else {
            scriptConfigurationSnapshotForFS = null;
        }
        companion.set(project, virtualFile, scriptConfigurationSnapshotForFS);
    }

    private static final ScriptingHostConfiguration loadDependencies$lambda$1$lambda$0(ScriptDefinition $scriptDefinition, ScriptingHostConfiguration it) {
        return HostConfigurationKt.withDefaultsFrom(it, $scriptDefinition.getHostConfiguration());
    }

    private static final Unit loadDependencies$lambda$1(ScriptDefinition $scriptDefinition, ScriptCompilationConfiguration.Builder $this$with) {
        Intrinsics.checkNotNullParameter((Object)$this$with, (String)"$this$with");
        $this$with.update(ScriptCompilationKt.getHostConfiguration($this$with), arg_0 -> ScriptConfigurationFileAttributeCache.loadDependencies$lambda$1$lambda$0($scriptDefinition, arg_0));
        return Unit.INSTANCE;
    }

    private static final String load$lambda$2(ScriptConfigurationSnapshotForFS $configurationSnapshot) {
        return "configuration from fileAttributes = " + $configurationSnapshot;
    }

    private static final String areDependenciesValid$lambda$4$lambda$3(Path $path) {
        Intrinsics.checkNotNull((Object)$path);
        return "classpath root saved to file attribute doesn't exist: " + ((Object)$path).toString();
    }
}

