/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k2;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.KotlinScriptEntitySource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B2\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\u0010*\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k2/LibraryDependencyFactory;", "", "fileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "entitySourceSupplier", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "Lkotlin/ParameterName;", "name", "virtualFileUrl", "Lorg/jetbrains/kotlin/idea/core/script/KotlinScriptEntitySource;", "<init>", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;Lkotlin/jvm/functions/Function1;)V", "cache", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "Lkotlin/collections/HashMap;", "get", "file", "storage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "createLibrary", "kotlin.base.scripting"})
final class LibraryDependencyFactory {
    @NotNull
    private final VirtualFileUrlManager fileUrlManager;
    @NotNull
    private final Function1<VirtualFileUrl, KotlinScriptEntitySource> entitySourceSupplier;
    @NotNull
    private final HashMap<VirtualFile, LibraryEntity> cache;

    public LibraryDependencyFactory(@NotNull VirtualFileUrlManager fileUrlManager, @NotNull Function1<? super VirtualFileUrl, ? extends KotlinScriptEntitySource> entitySourceSupplier) {
        Intrinsics.checkNotNullParameter((Object)fileUrlManager, (String)"fileUrlManager");
        Intrinsics.checkNotNullParameter(entitySourceSupplier, (String)"entitySourceSupplier");
        this.fileUrlManager = fileUrlManager;
        this.entitySourceSupplier = entitySourceSupplier;
        this.cache = new HashMap();
    }

    @NotNull
    public final LibraryEntity get(@NotNull VirtualFile file, @NotNull MutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        LibraryEntity libraryEntity = this.cache.computeIfAbsent(file, arg_0 -> LibraryDependencyFactory.get$lambda$1(arg_0 -> LibraryDependencyFactory.get$lambda$0(this, storage, file, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)libraryEntity, (String)"computeIfAbsent(...)");
        return libraryEntity;
    }

    @NotNull
    public final LibraryEntity createLibrary(@NotNull MutableEntityStorage $this$createLibrary, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$createLibrary, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFileUrl fileUrl = VirtualFileUrls.toVirtualFileUrl((VirtualFile)file, (VirtualFileUrlManager)this.fileUrlManager);
        LibraryRoot libraryRoot = new LibraryRoot(fileUrl, LibraryRootTypeId.Companion.getCOMPILED(), null, 4, null);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        LibraryEntity.Builder libraryEntity = LibraryEntity.Companion.create$default((LibraryEntity.Companion)LibraryEntity.Companion, (String)string, (LibraryTableId)((LibraryTableId)LibraryTableId.ProjectLibraryTableId.INSTANCE), (List)CollectionsKt.listOf((Object)libraryRoot), (EntitySource)((EntitySource)this.entitySourceSupplier.invoke((Object)fileUrl)), null, (int)16, null);
        return (LibraryEntity)$this$createLibrary.addEntity((WorkspaceEntity.Builder)libraryEntity);
    }

    private static final LibraryEntity get$lambda$0(LibraryDependencyFactory this$0, MutableEntityStorage $storage, VirtualFile $file, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createLibrary($storage, $file);
    }

    private static final LibraryEntity get$lambda$1(Function1 $tmp0, Object p0) {
        return (LibraryEntity)$tmp0.invoke(p0);
    }
}

