/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.ucache;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.backend.workspace.BuilderSnapshot;
import com.intellij.platform.backend.workspace.StorageReplacement;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ui.EDT;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesModificationTracker;
import org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptEntitiesKt;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsBuilder;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsCache;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsUpdater;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsUpdaterKt;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptSdks;
import org.jetbrains.kotlin.idea.util.FirPluginOracleService;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001[B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH&J\b\u0010\u001d\u001a\u00020\u001aH&J\b\u0010\u001e\u001a\u00020\u001aH&J\u0014\u0010\u001f\u001a\u00020\u001a2\n\u0010 \u001a\u00060!j\u0002`\"H&J\b\u0010#\u001a\u00020$H\u0002J\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020\u0011J\u0010\u0010)\u001a\u00020\u001a2\b\b\u0002\u0010,\u001a\u00020\u0011J\u0006\u0010-\u001a\u00020\u001aJ\u0006\u0010.\u001a\u00020\u0011J%\u0010/\u001a\u0002H0\"\u0004\b\u0000\u001002\f\u00101\u001a\b\u0012\u0004\u0012\u0002H002H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J\u0006\u00104\u001a\u00020\u001aJ\u0016\u00105\u001a\u00020\u001a2\u0006\u00106\u001a\u00020+2\u0006\u00107\u001a\u000208J\b\u00109\u001a\u00020\u001aH\u0002J\u0012\u0010<\u001a\u00020\u001a2\b\b\u0002\u0010,\u001a\u00020\u0011H\u0002J\u0010\u0010=\u001a\u00020\u001a2\u0006\u0010>\u001a\u00020?H\u0002J\b\u0010@\u001a\u00020\u001aH\u0002J\u001a\u0010A\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u00112\b\b\u0002\u0010B\u001a\u00020\u0011H\u0002J\u0018\u0010C\u001a\u00020\u001a2\u0006\u0010B\u001a\u00020\u00112\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020\u001a2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020\u001a2\u0006\u0010G\u001a\u00020HH\u0002J\u000e\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001a0KH\u0002J$\u0010L\u001a\u00020\u001a2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020+0N2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020+0NH\u0002J$\u0010P\u001a\u00020\u001a2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020+0N2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020+0NH\u0002J\b\u0010Q\u001a\u00020HH\u0002J#\u0010R\u001a\u00020\u001a2\u0012\u0010S\u001a\n\u0012\u0006\b\u0001\u0012\u00020U0T\"\u00020UH\u0000\u00a2\u0006\u0004\bV\u0010WJ$\u0010X\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00110ZH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010:\u001a\b\u0012\u0002\b\u0003\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\\"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsUpdater;", "", "project", "Lcom/intellij/openapi/project/Project;", "manager", "Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getManager", "()Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "invalidated", "", "syncUpdateRequired", "invalidationLock", "Ljava/util/concurrent/locks/ReentrantLock;", "updateState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsUpdater$UpdateState;", "kotlin.jvm.PlatformType", "gatherRoots", "", "builder", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsBuilder;", "afterUpdate", "onTrivialUpdate", "onUpdateException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "recreateRootsCache", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "cache", "classpathRoots", "getClasspathRoots", "()Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache;", "invalidate", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "synchronous", "invalidateAndCommit", "isTransactionAboutToHappen", "update", "T", "body", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "commit", "addConfiguration", "vFile", "configuration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "scheduleUpdateIfInvalid", "scheduledUpdate", "Lcom/intellij/openapi/progress/util/BackgroundTaskUtil$BackgroundTask;", "performUpdate", "ensureUpdateScheduled", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "updateSynchronously", "doUpdate", "underProgressManager", "doUpdateImpl", "disposable", "Lorg/jetbrains/kotlin/idea/core/KotlinPluginDisposable;", "updateConfigurationInScriptRoots", "updates", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsCache$Updates;", "launchHighlightingUpdateIfNeeded", "updateModificationTracker", "Lkotlinx/coroutines/Deferred;", "applyDiffToModelAsync", "filesToAddOrUpdate", "", "filesToRemove", "applyDiffToModel", "recreateRootsCacheAndDiff", "checkInvalidSdks", "remove", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "checkInvalidSdks$kotlin_base_scripting", "([Lcom/intellij/openapi/projectRoots/Sdk;)V", "updateHighlighting", "filter", "Lkotlin/Function1;", "UpdateState", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptClassRootsUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptClassRootsUpdater.kt\norg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsUpdater\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 9 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,431:1\n161#1,5:432\n161#1,5:437\n283#2:442\n280#2:444\n73#3:443\n1#4:445\n1#4:468\n2707#5,10:446\n31#6,2:456\n11476#7,9:458\n13402#7:467\n13403#7:469\n11485#7:470\n774#8:471\n865#8,2:472\n1863#8,2:474\n52#9:476\n*S KotlinDebug\n*F\n+ 1 ScriptClassRootsUpdater.kt\norg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsUpdater\n*L\n145#1:432,5\n175#1:437,5\n185#1:442\n189#1:444\n188#1:443\n419#1:468\n300#1:446,10\n415#1:456,2\n419#1:458,9\n419#1:467\n419#1:469\n419#1:470\n420#1:471\n420#1:472,2\n424#1:474,2\n292#1:476\n*E\n"})
public abstract class ScriptClassRootsUpdater {
    @NotNull
    private final Project project;
    @NotNull
    private final CompositeScriptConfigurationManager manager;
    @NotNull
    private final CoroutineScope scope;
    private boolean invalidated;
    private boolean syncUpdateRequired;
    @NotNull
    private final ReentrantLock invalidationLock;
    @NotNull
    private final AtomicReference<UpdateState> updateState;
    @NotNull
    private final AtomicReference<ScriptClassRootsCache> cache;
    @Nullable
    private BackgroundTaskUtil.BackgroundTask<?> scheduledUpdate;

    public ScriptClassRootsUpdater(@NotNull Project project, @NotNull CompositeScriptConfigurationManager manager, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.manager = manager;
        this.scope = scope;
        this.invalidationLock = new ReentrantLock();
        this.updateState = new AtomicReference<UpdateState>(UpdateState.NONE);
        this.cache = new AtomicReference<ScriptClassRootsCache>(ScriptClassRootsCache.Companion.getEMPTY());
        ProjectManager.getInstance().addProjectManagerListener(this.project, new ProjectManagerListener(){

            public void projectClosing(Project project) {
                block0: {
                    BackgroundTaskUtil.BackgroundTask backgroundTask;
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    BackgroundTaskUtil.BackgroundTask backgroundTask2 = scheduledUpdate;
                    if (backgroundTask2 == null) break block0;
                    BackgroundTaskUtil.BackgroundTask $this$projectClosing_u24lambda_u240 = backgroundTask = backgroundTask2;
                    boolean bl = false;
                    $this$projectClosing_u24lambda_u240.cancel();
                }
            }
        });
        if (KotlinPluginModeProvider.Companion.isK1Mode()) {
            this.performUpdate(false);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CompositeScriptConfigurationManager getManager() {
        return this.manager;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    public abstract void gatherRoots(@NotNull ScriptClassRootsBuilder var1);

    public abstract void afterUpdate();

    public abstract void onTrivialUpdate();

    public abstract void onUpdateException(@NotNull Exception var1);

    private final ScriptClassRootsCache recreateRootsCache() {
        ScriptClassRootsBuilder builder2 = new ScriptClassRootsBuilder(this.project, null, null, null, 14, null);
        this.gatherRoots(builder2);
        return builder2.build();
    }

    @NotNull
    public final ScriptClassRootsCache getClasspathRoots() {
        ScriptClassRootsCache scriptClassRootsCache = this.cache.get();
        Intrinsics.checkNotNullExpressionValue((Object)scriptClassRootsCache, (String)"get(...)");
        return scriptClassRootsCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidate(@NotNull VirtualFile file, boolean synchronous) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Lock lock = this.invalidationLock;
        lock.lock();
        try {
            boolean bl = false;
            this.invalidate(synchronous);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ void invalidate$default(ScriptClassRootsUpdater scriptClassRootsUpdater, VirtualFile virtualFile, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invalidate");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        scriptClassRootsUpdater.invalidate(virtualFile, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidate(boolean synchronous) {
        Lock lock = this.invalidationLock;
        lock.lock();
        try {
            boolean bl = false;
            this.invalidated = true;
            if (synchronous) {
                this.syncUpdateRequired = true;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ void invalidate$default(ScriptClassRootsUpdater scriptClassRootsUpdater, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invalidate");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        scriptClassRootsUpdater.invalidate(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidateAndCommit() {
        if (KotlinPluginModeProvider.Companion.isK1Mode()) {
            ScriptClassRootsUpdater this_$iv = this;
            boolean $i$f$update = false;
            try {
                boolean bl = false;
                ScriptClassRootsUpdater.invalidate$default(this, false, 1, null);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.commit();
            }
        }
    }

    public final boolean isTransactionAboutToHappen() {
        return this.updateState.get() != UpdateState.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T update(@NotNull Function0<? extends T> body2) {
        Object object;
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        boolean $i$f$update = false;
        try {
            object = body2.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.commit();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    public final void commit() {
        this.scheduleUpdateIfInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConfiguration(@NotNull VirtualFile vFile, @NotNull ScriptCompilationConfigurationWrapper configuration2) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        ScriptClassRootsUpdater this_$iv = this;
        boolean $i$f$update = false;
        try {
            boolean bl = false;
            ScriptClassRootsBuilder builder2 = this.getClasspathRoots().builder(this.project);
            builder2.warnAboutDependenciesExistence(false);
            builder2.add(vFile, configuration2);
            this.cache.set(builder2.build());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void scheduleUpdateIfInvalid() {
        var2_1 = this.invalidationLock;
        var2_1.lock();
        try {
            $i$a$-withLock-ScriptClassRootsUpdater$scheduleUpdateIfInvalid$isSync$1 = false;
            $this$ifFalse$iv = this.invalidated;
            $i$f$ifFalse = false;
            if (!$this$ifFalse$iv) {
                $i$a$-ifFalse-ScriptClassRootsUpdater$scheduleUpdateIfInvalid$isSync$1$1 = false;
                return;
            }
            this.invalidated = false;
            if (this.syncUpdateRequired) ** GOTO lbl-1000
            $i$f$isUnitTestMode = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            it = var4_3 = v0;
            $i$a$-also-ScriptClassRootsUpdater$scheduleUpdateIfInvalid$isSync$1$2 = false;
            $this$ifTrue$iv = it;
            $i$f$ifTrue = false;
            if ($this$ifTrue$iv) {
                $i$a$-ifTrue-ScriptClassRootsUpdater$scheduleUpdateIfInvalid$isSync$1$2$1 = false;
                this.syncUpdateRequired = false;
            }
            var3_2 = var4_3;
        }
        finally {
            var2_1.unlock();
        }
        isSync = var3_2;
        this.performUpdate(isSync);
    }

    private final void performUpdate(boolean synchronous) {
        if (KotlinPluginModeProvider.Companion.isK2Mode()) {
            return;
        }
        KotlinPluginDisposable disposable = KotlinPluginDisposable.Companion.getInstance(this.project);
        if (disposable.getDisposed()) {
            return;
        }
        if (synchronous) {
            this.updateSynchronously();
        } else {
            this.ensureUpdateScheduled(disposable);
        }
    }

    static /* synthetic */ void performUpdate$default(ScriptClassRootsUpdater scriptClassRootsUpdater, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performUpdate");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        scriptClassRootsUpdater.performUpdate(bl);
    }

    private final void ensureUpdateScheduled(Disposable parentDisposable) {
        if (this.updateState.compareAndSet(UpdateState.NONE, UpdateState.SCHEDULED)) {
            this.scheduledUpdate = BackgroundTaskUtil.submitTask((Disposable)parentDisposable, () -> ScriptClassRootsUpdater.ensureUpdateScheduled$lambda$8(this));
        } else {
            ScriptClassRootsUpdaterKt.getLOG().debug("Will not schedule update, state: " + (Object)((Object)this.updateState.get()));
        }
    }

    private final void updateSynchronously() {
        UpdateState previousState = this.updateState.getAndSet(UpdateState.RUNNING);
        if (previousState == UpdateState.SCHEDULED) {
            BackgroundTaskUtil.BackgroundTask<?> backgroundTask = this.scheduledUpdate;
            if (backgroundTask != null) {
                backgroundTask.cancel();
            }
        }
        ScriptClassRootsUpdater.doUpdate$default(this, true, false, 2, null);
    }

    /*
     * Exception decompiling
     */
    private final void doUpdate(boolean synchronous, boolean underProgressManager) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static /* synthetic */ void doUpdate$default(ScriptClassRootsUpdater scriptClassRootsUpdater, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doUpdate");
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        scriptClassRootsUpdater.doUpdate(bl, bl2);
    }

    private final void doUpdateImpl(boolean underProgressManager, KotlinPluginDisposable disposable) {
        ScriptClassRootsCache.Updates updates = this.recreateRootsCacheAndDiff();
        if (!updates.getChanged()) {
            ScriptClassRootsUpdaterKt.getLOG().debug("Does not have any new updates, aborting");
            return;
        }
        if (underProgressManager) {
            ProgressManager.checkCanceled();
        }
        if (disposable.getDisposed()) {
            return;
        }
        this.updateConfigurationInScriptRoots(updates);
        if (updates.getHasNewRoots()) {
            this.updateModificationTracker();
        }
        this.launchHighlightingUpdateIfNeeded(updates);
    }

    private final void updateConfigurationInScriptRoots(ScriptClassRootsCache.Updates updates) {
        Set<String> scriptVirtualFiles;
        Set<String> updatedScriptPaths;
        Set<String> set;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager manager = virtualFileManager;
        Set<String> it = set = (updatedScriptPaths = updates instanceof ScriptClassRootsCache.IncrementalUpdates ? ((ScriptClassRootsCache.IncrementalUpdates)updates).getUpdatedScripts() : updates.getCache().scriptsPaths());
        boolean bl = false;
        Set<String> set2 = scriptVirtualFiles = !it.isEmpty() ? set : null;
        if (scriptVirtualFiles == null) {
            this.onTrivialUpdate();
            return;
        }
        Sequence updatedScriptFiles = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)scriptVirtualFiles), arg_0 -> ScriptClassRootsUpdater.updateConfigurationInScriptRoots$lambda$11(manager, arg_0));
        Set<String> actualScriptPaths = updates.getCache().scriptsPaths();
        Sequence $this$partition$iv = updatedScriptFiles;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            VirtualFile it2 = (VirtualFile)element$iv;
            boolean bl2 = false;
            boolean bl3 = actualScriptPaths.contains(it2.getPath()) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List filesToAddOrUpdate = (List)pair.component1();
        List filesToRemove = (List)pair.component2();
        this.applyDiffToModelAsync(filesToAddOrUpdate, filesToRemove);
    }

    private final void launchHighlightingUpdateIfNeeded(ScriptClassRootsCache.Updates updates) {
        if (!updates.getHasUpdatedScripts()) {
            return;
        }
        BuildersKt.async$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, updates, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ScriptClassRootsUpdater this$0;
            final /* synthetic */ ScriptClassRootsCache.Updates $updates;
            {
                this.this$0 = $receiver;
                this.$updates = $updates;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$async = (CoroutineScope)this.L$0;
                        this.label = 1;
                        Object object3 = CoroutinesKt.readAction(() -> launchHighlightingUpdateIfNeeded.1.invokeSuspend$lambda$3(this.this$0, $this$async, this.$updates), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final boolean invokeSuspend$lambda$3$lambda$1$lambda$0(ScriptClassRootsCache.Updates $updates, VirtualFile file) {
                String string = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                return $updates.isScriptChanged(string);
            }

            private static final Unit invokeSuspend$lambda$3(ScriptClassRootsUpdater this$0, CoroutineScope $$this$async, ScriptClassRootsCache.Updates $updates) {
                block4: {
                    Object object;
                    if (this$0.getProject().isDisposed()) {
                        return Unit.INSTANCE;
                    }
                    Object object2 = $$this$async;
                    try {
                        CoroutineScope $this$invokeSuspend_u24lambda_u243_u24lambda_u241 = object2;
                        boolean bl = false;
                        ScriptClassRootsUpdater.access$updateHighlighting(this$0, this$0.getProject(), arg_0 -> launchHighlightingUpdateIfNeeded.1.invokeSuspend$lambda$3$lambda$1$lambda$0($updates, arg_0));
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable bl) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object2 = object;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                    if (throwable == null) break block4;
                    Object it = object = throwable;
                    boolean bl = false;
                    if (it instanceof ControlFlowException) {
                        throw it;
                    }
                    ScriptClassRootsUpdaterKt.getLOG().error("Failed to update highlighting", (Throwable)it);
                }
                return Unit.INSTANCE;
            }
        }), (int)3, null);
    }

    private final Deferred<Unit> updateModificationTracker() {
        return BuildersKt.async$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ScriptClassRootsUpdater this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ ScriptClassRootsUpdater this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = CoroutinesKt.edtWriteAction(() -> updateModificationTracker.1.invokeSuspend$lambda$0(this.this$0), (Continuation)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final Unit invokeSuspend$lambda$0(ScriptClassRootsUpdater this$0) {
                                if (this$0.getProject().isDisposed()) {
                                    return Unit.INSTANCE;
                                }
                                ScriptDependenciesModificationTracker.Companion.getInstance(this$0.getProject()).incModificationCount();
                                return Unit.INSTANCE;
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void applyDiffToModelAsync(List<? extends VirtualFile> filesToAddOrUpdate, List<? extends VirtualFile> filesToRemove) {
        if (ApplicationManager.getApplication().isUnitTestMode() || !EDT.isCurrentThreadEdt()) {
            this.applyDiffToModel(filesToAddOrUpdate, filesToRemove);
        } else {
            if (this.project.isDisposed()) {
                return;
            }
            ProgressIndicator progressIndicator = BackgroundTaskUtil.executeOnPooledThread((Disposable)KotlinPluginDisposable.Companion.getInstance(this.project), () -> ScriptClassRootsUpdater.applyDiffToModelAsync$lambda$13(this, filesToAddOrUpdate, filesToRemove));
            Intrinsics.checkNotNull((Object)progressIndicator);
        }
    }

    private final void applyDiffToModel(List<? extends VirtualFile> filesToAddOrUpdate, List<? extends VirtualFile> filesToRemove) {
        if (this.project.isDisposed()) {
            return;
        }
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)workspaceModel, (String)"null cannot be cast to non-null type com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal");
        BuilderSnapshot builderSnapshot = ((WorkspaceModelInternal)workspaceModel).getBuilderSnapshot();
        KotlinScriptEntitiesKt.syncScriptEntities(builderSnapshot, this.project, filesToAddOrUpdate, filesToRemove);
        StorageReplacement replacement = builderSnapshot.getStorageReplacement();
        ActionsKt.runInEdt((ModalityState)ModalityState.nonModal(), () -> ScriptClassRootsUpdater.applyDiffToModel$lambda$15(this, filesToAddOrUpdate, filesToRemove, replacement));
    }

    private final ScriptClassRootsCache.Updates recreateRootsCacheAndDiff() {
        ScriptClassRootsCache scriptClassRootsCache;
        ScriptClassRootsCache old;
        while (!this.cache.compareAndSet(old = this.cache.get(), scriptClassRootsCache = this.recreateRootsCache())) {
        }
        Intrinsics.checkNotNull((Object)old);
        return scriptClassRootsCache.diff(old);
    }

    public final void checkInvalidSdks$kotlin_base_scripting(Sdk ... remove) {
        ScriptSdks actualSdks;
        ScriptClassRootsCache scriptClassRootsCache;
        ScriptClassRootsCache old;
        Intrinsics.checkNotNullParameter((Object)remove, (String)"remove");
        do {
            old = this.cache.get();
            if (remove.length == 0) {
                v0 = old.getSdks().rebuild(this.project, null);
            } else {
                ScriptSdks sdks = old.getSdks();
                int n = remove.length;
                for (int j = 0; j < n; ++j) {
                    Sdk sdk = remove[j];
                    sdks = sdks.rebuild(this.project, sdk);
                }
                v0 = actualSdks = sdks;
            }
            if (!Intrinsics.areEqual((Object)actualSdks, (Object)old.getSdks())) continue;
            return;
        } while (!this.cache.compareAndSet(old, scriptClassRootsCache = old.withUpdatedSdks(actualSdks)));
        this.performUpdate(false);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateHighlighting(Project project, Function1<? super VirtualFile, Boolean> filter2) {
        void $this$filterTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        block10: {
            block9: {
                if (!project.isOpen()) break block9;
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<FirPluginOracleService> serviceClass$iv = FirPluginOracleService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                if (!((FirPluginOracleService)object).isFirPlugin()) break block10;
            }
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        Object[] $this$mapNotNull$iv = fileEditorArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Iterable<VirtualFile> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            VirtualFile it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            FileEditor it = (FileEditor)element$iv$iv;
            boolean bl2 = false;
            if (it.getFile() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List openFiles = (List)destination$iv$iv;
        Iterable $this$filter$iv = openFiles;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)filter2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List openedScripts = (List)destination$iv$iv2;
        if (openedScripts.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = openedScripts;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            KtFile ktFile2;
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            if (!it.isValid()) continue;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(it);
            if ((psiFile instanceof KtFile ? (KtFile)psiFile : null) == null) continue;
            ktFile2 = ktFile2;
            boolean bl4 = false;
            DaemonCodeAnalyzer.getInstance((Project)project).restart((PsiFile)ktFile2);
        }
    }

    private static final void ensureUpdateScheduled$lambda$8(ScriptClassRootsUpdater this$0) {
        if (this$0.updateState.compareAndSet(UpdateState.SCHEDULED, UpdateState.RUNNING)) {
            ScriptClassRootsUpdater.doUpdate$default(this$0, false, false, 2, null);
        }
    }

    private static final VirtualFile updateConfigurationInScriptRoots$lambda$11(VirtualFileManager $manager, String it) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        VirtualFile byNioPath = $manager.findFileByNioPath(Paths.get(it, new String[0]));
        if (byNioPath == null) {
            String string;
            String string2 = it;
            boolean condition$iv = StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null);
            boolean $i$f$applyIf = false;
            if (condition$iv) {
                void $this$updateConfigurationInScriptRoots_u24lambda_u2411_u24lambda_u2410 = $this$applyIf$iv;
                boolean bl = false;
                string = StringsKt.replaceFirst$default((String)it, (String)"/", (String)"", (boolean)false, (int)4, null);
            } else {
                string = $this$applyIf$iv;
            }
            void path2 = string;
            virtualFile = (VirtualFile)new LightVirtualFile((String)path2);
        } else {
            virtualFile = byNioPath;
        }
        return virtualFile;
    }

    private static final void applyDiffToModelAsync$lambda$13(ScriptClassRootsUpdater this$0, List $filesToAddOrUpdate, List $filesToRemove) {
        this$0.applyDiffToModel($filesToAddOrUpdate, $filesToRemove);
    }

    private static final boolean applyDiffToModel$lambda$15$lambda$14(ScriptClassRootsUpdater this$0, StorageReplacement $replacement) {
        boolean bl;
        if (this$0.project.isDisposed()) {
            bl = false;
        } else {
            WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this$0.project);
            Intrinsics.checkNotNull((Object)workspaceModel, (String)"null cannot be cast to non-null type com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal");
            bl = ((WorkspaceModelInternal)workspaceModel).replaceProjectModel($replacement);
        }
        return bl;
    }

    private static final Unit applyDiffToModel$lambda$15(ScriptClassRootsUpdater this$0, List $filesToAddOrUpdate, List $filesToRemove, StorageReplacement $replacement) {
        boolean replaced = (Boolean)ActionsKt.runWriteAction(() -> ScriptClassRootsUpdater.applyDiffToModel$lambda$15$lambda$14(this$0, $replacement));
        if (!replaced) {
            this$0.applyDiffToModelAsync($filesToAddOrUpdate, $filesToRemove);
        } else {
            this$0.afterUpdate();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateHighlighting(ScriptClassRootsUpdater $this, Project project, Function1 filter2) {
        $this.updateHighlighting(project, (Function1<? super VirtualFile, Boolean>)filter2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsUpdater$UpdateState;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "SCHEDULED", "RUNNING", "kotlin.base.scripting"})
    private static final class UpdateState
    extends Enum<UpdateState> {
        public static final /* enum */ UpdateState NONE = new UpdateState();
        public static final /* enum */ UpdateState SCHEDULED = new UpdateState();
        public static final /* enum */ UpdateState RUNNING = new UpdateState();
        private static final /* synthetic */ UpdateState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UpdateState[] values() {
            return (UpdateState[])$VALUES.clone();
        }

        public static UpdateState valueOf(String value) {
            return Enum.valueOf(UpdateState.class, value);
        }

        @NotNull
        public static EnumEntries<UpdateState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = updateStateArray = new UpdateState[]{UpdateState.NONE, UpdateState.SCHEDULED, UpdateState.RUNNING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

