/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a!\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0006*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000eH\u0000\u001a\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u000e*\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0015\u001a\u0016\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0007\u001a\u0016\u0010\u0019\u001a\u0004\u0018\u00010\f2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002\"\"\u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001c"}, d2={"javaBreakpointProperties", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaBreakpointProperties;", "Lcom/intellij/debugger/ui/breakpoints/LineBreakpoint;", "getJavaBreakpointProperties", "(Lcom/intellij/debugger/ui/breakpoints/LineBreakpoint;)Lorg/jetbrains/java/debugger/breakpoints/properties/JavaBreakpointProperties;", "isInsideInlineOnlyDeclaration", "", "Lcom/intellij/psi/PsiElement;", "isClosingBraceInMethod", "getLambdaByOrdinal", "Lorg/jetbrains/kotlin/psi/KtFunction;", "position", "Lcom/intellij/debugger/SourcePosition;", "ordinal", "", "(Lcom/intellij/debugger/SourcePosition;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/psi/KtFunction;", "getLambdaBreakpointTargets", "", "isSuitableLambdaBreakpointTarget", "line", "getFirstLineWithExecutableCode", "(Lorg/jetbrains/kotlin/psi/KtFunction;)Ljava/lang/Integer;", "inTheMethod", "pos", "method", "createLineSourcePosition", "breakpoint", "Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinLineBreakpointType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLineBreakpointType.kt\norg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointTypeKt\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n80#2:263\n1251#3,2:264\n774#4:266\n865#4,2:267\n*S KotlinDebug\n*F\n+ 1 KotlinLineBreakpointType.kt\norg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointTypeKt\n*L\n197#1:263\n197#1:264,2\n234#1:266\n234#1:267,2\n*E\n"})
public final class KotlinLineBreakpointTypeKt {
    private static final JavaBreakpointProperties<?> getJavaBreakpointProperties(LineBreakpoint<?> $this$javaBreakpointProperties) {
        XBreakpoint xBreakpoint = $this$javaBreakpointProperties.getXBreakpoint();
        JavaBreakpointProperties javaBreakpointProperties = xBreakpoint != null ? (JavaBreakpointProperties)xBreakpoint.getProperties() : null;
        return javaBreakpointProperties instanceof JavaBreakpointProperties ? javaBreakpointProperties : null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInsideInlineOnlyDeclaration(PsiElement $this$isInsideInlineOnlyDeclaration) {
        KtCallableDeclaration it;
        void $this$parentsOfType$iv;
        if ($this$isInsideInlineOnlyDeclaration == null) return false;
        PsiElement psiElement = $this$isInsideInlineOnlyDeclaration;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        Sequence $this$any$iv = PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, KtCallableDeclaration.class, (boolean)withSelf$iv);
        boolean $i$f$any = false;
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (KtCallableDeclaration)element$iv;
            boolean bl = false;
        } while (!BreakpointTypeUtilsKt.isInlineOnly(it));
        return true;
    }

    private static final boolean isClosingBraceInMethod(PsiElement $this$isClosingBraceInMethod) {
        if ($this$isClosingBraceInMethod instanceof LeafPsiElement && ((LeafPsiElement)$this$isClosingBraceInMethod).getNode().getElementType() == KtTokens.RBRACE) {
            PsiElement owner;
            PsiElement blockExpression = ((LeafPsiElement)$this$isClosingBraceInMethod).getParent();
            if (blockExpression instanceof KtFunctionLiteral) {
                return true;
            }
            if (blockExpression instanceof KtBlockExpression && ((owner = ((KtBlockExpression)blockExpression).getParent()) instanceof KtFunction || owner instanceof KtClassInitializer)) {
                return true;
            }
        }
        return false;
    }

    private static final KtFunction getLambdaByOrdinal(SourcePosition position, Integer ordinal) {
        if (ordinal == null || ordinal < 0) {
            return null;
        }
        List lambdas = (List)ActionsKt.runReadAction(() -> KotlinLineBreakpointTypeKt.getLambdaByOrdinal$lambda$1(position));
        return (KtFunction)CollectionsKt.getOrNull((List)lambdas, (int)ordinal);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KtFunction> getLambdaBreakpointTargets(SourcePosition position) {
        void $this$filterTo$iv$iv;
        List<KtFunction> allLambdas = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(position);
        int line = position.getLine();
        Iterable $this$filter$iv = allLambdas;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFunction it = (KtFunction)element$iv$iv;
            boolean bl = false;
            if (!KotlinLineBreakpointTypeKt.isSuitableLambdaBreakpointTarget(it, line)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSuitableLambdaBreakpointTarget(@NotNull KtFunction $this$isSuitableLambdaBreakpointTarget, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuitableLambdaBreakpointTarget, (String)"<this>");
        if (Registry.Companion.is("debugger.kotlin.multiline.lambda.breakpoints")) return true;
        if (PsiLinesUtilsKt.isOneLiner((PsiElement)$this$isSuitableLambdaBreakpointTarget)) return true;
        Integer n = KotlinLineBreakpointTypeKt.getFirstLineWithExecutableCode($this$isSuitableLambdaBreakpointTarget);
        int n2 = line;
        if (n == null) return false;
        if (n != n2) return false;
        return true;
    }

    private static final Integer getFirstLineWithExecutableCode(KtFunction $this$getFirstLineWithExecutableCode) {
        KtBlockExpression ktBlockExpression = $this$getFirstLineWithExecutableCode.getBodyBlockExpression();
        if (ktBlockExpression == null) {
            return null;
        }
        KtBlockExpression bodyExpression = ktBlockExpression;
        KtExpression ktExpression = bodyExpression.getFirstStatement();
        if (ktExpression == null) {
            return null;
        }
        KtExpression first2 = ktExpression;
        return PsiLinesUtilsKt.getLineNumber$default((PsiElement)first2, false, 1, null);
    }

    public static final boolean inTheMethod(@NotNull SourcePosition pos, @NotNull PsiElement method) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiElement psiElement = pos.getElementAt();
        if (psiElement == null) {
            return false;
        }
        PsiElement elem = psiElement;
        PsiElement topmostElement = KotlinPsiUtils.getTopmostElementAtOffset(elem, elem.getTextRange().getStartOffset());
        return Comparing.equal((Object)KotlinPositionManagerKt.getContainingMethod$default(topmostElement, false, 1, null), (Object)method);
    }

    private static final SourcePosition createLineSourcePosition(XLineBreakpointImpl<?> breakpoint2) {
        VirtualFile virtualFile = breakpoint2.getFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        PsiManager psiManager = PsiManager.getInstance((Project)breakpoint2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        PsiFile psiFile = (PsiFile)ActionsKt.runReadAction(() -> KotlinLineBreakpointTypeKt.createLineSourcePosition$lambda$3(psiManager2, file));
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        return SourcePosition.createFromLine((PsiFile)psiFile2, (int)breakpoint2.getLine());
    }

    private static final List getLambdaByOrdinal$lambda$1(SourcePosition $position) {
        PsiElement targetElement = $position.getElementAt();
        if (targetElement == null || !targetElement.isValid()) {
            return CollectionsKt.emptyList();
        }
        return KotlinLineBreakpointTypeKt.getLambdaBreakpointTargets($position);
    }

    private static final PsiFile createLineSourcePosition$lambda$3(PsiManager $psiManager, VirtualFile $file) {
        return $psiManager.findFile($file);
    }

    public static final /* synthetic */ JavaBreakpointProperties access$getJavaBreakpointProperties(LineBreakpoint $receiver) {
        return KotlinLineBreakpointTypeKt.getJavaBreakpointProperties($receiver);
    }

    public static final /* synthetic */ List access$getLambdaBreakpointTargets(SourcePosition position) {
        return KotlinLineBreakpointTypeKt.getLambdaBreakpointTargets(position);
    }

    public static final /* synthetic */ SourcePosition access$createLineSourcePosition(XLineBreakpointImpl breakpoint2) {
        return KotlinLineBreakpointTypeKt.createLineSourcePosition(breakpoint2);
    }

    public static final /* synthetic */ KtFunction access$getLambdaByOrdinal(SourcePosition position, Integer ordinal) {
        return KotlinLineBreakpointTypeKt.getLambdaByOrdinal(position, ordinal);
    }

    public static final /* synthetic */ boolean access$isInsideInlineOnlyDeclaration(PsiElement $receiver) {
        return KotlinLineBreakpointTypeKt.isInsideInlineOnlyDeclaration($receiver);
    }

    public static final /* synthetic */ boolean access$isClosingBraceInMethod(PsiElement $receiver) {
        return KotlinLineBreakpointTypeKt.isClosingBraceInMethod($receiver);
    }
}

