/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.filter;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.ExtraSteppingFilter;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.ui.classFilter.ClassFilter;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.ClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/filter/KotlinExtraSteppingFilter;", "Lcom/intellij/debugger/engine/ExtraSteppingFilter;", "<init>", "()V", "isApplicable", "", "context", "Lcom/intellij/debugger/engine/SuspendContext;", "getStepRequestDepth", "", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinExtraSteppingFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExtraSteppingFilter.kt\norg/jetbrains/kotlin/idea/debugger/core/filter/KotlinExtraSteppingFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1557#2:52\n1628#2,3:53\n*S KotlinDebug\n*F\n+ 1 KotlinExtraSteppingFilter.kt\norg/jetbrains/kotlin/idea/debugger/core/filter/KotlinExtraSteppingFilter\n*L\n33#1:52\n33#1:53,3\n*E\n"})
public final class KotlinExtraSteppingFilter
implements ExtraSteppingFilter {
    public boolean isApplicable(@Nullable SuspendContext context) {
        SuspendContext suspendContext = context;
        if (suspendContext == null || (suspendContext = suspendContext.getDebugProcess()) == null) {
            return false;
        }
        SuspendContext debugProcess = suspendContext;
        Object object = context.getFrameProxy();
        if (object == null || (object = SafeUtilKt.safeLocation(object)) == null) {
            return false;
        }
        Object location = object;
        if (!DebuggerUtil.isInKotlinSources((Location)location)) {
            return false;
        }
        KotlinPositionManager positionManager = new KotlinPositionManager((DebugProcess)debugProcess);
        SourcePosition sourcePosition = SafeUtilKt.safeGetSourcePosition((PositionManager)positionManager, (Location)location);
        if (sourcePosition == null) {
            return false;
        }
        SourcePosition sourcePosition2 = sourcePosition;
        DebuggerSettings settings2 = DebuggerSettings.getInstance();
        return (Boolean)ActionsKt.runReadAction(() -> KotlinExtraSteppingFilter.isApplicable$lambda$1(settings2, sourcePosition2));
    }

    public int getStepRequestDepth(@Nullable SuspendContext context) {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isApplicable$lambda$1(DebuggerSettings $settings, SourcePosition $sourcePosition) {
        void $this$mapTo$iv$iv;
        if (!$settings.TRACING_FILTERS_ENABLED) {
            return false;
        }
        Iterable $this$map$iv = new ClassNameProvider(null, 1, null).getCandidates($sourcePosition);
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JvmNameUtilsKt.internalNameToFqn((String)it));
        }
        List classNames = (List)destination$iv$iv;
        for (String className : classNames) {
            object = ArrayIteratorKt.iterator((Object[])$settings.getSteppingFilters());
            while (object.hasNext()) {
                ClassFilter filter2 = (ClassFilter)object.next();
                if (!filter2.isEnabled() || !filter2.matches(className)) continue;
                return true;
            }
        }
        return false;
    }
}

