/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.execution.JavaTestConfigurationWithDiscoverySupport;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.DumbModeUtils;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineDebuggerMode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001 B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014H\u0002J(\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018*\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0005*\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector;", "", "<init>", "()V", "kotlinxCoroutinesCoreName", "", "kotlinStdlibName", "kotlinxCoroutinesPackageName", "jarSeparator", "versionToCompareTo", "Lorg/apache/maven/artifact/versioning/DefaultArtifactVersion;", "kotlinxCoroutinesCoreJarRegex", "Lkotlin/text/Regex;", "attachCoroutineAgent", "", "project", "Lcom/intellij/openapi/project/Project;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "findKotlinxCoroutinesCoreJar", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector$KotlinxCoroutinesSearchResult;", "getJarVirtualFiles", "", "packageName", "getParentJarPath", "determineCoreVersionMode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;", "version", "initializeCoroutineAgent", "jarPath", "KotlinxCoroutinesSearchResult", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutineAgentConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineAgentConnector.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n11476#2,9:109\n13402#2:118\n13403#2:120\n11485#2:121\n1#3:119\n774#4:122\n865#4,2:123\n1863#4,2:125\n*S KotlinDebug\n*F\n+ 1 CoroutineAgentConnector.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector\n*L\n71#1:109,9\n71#1:118\n71#1:120\n71#1:121\n71#1:119\n96#1:122\n96#1:123,2\n96#1:125,2\n*E\n"})
public final class CoroutineAgentConnector {
    @NotNull
    public static final CoroutineAgentConnector INSTANCE = new CoroutineAgentConnector();
    @NotNull
    private static final String kotlinxCoroutinesCoreName = "kotlinx-coroutines-core";
    @NotNull
    private static final String kotlinStdlibName = "kotlin-stdlib";
    @NotNull
    private static final String kotlinxCoroutinesPackageName = "kotlinx.coroutines.debug";
    @NotNull
    private static final String jarSeparator = "!/";
    @NotNull
    private static final DefaultArtifactVersion versionToCompareTo = new DefaultArtifactVersion("1.3.7-255");
    @NotNull
    private static final Regex kotlinxCoroutinesCoreJarRegex = new Regex(".+\\Wkotlinx-coroutines-core(-jvm)?-(\\d[\\w.\\-]+)?\\.jar");

    private CoroutineAgentConnector() {
    }

    public final boolean attachCoroutineAgent(@NotNull Project project, @NotNull JavaParameters params, @Nullable RunConfigurationBase<?> configuration2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        KotlinxCoroutinesSearchResult searchResult = this.findKotlinxCoroutinesCoreJar(project, configuration2);
        if (searchResult.getDebuggerMode() == CoroutineDebuggerMode.VERSION_1_3_8_AND_UP && searchResult.getJarPath() != null) {
            return this.initializeCoroutineAgent(params, searchResult.getJarPath());
        }
        return false;
    }

    private final KotlinxCoroutinesSearchResult findKotlinxCoroutinesCoreJar(Project project, RunConfigurationBase<?> configuration2) {
        MatchResult matchResult = (MatchResult)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.getJarVirtualFiles(project, configuration2, kotlinxCoroutinesPackageName)), CoroutineAgentConnector::findKotlinxCoroutinesCoreJar$lambda$0));
        if (matchResult == null || matchResult.getGroupValues().size() < 3) {
            return new KotlinxCoroutinesSearchResult(null, CoroutineDebuggerMode.DISABLED);
        }
        return new KotlinxCoroutinesSearchResult(matchResult.getValue(), this.determineCoreVersionMode((String)matchResult.getGroupValues().get(2)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getJarVirtualFiles(Project $this$getJarVirtualFiles, RunConfigurationBase<?> configuration2, String packageName) {
        void $this$mapNotNullTo$iv$iv;
        if (!(configuration2 instanceof ModuleBasedConfiguration)) {
            return CollectionsKt.emptyList();
        }
        Module module = ((ModuleBasedConfiguration)configuration2).getConfigurationModule().getModule();
        if (module == null || (module = module.getModuleRuntimeScope(configuration2 instanceof JavaTestConfigurationWithDiscoverySupport)) == null) {
            return CollectionsKt.emptyList();
        }
        Module scope = module;
        PsiPackage psiPackage = (PsiPackage)DumbModeUtils.runReadActionInSmartMode($this$getJarVirtualFiles, () -> CoroutineAgentConnector.getJarVirtualFiles$lambda$1($this$getJarVirtualFiles, packageName));
        if (psiPackage == null) {
            return CollectionsKt.emptyList();
        }
        PsiPackage kotlinxCoroutinesPackage = psiPackage;
        PsiDirectory[] psiDirectoryArray = kotlinxCoroutinesPackage.getDirectories((GlobalSearchScope)scope);
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
        Object[] $this$mapNotNull$iv = psiDirectoryArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            PsiDirectory it = (PsiDirectory)element$iv$iv;
            boolean bl2 = false;
            String string = it.getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (INSTANCE.getParentJarPath(string) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String getParentJarPath(String $this$getParentJarPath) {
        int i2 = StringsKt.indexOf$default((CharSequence)$this$getParentJarPath, (String)jarSeparator, (int)0, (boolean)false, (int)6, null);
        if (i2 != -1) {
            String string = $this$getParentJarPath.substring(0, i2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return null;
    }

    private final CoroutineDebuggerMode determineCoreVersionMode(String version) {
        return new DefaultArtifactVersion(version).compareTo((ArtifactVersion)versionToCompareTo) > 0 ? CoroutineDebuggerMode.VERSION_1_3_8_AND_UP : CoroutineDebuggerMode.DISABLED;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean initializeCoroutineAgent(JavaParameters params, String jarPath) {
        ParametersList parametersList = params.getVMParametersList();
        if (parametersList == null) {
            return false;
        }
        ParametersList vmParametersList = parametersList;
        vmParametersList.add("-javaagent:" + jarPath);
        if (params.isClasspathFile()) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            List list2 = params.getClassPath().getRootDirs();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRootDirs(...)");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)kotlinStdlibName, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                VirtualFileSystem fs;
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getFileSystem(), (String)"getFileSystem(...)");
                if (fs instanceof ArchiveFileSystem) {
                    VirtualFile virtualFile = ((ArchiveFileSystem)fs).getLocalByEntry(it);
                    string = virtualFile != null ? virtualFile.getPath() : null;
                } else {
                    string = it.getPath();
                }
                String path2 = string;
                it.putUserData(JdkUtil.AGENT_RUNTIME_CLASSPATH, (Object)path2);
            }
        }
        return true;
    }

    private static final MatchResult findKotlinxCoroutinesCoreJar$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return kotlinxCoroutinesCoreJarRegex.matchEntire((CharSequence)it);
    }

    private static final PsiPackage getJarVirtualFiles$lambda$1(Project $this_getJarVirtualFiles, String $packageName) {
        return JavaPsiFacade.getInstance((Project)$this_getJarVirtualFiles).findPackage($packageName);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector$KotlinxCoroutinesSearchResult;", "", "jarPath", "", "debuggerMode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;)V", "getJarPath", "()Ljava/lang/String;", "getDebuggerMode", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.jvm-debugger.coroutines"})
    private static final class KotlinxCoroutinesSearchResult {
        @Nullable
        private final String jarPath;
        @NotNull
        private final CoroutineDebuggerMode debuggerMode;

        public KotlinxCoroutinesSearchResult(@Nullable String jarPath, @NotNull CoroutineDebuggerMode debuggerMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)debuggerMode), (String)"debuggerMode");
            this.jarPath = jarPath;
            this.debuggerMode = debuggerMode;
        }

        @Nullable
        public final String getJarPath() {
            return this.jarPath;
        }

        @NotNull
        public final CoroutineDebuggerMode getDebuggerMode() {
            return this.debuggerMode;
        }

        @Nullable
        public final String component1() {
            return this.jarPath;
        }

        @NotNull
        public final CoroutineDebuggerMode component2() {
            return this.debuggerMode;
        }

        @NotNull
        public final KotlinxCoroutinesSearchResult copy(@Nullable String jarPath, @NotNull CoroutineDebuggerMode debuggerMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)debuggerMode), (String)"debuggerMode");
            return new KotlinxCoroutinesSearchResult(jarPath, debuggerMode);
        }

        public static /* synthetic */ KotlinxCoroutinesSearchResult copy$default(KotlinxCoroutinesSearchResult kotlinxCoroutinesSearchResult, String string, CoroutineDebuggerMode coroutineDebuggerMode, int n, Object object) {
            if ((n & 1) != 0) {
                string = kotlinxCoroutinesSearchResult.jarPath;
            }
            if ((n & 2) != 0) {
                coroutineDebuggerMode = kotlinxCoroutinesSearchResult.debuggerMode;
            }
            return kotlinxCoroutinesSearchResult.copy(string, coroutineDebuggerMode);
        }

        @NotNull
        public String toString() {
            return "KotlinxCoroutinesSearchResult(jarPath=" + this.jarPath + ", debuggerMode=" + this.debuggerMode + ")";
        }

        public int hashCode() {
            int result2 = this.jarPath == null ? 0 : this.jarPath.hashCode();
            result2 = result2 * 31 + this.debuggerMode.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KotlinxCoroutinesSearchResult)) {
                return false;
            }
            KotlinxCoroutinesSearchResult kotlinxCoroutinesSearchResult = (KotlinxCoroutinesSearchResult)other;
            if (!Intrinsics.areEqual((Object)this.jarPath, (Object)kotlinxCoroutinesSearchResult.jarPath)) {
                return false;
            }
            return this.debuggerMode == kotlinxCoroutinesSearchResult.debuggerMode;
        }
    }
}

