/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.ExternalExpressionEvaluator;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.BitUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.eval4j.AbnormalTermination;
import org.jetbrains.eval4j.AbstractValue;
import org.jetbrains.eval4j.Eval4JIllegalArgumentException;
import org.jetbrains.eval4j.Eval4JIllegalStateException;
import org.jetbrains.eval4j.Eval4JInterpretingException;
import org.jetbrains.eval4j.ExceptionThrown;
import org.jetbrains.eval4j.InterpreterLoopKt;
import org.jetbrains.eval4j.InterpreterResult;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValueReturned;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JDIEval;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.idea.base.util.KotlinPlatformUtils;
import org.jetbrains.kotlin.idea.base.util.caching.ConcurrentFactoryCache;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.BaseExecutionContext;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.IncorrectCodeFragmentException;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentCompiler;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentCompilerKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluatorStatisticsCollector;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluatorStatisticsCollectorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerSessionRefreshTracker;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.StatisticsEvaluationResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoadKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCodegenException;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCodegenExceptionKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompilationCodeFragmentResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentData;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentDataKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.FailedCompilationCodeFragment;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.CompilingEvaluatorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.VariableFinder;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 52\u00020\u00012\u00020\u0002:\u000245B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u0010H\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u0010H\u0002J\"\u0010\"\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H\u0002J\"\u0010%\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002JI\u0010\u001e\u001a\u0002H'\"\u0004\b\u0000\u0010'2\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010$2\u001a\u0010(\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001a\u0012\u0004\u0012\u0002H'0)H\u0002\u00a2\u0006\u0002\u0010*J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J \u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001a2\u0006\u00102\u001a\u0002032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator;", "Lcom/intellij/debugger/engine/evaluation/expression/Evaluator;", "Lcom/intellij/debugger/engine/evaluation/expression/ExternalExpressionEvaluator;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lcom/intellij/debugger/SourcePosition;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "evaluate", "", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "evaluateSafe", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "extractStandardExceptionFromInvocation", "", "cause", "", "checkCauseOfEvaluateException", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/StatisticsEvaluationResult;", "hasCast", "", "prepareBytecodes", "", "Lkotlin/Pair;", "compiledData", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData;", "runEvaluation", "Lcom/sun/jdi/Value;", "getCompiledCodeFragment", "compileCodeFragment", "evaluateWithCompilation", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "evaluateWithEval4J", "Lorg/jetbrains/eval4j/InterpreterResult;", "T", "block", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData;Lcom/sun/jdi/ClassLoaderReference;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "updateLocalVariableValue", "", "converter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter;", "ref", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$RefWrapper;", "calculateMainMethodCallArguments", "variableFinder", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder;", "OnRefreshCachedValueProvider", "Companion", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nKotlinEvaluatorBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinEvaluatorBuilder.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,604:1\n73#2:605\n81#2:606\n1#3:607\n230#4,2:608\n774#4:610\n865#4,2:611\n1863#4,2:613\n1557#4:615\n1628#4,3:616\n626#4,12:619\n1557#4:631\n1628#4,3:632\n1755#4,3:635\n*S KotlinDebug\n*F\n+ 1 KotlinEvaluatorBuilder.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator\n*L\n166#1:605\n194#1:606\n346#1:608,2\n419#1:610\n419#1:611,2\n420#1:613,2\n460#1:615\n460#1:616,3\n332#1:619,12\n392#1:631\n392#1:632,3\n470#1:635,3\n*E\n"})
public final class KotlinEvaluator
implements Evaluator,
ExternalExpressionEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtCodeFragment codeFragment;
    @Nullable
    private final SourcePosition sourcePosition;
    private static boolean LOG_COMPILATIONS;
    @NotNull
    private static final List<String> DEFAULT_METHOD_MARKERS;

    public KotlinEvaluator(@NotNull KtCodeFragment codeFragment, @Nullable SourcePosition sourcePosition) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        this.codeFragment = codeFragment;
        this.sourcePosition = sourcePosition;
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @Nullable
    public Object evaluate(@NotNull EvaluationContextImpl context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = this.codeFragment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() == 0) {
            return context.getSuspendContext().getVirtualMachineProxy().mirrorOfVoid();
        }
        if (!context.getDebugProcess().isAttached()) {
            throw EvaluateExceptionUtil.PROCESS_EXITED;
        }
        StackFrameProxyImpl stackFrameProxyImpl = context.getFrameProxy();
        if (stackFrameProxyImpl == null) {
            KotlinEvaluator $this$evaluate_u24lambda_u240 = this;
            boolean bl = false;
            throw EvaluateExceptionUtil.NULL_STACK_FRAME;
        }
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        ThreadReferenceProxyImpl threadReferenceProxyImpl = context.getSuspendContext().getThread();
        if (threadReferenceProxyImpl == null) {
            KotlinEvaluator $this$evaluate_u24lambda_u241 = this;
            boolean bl = false;
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.thread.unavailable", new Object[0]));
            throw new KotlinNothingValueException();
        }
        ThreadReferenceProxyImpl operatingThread = threadReferenceProxyImpl;
        if (!operatingThread.isSuspended()) {
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.thread.not.suspended", new Object[0]));
            throw new KotlinNothingValueException();
        }
        try {
            ExecutionContext executionContext = new ExecutionContext(context, frameProxy);
            return this.evaluateSafe(executionContext);
        }
        catch (CodeFragmentCodegenException e) {
            KotlinEvaluatorBuilderKt.evaluationException(e.getReason());
            throw new KotlinNothingValueException();
        }
        catch (EvaluateException e) {
            throw e;
        }
        catch (IndexNotReadyException e) {
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.dumb.mode", new Object[0]));
            throw new KotlinNothingValueException();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Eval4JInterpretingException e) {
            KotlinEvaluatorBuilderKt.evaluationException(e.getCause());
            throw new KotlinNothingValueException();
        }
        catch (Exception e) {
            boolean isSpecialException = KotlinEvaluatorBuilderKt.access$isSpecialException(e);
            if (isSpecialException) {
                KotlinEvaluatorBuilderKt.evaluationException(e);
                throw new KotlinNothingValueException();
            }
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = KotlinDebuggerEvaluationBundle.message("error.exception.occurred", new Object[0]);
            }
            KotlinEvaluatorBuilderKt.access$reportError(this.codeFragment, this.sourcePosition, string2, e);
            String cause = e.getMessage() != null ? ": " + e.getMessage() : "";
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.evaluate", new Object[0]) + cause);
            throw new KotlinNothingValueException();
        }
    }

    private final Object evaluateSafe(ExecutionContext context) {
        Object object;
        boolean hasCast = KotlinCodeFragmentCompilerKt.hasCastOperator(this.codeFragment);
        try {
            object = this.getCompiledCodeFragment(context);
        }
        catch (Throwable e) {
            if (!(e instanceof ProcessCanceledException)) {
                Throwable throwable = e;
                StatisticsEvaluationResult evaluationResultValue = throwable instanceof IncorrectCodeFragmentException ? StatisticsEvaluationResult.COMPILATION_FAILURE : (throwable instanceof EvaluateException ? StatisticsEvaluationResult.COMPILER_INTERNAL_ERROR : StatisticsEvaluationResult.UNCLASSIFIED_COMPILATION_PROBLEM);
                KotlinDebuggerEvaluatorStatisticsCollector.logEvaluationResult$kotlin_jvm_debugger_evaluation$default(this.codeFragment.getProject(), evaluationResultValue, KotlinCodeFragmentCompiler.Companion.getInstance().getCompilerType(), KotlinDebuggerEvaluatorStatisticsCollectorKt.getOrigin(context.getEvaluationContext()), null, 16, null);
            }
            throw e;
        }
        CompiledCodeFragmentData compiledData = object;
        try {
            Object it = object = this.runEvaluation(context, compiledData);
            boolean bl = false;
            if (!compiledData.getStatisticReported()) {
                compiledData.setStatisticReported(true);
                KotlinDebuggerEvaluatorStatisticsCollector.logEvaluationResult$kotlin_jvm_debugger_evaluation$default(this.codeFragment.getProject(), StatisticsEvaluationResult.SUCCESS, compiledData.getCompilerType(), KotlinDebuggerEvaluatorStatisticsCollectorKt.getOrigin(context.getEvaluationContext()), null, 16, null);
            }
        }
        catch (Throwable e) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                StatisticsEvaluationResult errorType;
                Throwable cause = e.getCause();
                StatisticsEvaluationResult statisticsEvaluationResult = e instanceof ControlFlowException || e instanceof IndexNotReadyException ? StatisticsEvaluationResult.UNRELATED_EXCEPTION : (e instanceof LinkageError || e instanceof Eval4JIllegalArgumentException || e instanceof Eval4JIllegalStateException ? StatisticsEvaluationResult.MISCOMPILED : (e instanceof Eval4JInterpretingException ? (!hasCast && ((Eval4JInterpretingException)e).getCause() instanceof ClassCastException ? StatisticsEvaluationResult.MISCOMPILED : StatisticsEvaluationResult.USER_EXCEPTION) : (e instanceof EvaluateException && cause != null ? this.checkCauseOfEvaluateException(cause, hasCast) : (e instanceof EvaluateException ? StatisticsEvaluationResult.UNSUPPORTED_CALL : (errorType = KotlinEvaluatorBuilderKt.access$isSpecialException(e) ? StatisticsEvaluationResult.WRONG_JVM_STATE : StatisticsEvaluationResult.UNCLASSIFIED_EVALUATION_PROBLEM)))));
                if (!compiledData.getStatisticReported()) {
                    if (errorType != StatisticsEvaluationResult.UNRELATED_EXCEPTION && errorType != StatisticsEvaluationResult.WRONG_JVM_STATE) {
                        compiledData.setStatisticReported(true);
                    }
                    KotlinDebuggerEvaluatorStatisticsCollector.logEvaluationResult$kotlin_jvm_debugger_evaluation(this.codeFragment.getProject(), errorType, compiledData.getCompilerType(), KotlinDebuggerEvaluatorStatisticsCollectorKt.getOrigin(context.getEvaluationContext()), this.extractStandardExceptionFromInvocation(cause));
                }
                boolean $i$f$isApplicationInternalMode = false;
                if (ApplicationManager.getApplication().isInternal()) {
                    CodeFragmentCodegenExceptionKt.reportErrorWithAttachments(context, this.codeFragment, e, this.prepareBytecodes(compiledData), "Can't perform evaluation: " + errorType + ". Compiled by " + compiledData.getCompilerType() + " compiler");
                }
            }
            throw e;
        }
        return object;
    }

    private final String extractStandardExceptionFromInvocation(Throwable cause) {
        String string;
        String string2;
        com.sun.jdi.Type type2;
        ObjectReference objectReference;
        InvocationException invocationException;
        InvocationException invocationException2 = invocationException = cause instanceof InvocationException ? (InvocationException)cause : null;
        if (invocationException != null && (objectReference = invocationException.exception()) != null && (type2 = objectReference.type()) != null && (string2 = type2.name()) != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = PluginInfoDetectorKt.hasStandardExceptionPrefix((String)it) ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    private final StatisticsEvaluationResult checkCauseOfEvaluateException(Throwable cause, boolean hasCast) {
        block9: {
            if (!(cause instanceof InvocationException)) break block9;
            try {
                com.sun.jdi.Type type2;
                block11: {
                    block10: {
                        ObjectReference exceptionFromCodeFragment = ((InvocationException)cause).exception();
                        type2 = exceptionFromCodeFragment.type();
                        if (type2.signature().equals("Ljava/lang/IllegalArgumentException;") && Intrinsics.areEqual((Object)DebuggerUtils.tryExtractExceptionMessage((ObjectReference)exceptionFromCodeFragment), (Object)"argument type mismatch")) {
                            return StatisticsEvaluationResult.MISCOMPILED;
                        }
                        String string = type2.signature();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signature(...)");
                        if (StringsKt.startsWith$default((String)string, (String)"Ljava/lang/invoke/", (boolean)false, (int)2, null)) break block10;
                        Intrinsics.checkNotNull((Object)type2);
                        if (!CoroutineUtilsKt.isSubTypeOrSame(type2, "java.lang.ReflectiveOperationException") && !CoroutineUtilsKt.isSubTypeOrSame(type2, "java.lang.LinkageError")) break block11;
                    }
                    return StatisticsEvaluationResult.MISCOMPILED;
                }
                if (CoroutineUtilsKt.isSubTypeOrSame(type2, "java.lang.ClassCastException")) {
                    return hasCast ? StatisticsEvaluationResult.USER_EXCEPTION : StatisticsEvaluationResult.MISCOMPILED;
                }
            }
            catch (Throwable e) {
                KotlinEvaluatorBuilderKt.getLOG().error("Can't extract error type from InvocationException", e);
                return StatisticsEvaluationResult.ERROR_DURING_PARSING_EXCEPTION;
            }
            return StatisticsEvaluationResult.USER_EXCEPTION;
        }
        if (KotlinEvaluatorBuilderKt.access$isSpecialException(cause)) {
            return StatisticsEvaluationResult.WRONG_JVM_STATE;
        }
        return StatisticsEvaluationResult.MISCOMPILED;
    }

    private final List<Pair<String, String>> prepareBytecodes(CompiledCodeFragmentData compiledData) {
        StringBuilder stringBuilder;
        StringBuilder $this$prepareBytecodes_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (ClassToLoad classToLoad : compiledData.getClasses()) {
            String className = classToLoad.component1();
            String relativeFileName = classToLoad.component2();
            byte[] bytes = classToLoad.component3();
            $this$prepareBytecodes_u24lambda_u244.append("Bytecode for " + className + " in " + relativeFileName + ":").append('\n');
            $this$prepareBytecodes_u24lambda_u244.append(ArraysKt.joinToString$default((byte[])bytes, null, null, null, (int)0, null, null, (int)63, null)).append('\n');
            $this$prepareBytecodes_u24lambda_u244.append('\n');
        }
        String result2 = stringBuilder.toString();
        return CollectionsKt.listOf((Object)TuplesKt.to((Object)"bytecodes.txt", (Object)result2));
    }

    private final com.sun.jdi.Value runEvaluation(ExecutionContext context, CompiledCodeFragmentData compiledData) {
        InterpreterResult interpreterResult;
        Object classLoadingResult = CompilingEvaluatorKt.loadClassesSafely(context, (Collection<ClassToLoad>)compiledData.getClasses());
        ClassLoaderReference classLoaderRef = (ClassLoaderReference)(Result.isFailure-impl((Object)classLoadingResult) ? null : classLoadingResult);
        if (classLoaderRef != null) {
            try {
                return this.evaluateWithCompilation(context, compiledData, classLoaderRef);
            }
            catch (Throwable original) {
                InterpreterResult interpreterResult2;
                if (original instanceof CancellationException) {
                    throw original;
                }
                try {
                    InterpreterResult it = interpreterResult2 = this.evaluateWithEval4J(context, compiledData, classLoaderRef);
                    boolean bl = false;
                    CodeFragmentCodegenExceptionKt.reportErrorWithAttachments$default(context, this.codeFragment, original, null, "Eval4J success, but compiling evaluator failed with: ", 8, null);
                }
                catch (Throwable e) {
                    Throwable throwable;
                    Throwable it = throwable = original;
                    boolean bl = false;
                    ExceptionsKt.addSuppressed((Throwable)it, (Throwable)e);
                    throw throwable;
                }
                interpreterResult = interpreterResult2;
            }
        } else {
            interpreterResult = this.evaluateWithEval4J(context, compiledData, context.getClassLoader());
        }
        InterpreterResult result2 = interpreterResult;
        return KotlinEvaluator.Companion.toJdiValue(result2, context);
    }

    private final CompiledCodeFragmentData getCompiledCodeFragment(ExecutionContext context) {
        CompilationCodeFragmentResult result2;
        StringBuilder stringBuilder;
        ConcurrentFactoryCache cache2 = (ConcurrentFactoryCache)ActionsKt.runReadAction(() -> KotlinEvaluator.getCompiledCodeFragment$lambda$7(this, context));
        if (cache2 == null) {
            return this.compileCodeFragment(context);
        }
        StringBuilder $this$getCompiledCodeFragment_u24lambda_u248 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getCompiledCodeFragment_u24lambda_u248.append(this.codeFragment.importsToString()).append('\n');
        $this$getCompiledCodeFragment_u24lambda_u248.append(this.codeFragment.getText());
        String key = stringBuilder.toString();
        CompilationCodeFragmentResult compilationCodeFragmentResult = result2 = (CompilationCodeFragmentResult)cache2.get(key, arg_0 -> KotlinEvaluator.getCompiledCodeFragment$lambda$9(this, context, arg_0));
        if (compilationCodeFragmentResult instanceof CompiledCodeFragmentData) {
            return (CompiledCodeFragmentData)result2;
        }
        if (compilationCodeFragmentResult instanceof FailedCompilationCodeFragment) {
            throw ((FailedCompilationCodeFragment)result2).getEvaluateException();
        }
        throw new NoWhenBranchMatchedException();
    }

    private final CompiledCodeFragmentData compileCodeFragment(ExecutionContext context) {
        try {
            return KotlinCodeFragmentCompiler.Companion.getInstance().compileCodeFragment(context, this.codeFragment);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
    }

    private final com.sun.jdi.Value evaluateWithCompilation(ExecutionContext context, CompiledCodeFragmentData compiledData, ClassLoaderReference classLoader) {
        return (com.sun.jdi.Value)this.runEvaluation(context, compiledData, classLoader, arg_0 -> KotlinEvaluator.evaluateWithCompilation$lambda$11(context, classLoader, arg_0));
    }

    private final InterpreterResult evaluateWithEval4J(ExecutionContext context, CompiledCodeFragmentData compiledData, ClassLoaderReference classLoader) {
        Object element$iv2;
        boolean mayRetry;
        block2: {
            ClassNode classNode;
            mayRetry = context.getEvaluationContext().isMayRetryEvaluation();
            byte[] mainClassBytecode = CompiledCodeFragmentDataKt.getMainClass(compiledData).getBytes();
            ClassNode $this$evaluateWithEval4J_u24lambda_u2412 = classNode = new ClassNode();
            boolean bl = false;
            new ClassReader(mainClassBytecode).accept((ClassVisitor)$this$evaluateWithEval4J_u24lambda_u2412, 0);
            ClassNode mainClassAsmNode = classNode;
            List list2 = mainClassAsmNode.methods;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"methods");
            Iterable $this$first$iv = list2;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MethodNode it = (MethodNode)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!ClassToLoadKt.isEvaluationEntryPoint(it)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        MethodNode mainMethod = (MethodNode)element$iv2;
        ClassLoaderReference classLoaderReference = classLoader;
        if (classLoaderReference == null) {
            classLoaderReference = context.getEvaluationContext().getClassLoader();
        }
        Object t = this.runEvaluation(context, compiledData, classLoaderReference, arg_0 -> KotlinEvaluator.evaluateWithEval4J$lambda$18(context, mayRetry, classLoader, mainMethod, arg_0));
        Intrinsics.checkNotNullExpressionValue(t, (String)"runEvaluation(...)");
        return (InterpreterResult)t;
    }

    private final <T> T runEvaluation(ExecutionContext context, CompiledCodeFragmentData compiledData, ClassLoaderReference classLoader, Function1<? super List<? extends com.sun.jdi.Value>, ? extends T> block) {
        Iterator<Type> $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = compiledData.getClasses();
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            ClassToLoad it = (ClassToLoad)element$iv$iv;
            boolean bl = false;
            if (!(!it.isMainClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Object element$iv = $this$filterTo$iv$iv.next();
            ClassToLoad it = (ClassToLoad)element$iv;
            boolean bl = false;
            context.findClass(it.getClassName(), classLoader);
        }
        for (Type parameterType : compiledData.getMainMethodSignature().getParameterTypes()) {
            context.findClass(parameterType, classLoader);
        }
        VariableFinder variableFinder = new VariableFinder(context);
        List<com.sun.jdi.Value> args = this.calculateMainMethodCallArguments(variableFinder, compiledData);
        Object result2 = block.invoke(args);
        for (VariableFinder.RefWrapper wrapper : variableFinder.getRefWrappers()) {
            this.updateLocalVariableValue(variableFinder.getEvaluatorValueConverter(), wrapper);
        }
        return (T)result2;
    }

    private final void updateLocalVariableValue(EvaluatorValueConverter converter, VariableFinder.RefWrapper ref) {
        StackFrameProxyImpl frameProxy = converter.getContext().getFrameProxy();
        com.sun.jdi.Value newValue = EvaluatorValueConverter.Companion.unref(ref.getWrapper());
        LocalVariableProxyImpl variable = SafeUtilKt.safeVisibleVariableByName(frameProxy, ref.getLocalVariableName());
        if (variable != null) {
            try {
                frameProxy.setValue(variable, newValue);
            }
            catch (InvalidTypeException e) {
                com.sun.jdi.Value value = newValue;
                KotlinEvaluatorBuilderKt.getLOG().error("Cannot update local variable value: expected type " + variable.getType() + ", actual type " + (value != null ? value.type() : null), (Throwable)e);
            }
        } else if (frameProxy instanceof CoroutineStackFrameProxyImpl) {
            ((CoroutineStackFrameProxyImpl)frameProxy).updateSpilledVariableValue(ref.getLocalVariableName(), newValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<com.sun.jdi.Value> calculateMainMethodCallArguments(VariableFinder variableFinder, CompiledCodeFragmentData compiledData) {
        void $this$mapTo$iv$iv;
        List<Type> asmValueParameters = compiledData.getMainMethodSignature().getParameterTypes();
        List<CodeFragmentParameter.Dumb> valueParameters = compiledData.getParameters();
        if (!(asmValueParameters.size() == valueParameters.size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List args = CollectionsKt.zip((Iterable)valueParameters, (Iterable)asmValueParameters);
        Iterable $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Type asmType;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CodeFragmentParameter.Dumb parameter = (CodeFragmentParameter.Dumb)pair.component1();
            VariableFinder.Result result2 = variableFinder.find(parameter, asmType = (Type)pair.component2(), this.codeFragment);
            if (result2 == null) {
                String name2 = parameter.getDebugString();
                StackFrameProxyImpl frameProxy = variableFinder.getContext().getFrameProxy();
                if (parameter.getKind() == CodeFragmentParameter.Kind.COROUTINE_CONTEXT) {
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.coroutine.context.unavailable", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                if (compiledData.getCrossingBounds().contains(parameter)) {
                    Object[] objectArray = new Object[]{name2};
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.not.captured", objectArray));
                    throw new KotlinNothingValueException();
                }
                if (parameter.getKind() == CodeFragmentParameter.Kind.FIELD_VAR) {
                    Object[] objectArray = new Object[]{parameter.getName()};
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.find.backing.field", objectArray));
                    throw new KotlinNothingValueException();
                }
                if (parameter.getKind() == CodeFragmentParameter.Kind.ORDINARY && KotlinEvaluator.calculateMainMethodCallArguments$lambda$22$isInsideDefaultInterfaceMethod(frameProxy)) {
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.parameter.evaluation.default.methods", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                if (parameter.getKind() == CodeFragmentParameter.Kind.ORDINARY && frameProxy instanceof CoroutineStackFrameProxyImpl) {
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.variable.was.optimised", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                Object[] objectArray = new Object[]{name2, asmType.getClassName()};
                KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.find.variable", objectArray));
                throw new KotlinNothingValueException();
            }
            collection.add(result2.getValue());
        }
        return (List)destination$iv$iv;
    }

    private static final ConcurrentFactoryCache getCompiledCodeFragment$lambda$7(KotlinEvaluator this$0, ExecutionContext $context) {
        PsiElement psiElement = this$0.codeFragment.getContext();
        if (psiElement == null) {
            return null;
        }
        PsiElement contextElement = psiElement;
        return (ConcurrentFactoryCache)CachedValuesManager.getCachedValue((PsiElement)contextElement, (CachedValueProvider)new OnRefreshCachedValueProvider($context.getProject()));
    }

    private static final CompilationCodeFragmentResult getCompiledCodeFragment$lambda$9(KotlinEvaluator this$0, ExecutionContext $context, String it) {
        CompilationCodeFragmentResult compilationCodeFragmentResult;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            compilationCodeFragmentResult = this$0.compileCodeFragment($context);
        }
        catch (EvaluateException e) {
            compilationCodeFragmentResult = new FailedCompilationCodeFragment(e);
        }
        return compilationCodeFragmentResult;
    }

    private static final com.sun.jdi.Value evaluateWithCompilation$lambda$11(ExecutionContext $context, ClassLoaderReference $classLoader, List args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ReferenceType referenceType = $context.findClass("Generated_for_debugger_class", $classLoader);
        ClassType classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
        if (classType == null) {
            throw new IllegalStateException("Can not find class \"Generated_for_debugger_class\"".toString());
        }
        ClassType mainClassType = classType;
        List<Method> list2 = mainClassType.methods();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"methods(...)");
        Iterable $this$single$iv = list2;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            Method it = (Method)element$iv;
            boolean bl = false;
            String string = it.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
            if (!ClassToLoadKt.isEvaluationEntryPoint(string)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Method mainMethod = single$iv;
        BaseExecutionContext baseExecutionContext = $context;
        Intrinsics.checkNotNull((Object)mainMethod);
        com.sun.jdi.Value returnValue = BaseExecutionContext.invokeMethod$default(baseExecutionContext, mainClassType, mainMethod, args, false, 8, null);
        return EvaluatorValueConverter.Companion.unref(returnValue);
    }

    /*
     * WARNING - void declaration
     */
    private static final InterpreterResult evaluateWithEval4J$lambda$18$interpreterLoop(MethodNode mainMethod, List<? extends com.sun.jdi.Value> $args, evaluateWithEval4J.1.eval.1 eval2) {
        Collection<Value> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNull((Object)mainMethod);
        Iterable iterable = $args;
        MethodNode methodNode = mainMethod;
        MethodNode methodNode2 = mainMethod;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            com.sun.jdi.Value value = (com.sun.jdi.Value)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JdiValuesKt.asValue((com.sun.jdi.Value)it));
        }
        collection = (List)destination$iv$iv;
        return InterpreterLoopKt.interpreterLoop$default(methodNode2, JdiValuesKt.makeInitialFrame(methodNode, (List<? extends Value>)collection), eval2, null, 8, null);
    }

    private static final void evaluateWithEval4J$lambda$18$keepResult(ExecutionContext $context, InterpreterResult result2) {
        Value value;
        InterpreterResult interpreterResult = result2;
        if (interpreterResult instanceof ValueReturned) {
            value = ((ValueReturned)result2).getResult();
        } else if (interpreterResult instanceof ExceptionThrown) {
            value = ((ExceptionThrown)result2).getException();
        } else {
            return;
        }
        Object object = ValuesKt.obj$default(value, null, 1, null);
        ObjectReference objectReference = object instanceof ObjectReference ? (ObjectReference)object : null;
        if (objectReference == null) {
            return;
        }
        ObjectReference jdiObject = objectReference;
        $context.getEvaluationContext().keep((com.sun.jdi.Value)jdiObject);
    }

    private static final InterpreterResult evaluateWithEval4J$lambda$18$lambda$16(ExecutionContext $context, InterpreterResult it) {
        Intrinsics.checkNotNull((Object)it);
        KotlinEvaluator.evaluateWithEval4J$lambda$18$keepResult($context, it);
        return it;
    }

    private static final InterpreterResult evaluateWithEval4J$lambda$18$lambda$17(Function1 $tmp0, Object p0) {
        return (InterpreterResult)$tmp0.invoke(p0);
    }

    private static final InterpreterResult evaluateWithEval4J$lambda$18(ExecutionContext $context, boolean $mayRetry, ClassLoaderReference $classLoader, MethodNode $mainMethod, List args) {
        Object object;
        VirtualMachine vm;
        block3: {
            block2: {
                Object object2;
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                VirtualMachine virtualMachine = $context.getVm().getVirtualMachine();
                Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"getVirtualMachine(...)");
                vm = virtualMachine;
                object = $context.getSuspendContext().getThread();
                if (object == null || (object = object.getThreadReference()) == null) break block2;
                Object it = object2 = object;
                boolean bl = false;
                object = it.isSuspended() ? object2 : null;
                if (object != null) break block3;
            }
            throw new IllegalStateException("Can not find a thread to run evaluation on".toString());
        }
        Object thread = object;
        int n = $context.getInvokePolicy();
        JDIEval eval2 = new JDIEval(vm, $classLoader, (ThreadReference)thread, $context, n){
            final /* synthetic */ ExecutionContext $context;
            {
                this.$context = $context;
                super($vm, $classLoader, $thread, $super_call_param$1);
            }

            public com.sun.jdi.Value jdiInvokeStaticMethod(ClassType type2, Method method, List<? extends com.sun.jdi.Value> args, int invokePolicy) {
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                Intrinsics.checkNotNullParameter(args, (String)"args");
                return BaseExecutionContext.invokeMethod$default(this.$context, type2, method, args, false, 8, null);
            }

            public com.sun.jdi.Value jdiInvokeStaticMethod(InterfaceType type2, Method method, List<? extends com.sun.jdi.Value> args, int invokePolicy) {
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                Intrinsics.checkNotNullParameter(args, (String)"args");
                return this.$context.invokeMethod(type2, method, args);
            }

            public com.sun.jdi.Value jdiInvokeMethod(ObjectReference obj, Method method, List<? extends com.sun.jdi.Value> args, int policy) {
                Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                Intrinsics.checkNotNullParameter(args, (String)"args");
                int invocationOptions = 0;
                if (BitUtil.isSet((int)policy, (int)2)) {
                    invocationOptions = 2;
                }
                return BaseExecutionContext.invokeMethod$default(this.$context, obj, method, args, invocationOptions, false, 16, null);
            }

            public com.sun.jdi.Value jdiNewInstance(ClassType clazz, Method ctor, List<? extends com.sun.jdi.Value> args, int policy) {
                Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
                Intrinsics.checkNotNullParameter((Object)ctor, (String)"ctor");
                Intrinsics.checkNotNullParameter(args, (String)"args");
                return this.$context.newInstance(clazz, ctor, args);
            }

            public StringReference jdiMirrorOfString(String str) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                StringReference stringReference = DebuggerUtilsEx.mirrorOfString((String)str, (EvaluationContext)((EvaluationContext)this.$context.getEvaluationContext()));
                Intrinsics.checkNotNullExpressionValue((Object)stringReference, (String)"mirrorOfString(...)");
                return stringReference;
            }

            public ArrayReference jdiNewArray(ArrayType arrayType, int size) {
                Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
                ArrayReference arrayReference = DebuggerUtilsEx.mirrorOfArray((ArrayType)arrayType, (int)size, (EvaluationContext)((EvaluationContext)this.$context.getEvaluationContext()));
                Intrinsics.checkNotNullExpressionValue((Object)arrayReference, (String)"mirrorOfArray(...)");
                return arrayReference;
            }

            public boolean shouldInvokeMethodWithReflection(Method method, List<? extends com.sun.jdi.Value> args) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                Intrinsics.checkNotNullParameter(args, (String)"args");
                return false;
            }

            public ReferenceType loadType(Type classType, ClassLoaderReference classLoader) {
                Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
                ReferenceType referenceType = this.$context.getDebugProcess().findClass((EvaluationContext)this.$context.getEvaluationContext(), classType.getClassName(), classLoader);
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"findClass(...)");
                return referenceType;
            }
        };
        return $mayRetry ? (InterpreterResult)DebuggerUtils.getInstance().processCollectibleValue((ThrowableComputable)new ThrowableComputable<InterpreterResult, EvaluateException>($mainMethod, (List<? extends com.sun.jdi.Value>)args, eval2){
            final /* synthetic */ MethodNode $mainMethod;
            final /* synthetic */ List<com.sun.jdi.Value> $args;
            final /* synthetic */ evaluateWithEval4J.1.eval.1 $eval;
            {
                this.$mainMethod = $mainMethod;
                this.$args = $args;
                this.$eval = $eval;
            }

            public InterpreterResult compute() {
                return KotlinEvaluator.access$evaluateWithEval4J$lambda$18$interpreterLoop(this.$mainMethod, this.$args, this.$eval);
            }
        }, arg_0 -> KotlinEvaluator.evaluateWithEval4J$lambda$18$lambda$17(arg_0 -> KotlinEvaluator.evaluateWithEval4J$lambda$18$lambda$16($context, arg_0), arg_0), (EvaluationContext)$context.getEvaluationContext()) : KotlinEvaluator.evaluateWithEval4J$lambda$18$interpreterLoop($mainMethod, args, eval2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean calculateMainMethodCallArguments$lambda$22$isInsideDefaultInterfaceMethod(StackFrameProxyImpl frameProxy) {
        String it;
        Location location = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
        Comparable<Location> comparable = location;
        if (location == null) return false;
        if ((comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) {
            return false;
        }
        Comparable<Location> method = comparable;
        String desc = method.signature();
        String string = method.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        if (!StringsKt.endsWith$default((String)string, (String)"$default", (boolean)false, (int)2, null)) return false;
        Iterable $this$any$iv = DEFAULT_METHOD_MARKERS;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)desc);
        } while (!StringsKt.contains$default((CharSequence)desc, (CharSequence)("IL" + it + ";)"), (boolean)false, (int)2, null));
        return true;
    }

    public static final /* synthetic */ InterpreterResult access$evaluateWithEval4J$lambda$18$interpreterLoop(MethodNode mainMethod, List $args, evaluateWithEval4J.1.eval.1 eval2) {
        return KotlinEvaluator.evaluateWithEval4J$lambda$18$interpreterLoop(mainMethod, $args, eval2);
    }

    static {
        Object[] objectArray = new String[]{"java/lang/Object", "kotlin/jvm/internal/DefaultConstructorMarker"};
        DEFAULT_METHOD_MARKERS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001c\u0010\u0004\u001a\u00020\u00058GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion;", "", "<init>", "()V", "LOG_COMPILATIONS", "", "getLOG_COMPILATIONS", "()Z", "setLOG_COMPILATIONS", "(Z)V", "logCompilation", "", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "DEFAULT_METHOD_MARKERS", "", "", "toJdiValue", "Lcom/sun/jdi/Value;", "Lorg/jetbrains/eval4j/InterpreterResult;", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "getValueIfSharedVar", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "value", "Lorg/jetbrains/eval4j/Value;", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        @ApiStatus.Internal
        public final boolean getLOG_COMPILATIONS() {
            return LOG_COMPILATIONS;
        }

        public final void setLOG_COMPILATIONS(boolean bl) {
            LOG_COMPILATIONS = bl;
        }

        public final void logCompilation(@NotNull KtCodeFragment codeFragment) {
            boolean needLog;
            Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
            boolean bl = needLog = this.getLOG_COMPILATIONS() && !Intrinsics.areEqual((Object)true, (Object)codeFragment.getUserData(KotlinPlatformUtils.getSuppressCodeFragmentCompilationLogging()));
            if (needLog) {
                KotlinEvaluatorBuilderKt.getLOG().debug("Compile bytecode for " + codeFragment.getText());
            }
        }

        private final com.sun.jdi.Value toJdiValue(InterpreterResult $this$toJdiValue, ExecutionContext context) {
            InterpreterResult interpreterResult = $this$toJdiValue;
            if (!(interpreterResult instanceof ValueReturned)) {
                if (interpreterResult instanceof ExceptionThrown) {
                    switch (WhenMappings.$EnumSwitchMapping$0[((ExceptionThrown)$this$toJdiValue).getKind().ordinal()]) {
                        case 1: {
                            Object v = ((ExceptionThrown)$this$toJdiValue).getException().getValue();
                            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
                            ObjectReference exceptionReference = (ObjectReference)v;
                            KotlinEvaluatorBuilderKt.evaluationException(new InvocationException(exceptionReference));
                            throw new KotlinNothingValueException();
                        }
                        case 2: {
                            Object v = ((ExceptionThrown)$this$toJdiValue).getException().getValue();
                            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Throwable");
                            throw (Throwable)v;
                        }
                    }
                    KotlinEvaluatorBuilderKt.evaluationException(((ExceptionThrown)$this$toJdiValue).getException().toString());
                    throw new KotlinNothingValueException();
                }
                if (interpreterResult instanceof AbnormalTermination) {
                    KotlinEvaluatorBuilderKt.evaluationException(((AbnormalTermination)$this$toJdiValue).getMessage());
                    throw new KotlinNothingValueException();
                }
                throw new IllegalStateException("Unknown result value produced by eval4j");
            }
            Value jdiValue = ((ValueReturned)$this$toJdiValue).getResult();
            VariableFinder.Result sharedVar = jdiValue instanceof AbstractValue ? this.getValueIfSharedVar(jdiValue) : null;
            Object object = sharedVar;
            if (object == null || (object = ((VariableFinder.Result)object).getValue()) == null) {
                VirtualMachine virtualMachine = context.getVm().getVirtualMachine();
                Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"getVirtualMachine(...)");
                object = JdiValuesKt.asJdiValue(jdiValue, virtualMachine, (Function0<Type>)((Function0)() -> Companion.toJdiValue$lambda$0(jdiValue)));
            }
            return object;
        }

        private final VariableFinder.Result getValueIfSharedVar(Value value) {
            Object object = ValuesKt.obj(value, (Function0<Type>)((Function0)() -> Companion.getValueIfSharedVar$lambda$1(value)));
            ObjectReference objectReference = object instanceof ObjectReference ? (ObjectReference)object : null;
            if (objectReference == null) {
                return null;
            }
            ObjectReference obj = objectReference;
            return new VariableFinder.Result(EvaluatorValueConverter.Companion.unref(obj));
        }

        private static final Type toJdiValue$lambda$0(Value $jdiValue) {
            return $jdiValue.getAsmType();
        }

        private static final Type getValueIfSharedVar$lambda$1(Value $value) {
            return $value.getAsmType();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ExceptionThrown.ExceptionKind.values().length];
                try {
                    nArray[ExceptionThrown.ExceptionKind.FROM_EVALUATED_CODE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExceptionThrown.ExceptionKind.BROKEN_CODE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$OnRefreshCachedValueProvider;", "Lcom/intellij/psi/util/CachedValueProvider;", "Lorg/jetbrains/kotlin/idea/base/util/caching/ConcurrentFactoryCache;", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompilationCodeFragmentResult;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "compute", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "kotlin.jvm-debugger.evaluation"})
    private static final class OnRefreshCachedValueProvider
    implements CachedValueProvider<ConcurrentFactoryCache<String, CompilationCodeFragmentResult>> {
        @NotNull
        private final Project project;

        public OnRefreshCachedValueProvider(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public CachedValueProvider.Result<ConcurrentFactoryCache<String, CompilationCodeFragmentResult>> compute() {
            ConcurrentHashMap storage = new ConcurrentHashMap();
            Object[] objectArray = new Object[]{KotlinDebuggerSessionRefreshTracker.Companion.getInstance(this.project)};
            return new CachedValueProvider.Result(new ConcurrentFactoryCache(storage), objectArray);
        }
    }
}

