/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.psi.sequence;

import com.intellij.debugger.streams.core.trace.impl.handler.type.ArrayType;
import com.intellij.debugger.streams.core.trace.impl.handler.type.ClassTypeImpl;
import com.intellij.debugger.streams.core.trace.impl.handler.type.GenericType;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.CallTypeExtractor;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.KotlinPsiUtil;
import org.jetbrains.kotlin.idea.debugger.sequence.trace.dsl.KotlinSequenceTypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/sequence/SequenceTypeExtractor;", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/CallTypeExtractor$Base;", "<init>", "()V", "extractItemsType", "Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getResultType", "tryToFindElementType", "defaultType", "Companion", "kotlin.jvm-debugger.sequence.k1"})
public final class SequenceTypeExtractor
extends CallTypeExtractor.Base {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    @NotNull
    protected GenericType extractItemsType(@Nullable KotlinType type2) {
        if (type2 == null) {
            return KotlinSequenceTypes.INSTANCE.getNULLABLE_ANY();
        }
        GenericType genericType = this.tryToFindElementType(type2);
        if (genericType == null) {
            genericType = this.defaultType(type2);
        }
        return genericType;
    }

    @Override
    @NotNull
    protected GenericType getResultType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        String typeName = KotlinPsiUtil.INSTANCE.getTypeWithoutTypeParameters(type2);
        GenericType genericType = KotlinSequenceTypes.INSTANCE.primitiveTypeByName(typeName);
        if (genericType == null) {
            ArrayType arrayType = KotlinSequenceTypes.INSTANCE.primitiveArrayByName(typeName);
            genericType = arrayType != null ? (GenericType)arrayType : (GenericType)new ClassTypeImpl(KotlinPsiUtil.INSTANCE.getTypeName(type2), null, 2, null);
        }
        return genericType;
    }

    private final GenericType tryToFindElementType(KotlinType type2) {
        String typeName = KotlinPsiUtil.INSTANCE.getTypeWithoutTypeParameters(type2);
        if (Intrinsics.areEqual((Object)typeName, (Object)"kotlin.sequences.Sequence")) {
            if (type2.getArguments().isEmpty()) {
                return KotlinSequenceTypes.INSTANCE.getNULLABLE_ANY();
            }
            KotlinType kotlinType = ((TypeProjection)CollectionsKt.single((List)type2.getArguments())).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            KotlinType itemsType = kotlinType;
            if (itemsType.isMarkedNullable()) {
                return KotlinSequenceTypes.INSTANCE.getNULLABLE_ANY();
            }
            GenericType primitiveType = KotlinSequenceTypes.INSTANCE.primitiveTypeByName(KotlinPsiUtil.INSTANCE.getTypeWithoutTypeParameters(itemsType));
            GenericType genericType = primitiveType;
            if (genericType == null) {
                genericType = KotlinSequenceTypes.INSTANCE.getANY();
            }
            return genericType;
        }
        return (GenericType)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)TypeUtilsKt.supertypes((KotlinType)type2)), (Function1)((Function1)new Function1<KotlinType, GenericType>((Object)this){

            public final GenericType invoke(KotlinType p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SequenceTypeExtractor.access$tryToFindElementType((SequenceTypeExtractor)this.receiver, p0);
            }
        })));
    }

    private final GenericType defaultType(KotlinType type2) {
        LOG.warn("Could not find type of items for type " + KotlinPsiUtil.INSTANCE.getTypeName(type2));
        return type2.isMarkedNullable() ? KotlinSequenceTypes.INSTANCE.getNULLABLE_ANY() : KotlinSequenceTypes.INSTANCE.getANY();
    }

    public static final /* synthetic */ GenericType access$tryToFindElementType(SequenceTypeExtractor $this, KotlinType type2) {
        return $this.tryToFindElementType(type2);
    }

    static {
        Logger logger = Logger.getInstance(SequenceTypeExtractor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/sequence/SequenceTypeExtractor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.jvm-debugger.sequence.k1"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

