/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.ByDescriptorIndexer;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfoUtils;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\u001a\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a(\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u000f"}, d2={"findDecompiledDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "project", "Lcom/intellij/openapi/project/Project;", "referencedDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "builtInsSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findInScope", "scope", "isLocal", "", "descriptor", "findCandidateDeclarationsInIndex", "", "kotlin.base.fe10.analysis"})
@SourceDebugExtension(value={"SMAP\nfindDecompiledDeclaration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 findDecompiledDeclaration.kt\norg/jetbrains/kotlin/idea/decompiler/navigation/FindDecompiledDeclarationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1#2:103\n1#2:106\n1619#3:104\n1863#3:105\n1864#3:107\n1620#3:108\n*S KotlinDebug\n*F\n+ 1 findDecompiledDeclaration.kt\norg/jetbrains/kotlin/idea/decompiler/navigation/FindDecompiledDeclarationKt\n*L\n55#1:106\n55#1:104\n55#1:105\n55#1:107\n55#1:108\n*E\n"})
public final class FindDecompiledDeclarationKt {
    @Nullable
    public static final KtDeclaration findDecompiledDeclaration(@NotNull Project project, @NotNull DeclarationDescriptor referencedDescriptor, @Nullable GlobalSearchScope builtInsSearchScope) {
        block8: {
            GlobalSearchScope globalSearchScope;
            block10: {
                block9: {
                    BinaryModuleInfo binaryInfo;
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)referencedDescriptor, (String)"referencedDescriptor");
                    if (ErrorUtils.isError((DeclarationDescriptor)referencedDescriptor)) {
                        return null;
                    }
                    if (FindDecompiledDeclarationKt.isLocal(referencedDescriptor)) {
                        return null;
                    }
                    if (referencedDescriptor instanceof PackageFragmentDescriptor || referencedDescriptor instanceof PackageViewDescriptor) {
                        return null;
                    }
                    Object object = DescriptorUtilsKt.getModule((DeclarationDescriptor)referencedDescriptor).getCapability(ModuleInfo.Companion.getCapability());
                    BinaryModuleInfo binaryModuleInfo = binaryInfo = object instanceof BinaryModuleInfo ? (BinaryModuleInfo)object : null;
                    if (binaryInfo != null && (object = IdeaModuleInfoUtils.getBinariesScope(binaryInfo)) != null) {
                        Object it = object;
                        boolean bl = false;
                        return FindDecompiledDeclarationKt.findInScope(referencedDescriptor, (GlobalSearchScope)it);
                    }
                    if (!KotlinBuiltIns.isBuiltIn((DeclarationDescriptor)referencedDescriptor)) break block8;
                    globalSearchScope = builtInsSearchScope;
                    if (globalSearchScope == null) break block9;
                    GlobalSearchScope it = globalSearchScope;
                    boolean bl = false;
                    KtDeclaration ktDeclaration = FindDecompiledDeclarationKt.findInScope(referencedDescriptor, it);
                    globalSearchScope = ktDeclaration;
                    if (ktDeclaration != null) break block10;
                }
                GlobalSearchScope globalSearchScope2 = GlobalSearchScope.allScope((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"allScope(...)");
                globalSearchScope = FindDecompiledDeclarationKt.findInScope(referencedDescriptor, globalSearchScope2);
                if (globalSearchScope == null) {
                    GlobalSearchScope globalSearchScope3 = GlobalSearchScope.everythingScope((Project)project);
                    Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"everythingScope(...)");
                    globalSearchScope = FindDecompiledDeclarationKt.findInScope(referencedDescriptor, globalSearchScope3);
                }
            }
            return globalSearchScope;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final KtDeclaration findInScope(DeclarationDescriptor referencedDescriptor, GlobalSearchScope scope) {
        void $this$mapNotNullTo$iv;
        Project project = scope.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        DeclarationDescriptor declarationDescriptor = referencedDescriptor.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getOriginal(...)");
        Iterable iterable = FindDecompiledDeclarationKt.findCandidateDeclarationsInIndex(declarationDescriptor, KotlinSourceFilterScope.Companion.libraryClasses(scope, project2), project2);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            KtDecompiledFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            KtDeclaration it = (KtDeclaration)element$iv;
            boolean bl2 = false;
            KtDeclaration ktDeclaration = it;
            Object object = ktDeclaration != null ? ktDeclaration.getContainingFile() : null;
            if ((object instanceof KtDecompiledFile ? (KtDecompiledFile)object : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        LinkedHashSet decompiledFiles = (LinkedHashSet)destination$iv;
        return (KtDeclaration)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)decompiledFiles), arg_0 -> FindDecompiledDeclarationKt.findInScope$lambda$3(referencedDescriptor, arg_0)));
    }

    private static final boolean isLocal(DeclarationDescriptor descriptor2) {
        boolean bl;
        if (descriptor2 instanceof ParameterDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((ParameterDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            bl = FindDecompiledDeclarationKt.isLocal(declarationDescriptor);
        } else {
            bl = DescriptorUtils.isLocal((DeclarationDescriptor)descriptor2);
        }
        return bl;
    }

    private static final Collection<KtDeclaration> findCandidateDeclarationsInIndex(DeclarationDescriptor referencedDescriptor, GlobalSearchScope scope, Project project) {
        Collection<Object> collection;
        DeclarationDescriptor topLevelDeclaration;
        ClassDescriptor containingClass = (ClassDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, ClassDescriptor.class, (boolean)false);
        if (containingClass != null) {
            return KotlinFullClassNameIndex.Helper.get(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)containingClass)).asString(), project, scope);
        }
        DeclarationDescriptor declarationDescriptor = DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, PropertyDescriptor.class, (boolean)false);
        if (declarationDescriptor == null) {
            TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = (TypeAliasConstructorDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, TypeAliasConstructorDescriptor.class, (boolean)false);
            Object object = typeAliasConstructorDescriptor != null ? typeAliasConstructorDescriptor.getTypeAliasDescriptor() : null;
            if (object != null) {
                declarationDescriptor = (DeclarationDescriptor)object;
            } else {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, FunctionDescriptor.class, (boolean)false);
                if (functionDescriptor != null) {
                    declarationDescriptor = (DeclarationDescriptor)functionDescriptor;
                } else {
                    TypeAliasDescriptor typeAliasDescriptor = (TypeAliasDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, TypeAliasDescriptor.class, (boolean)false);
                    if (typeAliasDescriptor != null) {
                        declarationDescriptor = (DeclarationDescriptor)typeAliasDescriptor;
                    } else {
                        return CollectionsKt.emptyList();
                    }
                }
            }
        }
        if (!DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)(topLevelDeclaration = declarationDescriptor))) {
            return CollectionsKt.emptyList();
        }
        String fqName2 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)topLevelDeclaration).asString();
        DeclarationDescriptor declarationDescriptor2 = topLevelDeclaration;
        if (declarationDescriptor2 instanceof FunctionDescriptor) {
            collection = KotlinTopLevelFunctionFqnNameIndex.Helper.get(fqName2, project, scope);
        } else if (declarationDescriptor2 instanceof PropertyDescriptor) {
            collection = KotlinTopLevelPropertyFqnNameIndex.Helper.get(fqName2, project, scope);
        } else if (declarationDescriptor2 instanceof TypeAliasDescriptor) {
            collection = KotlinTopLevelTypeAliasFqNameIndex.Helper.get(fqName2, project, scope);
        } else {
            throw new IllegalStateException(("Referenced non local declaration that is not inside top level function, property, class or typealias:\n " + referencedDescriptor).toString());
        }
        return collection;
    }

    private static final KtDeclaration findInScope$lambda$3(DeclarationDescriptor $referencedDescriptor, KtDecompiledFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ByDescriptorIndexer.INSTANCE.getDeclarationForDescriptor($referencedDescriptor, file);
    }
}

