/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.TrailingCommaUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.visitor.TrailingCommaVisitor;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.TrailingCommaPostFormatProcessorKt;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaContext;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaHelper;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaState;
import org.jetbrains.kotlin.idea.formatter.trailingComma.UtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u000e\u0010\b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/TrailingCommaPostFormatVisitor;", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/visitor/TrailingCommaVisitor;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "<init>", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "myPostProcessor", "Lcom/intellij/psi/impl/source/codeStyle/PostFormatProcessorHelper;", "process", "", "trailingCommaContext", "Lorg/jetbrains/kotlin/idea/formatter/trailingComma/TrailingCommaContext;", "processIfInRange", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "block", "Lkotlin/Function0;", "processCommaOwner", "updatePsi", "updater", "", "correctCommaPosition", "parent", "Lcom/intellij/psi/PsiElement;", "formatted", "processText", "Lcom/intellij/openapi/util/TextRange;", "source", "Lcom/intellij/psi/PsiFile;", "rangeToReformat", "Companion", "kotlin.code-insight.impl-base"})
@SourceDebugExtension(value={"SMAP\nTrailingCommaPostFormatProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrailingCommaPostFormatProcessor.kt\norg/jetbrains/kotlin/idea/formatter/TrailingCommaPostFormatVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1557#2:145\n1628#2,3:146\n*S KotlinDebug\n*F\n+ 1 TrailingCommaPostFormatProcessor.kt\norg/jetbrains/kotlin/idea/formatter/TrailingCommaPostFormatVisitor\n*L\n98#1:145\n98#1:146,3\n*E\n"})
final class TrailingCommaPostFormatVisitor
extends TrailingCommaVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeStyleSettings settings;
    @NotNull
    private final PostFormatProcessorHelper myPostProcessor;
    @NotNull
    private static final Logger LOG;

    public TrailingCommaPostFormatVisitor(@NotNull CodeStyleSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        this.settings = settings2;
        this.myPostProcessor = new PostFormatProcessorHelper((CommonCodeStyleSettings)CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)this.settings));
    }

    @Override
    protected void process(@NotNull TrailingCommaContext trailingCommaContext) {
        Intrinsics.checkNotNullParameter((Object)trailingCommaContext, (String)"trailingCommaContext");
        this.processIfInRange(trailingCommaContext.getKtElement(), (Function0<Unit>)((Function0)() -> TrailingCommaPostFormatVisitor.process$lambda$0(this, trailingCommaContext)));
    }

    private final void processIfInRange(KtElement element, Function0<Unit> block) {
        if (this.myPostProcessor.isElementPartlyInRange((PsiElement)element)) {
            block.invoke();
        }
    }

    static /* synthetic */ void processIfInRange$default(TrailingCommaPostFormatVisitor trailingCommaPostFormatVisitor, KtElement ktElement, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = TrailingCommaPostFormatVisitor::processIfInRange$lambda$1;
        }
        trailingCommaPostFormatVisitor.processIfInRange(ktElement, (Function0<Unit>)function0);
    }

    private final void processCommaOwner(TrailingCommaContext trailingCommaContext) {
        KtElement ktElement = trailingCommaContext.getKtElement();
        PsiElement psiElement = TrailingCommaHelper.INSTANCE.trailingCommaOrLastElement(ktElement);
        if (psiElement == null) {
            return;
        }
        PsiElement lastElementOrComma = psiElement;
        this.updatePsi(ktElement, (Function0<Boolean>)((Function0)() -> TrailingCommaPostFormatVisitor.processCommaOwner$lambda$2(trailingCommaContext, this, ktElement, lastElementOrComma)));
    }

    private final void updatePsi(KtElement element, Function0<Boolean> updater2) {
        int oldLength = element.getParent().getTextLength();
        if (!((Boolean)updater2.invoke()).booleanValue()) {
            return;
        }
        PsiElement resultElement = GenericPsiUtils.reformatted((PsiElement)element, true);
        this.myPostProcessor.updateResultRange(oldLength, resultElement.getParent().getTextLength());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean correctCommaPosition(KtElement parent2) {
        void $this$mapTo$iv$iv;
        boolean hasChange = false;
        Iterable $this$map$iv = TrailingCommaHelper.INSTANCE.findInvalidCommas(parent2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SmartPointersKt.createSmartPointer((PsiElement)it));
        }
        for (SmartPsiElementPointer pointerToComma : (List)destination$iv$iv) {
            PsiElement it;
            if (pointerToComma.getElement() == null) continue;
            boolean bl = false;
            TrailingCommaPostFormatProcessorKt.access$correctComma(it);
            hasChange = true;
        }
        return hasChange || TrailingCommaHelper.INSTANCE.lineBreakIsMissing(parent2);
    }

    @NotNull
    public final PsiElement process(@NotNull PsiElement formatted) {
        Intrinsics.checkNotNullParameter((Object)formatted, (String)"formatted");
        LOG.assertTrue(formatted.isValid());
        formatted.accept((PsiElementVisitor)this);
        return formatted;
    }

    @NotNull
    public final TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)rangeToReformat, (String)"rangeToReformat");
        this.myPostProcessor.setResultTextRange(rangeToReformat);
        source.accept((PsiElementVisitor)this);
        TextRange textRange = this.myPostProcessor.getResultTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getResultTextRange(...)");
        return textRange;
    }

    private static final Unit process$lambda$0(TrailingCommaPostFormatVisitor this$0, TrailingCommaContext $trailingCommaContext) {
        this$0.processCommaOwner($trailingCommaContext);
        return Unit.INSTANCE;
    }

    private static final Unit processIfInRange$lambda$1() {
        return Unit.INSTANCE;
    }

    private static final boolean processCommaOwner$lambda$2(TrailingCommaContext $trailingCommaContext, TrailingCommaPostFormatVisitor this$0, KtElement $ktElement, PsiElement $lastElementOrComma) {
        boolean bl;
        TrailingCommaState state = $trailingCommaContext.getState();
        if (state == TrailingCommaState.MISSING && UtilKt.addTrailingCommaIsAllowedFor((KotlinCodeStyleSettings)CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this$0.settings), (PsiElement)((PsiElement)$ktElement))) {
            boolean hasChange;
            if (TrailingCommaUtilsKt.trailingCommaAllowedInModule((PsiElement)$ktElement)) {
                Project project = $ktElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                TrailingCommaPostFormatProcessorKt.access$addCommaAfter($lastElementOrComma, new KtPsiFactory(project, false, 2, null));
                v1 = true;
            } else {
                v1 = hasChange = false;
            }
            bl = this$0.correctCommaPosition($ktElement) || hasChange;
        } else if (state == TrailingCommaState.EXISTS) {
            bl = this$0.correctCommaPosition($ktElement);
        } else if (state == TrailingCommaState.REDUNDANT) {
            $lastElementOrComma.delete();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    static {
        Logger logger = Logger.getInstance(TrailingCommaVisitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/TrailingCommaPostFormatVisitor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.code-insight.impl-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

