/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleCodeInsightCommon;

import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.changes.Change;
import java.awt.Desktop;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurationService;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider;
import org.jetbrains.kotlin.idea.configuration.ui.changes.KotlinConfiguratorChangesDialog;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0001\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fJ\u0010\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0006\u0010\u001a\u001a\u00020\u000bJ\u0015\u0010\u001b\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001b\u0010\u001c\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0015\u0010\u001e\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u001f\u001a\u00020\u000bH\u0002J\b\u0010 \u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/gradleCodeInsightCommon/KotlinAutoConfigurationNotificationHolder;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "shownNotification", "Lcom/intellij/notification/Notification;", "notificationData", "Lorg/jetbrains/kotlin/idea/gradleCodeInsightCommon/KotlinAutoConfigurationNotificationHolder$NotificationData;", "showAutoConfiguredNotification", "", "moduleName", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "browseKotlinGradleConfiguration", "Lcom/intellij/notification/NotificationAction;", "Lorg/jetbrains/annotations/NotNull;", "showAutoConfigurationUndoneNotification", "module", "Lcom/intellij/openapi/module/Module;", "reshowAutoConfiguredNotification", "manualConfigurationStarted", "", "onManualConfigurationCompleted", "configureKotlinManuallyAction", "viewAppliedChangesAction", "showUndoErrorMessage", "undoAction", "expireShownNotification", "dispose", "Companion", "NotificationData", "kotlin.gradle.code-insight-common"})
public final class KotlinAutoConfigurationNotificationHolder
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private Notification shownNotification;
    @Nullable
    private NotificationData notificationData;
    @NotNull
    private final NotificationAction browseKotlinGradleConfiguration;
    private boolean manualConfigurationStarted;

    public KotlinAutoConfigurationNotificationHolder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        NotificationAction notificationAction = NotificationAction.create((String)KotlinProjectConfigurationBundle.message("auto.configure.kotlin.documentation.gradle", new Object[0]), (arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.browseKotlinGradleConfiguration$lambda$1(KotlinAutoConfigurationNotificationHolder::browseKotlinGradleConfiguration$lambda$0, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"create(...)");
        this.browseKotlinGradleConfiguration = notificationAction;
    }

    public final void showAutoConfiguredNotification(@Nullable String moduleName, @Nullable List<? extends Change> changes) {
        String string;
        Notification notification = this.shownNotification;
        if (notification != null) {
            notification.expire();
        }
        this.notificationData = moduleName != null && changes != null ? new NotificationData(moduleName, changes) : null;
        if (moduleName != null) {
            Object[] objectArray = new Object[]{moduleName};
            string = KotlinProjectConfigurationBundle.message("auto.configure.kotlin.notification", objectArray);
        } else {
            string = KotlinProjectConfigurationBundle.message("auto.configure.kotlin.notification.no-module", new Object[0]);
        }
        String notificationText = string;
        Notification notification2 = NotificationGroupManager.getInstance().getNotificationGroup("Configure Kotlin").createNotification(KotlinProjectConfigurationBundle.message("auto.configure.kotlin", new Object[0]), notificationText, NotificationType.INFORMATION);
        notification2.addAction((AnAction)this.undoAction(this.project));
        if (changes != null) {
            notification2.addAction((AnAction)this.viewAppliedChangesAction(changes));
        }
        notification2.notify(this.project);
        this.shownNotification = notification2;
    }

    public final void showAutoConfigurationUndoneNotification(@Nullable Module module) {
        NotificationData existingNotificationData = this.notificationData;
        Notification notification = this.shownNotification;
        if (notification != null) {
            notification.expire();
        }
        Notification notification2 = NotificationGroupManager.getInstance().getNotificationGroup("Configure Kotlin").createNotification(KotlinProjectConfigurationBundle.message("auto.configure.kotlin.undone", new Object[0]), "", NotificationType.INFORMATION);
        Module module2 = module;
        if (module2 != null) {
            Module it = module2;
            boolean bl = false;
            notification2.addAction((AnAction)this.configureKotlinManuallyAction(it));
        }
        notification2.addAction((AnAction)this.browseKotlinGradleConfiguration);
        notification2.notify(this.project);
        this.shownNotification = notification2;
        this.notificationData = existingNotificationData;
    }

    public final void reshowAutoConfiguredNotification(@Nullable Module module) {
        NotificationData existingNotificationData = this.notificationData;
        Notification notification = this.shownNotification;
        if (notification != null) {
            notification.expire();
        }
        Module module2 = module;
        NotificationData notificationData = existingNotificationData;
        this.showAutoConfiguredNotification(module2 != null ? module2.getName() : null, notificationData != null ? notificationData.getChanges() : null);
    }

    public final void onManualConfigurationCompleted() {
        this.manualConfigurationStarted = true;
    }

    private final NotificationAction configureKotlinManuallyAction(Module module) {
        NotificationAction notificationAction = NotificationAction.create((String)KotlinProjectConfigurationBundle.message("configure.kotlin.manually", new Object[0]), (arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.configureKotlinManuallyAction$lambda$5((arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.configureKotlinManuallyAction$lambda$4(this, module, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"create(...)");
        return notificationAction;
    }

    private final NotificationAction viewAppliedChangesAction(List<? extends Change> changes) {
        NotificationAction notificationAction = NotificationAction.create((String)KotlinProjectConfigurationBundle.message("view.code.differences.action", new Object[0]), (arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.viewAppliedChangesAction$lambda$7((arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.viewAppliedChangesAction$lambda$6(this, changes, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"create(...)");
        return notificationAction;
    }

    private final void showUndoErrorMessage(Project project) {
        Messages.showErrorDialog((Project)project, (String)KotlinProjectConfigurationBundle.message("auto.configure.kotlin.undo.not-possible.content", new Object[0]), (String)KotlinProjectConfigurationBundle.message("auto.configure.kotlin.undo.not-possible.title", new Object[0]));
    }

    private final NotificationAction undoAction(Project project) {
        NotificationAction notificationAction = NotificationAction.create((String)KotlinProjectConfigurationBundle.message("undo.configuration.action", new Object[0]), (arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.undoAction$lambda$9((arg_0, arg_1) -> KotlinAutoConfigurationNotificationHolder.undoAction$lambda$8(project, this, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"create(...)");
        return notificationAction;
    }

    private final void expireShownNotification() {
        Notification notification = this.shownNotification;
        if (notification != null) {
            notification.expire();
        }
        this.shownNotification = null;
        this.notificationData = null;
    }

    public void dispose() {
        this.expireShownNotification();
    }

    private static final Unit browseKotlinGradleConfiguration$lambda$0(AnActionEvent anActionEvent, Notification notification) {
        if (Desktop.isDesktopSupported()) {
            String url = KotlinProjectConfigurationBundle.message("auto.configure.kotlin.documentation.gradle.url", new Object[0]);
            Desktop.getDesktop().browse(new URI(url));
        }
        return Unit.INSTANCE;
    }

    private static final void browseKotlinGradleConfiguration$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void configureKotlinManuallyAction$lambda$4$expireNotificationIfConfigured(KotlinAutoConfigurationNotificationHolder this$0, Notification $notification) {
        if (this$0.manualConfigurationStarted) {
            $notification.expire();
        }
    }

    private static final Unit configureKotlinManuallyAction$lambda$4$lambda$3(KotlinAutoConfigurationNotificationHolder this$0, Notification $notification, KotlinProjectConfigurator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KotlinAutoConfigurationNotificationHolder.configureKotlinManuallyAction$lambda$4$expireNotificationIfConfigured(this$0, $notification);
        return Unit.INSTANCE;
    }

    private static final Unit configureKotlinManuallyAction$lambda$4(KotlinAutoConfigurationNotificationHolder this$0, Module $module, AnActionEvent e, Notification notification) {
        if (KotlinProjectConfigurationService.Companion.getInstance(this$0.project).isSyncInProgress()) {
            Messages.showWarningDialog((Project)this$0.project, (String)KotlinProjectConfigurationBundle.message("auto.configure.kotlin.wait.gradle.sync.finished", new Object[0]), (String)KotlinProjectConfigurationBundle.message("auto.configure.kotlin.wait.gradle.sync.finished.title", new Object[0]));
            return Unit.INSTANCE;
        }
        List configurators = CollectionsKt.toList((Iterable)ConfigureKotlinInProjectUtilsKt.getAbleToRunConfigurators($module));
        this$0.manualConfigurationStarted = false;
        if (configurators.size() > 1) {
            KotlinSetupEnvironmentNotificationProvider.Companion.createConfiguratorsPopup(this$0.project, configurators, (Function1<? super KotlinProjectConfigurator, Unit>)((Function1)arg_0 -> KotlinAutoConfigurationNotificationHolder.configureKotlinManuallyAction$lambda$4$lambda$3(this$0, notification, arg_0))).showInBestPositionFor(e.getDataContext());
        } else if (configurators.size() == 1) {
            ((KotlinProjectConfigurator)CollectionsKt.first((List)configurators)).configure(this$0.project, CollectionsKt.emptyList());
        }
        KotlinAutoConfigurationNotificationHolder.configureKotlinManuallyAction$lambda$4$expireNotificationIfConfigured(this$0, notification);
        return Unit.INSTANCE;
    }

    private static final void configureKotlinManuallyAction$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit viewAppliedChangesAction$lambda$6(KotlinAutoConfigurationNotificationHolder this$0, List $changes, AnActionEvent anActionEvent, Notification notification) {
        new KotlinConfiguratorChangesDialog(this$0.project, $changes);
        return Unit.INSTANCE;
    }

    private static final void viewAppliedChangesAction$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit undoAction$lambda$8(Project $project, KotlinAutoConfigurationNotificationHolder this$0, AnActionEvent anActionEvent, Notification notification) {
        UndoManager undoManager = UndoManager.getInstance((Project)$project);
        if (undoManager.isUndoAvailable(null)) {
            String undoActionName = (String)undoManager.getUndoActionNameAndDescription(null).first;
            Object[] objectArray = new Object[]{KotlinIdeaGradleBundle.message("command.name.configure.kotlin.automatically", new Object[0])};
            String undoAutoconfigureKotlinName = ActionsBundle.message((String)"action.undo.text", (Object[])objectArray);
            if (Intrinsics.areEqual((Object)undoActionName, (Object)undoAutoconfigureKotlinName)) {
                undoManager.undo(null);
            } else {
                this$0.showUndoErrorMessage($project);
            }
        } else {
            this$0.showUndoErrorMessage($project);
        }
        return Unit.INSTANCE;
    }

    private static final void undoAction$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/gradleCodeInsightCommon/KotlinAutoConfigurationNotificationHolder$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/gradleCodeInsightCommon/KotlinAutoConfigurationNotificationHolder;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.gradle.code-insight-common"})
    @SourceDebugExtension(value={"SMAP\nKotlinAutoConfigurationNotificationHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinAutoConfigurationNotificationHolder.kt\norg/jetbrains/kotlin/idea/gradleCodeInsightCommon/KotlinAutoConfigurationNotificationHolder$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,194:1\n31#2,2:195\n*S KotlinDebug\n*F\n+ 1 KotlinAutoConfigurationNotificationHolder.kt\norg/jetbrains/kotlin/idea/gradleCodeInsightCommon/KotlinAutoConfigurationNotificationHolder$Companion\n*L\n30#1:195,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinAutoConfigurationNotificationHolder getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinAutoConfigurationNotificationHolder> serviceClass$iv = KotlinAutoConfigurationNotificationHolder.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KotlinAutoConfigurationNotificationHolder)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/gradleCodeInsightCommon/KotlinAutoConfigurationNotificationHolder$NotificationData;", "", "moduleName", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getModuleName", "()Ljava/lang/String;", "getChanges", "()Ljava/util/List;", "kotlin.gradle.code-insight-common"})
    private static final class NotificationData {
        @NotNull
        private final String moduleName;
        @NotNull
        private final List<Change> changes;

        public NotificationData(@NotNull String moduleName, @NotNull List<? extends Change> changes) {
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            this.moduleName = moduleName;
            this.changes = changes;
        }

        @NotNull
        public final String getModuleName() {
            return this.moduleName;
        }

        @NotNull
        public final List<Change> getChanges() {
            return this.changes;
        }
    }
}

