/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting.legacy;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.configuration.DefaultScriptingSupportBase;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.ScriptChangeListener;
import org.jetbrains.kotlin.idea.gradleJava.scripting.UtilsKt;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/legacy/GradleLegacyScriptListener;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "buildRootsManager", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsManager;", "getBuildRootsManager", "()Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsManager;", "isApplicable", "", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorActivated", "", "documentChanged", "checkUpToDate", "kotlin.gradle.gradle-java"})
public final class GradleLegacyScriptListener
extends ScriptChangeListener {
    public GradleLegacyScriptListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    private final GradleBuildRootsManager getBuildRootsManager() {
        return GradleBuildRootsManager.Companion.getInstanceSafe(this.getProject());
    }

    @Override
    public boolean isApplicable(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        return UtilsKt.isGradleKotlinScript(vFile);
    }

    @Override
    public void editorActivated(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        this.checkUpToDate(vFile);
    }

    @Override
    public void documentChanged(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        this.checkUpToDate(vFile);
    }

    private final void checkUpToDate(VirtualFile vFile) {
        GradleBuildRootsManager gradleBuildRootsManager = this.getBuildRootsManager();
        String string = vFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (!gradleBuildRootsManager.isAffectedGradleProjectFile(string)) {
            return;
        }
        KtFile file = this.getAnalyzableKtFileForScript(vFile);
        if (file != null) {
            DefaultScriptingSupportBase.ensureUpToDatedConfigurationSuggested$default(this.getDefault(), file, false, false, 6, null);
        }
    }
}

