/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.hierarchy.calls.CallHierarchyUtilsKt;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCallHierarchyNodeDescriptor;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCalleeTreeStructure;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCallerTreeStructure;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\tH\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J \u0010\u0015\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017`\u0018H\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallHierarchyBrowser;", "Lcom/intellij/ide/hierarchy/CallHierarchyBrowserBase;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "createTrees", "", "trees", "", "", "Ljavax/swing/JTree;", "getElementFromDescriptor", "descriptor", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "isApplicableElement", "", "createHierarchyTreeStructure", "Lcom/intellij/ide/hierarchy/HierarchyTreeStructure;", "type", "psiElement", "getComparator", "Ljava/util/Comparator;", "Lcom/intellij/ide/util/treeView/NodeDescriptor;", "Lkotlin/Comparator;", "Companion", "kotlin.idea"})
public final class KotlinCallHierarchyBrowser
extends CallHierarchyBrowserBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KotlinCallHierarchyBrowser(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element.getProject(), element);
    }

    protected void createTrees(@NotNull Map<? super String, ? super JTree> trees) {
        Intrinsics.checkNotNullParameter(trees, (String)"trees");
        CallHierarchyBrowserBase.BaseOnThisMethodAction baseOnThisMethodAction = new CallHierarchyBrowserBase.BaseOnThisMethodAction();
        JTree jTree = this.createTree(false);
        Intrinsics.checkNotNullExpressionValue((Object)jTree, (String)"createTree(...)");
        JTree tree1 = jTree;
        PopupHandler.installPopupMenu((JComponent)tree1, (String)"CallHierarchyPopupMenu", (String)"CallHierarchyViewPopup");
        baseOnThisMethodAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("CallHierarchy").getShortcutSet(), (JComponent)tree1);
        trees.put(CallHierarchyBrowserBase.getCalleeType(), tree1);
        JTree jTree2 = this.createTree(false);
        Intrinsics.checkNotNullExpressionValue((Object)jTree2, (String)"createTree(...)");
        JTree tree2 = jTree2;
        PopupHandler.installPopupMenu((JComponent)tree2, (String)"CallHierarchyPopupMenu", (String)"CallHierarchyViewPopup");
        baseOnThisMethodAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("CallHierarchy").getShortcutSet(), (JComponent)tree2);
        trees.put(CallHierarchyBrowserBase.getCallerType(), tree2);
    }

    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return KotlinCallHierarchyBrowser.Companion.getTargetElement(descriptor2);
    }

    protected boolean isApplicableElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PsiClass ? false : CallHierarchyUtilsKt.isCallHierarchyElement(element);
    }

    @Nullable
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String type2, @NotNull PsiElement psiElement) {
        HierarchyTreeStructure hierarchyTreeStructure;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!(psiElement instanceof KtElement)) {
            return null;
        }
        String string = type2;
        if (Intrinsics.areEqual((Object)string, (Object)CallHierarchyBrowserBase.getCallerType())) {
            KtElement ktElement = (KtElement)psiElement;
            String string2 = this.getCurrentScopeType();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCurrentScopeType(...)");
            hierarchyTreeStructure = new KotlinCallerTreeStructure(ktElement, string2);
        } else if (Intrinsics.areEqual((Object)string, (Object)CallHierarchyBrowserBase.getCalleeType())) {
            KtElement ktElement = (KtElement)psiElement;
            String string3 = this.getCurrentScopeType();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCurrentScopeType(...)");
            hierarchyTreeStructure = new KotlinCalleeTreeStructure(ktElement, string3);
        } else {
            hierarchyTreeStructure = null;
        }
        return hierarchyTreeStructure;
    }

    @NotNull
    protected Comparator<NodeDescriptor<?>> getComparator() {
        Comparator comparator = JavaHierarchyUtil.getComparator((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"getComparator(...)");
        return comparator;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallHierarchyBrowser$Companion;", "", "<init>", "()V", "getTargetElement", "Lcom/intellij/psi/PsiElement;", "descriptor", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        private final PsiElement getTargetElement(HierarchyNodeDescriptor descriptor2) {
            KotlinCallHierarchyNodeDescriptor kotlinCallHierarchyNodeDescriptor = descriptor2 instanceof KotlinCallHierarchyNodeDescriptor ? (KotlinCallHierarchyNodeDescriptor)descriptor2 : null;
            return kotlinCallHierarchyNodeDescriptor != null ? kotlinCallHierarchyNodeDescriptor.getPsiElement() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

