/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting.analyzers;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.types.KaFunctionType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.highlighting.dsl.DslStyleUtils;
import org.jetbrains.kotlin.idea.highlighter.HighlightingFactory;
import org.jetbrains.kotlin.idea.highlighting.analyzers.KotlinDslSemanticAnalyzerKt;
import org.jetbrains.kotlin.idea.highlighting.analyzers.KotlinSemanticAnalyzer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/analyzers/KotlinDslSemanticAnalyzer;", "Lorg/jetbrains/kotlin/idea/highlighting/analyzers/KotlinSemanticAnalyzer;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "session", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<init>", "(Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;Lorg/jetbrains/kotlin/analysis/api/KaSession;)V", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "highlightCall", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo$Builder;", "element", "kotlin.highlighting.k2"})
public final class KotlinDslSemanticAnalyzer
extends KotlinSemanticAnalyzer {
    public KotlinDslSemanticAnalyzer(@NotNull HighlightInfoHolder holder2, @NotNull KaSession session) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(holder2, session);
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        HighlightInfo.Builder builder2 = this.highlightCall(expression);
        this.getHolder().add((HighlightInfo)(builder2 != null ? builder2.create() : null));
    }

    private final HighlightInfo.Builder highlightCall(KtCallExpression element) {
        KtExpression ktExpression = element.getCalleeExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression calleeExpression = ktExpression;
        List list2 = element.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list2);
        if (ktLambdaArgument == null || (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) == null) {
            return null;
        }
        KtLambdaArgument lambdaExpression = ktLambdaArgument;
        KaSession $this$highlightCall_u24lambda_u240 = this.getSession();
        boolean bl = false;
        KaType kaType = $this$highlightCall_u24lambda_u240.getExpressionType((KtExpression)lambdaExpression);
        KaType kaType2 = kaType instanceof KaFunctionType ? (KaFunctionType)kaType : null;
        if (kaType2 == null || (kaType2 = kaType2.getReceiverType()) == null) {
            return null;
        }
        KaType receiverType = kaType2;
        ClassId classId = KotlinDslSemanticAnalyzerKt.access$getDslAnnotation($this$highlightCall_u24lambda_u240, receiverType);
        if (classId == null) {
            return null;
        }
        ClassId dslAnnotation = classId;
        int dslStyleId = DslStyleUtils.INSTANCE.styleIdByFQName(dslAnnotation.asSingleFqName());
        return HighlightingFactory.highlightName$default((HighlightingFactory)HighlightingFactory.INSTANCE, (PsiElement)((PsiElement)calleeExpression), (HighlightInfoType)DslStyleUtils.INSTANCE.typeById(dslStyleId), null, (int)4, null);
    }
}

