/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.DeprecationCollectingInspection;
import org.jetbrains.kotlin.idea.inspections.ConvertObjectToDataObjectInspectionKt;
import org.jetbrains.kotlin.idea.inspections.ConvertToDataObjectQuickFix;
import org.jetbrains.kotlin.idea.inspections.VirtualFunction;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.idea.statistics.InspectionData;
import org.jetbrains.kotlin.idea.statistics.KotlinLanguageFeaturesFUSCollector;
import org.jetbrains.kotlin.idea.statistics.NewAndDeprecatedFeaturesInspectionData;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertObjectToDataObjectInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/DeprecationCollectingInspection;", "Lorg/jetbrains/kotlin/idea/statistics/NewAndDeprecatedFeaturesInspectionData;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "ObjectVisitor", "kotlin.idea"})
public final class ConvertObjectToDataObjectInspection
extends DeprecationCollectingInspection<NewAndDeprecatedFeaturesInspectionData> {
    public ConvertObjectToDataObjectInspection() {
        super(KotlinLanguageFeaturesFUSCollector.INSTANCE.getDataObjectCollector(), (InspectionData)new NewAndDeprecatedFeaturesInspectionData(false, false, 3, null));
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = holder2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)psiFile).supportsFeature(LanguageFeature.DataObjects)) {
            psiElementVisitor = (PsiElementVisitor)new ObjectVisitor(holder2, session);
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            psiElementVisitor = psiElementVisitor2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor2, (String)"EMPTY_VISITOR");
        }
        return psiElementVisitor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f\u00b2\u0006\n\u0010\r\u001a\u00020\u000eX\u008a\u0084\u0002\u00b2\u0006\n\u0010\u000f\u001a\u00020\u000eX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertObjectToDataObjectInspection$ObjectVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "<init>", "(Lorg/jetbrains/kotlin/idea/inspections/ConvertObjectToDataObjectInspection;Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "visitObjectDeclaration", "", "ktObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "kotlin.idea", "isSealedSubClassCase", "", "isToStringCase"})
    private final class ObjectVisitor
    extends KtVisitorVoid {
        @NotNull
        private final ProblemsHolder holder;
        @NotNull
        private final LocalInspectionToolSession session;

        public ObjectVisitor(@NotNull ProblemsHolder holder2, LocalInspectionToolSession session) {
            Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.holder = holder2;
            this.session = session;
        }

        public void visitObjectDeclaration(@NotNull KtObjectDeclaration ktObject) {
            Intrinsics.checkNotNullParameter((Object)ktObject, (String)"ktObject");
            if (ktObject.isData()) {
                ConvertObjectToDataObjectInspection.this.updateDeprecationData(this.session, ObjectVisitor::visitObjectDeclaration$lambda$0);
                return;
            }
            if (ktObject.isCompanion() || ktObject.isObjectLiteral()) {
                return;
            }
            Lazy fqName2 = LazyKt.lazy(() -> ObjectVisitor.visitObjectDeclaration$lambda$1(ktObject));
            VirtualFunction toString = ConvertObjectToDataObjectInspectionKt.access$findToString(ktObject);
            Lazy isSealedSubClassCase$delegate = LazyKt.lazy(() -> ObjectVisitor.visitObjectDeclaration$lambda$2(toString, ktObject));
            Lazy isToStringCase$delegate = LazyKt.lazy(() -> ObjectVisitor.visitObjectDeclaration$lambda$4(toString, ktObject, fqName2));
            if ((ObjectVisitor.visitObjectDeclaration$lambda$3((Lazy<Boolean>)isSealedSubClassCase$delegate) || ObjectVisitor.visitObjectDeclaration$lambda$5((Lazy<Boolean>)isToStringCase$delegate)) && ConvertObjectToDataObjectInspectionKt.access$isCompatibleHashCode(ktObject, fqName2) && ConvertObjectToDataObjectInspectionKt.access$isCompatibleEquals(ktObject, fqName2)) {
                ConvertObjectToDataObjectInspection.this.updateDeprecationData(this.session, ObjectVisitor::visitObjectDeclaration$lambda$6);
                PsiElement psiElement = ktObject.getObjectKeyword();
                if (psiElement == null) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ConvertToDataObjectQuickFix()};
                this.holder.registerProblem(psiElement, KotlinBundle.message((String)(ObjectVisitor.visitObjectDeclaration$lambda$3((Lazy<Boolean>)isSealedSubClassCase$delegate) ? "inspection.message.sealed.object.can.be.converted.to.data.object" : "inspection.message.object.with.manual.tostring.can.be.converted.to.data.object"), (Object[])new Object[0]), localQuickFixArray);
            }
        }

        private static final NewAndDeprecatedFeaturesInspectionData visitObjectDeclaration$lambda$0(NewAndDeprecatedFeaturesInspectionData it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.withNewFeature();
        }

        private static final FqName visitObjectDeclaration$lambda$1(KtObjectDeclaration $ktObject) {
            DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)$ktObject);
            if (declarationDescriptor == null || (declarationDescriptor = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)declarationDescriptor)) == null) {
                declarationDescriptor = FqName.ROOT;
            }
            return declarationDescriptor;
        }

        private static final boolean visitObjectDeclaration$lambda$2(VirtualFunction $toString, KtObjectDeclaration $ktObject) {
            return Intrinsics.areEqual((Object)$toString, (Object)VirtualFunction.TrivialSuper.INSTANCE) && ConvertObjectToDataObjectInspectionKt.access$isSubclassOfSealed($ktObject);
        }

        private static final boolean visitObjectDeclaration$lambda$3(Lazy<Boolean> $isSealedSubClassCase$delegate) {
            Lazy<Boolean> lazy = $isSealedSubClassCase$delegate;
            return (Boolean)lazy.getValue();
        }

        private static final boolean visitObjectDeclaration$lambda$4(VirtualFunction $toString, KtObjectDeclaration $ktObject, Lazy $fqName) {
            return $toString instanceof VirtualFunction.Function && ConvertObjectToDataObjectInspectionKt.access$isCompatibleToString($ktObject, $fqName, ((VirtualFunction.Function)$toString).getFunction());
        }

        private static final boolean visitObjectDeclaration$lambda$5(Lazy<Boolean> $isToStringCase$delegate) {
            Lazy<Boolean> lazy = $isToStringCase$delegate;
            return (Boolean)lazy.getValue();
        }

        private static final NewAndDeprecatedFeaturesInspectionData visitObjectDeclaration$lambda$6(NewAndDeprecatedFeaturesInspectionData it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.withDeprecatedFeature();
        }
    }
}

